/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotCollection;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemInfo;
import com.kingdee.shr.compensation.app.budget.BusinessTypeEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.DataStateEnum;
import com.kingdee.shr.compensation.app.budget.DeduNodeEnum;
import com.kingdee.shr.compensation.app.budget.RollBackNodeEnum;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigInfo;
import com.kingdee.shr.compensation.app.budget.StandingBookItemInfo;
import com.kingdee.shr.compensation.app.budget.UpdateDirectionEnum;
import com.kingdee.shr.compensation.app.budget.UpdateNodeEnum;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.exception.BudgetEASBizException;
import com.kingdee.shr.compensation.service.budget.MethodParam;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.budget.BudgetUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Deprecated
public class BudgetDeductService {
    public void dealSchemeDeductConfig(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Iterator iterator = paramMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry param = entry = iterator.next();
            String billId = (String)param.getKey();
            Map map = (Map)param.getValue();
            if (StringUtils.isEmpty((String)billId) || map == null) continue;
            this.checkHasBudgetData(ctx, billId);
            String submitSchemeId = (String)map.get("submitSchemeId");
            Set entryIdSet = (Set)map.get("entryIdSet");
            if (StringUtils.isEmpty((String)submitSchemeId)) continue;
            DeduNodeEnum deduNodeEnum = (DeduNodeEnum)((Object)map.get("deduNodeEnum"));
            RollBackNodeEnum rollBackNodeEnum = (RollBackNodeEnum)((Object)map.get("rollBackNodeEnum"));
            if (deduNodeEnum != null) {
                this.checkAcross(ctx, submitSchemeId, billId, entryIdSet);
            }
            UpdateNodeEnum updateNodeEnum = (UpdateNodeEnum)((Object)map.get("updateNodeEnum"));
            this.dealDeductConfig(ctx, submitSchemeId, billId, entryIdSet, deduNodeEnum, updateNodeEnum);
            this.dealOffsetConfig(ctx, submitSchemeId, entryIdSet, deduNodeEnum, updateNodeEnum);
            this.dealRollbackConfig(ctx, submitSchemeId, entryIdSet, rollBackNodeEnum, updateNodeEnum);
        }
    }

    protected void checkHasBudgetData(Context ctx, String billId) throws BOSException, EASBizException {
        String sqlBuilder = " SELECT b.FID,b.FCostBearOrgID,b.FCostTypeID, c.FBudgetTemplateID, b.FSubmitSchemeID  FROM T_HR_SBatchSubmitShemeBill  b left join T_HR_SCalSubmitScheme c on c.FID = b.FSubmitSchemeID  where c.FBudgetTemplateID is not null and b.FID = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder, (Object[])new Object[]{billId});
        try {
            while (rowSet.next()) {
                java.util.Date currentDate;
                Map<String, Object> schemeIdAndCurrency;
                String costBearOrgID = rowSet.getString("FCostBearOrgID");
                String costTypeID = rowSet.getString("FCostTypeID");
                String budgetTemplateID = rowSet.getString("FBudgetTemplateID");
                String submitSchemeId = rowSet.getString("FSubmitSchemeID");
                if (StringUtils.isEmpty((String)costBearOrgID) || StringUtils.isEmpty((String)budgetTemplateID) || StringUtils.isEmpty((String)submitSchemeId) || (schemeIdAndCurrency = this.getBudgetSchemeIdAndCurrency(ctx, currentDate = this.getOperateDate(), submitSchemeId)) == null) continue;
                Boolean schemeHasTemplate = (Boolean)schemeIdAndCurrency.get("schemeHasTemplate");
                if (schemeHasTemplate != null && schemeHasTemplate.booleanValue() && StringUtils.isEmpty((String)((String)schemeIdAndCurrency.get("budgetSchemeId")))) {
                    throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)ctx.getLocale())));
                }
                String queryDataSql = "select top 1 FID from T_HR_SBudgetManage where FAdminOrgUnitID = ?  and FCostTypeID = ?";
                IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)queryDataSql, (Object[])new Object[]{costBearOrgID, costTypeID});
                if (rowSet1.next()) continue;
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected BudgetSnapshotCollection getSnapshotNeedToOffset(Context ctx, String submitSchemeId, String entryIdInSql, String budgetItemId, String calSubmitItemId, String templateStbItemId) throws BOSException {
        String oqlBuilder = " where calSubmitScheme.id = '" + submitSchemeId + "' and calSubmitItem.id = '" + calSubmitItemId + "' and cmpBudgetItem.id = '" + budgetItemId + "' and templateStbItem.id = '" + templateStbItemId + "' and submitShemeBillEntry.id in " + entryIdInSql + " and dataState = " + 30 + " and (isOffset = 0 or isOffset is null )";
        return BudgetSnapshotFactory.getLocalInstance(ctx).getBudgetSnapshotCollection(oqlBuilder);
    }

    protected void dealRollbackConfig(Context ctx, String submitSchemeId, Set<String> entryIdSet, RollBackNodeEnum rollBackNodeEnum, UpdateNodeEnum updateNodeEnum) throws BOSException, EASBizException {
        SchemeDeduConfigCollection configCollection;
        if (rollBackNodeEnum == null) {
            return;
        }
        boolean isReverseApprove = false;
        String deductOql = " where calSubmitScheme = '" + submitSchemeId + "' and rollBackNode = " + rollBackNodeEnum.getValue();
        if (250 == rollBackNodeEnum.getValue()) {
            isReverseApprove = true;
            deductOql = " where calSubmitScheme = '" + submitSchemeId + "' and rollBackNode in (" + 150 + "," + 250 + ") order by rollBackNode desc";
        }
        if ((configCollection = SchemeDeduConfigFactory.getLocalInstance(ctx).getSchemeDeduConfigCollection(deductOql)) == null || configCollection.isEmpty()) {
            return;
        }
        HashSet<String> calSubmitItemIdSet = new HashSet<String>();
        HashSet<String> cmpBudgetItemIdSet = new HashSet<String>();
        HashSet<String> templateStbItemIdSet = new HashSet<String>();
        this.extractIdFromConfigCollection(configCollection, calSubmitItemIdSet, cmpBudgetItemIdSet, templateStbItemIdSet);
        if (templateStbItemIdSet.isEmpty() || calSubmitItemIdSet.isEmpty()) {
            return;
        }
        Map<String, BudgetTemplateSTBItemInfo> stbItemInfoMap = this.getTemplateStbItemMap(ctx, templateStbItemIdSet);
        Map<String, CmpBudgetItemInfo> cmpBudgetItemInfoMap = this.getBudgetItemSnMap(ctx, cmpBudgetItemIdSet);
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String entryIdInSql = cmpInSql.createInSqlBaseOnFId(ctx, entryIdSet);
        int configSize = configCollection.size();
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)currentUserId));
        BudgetPeriodEnum budgetPeriodEnum = this.getBudgetPeriodEnum(ctx, submitSchemeId);
        for (int i = 0; i < configSize; ++i) {
            BudgetSnapshotCollection snapshotCollection;
            SchemeDeduConfigInfo configInfo = configCollection.get(i);
            CalSubmitItemInfo calSubmitItem = configInfo.getCalSubmitItem();
            if (calSubmitItem == null || calSubmitItem.getId() == null) continue;
            String calSubmitItemId = calSubmitItem.getId().toString();
            CmpBudgetItemInfo cmpBudgetItem = configInfo.getCmpBudgetItem();
            if (cmpBudgetItem == null || cmpBudgetItem.getId() == null) continue;
            cmpBudgetItem = cmpBudgetItemInfoMap.get(cmpBudgetItem.getId().toString());
            BudgetTemplateSTBItemInfo templateStbItem = configInfo.getTemplateStbItem();
            if (templateStbItem == null || templateStbItem.getId() == null) continue;
            String budgetItemId = cmpBudgetItem.getId().toString();
            BudgetTemplateSTBItemInfo templateSTBItemInfo = stbItemInfoMap.get(templateStbItem.getId().toString());
            if (templateSTBItemInfo == null || templateSTBItemInfo.getStandingBookItem() == null) continue;
            String templateStbItemId = templateStbItem.getId().toString();
            RollBackNodeEnum rollBackNode = configInfo.getRollBackNode();
            if (isReverseApprove && 150 == rollBackNode.getValue()) {
                updateNodeEnum = UpdateNodeEnum.WITHDRAW;
            }
            if ((snapshotCollection = this.getSnapshotNeedToRollBack(ctx, submitSchemeId, entryIdInSql, budgetItemId, calSubmitItemId, templateStbItemId, updateNodeEnum)) == null || snapshotCollection.isEmpty()) continue;
            int snapshotSize = snapshotCollection.size();
            HashMap<String, BigDecimal> sumValueForOffsetMap = new HashMap<String, BigDecimal>();
            String splitFlag = "###";
            for (int j = 0; j < snapshotSize; ++j) {
                BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
                String bookTableId = snapshotInfo.getBookTableId();
                String subBookTableId = snapshotInfo.getSubBookTableId();
                if (StringUtils.isEmpty((String)bookTableId)) continue;
                String key = bookTableId + splitFlag + subBookTableId;
                BigDecimal sumVal = (BigDecimal)sumValueForOffsetMap.get(key);
                if (sumVal == null) {
                    sumVal = BigDecimal.ZERO;
                }
                BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
                sumVal = sumVal.add(value);
                sumValueForOffsetMap.put(key, sumVal);
                snapshotInfo.setIsRollback(true);
            }
            this.updateBookTableDataOfRollback(ctx, templateSTBItemInfo, sumValueForOffsetMap, splitFlag, budgetPeriodEnum);
            this.recordRollbackSnapshot(ctx, userInfo, snapshotCollection, updateNodeEnum);
            DeduNodeEnum deduNode = configInfo.getDeduNode();
            String reverseOffsetOql = " where calSubmitScheme = '" + submitSchemeId + "'  and calSubmitItem = '" + calSubmitItemId + "' and cmpBudgetItem = '" + cmpBudgetItem.getId().toString() + "' and offsetNode = " + deduNode.getValue();
            SchemeDeduConfigCollection offsetConfigCollection = SchemeDeduConfigFactory.getLocalInstance(ctx).getSchemeDeduConfigCollection(reverseOffsetOql);
            if (offsetConfigCollection == null || offsetConfigCollection.isEmpty()) continue;
            this.reverseOffsetData(ctx, submitSchemeId, entryIdInSql, userInfo, offsetConfigCollection);
        }
    }

    protected void reverseOffsetData(Context ctx, String submitSchemeId, String entryIdInSql, UserInfo userInfo, SchemeDeduConfigCollection offsetConfigCollection) throws BOSException, EASBizException {
        HashSet<String> calSubmitItemIdSet = new HashSet<String>();
        HashSet<String> cmpBudgetItemIdSet = new HashSet<String>();
        HashSet<String> templateStbItemIdSet = new HashSet<String>();
        this.extractIdFromConfigCollection(offsetConfigCollection, calSubmitItemIdSet, cmpBudgetItemIdSet, templateStbItemIdSet);
        if (templateStbItemIdSet.isEmpty() || calSubmitItemIdSet.isEmpty()) {
            return;
        }
        Map<String, BudgetTemplateSTBItemInfo> stbItemInfoMap = this.getTemplateStbItemMap(ctx, templateStbItemIdSet);
        for (int j = 0; j < offsetConfigCollection.size(); ++j) {
            BudgetTemplateSTBItemInfo templateSTBItemInfoOffset;
            BudgetTemplateSTBItemInfo templateStbItemOffset;
            SchemeDeduConfigInfo offsetConfig = offsetConfigCollection.get(j);
            CalSubmitItemInfo calSubmitItemOffset = offsetConfig.getCalSubmitItem();
            if (calSubmitItemOffset == null || calSubmitItemOffset.getId() == null) continue;
            String calSubmitItemId = calSubmitItemOffset.getId().toString();
            CmpBudgetItemInfo cmpBudgetItemOffset = offsetConfig.getCmpBudgetItem();
            if (cmpBudgetItemOffset == null || cmpBudgetItemOffset.getId() == null || (templateStbItemOffset = offsetConfig.getTemplateStbItem()) == null || templateStbItemOffset.getId() == null || (templateSTBItemInfoOffset = stbItemInfoMap.get(templateStbItemOffset.getId().toString())) == null || templateSTBItemInfoOffset.getStandingBookItem() == null) continue;
            String budgetItemIdOffset = cmpBudgetItemOffset.getId().toString();
            String templateStbItemIdOffset = templateSTBItemInfoOffset.getId().toString();
            BudgetSnapshotCollection snapshotNeedToReverseOffset = this.getSnapshotNeedToReverseOffset(ctx, submitSchemeId, entryIdInSql, budgetItemIdOffset, calSubmitItemId, templateStbItemIdOffset);
            int snapshotReOffsetSize = snapshotNeedToReverseOffset.size();
            String reSplitFlag = "###";
            BudgetPeriodEnum budgetPeriodEnum = this.getBudgetPeriodEnum(ctx, submitSchemeId);
            HashMap<String, BigDecimal> sumValueForReOffsetMap = new HashMap<String, BigDecimal>();
            for (int k = 0; k < snapshotReOffsetSize; ++k) {
                BudgetSnapshotInfo snapshotInfo = snapshotNeedToReverseOffset.get(k);
                String bookTableId = snapshotInfo.getBookTableId();
                String subBookTableId = snapshotInfo.getSubBookTableId();
                if (StringUtils.isEmpty((String)bookTableId) || StringUtils.isEmpty((String)subBookTableId)) continue;
                String key = bookTableId + reSplitFlag + subBookTableId;
                BigDecimal sumVal = (BigDecimal)sumValueForReOffsetMap.get(key);
                if (sumVal == null) {
                    sumVal = BigDecimal.ZERO;
                }
                BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
                sumVal = sumVal.add(value);
                sumValueForReOffsetMap.put(key, sumVal);
                snapshotInfo.setIsRollbackOffset(true);
            }
            this.updateBookTableDataOfReOffset(ctx, templateSTBItemInfoOffset, sumValueForReOffsetMap, reSplitFlag, budgetPeriodEnum);
            this.recordReOffsetSnapshot(ctx, userInfo, snapshotNeedToReverseOffset);
        }
    }

    protected void updateBookTableDataOfReOffset(Context ctx, BudgetTemplateSTBItemInfo templateSTBItemInfo, Map<String, BigDecimal> sumValueForOffsetMap, String splitFlag, BudgetPeriodEnum budgetPeriodEnum) throws BOSException {
        int fieldSn = templateSTBItemInfo.getStandingBookItem().getFieldSn();
        for (Map.Entry<String, BigDecimal> data : sumValueForOffsetMap.entrySet()) {
            String updateSql;
            String key = data.getKey();
            BigDecimal value = data.getValue();
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                value = BigDecimal.ZERO;
            }
            String[] tableSplit = key.split(splitFlag);
            if (budgetPeriodEnum != null && 0 == budgetPeriodEnum.getValue()) {
                updateSql = "update T_HR_SCmpStandingBook set S" + fieldSn + " = S" + fieldSn + "+" + value + " where FID ='" + tableSplit[0] + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
                continue;
            }
            updateSql = "update T_HR_SCmpStandingBook set S" + fieldSn + " = S" + fieldSn + "+" + value + " where FID ='" + tableSplit[0] + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
            updateSql = "update T_HR_SubCmpStandingBook set S" + fieldSn + " = S" + fieldSn + " + " + value + " where FID ='" + tableSplit[1] + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    protected void recordReOffsetSnapshot(Context ctx, UserInfo userInfo, BudgetSnapshotCollection snapshotCollection) throws BOSException, EASBizException {
        CoreBaseCollection updateSnapshotColl = new CoreBaseCollection();
        Timestamp timeStamp = new Timestamp(new java.util.Date().getTime());
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
            if (!snapshotInfo.isIsRollbackOffset()) continue;
            snapshotInfo.setLastUpdateTime(timeStamp);
            snapshotInfo.setLastUpdateUser(userInfo);
            updateSnapshotColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (updateSnapshotColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance(ctx).saveBatchData(updateSnapshotColl);
        }
    }

    protected void recordRollbackSnapshot(Context ctx, UserInfo userInfo, BudgetSnapshotCollection snapshotCollection, UpdateNodeEnum updateNodeEnum) throws BOSException, EASBizException {
        CoreBaseCollection updateSnapshotColl = new CoreBaseCollection();
        Timestamp timeStamp = new Timestamp(new java.util.Date().getTime());
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
            if (!snapshotInfo.isIsRollback()) continue;
            snapshotInfo.setLastUpdateTime(timeStamp);
            snapshotInfo.setLastUpdateUser(userInfo);
            updateSnapshotColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (updateSnapshotColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance(ctx).saveBatchData(updateSnapshotColl);
        }
        Timestamp currentTimeStamp = new Timestamp(new java.util.Date().getTime());
        CoreBaseCollection insertCoreBaseColl = new CoreBaseCollection();
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
            if (!snapshotInfo.isIsRollback()) continue;
            snapshotInfo.setId(null);
            snapshotInfo.setCreateTime(currentTimeStamp);
            snapshotInfo.setLastUpdateTime(currentTimeStamp);
            snapshotInfo.setDataState(DataStateEnum.ROLLBACK);
            snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
            snapshotInfo.setUpdateNode(updateNodeEnum);
            snapshotInfo.setIsOffset(false);
            snapshotInfo.setIsRollback(false);
            snapshotInfo.setIsRollbackOffset(false);
            snapshotInfo.setCreator(userInfo);
            snapshotInfo.setLastUpdateUser(userInfo);
            insertCoreBaseColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (insertCoreBaseColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance(ctx).saveBatchData(insertCoreBaseColl);
        }
    }

    protected void updateBookTableDataOfRollback(Context ctx, BudgetTemplateSTBItemInfo templateSTBItemInfo, Map<String, BigDecimal> sumValueForOffsetMap, String splitFlag, BudgetPeriodEnum budgetPeriodEnum) throws BOSException {
        int fieldSn = templateSTBItemInfo.getStandingBookItem().getFieldSn();
        int balanceSn = templateSTBItemInfo.getBalanceLedgerItem().getFieldSn();
        for (Map.Entry<String, BigDecimal> data : sumValueForOffsetMap.entrySet()) {
            String updateSql;
            String key = data.getKey();
            BigDecimal value = data.getValue();
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                value = BigDecimal.ZERO;
            }
            String[] tableSplit = key.split(splitFlag);
            if (budgetPeriodEnum != null && 0 == budgetPeriodEnum.getValue()) {
                updateSql = "update T_HR_SCmpStandingBook set S" + fieldSn + " = S" + fieldSn + " - " + value + ",S" + balanceSn + " = S" + balanceSn + "+" + value + " where FID ='" + tableSplit[0] + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
                continue;
            }
            updateSql = "update T_HR_SCmpStandingBook set S" + fieldSn + " = S" + fieldSn + " - " + value + ",S" + balanceSn + " = S" + balanceSn + "+" + value + " where FID ='" + tableSplit[0] + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
            updateSql = "update T_HR_SubCmpStandingBook set S" + fieldSn + " = S" + fieldSn + " - " + value + ",S" + balanceSn + " = S" + balanceSn + "+" + value + " where FID ='" + tableSplit[1] + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    protected void dealOffsetConfig(Context ctx, String submitSchemeId, Set<String> entryIdSet, DeduNodeEnum deduNodeEnum, UpdateNodeEnum updateNodeEnum) throws BOSException, EASBizException {
        if (deduNodeEnum == null) {
            return;
        }
        String deductOql = " where calSubmitScheme = '" + submitSchemeId + "' and offsetNode = " + deduNodeEnum.getValue();
        SchemeDeduConfigCollection configCollection = SchemeDeduConfigFactory.getLocalInstance(ctx).getSchemeDeduConfigCollection(deductOql);
        if (configCollection == null || configCollection.isEmpty()) {
            return;
        }
        HashSet<String> calSubmitItemIdSet = new HashSet<String>();
        HashSet<String> cmpBudgetItemIdSet = new HashSet<String>();
        HashSet<String> templateStbItemIdSet = new HashSet<String>();
        this.extractIdFromConfigCollection(configCollection, calSubmitItemIdSet, cmpBudgetItemIdSet, templateStbItemIdSet);
        if (calSubmitItemIdSet.isEmpty() || cmpBudgetItemIdSet.isEmpty() || templateStbItemIdSet.isEmpty()) {
            return;
        }
        Map<String, BudgetTemplateSTBItemInfo> stbItemInfoMap = this.getTemplateStbItemMap(ctx, templateStbItemIdSet);
        Map<String, CalSubmitItemInfo> submitItemSnMap = this.getSubmitItemSnMap(ctx, calSubmitItemIdSet);
        Map<String, CmpBudgetItemInfo> cmpBudgetItemInfoMap = this.getBudgetItemSnMap(ctx, cmpBudgetItemIdSet);
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String entryIdInSql = cmpInSql.createInSqlBaseOnFId(ctx, entryIdSet);
        int configSize = configCollection.size();
        java.util.Date date = new java.util.Date();
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)currentUserId));
        BudgetPeriodEnum budgetPeriodEnum = this.getBudgetPeriodEnum(ctx, submitSchemeId);
        for (int i = 0; i < configSize; ++i) {
            SchemeDeduConfigInfo configInfo = configCollection.get(i);
            CalSubmitItemInfo calSubmitItem = configInfo.getCalSubmitItem();
            if (calSubmitItem == null || calSubmitItem.getId() == null) continue;
            String submitItemId = calSubmitItem.getId().toString();
            calSubmitItem = submitItemSnMap.get(submitItemId);
            CmpBudgetItemInfo cmpBudgetItem = configInfo.getCmpBudgetItem();
            if (cmpBudgetItem == null || cmpBudgetItem.getId() == null) continue;
            cmpBudgetItem = cmpBudgetItemInfoMap.get(cmpBudgetItem.getId().toString());
            BudgetTemplateSTBItemInfo templateStbItem = configInfo.getTemplateStbItem();
            if (templateStbItem == null || templateStbItem.getId() == null) continue;
            String budgetItemId = cmpBudgetItem.getId().toString();
            BudgetTemplateSTBItemInfo templateSTBItemInfo = stbItemInfoMap.get(templateStbItem.getId().toString());
            if (templateSTBItemInfo == null || templateSTBItemInfo.getStandingBookItem() == null) continue;
            String templateStbItemId = templateStbItem.getId().toString();
            BudgetSnapshotCollection snapshotCollection = this.getSnapshotNeedToOffset(ctx, submitSchemeId, entryIdInSql, budgetItemId, submitItemId, templateStbItemId);
            int snapshotSize = snapshotCollection.size();
            HashMap<String, BigDecimal> sumValueForOffsetMap = new HashMap<String, BigDecimal>();
            String splitFlag = "###";
            for (int j = 0; j < snapshotSize; ++j) {
                BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
                String bookTableId = snapshotInfo.getBookTableId();
                String subBookTableId = snapshotInfo.getSubBookTableId();
                if (StringUtils.isEmpty((String)bookTableId)) continue;
                String key = bookTableId + splitFlag + subBookTableId;
                BigDecimal sumVal = (BigDecimal)sumValueForOffsetMap.get(key);
                if (sumVal == null) {
                    sumVal = BigDecimal.ZERO;
                }
                BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
                sumVal = sumVal.add(value);
                sumValueForOffsetMap.put(key, sumVal);
                snapshotInfo.setIsOffset(true);
            }
            this.updateBookTableData(ctx, templateSTBItemInfo, sumValueForOffsetMap, splitFlag, budgetPeriodEnum);
            this.recordOffsetSnapshot(ctx, userInfo, snapshotCollection);
        }
    }

    protected void recordOffsetSnapshot(Context ctx, UserInfo userInfo, BudgetSnapshotCollection snapshotCollection) throws BOSException, EASBizException {
        CoreBaseCollection updateSnapshotColl = new CoreBaseCollection();
        Timestamp timeStamp = new Timestamp(new java.util.Date().getTime());
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
            if (!snapshotInfo.isIsOffset()) continue;
            snapshotInfo.setLastUpdateTime(timeStamp);
            snapshotInfo.setLastUpdateUser(userInfo);
            updateSnapshotColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (updateSnapshotColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance(ctx).saveBatchData(updateSnapshotColl);
        }
    }

    protected void updateBookTableData(Context ctx, BudgetTemplateSTBItemInfo templateSTBItemInfo, Map<String, BigDecimal> sumValueForOffsetMap, String splitFlag, BudgetPeriodEnum budgetPeriodEnum) throws BOSException {
        int fieldSn = templateSTBItemInfo.getStandingBookItem().getFieldSn();
        for (Map.Entry<String, BigDecimal> data : sumValueForOffsetMap.entrySet()) {
            String updateSql;
            String key = data.getKey();
            BigDecimal value = data.getValue();
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                value = BigDecimal.ZERO;
            }
            String[] tableSplit = key.split(splitFlag);
            if (budgetPeriodEnum != null && 0 == budgetPeriodEnum.getValue()) {
                updateSql = "update T_HR_SCmpStandingBook set S" + fieldSn + " = S" + fieldSn + " - " + value + " where FID ='" + tableSplit[0] + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
                continue;
            }
            updateSql = "update T_HR_SCmpStandingBook set S" + fieldSn + " = S" + fieldSn + " - " + value + " where FID ='" + tableSplit[0] + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
            updateSql = "update T_HR_SubCmpStandingBook set S" + fieldSn + " = S" + fieldSn + " - " + value + " where FID ='" + tableSplit[1] + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    protected BudgetSnapshotCollection getSnapshotNeedToRollBack(Context ctx, String submitSchemeId, String entryIdInSql, String budgetItemId, String calSubmitItemId, String templateStbItemId, UpdateNodeEnum updateNodeEnum) throws BOSException {
        StringBuilder oqlBuilder = new StringBuilder();
        oqlBuilder.append(" where calSubmitScheme.id ='").append(submitSchemeId).append("'");
        oqlBuilder.append(" and cmpBudgetItem.id = '").append(budgetItemId).append("'");
        oqlBuilder.append(" and calSubmitItem.id = '").append(calSubmitItemId).append("'");
        oqlBuilder.append(" and templateStbItem.id ='").append(templateStbItemId).append("'");
        oqlBuilder.append(" and submitShemeBillEntry.id in ").append(entryIdInSql);
        oqlBuilder.append(" and dataState = ").append(10);
        oqlBuilder.append(" and ( isRollback = 0 or isRollback is null)");
        if (updateNodeEnum != null) {
            int updateNodeEnumValue = updateNodeEnum.getValue();
            if (550 == updateNodeEnumValue) {
                oqlBuilder.append(" and updateNode = ").append(500);
            } else if (450 == updateNodeEnumValue) {
                oqlBuilder.append(" and updateNode = ").append(400);
            } else if (350 == updateNodeEnumValue) {
                oqlBuilder.append(" and updateNode in (");
                oqlBuilder.append(320);
                oqlBuilder.append(")");
            } else if (380 == updateNodeEnumValue) {
                oqlBuilder.append(" and updateNode = ").append(200);
            } else if (250 == updateNodeEnumValue) {
                oqlBuilder.append(" and updateNode = ").append(200);
            }
        }
        return BudgetSnapshotFactory.getLocalInstance(ctx).getBudgetSnapshotCollection(oqlBuilder.toString());
    }

    protected BudgetSnapshotCollection getSnapshotNeedToReverseOffset(Context ctx, String submitSchemeId, String entryIdInSql, String budgetItemId, String calSubmitItemId, String templateStbItemId) throws BOSException {
        String oqlBuilder = " where calSubmitScheme.id ='" + submitSchemeId + "' and cmpBudgetItem.id = '" + budgetItemId + "' and calSubmitItem.id = '" + calSubmitItemId + "' and templateStbItem.id ='" + templateStbItemId + "' and submitShemeBillEntry.id in " + entryIdInSql + " and dataState = " + 30 + " and isOffset = 1  and (isRollbackOffset = 0 or isRollbackOffset is null) ";
        return BudgetSnapshotFactory.getLocalInstance(ctx).getBudgetSnapshotCollection(oqlBuilder);
    }

    protected void extractIdFromConfigCollection(SchemeDeduConfigCollection configCollection, Set<String> calSubmitItemIdSet, Set<String> cmpBudgetItemIdSet, Set<String> templateStbItemIdSet) {
        int configSize = configCollection.size();
        for (int i = 0; i < configSize; ++i) {
            BudgetTemplateSTBItemInfo templateStbItem;
            CmpBudgetItemInfo cmpBudgetItem;
            SchemeDeduConfigInfo configInfo = configCollection.get(i);
            CalSubmitItemInfo calSubmitItem = configInfo.getCalSubmitItem();
            if (calSubmitItem != null && calSubmitItem.getId() != null) {
                calSubmitItemIdSet.add(calSubmitItem.getId().toString());
            }
            if ((cmpBudgetItem = configInfo.getCmpBudgetItem()) != null && cmpBudgetItem.getId() != null) {
                cmpBudgetItemIdSet.add(cmpBudgetItem.getId().toString());
            }
            if ((templateStbItem = configInfo.getTemplateStbItem()) == null || templateStbItem.getId() == null) continue;
            templateStbItemIdSet.add(templateStbItem.getId().toString());
        }
    }

    protected Map<String, BudgetTemplateSTBItemInfo> getTemplateStbItemMap(Context ctx, Set<String> templateStbItemIdSet) throws BOSException {
        HashMap<String, BudgetTemplateSTBItemInfo> stbItemInfoMap = new HashMap<String, BudgetTemplateSTBItemInfo>();
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String templateStbItemIn = cmpInSql.createInSqlBaseOnFId(ctx, templateStbItemIdSet);
        String templateStbOql = "select id,standingBookItem.id,standingBookItem.dataDot,standingBookItem.fieldSn,balanceLedgerItem.id,balanceLedgerItem.dataDot,balanceLedgerItem.fieldSn where id in " + templateStbItemIn;
        BudgetTemplateSTBItemCollection stbItemCollection = BudgetTemplateSTBItemFactory.getLocalInstance(ctx).getBudgetTemplateSTBItemCollection(templateStbOql);
        int stbItemSize = stbItemCollection.size();
        for (int i = 0; i < stbItemSize; ++i) {
            BudgetTemplateSTBItemInfo stbItemInfo = stbItemCollection.get(i);
            if (stbItemInfo == null || stbItemInfo.getId() == null) continue;
            stbItemInfoMap.put(stbItemInfo.getId().toString(), stbItemInfo);
        }
        return stbItemInfoMap;
    }

    protected Map<String, CalSubmitItemInfo> getSubmitItemSnMap(Context ctx, Set<String> submitItemIds) throws BOSException {
        HashMap<String, CalSubmitItemInfo> itemInfoMap = new HashMap<String, CalSubmitItemInfo>();
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String templateStbItemIn = cmpInSql.createInSqlBaseOnFId(ctx, submitItemIds);
        String oql = "select id,number,name,dataDot,fieldSn where id in " + templateStbItemIn;
        CalSubmitItemCollection itemCollection = CalSubmitItemFactory.getLocalInstance(ctx).getCalSubmitItemCollection(oql);
        int stbItemSize = itemCollection.size();
        for (int i = 0; i < stbItemSize; ++i) {
            CalSubmitItemInfo itemInfo = itemCollection.get(i);
            if (itemInfo == null || itemInfo.getId() == null) continue;
            itemInfoMap.put(itemInfo.getId().toString(), itemInfo);
        }
        return itemInfoMap;
    }

    protected Map<String, CmpBudgetItemInfo> getBudgetItemSnMap(Context ctx, Set<String> budgetItemIds) throws BOSException {
        HashMap<String, CmpBudgetItemInfo> itemInfoMap = new HashMap<String, CmpBudgetItemInfo>();
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String templateStbItemIn = cmpInSql.createInSqlBaseOnFId(ctx, budgetItemIds);
        String oql = "select id,number,name,dataDot,fieldSn where id in " + templateStbItemIn;
        CmpBudgetItemCollection itemCollection = CmpBudgetItemFactory.getLocalInstance(ctx).getCmpBudgetItemCollection(oql);
        int stbItemSize = itemCollection.size();
        for (int i = 0; i < stbItemSize; ++i) {
            CmpBudgetItemInfo itemInfo = itemCollection.get(i);
            if (itemInfo == null || itemInfo.getId() == null) continue;
            itemInfoMap.put(itemInfo.getId().toString(), itemInfo);
        }
        return itemInfoMap;
    }

    protected Map<String, Object> getBudgetSchemeIdAndCurrency(Context ctx, java.util.Date operateDate, String submitSchemeId) throws BOSException {
        String operateKsqlDate = CmpDateUtil.toKSqlDate(operateDate);
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean schemeHasTemplate = false;
        String getTemplateOfSubmitSchemeSql = "select FBUDGETTEMPLATEID from T_HR_SCalSubmitScheme where FBudgetTemplateID is not null and FID = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getTemplateOfSubmitSchemeSql, (Object[])new Object[]{submitSchemeId});
        try {
            while (rowSet.next()) {
                String templateId = rowSet.getString("FBUDGETTEMPLATEID");
                if (StringUtils.isEmpty((String)templateId)) continue;
                schemeHasTemplate = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("schemeHasTemplate", schemeHasTemplate);
        String schemeSql = " SELECT FID,FCURRENCYID FROM T_HR_SCmpBudgetScheme where FTemplateID in  ( select FBUDGETTEMPLATEID from T_HR_SCalSubmitScheme where FBudgetTemplateID is not null and FID = '" + submitSchemeId + "' )  and FEffectDate <= " + operateKsqlDate + " and FExpiryDate >= " + operateKsqlDate;
        IRowSet budgetRowSet = DbUtil.executeQuery((Context)ctx, (String)schemeSql);
        try {
            while (budgetRowSet.next()) {
                map.put("budgetSchemeId", budgetRowSet.getString("FID"));
                map.put("currencyId", budgetRowSet.getString("FCURRENCYID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    protected String getExChangeTableId(Context ctx, String submitSchemeId) throws BOSException {
        String queryExchangeTbSql = "SELECT FEXCHANGETABLEID FROM T_HR_SCalSubmitScheme where FID = '" + submitSchemeId + "'";
        IRowSet exchangeRowSet = DbUtil.executeQuery((Context)ctx, (String)queryExchangeTbSql);
        String exchangeTableId = "";
        try {
            while (exchangeRowSet.next()) {
                exchangeTableId = exchangeRowSet.getString("FEXCHANGETABLEID");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return exchangeTableId;
    }

    protected Map<String, Object> getSubmitDataAndInitSnapshot(Context ctx, Map<String, Object> params) throws BOSException {
        Set calSubmitItemIdSet = (Set)params.get("calSubmitItemIdSet");
        String billId = (String)params.get("billId");
        String submitSchemeId = (String)params.get("submitSchemeId");
        String dynamicEntryTableName = CmpIntegrateUtils.getCalShemeTableName(ctx, submitSchemeId);
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String calSubmitInSql = cmpInSql.createInSqlBaseOnFId(ctx, calSubmitItemIdSet);
        HashMap<String, String> submitSnIdMap = new HashMap<String, String>();
        HashSet<String> snSet = new HashSet<String>();
        String oql = "select id,dataDot,fieldSn where id in " + calSubmitInSql;
        CalSubmitItemCollection submitItemCollection = CalSubmitItemFactory.getLocalInstance(ctx).getCalSubmitItemCollection(oql);
        StringBuilder snBuilder = new StringBuilder();
        int itemSize = submitItemCollection.size();
        for (int i = 0; i < itemSize; ++i) {
            CalSubmitItemInfo submitItemInfo = submitItemCollection.get(i);
            int fieldSn = submitItemInfo.getFieldSn();
            String key = "S" + fieldSn;
            if (snSet.contains(key)) continue;
            snSet.add(key);
            snBuilder.append(",entry.").append(key);
            submitSnIdMap.put(key, submitItemInfo.getId().toString());
        }
        String exchangeTableId = this.getExChangeTableId(ctx, submitSchemeId);
        IRowSet entryRowSet = this.getBillEntryData(ctx, params, billId, dynamicEntryTableName, snBuilder);
        return this.getReturnDataMap(ctx, params, submitSnIdMap, snSet, exchangeTableId, entryRowSet);
    }

    private Map<String, Object> getReturnDataMap(Context ctx, Map<String, Object> params, Map<String, String> submitSnIdMap, Set<String> snSet, String exchangeTableId, IRowSet entryRowSet) throws BOSException {
        java.util.Date operateDate = (java.util.Date)params.get("operateDate");
        String currencyId = (String)params.get("currencyId");
        UpdateNodeEnum updateNodeEnum = (UpdateNodeEnum)((Object)params.get("updateNodeEnum"));
        ArrayList entryDataList = new ArrayList();
        HashMap<String, BigDecimal> submitSnDataMap = new HashMap<String, BigDecimal>();
        HashMap snapshotMap = new HashMap();
        try {
            String submitSchemeId = (String)params.get("submitSchemeId");
            BudgetTemplateInfo budgetTemplateInfo = null;
            if (!StringUtils.isEmpty((String)submitSchemeId)) {
                String getBudgetTemplateSql = "SELECT FBudgetTemplateID FROM T_HR_SCalSubmitScheme where FID = ?";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getBudgetTemplateSql, (Object[])new Object[]{submitSchemeId});
                while (rowSet.next()) {
                    String budgetTemplateID = rowSet.getString("FBudgetTemplateID");
                    if (StringUtils.isEmpty((String)budgetTemplateID)) continue;
                    budgetTemplateInfo = new BudgetTemplateInfo();
                    budgetTemplateInfo.setId(BOSUuid.read((String)budgetTemplateID));
                }
            }
            Timestamp operateTimeStamp = new Timestamp(operateDate.getTime());
            DataStateEnum dataStateEnum = (DataStateEnum)((Object)params.get("dataStateEnum"));
            HashMap<String, ExchangeRateInfo> rateInfoMap = new HashMap<String, ExchangeRateInfo>();
            while (entryRowSet.next()) {
                String entryId = entryRowSet.getString("FID");
                String billId = entryRowSet.getString("FBILLID");
                String currencyIdEntry = entryRowSet.getString("FCURRENCYID");
                HashMap<String, Object> entryMap = new HashMap<String, Object>();
                entryMap.put("entryId", entryId);
                for (String sn : snSet) {
                    BigDecimal entryData = entryRowSet.getBigDecimal(sn) == null ? BigDecimal.ZERO : entryRowSet.getBigDecimal(sn);
                    String submitItemId = submitSnIdMap.get(sn);
                    BigDecimal snSumData = submitSnDataMap.get(sn) == null ? BigDecimal.ZERO : (BigDecimal)submitSnDataMap.get(sn);
                    BigDecimal realVal = entryData;
                    BigDecimal rate = BigDecimal.ONE;
                    List<BudgetSnapshotInfo> snapshotInfoList = snapshotMap.get(sn) == null ? new ArrayList() : (List)snapshotMap.get(sn);
                    BudgetSnapshotInfo snapshotInfo = new BudgetSnapshotInfo();
                    this.setSubmitSchemeInfo(params, snapshotInfo);
                    this.setSubmitItemInfo(submitItemId, snapshotInfo);
                    this.setBillInfo(billId, snapshotInfo);
                    this.setBillEntryInfo(entryId, snapshotInfo);
                    this.setPersonInfo(entryRowSet, snapshotInfo);
                    this.setAdminOrgUnitInfo(entryRowSet, snapshotInfo);
                    this.setBudgetYear(entryRowSet, snapshotInfo);
                    this.setCostBearOrgInfo(entryRowSet, snapshotInfo);
                    this.setCostTypeInfo(entryRowSet, snapshotInfo);
                    this.setBusinessType(entryRowSet, snapshotInfo);
                    this.setHrOrgInfo(entryRowSet, snapshotInfo);
                    this.setCurrencyInfo(currencyIdEntry, snapshotInfo);
                    snapshotInfo.setIsRollback(false);
                    snapshotInfo.setIsOffset(false);
                    snapshotInfo.setIsRollbackOffset(false);
                    if (budgetTemplateInfo != null) {
                        snapshotInfo.setBudgetTemplate(budgetTemplateInfo);
                    }
                    snapshotInfo.setCreateTime(operateTimeStamp);
                    snapshotInfo.setLastUpdateTime(operateTimeStamp);
                    snapshotInfo.setUpdateNode(updateNodeEnum);
                    snapshotInfo.setDataState(dataStateEnum);
                    this.setUpdateDirection(dataStateEnum, snapshotInfo);
                    if (StringUtils.isEmpty((String)currencyIdEntry) || StringUtils.isEmpty((String)exchangeTableId)) {
                        snSumData = snSumData.add(entryData);
                        realVal = entryData;
                    } else {
                        ExchangeRateInfo exchangeRateInfo;
                        if (rateInfoMap.containsKey(currencyIdEntry)) {
                            exchangeRateInfo = (ExchangeRateInfo)rateInfoMap.get(currencyIdEntry);
                        } else {
                            exchangeRateInfo = CurrencyUtil.getClosestExchangeRate(ctx, exchangeTableId, currencyId, currencyIdEntry, operateDate);
                            rateInfoMap.put(currencyIdEntry, exchangeRateInfo);
                        }
                        if (exchangeRateInfo == null) {
                            snSumData = snSumData.add(entryData);
                            snapshotInfo.setValue(entryData);
                        } else {
                            BigDecimal convertRate = exchangeRateInfo.getConvertRate();
                            BigDecimal afterRateData = entryData.multiply(convertRate);
                            snSumData = snSumData.add(afterRateData);
                            realVal = afterRateData;
                            rate = convertRate;
                        }
                    }
                    snapshotInfo.setRate(rate);
                    snapshotInfo.setValue(realVal);
                    submitSnDataMap.put(sn, snSumData);
                    snapshotInfoList.add(snapshotInfo);
                    snapshotMap.put(sn, snapshotInfoList);
                    entryMap.put(sn, realVal);
                }
                entryDataList.add(entryMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        HashMap<String, Object> methodReturnMap = new HashMap<String, Object>();
        methodReturnMap.put("submitSnDataMap", submitSnDataMap);
        methodReturnMap.put("snapshotMap", snapshotMap);
        methodReturnMap.put("entryDataList", entryDataList);
        return methodReturnMap;
    }

    private void setBudgetYear(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        int budgetYear = entryRowSet.getInt("FBudgetYear");
        snapshotInfo.setBudgetYear(budgetYear);
    }

    private void setUpdateDirection(DataStateEnum dataStateEnum, BudgetSnapshotInfo snapshotInfo) {
        if (dataStateEnum != null) {
            if (10 == dataStateEnum.getValue()) {
                snapshotInfo.setUpdateDirection(UpdateDirectionEnum.SUBTRACT);
            } else if (20 == dataStateEnum.getValue()) {
                snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
            } else if (30 == dataStateEnum.getValue()) {
                snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
            }
        }
    }

    private void setBusinessType(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        int submitSchemeType = entryRowSet.getInt("FSubmitSchemeType");
        BusinessTypeEnum businessTypeEnum = null;
        if (submitSchemeType == 1) {
            businessTypeEnum = BusinessTypeEnum.SUBMIT_MANAGE;
        } else if (submitSchemeType == 2) {
            businessTypeEnum = BusinessTypeEnum.INSPIRE_MANAGE;
        } else if (submitSchemeType == 3) {
            businessTypeEnum = BusinessTypeEnum.ADJUST_SALARY_MANAGE;
        }
        snapshotInfo.setBusinessType(businessTypeEnum);
    }

    private void setCostTypeInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String costTypeID = entryRowSet.getString("FCostTypeID");
        if (!StringUtils.isEmpty((String)costTypeID)) {
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)costTypeID));
            snapshotInfo.setCostType(costTypeInfo);
        }
    }

    private void setCostBearOrgInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String costBearOrgID = entryRowSet.getString("FCostBearOrgID");
        if (!StringUtils.isEmpty((String)costBearOrgID)) {
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)costBearOrgID));
            snapshotInfo.setCostBearOrg(adminOrgUnitInfo);
        }
    }

    private void setAdminOrgUnitInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String adminOrgUnitID = entryRowSet.getString("FAdminOrgUnitID");
        if (!StringUtils.isEmpty((String)adminOrgUnitID)) {
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitID));
            snapshotInfo.setAdminOrgUnit(adminOrgUnitInfo);
        }
    }

    private void setCurrencyInfo(String currencyIdEntry, BudgetSnapshotInfo snapshotInfo) {
        if (!StringUtils.isEmpty((String)currencyIdEntry)) {
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)currencyIdEntry));
            snapshotInfo.setCurrency(currencyInfo);
        }
    }

    private void setHrOrgInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String hrOrgUnitId = entryRowSet.getString("FHROrgUnitID");
        HROrgUnitInfo hrOrgUnit = null;
        if (!StringUtils.isEmpty((String)hrOrgUnitId)) {
            hrOrgUnit = new HROrgUnitInfo();
            hrOrgUnit.setId(BOSUuid.read((String)hrOrgUnitId));
        }
        snapshotInfo.setHrOrgUnit(hrOrgUnit);
    }

    private void setBillInfo(String billId, BudgetSnapshotInfo snapshotInfo) {
        BatchSubmitShemeBillInfo submitSchemeBill = null;
        if (!StringUtils.isEmpty((String)billId)) {
            submitSchemeBill = new BatchSubmitShemeBillInfo();
            submitSchemeBill.setId(BOSUuid.read((String)billId));
        }
        snapshotInfo.setSubmitShemeBill(submitSchemeBill);
        snapshotInfo.setBill(submitSchemeBill);
    }

    private void setSubmitItemInfo(String submitItemId, BudgetSnapshotInfo snapshotInfo) {
        CalSubmitItemInfo calSubmitItemInfo = null;
        if (!StringUtils.isEmpty((String)submitItemId)) {
            calSubmitItemInfo = new CalSubmitItemInfo();
            calSubmitItemInfo.setId(BOSUuid.read((String)submitItemId));
        }
        snapshotInfo.setCalSubmitItem(calSubmitItemInfo);
        snapshotInfo.setItem(calSubmitItemInfo);
    }

    private void setSubmitSchemeInfo(Map<String, Object> params, BudgetSnapshotInfo snapshotInfo) {
        CalSubmitSchemeInfo calSubmitSchemeInfo = null;
        String submitSchemeId = (String)params.get("submitSchemeId");
        if (!StringUtils.isEmpty((String)submitSchemeId)) {
            calSubmitSchemeInfo = new CalSubmitSchemeInfo();
            calSubmitSchemeInfo.setId(BOSUuid.read((String)submitSchemeId));
        }
        snapshotInfo.setCalSubmitScheme(calSubmitSchemeInfo);
        snapshotInfo.setScheme(calSubmitSchemeInfo);
    }

    private void setBillEntryInfo(String entryId, BudgetSnapshotInfo snapshotInfo) {
        BatchSubmitShemeBillEntryInfo billEntryInfo = null;
        if (!StringUtils.isEmpty((String)entryId)) {
            billEntryInfo = new BatchSubmitShemeBillEntryInfo();
            billEntryInfo.setId(BOSUuid.read((String)entryId));
        }
        snapshotInfo.setSubmitShemeBillEntry(billEntryInfo);
        snapshotInfo.setBillEntry(billEntryInfo);
    }

    private void setPersonInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String personId = entryRowSet.getString("FpersonId");
        if (!StringUtils.isEmpty((String)personId)) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            snapshotInfo.setPerson(personInfo);
        }
    }

    protected IRowSet getBillEntryData(Context ctx, Map<String, Object> params, String billId, String dynamicEntryTableName, StringBuilder snBuilder) throws BOSException {
        String entryIdInSql = (String)params.get("entryIdInSql");
        String billEntrySqlBuild = " select bill.FBudgetYear, entry.FID,entry.FAdminOrgUnitID,entry.FBILLID,entry.FpersonId,entry.FCURRENCYID, bill.FHROrgUnitID,bill.FCostBearOrgID,bill.FCostTypeID, s.FSubmitSchemeType " + snBuilder + " FROM " + dynamicEntryTableName + " as entry left join T_HR_SBatchSubmitShemeBill bill on bill.FID = entry.FBILLID  left join T_HR_SCalSubmitScheme s on s.FID = bill.FSubmitSchemeID  where entry.FBillID = ?  and entry.FID in " + entryIdInSql;
        Object[] sqlParam = new Object[]{billId};
        return DbUtil.executeQuery((Context)ctx, (String)billEntrySqlBuild, (Object[])sqlParam);
    }

    protected int getBalanceTypeEnumValue(Context ctx, String budgetSchemeId) throws BOSException {
        int returnVal = Integer.MIN_VALUE;
        String balanceTypeOql = " SELECT id,subBalanceTypeEnum where id = '" + budgetSchemeId + "'";
        CmpBudgetSchemeCollection budgetSchemeCollection = CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeCollection(balanceTypeOql);
        if (budgetSchemeCollection == null || budgetSchemeCollection.isEmpty()) {
            return returnVal;
        }
        CmpBudgetSchemeInfo budgetSchemeInfo = budgetSchemeCollection.get(0);
        if (budgetSchemeInfo == null || budgetSchemeInfo.getSubBalanceTypeEnum() == null) {
            return returnVal;
        }
        return budgetSchemeInfo.getSubBalanceTypeEnum().getValue();
    }

    protected Map<String, String> getCostOrgAndCostTypeByBillId(Context ctx, String billId) throws BOSException {
        String billSql = "SELECT FID,FCOSTBEARORGID,FCOSTTYPEID FROM T_HR_SBatchSubmitShemeBill where FID = ?";
        String costBearOrgId = "";
        String costTypeId = "";
        IRowSet billRowSet = DbUtil.executeQuery((Context)ctx, (String)billSql, (Object[])new Object[]{billId});
        try {
            while (billRowSet.next()) {
                costBearOrgId = billRowSet.getString("FCOSTBEARORGID");
                costTypeId = billRowSet.getString("FCOSTTYPEID");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("costBearOrgId", costBearOrgId);
        map.put("costTypeId", costTypeId);
        return map;
    }

    protected BudgetPeriodEnum getBudgetPeriodEnum(Context ctx, String submitSchemeId) throws BOSException {
        String submitOql = "select id,budgetTemplate.budgetPeriod where id = '" + submitSchemeId + "'";
        CalSubmitSchemeCollection schemeCollection = CalSubmitSchemeFactory.getLocalInstance(ctx).getCalSubmitSchemeCollection(submitOql);
        if (schemeCollection.isEmpty() || schemeCollection.get(0) == null || schemeCollection.get(0).getBudgetTemplate() == null) {
            return null;
        }
        CalSubmitSchemeInfo submitSchemeInfo = schemeCollection.get(0);
        BudgetTemplateInfo budgetTemplateInfo = submitSchemeInfo.getBudgetTemplate();
        return budgetTemplateInfo.getBudgetPeriod();
    }

    protected java.util.Date getOperateDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected void checkAcross(Context ctx, String submitSchemeId, String billId, Set<String> billEntryIdSet) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)submitSchemeId)) {
            return;
        }
        java.util.Date operateDate = this.getOperateDate();
        Map<String, Object> budgetSchemeIdAndCurrency = this.getBudgetSchemeIdAndCurrency(ctx, operateDate, submitSchemeId);
        String budgetSchemeId = (String)budgetSchemeIdAndCurrency.get("budgetSchemeId");
        if (StringUtils.isEmpty((String)budgetSchemeId)) {
            return;
        }
        CmpInSql<String> inSqlObj = CmpInSqlFactory.getInstance();
        String inSql = inSqlObj.createInSqlBaseOnFId(ctx, billEntryIdSet);
        String sqlBuilder = " SELECT top 1 FID,FCreateTime,FSubBookTableId FROM T_HR_SBudgetSnapshot  where FDataState = 10 and FCreateTime is not null  and (FIsRollback=0 or FIsRollback is null)  and FSubmitShemeBillEntryID in " + inSql + " order by FCreateTime desc ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder);
        String subBookTableIdOfSnapshot = null;
        try {
            while (rowSet.next()) {
                String lastBudgetSchemeId;
                java.util.Date snapShotDate;
                Map<String, Object> snapshot;
                Date lastDeductDate = rowSet.getDate("FCreateTime");
                subBookTableIdOfSnapshot = rowSet.getString("FSubBookTableId");
                if (lastDeductDate == null || (snapshot = this.getBudgetSchemeIdAndCurrency(ctx, snapShotDate = new java.util.Date(lastDeductDate.getTime()), submitSchemeId)) == null || StringUtils.isEmpty((String)((String)snapshot.get("budgetSchemeId"))) || budgetSchemeId.equals(lastBudgetSchemeId = (String)snapshot.get("budgetSchemeId"))) continue;
                throw new EASBizException(new NumericExceptionSubItem("CMP_COMMON_INFO", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label12", (Locale)ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        this.checkAcrossOfSub(ctx, submitSchemeId, billId, operateDate, budgetSchemeId, subBookTableIdOfSnapshot);
    }

    protected void checkAcrossOfSub(Context ctx, String submitSchemeId, String billId, java.util.Date operateDate, String budgetSchemeId, String subBookTableIdOfSnapshot) throws BOSException, EASBizException {
        Map<String, String> costOrgAndCostTypeMap = this.getCostOrgAndCostTypeByBillId(ctx, billId);
        String costBearOrgId = costOrgAndCostTypeMap.get("costBearOrgId");
        String costTypeId = costOrgAndCostTypeMap.get("costTypeId");
        BudgetPeriodEnum budgetPeriodEnum = this.getBudgetPeriodEnum(ctx, submitSchemeId);
        if (budgetPeriodEnum != null && 0 != budgetPeriodEnum.getValue()) {
            String nowDate = BudgetUtil.getNowDateStr();
            int balanceTypeEnumValue = this.getBalanceTypeEnumValue(ctx, budgetSchemeId);
            if (2 == balanceTypeEnumValue) {
                StringBuilder subSqlBuild = new StringBuilder();
                subSqlBuild.append(" select sb.FID ");
                subSqlBuild.append(" FROM T_HR_SSubBudgetQuery ss ");
                subSqlBuild.append(" left join T_HR_SBudgetManage s on s.FID = ss.FBudgetManageID ");
                subSqlBuild.append(" left join T_HR_SCmpBudgetScheme cbs on s.FBudgetSchemeID = cbs.fid ");
                subSqlBuild.append(" left join T_HR_SCmpStandingBook b on b.FBudgetManageID=s.FID ");
                subSqlBuild.append(" left join T_HR_SubCmpStandingBook sb on sb.FCmpStandingBookID=b.FID and sb.FSubBudgetQueryID=ss.FID ");
                subSqlBuild.append(" where s.FAdminOrgUnitID = '").append(costBearOrgId).append("'");
                subSqlBuild.append(" and s.FCostTypeID = '").append(costTypeId).append("'");
                subSqlBuild.append(" and s.FBudgetSchemeID = '").append(budgetSchemeId).append("'");
                subSqlBuild.append(" and cbs.FEffectDate <= ").append(nowDate);
                subSqlBuild.append(" and cbs.FExpiryDate >= ").append(nowDate);
                subSqlBuild.append(" and s.FState = 1 ");
                String operateKsqlDate = CmpDateUtil.toKSqlDate(operateDate);
                subSqlBuild.append(" and ss.FEffectDate <= ").append(operateKsqlDate);
                subSqlBuild.append(" and ss.FExpiryDate >= ").append(operateKsqlDate);
                IRowSet subRowSet = DbUtil.executeQuery((Context)ctx, (String)subSqlBuild.toString());
                try {
                    while (subRowSet.next()) {
                        String id = subRowSet.getString("FID");
                        if (subBookTableIdOfSnapshot == null || subBookTableIdOfSnapshot.equals(id)) continue;
                        throw new EASBizException(new NumericExceptionSubItem("CMP_COMMON_INFO", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label12", (Locale)ctx.getLocale())));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void dealDeductConfig(Context ctx, String submitSchemeId, String billId, Set<String> entryIdSet, DeduNodeEnum deduNodeEnum, UpdateNodeEnum updateNodeEnum) throws BOSException, EASBizException {
        if (deduNodeEnum == null) {
            return;
        }
        String deductOql = " where calSubmitScheme = '" + submitSchemeId + "' and deduNode = " + deduNodeEnum.getValue();
        SchemeDeduConfigCollection configCollection = SchemeDeduConfigFactory.getLocalInstance(ctx).getSchemeDeduConfigCollection(deductOql);
        if (configCollection == null || configCollection.isEmpty()) {
            return;
        }
        HashSet<String> calSubmitItemIdSet = new HashSet<String>();
        HashSet<String> cmpBudgetItemIdSet = new HashSet<String>();
        HashSet<String> templateStbItemIdSet = new HashSet<String>();
        this.extractIdFromConfigCollection(configCollection, calSubmitItemIdSet, cmpBudgetItemIdSet, templateStbItemIdSet);
        if (calSubmitItemIdSet.isEmpty() || cmpBudgetItemIdSet.isEmpty() || templateStbItemIdSet.isEmpty()) {
            return;
        }
        Map<String, BudgetTemplateSTBItemInfo> stbItemInfoMap = this.getTemplateStbItemMap(ctx, templateStbItemIdSet);
        Map<String, CalSubmitItemInfo> submitItemSnMap = this.getSubmitItemSnMap(ctx, calSubmitItemIdSet);
        Map<String, CmpBudgetItemInfo> cmpBudgetItemInfoMap = this.getBudgetItemSnMap(ctx, cmpBudgetItemIdSet);
        java.util.Date operateDate = this.getOperateDate();
        Map<String, Object> budgetSchemeIdAndCurrency = this.getBudgetSchemeIdAndCurrency(ctx, operateDate, submitSchemeId);
        String budgetSchemeId = (String)budgetSchemeIdAndCurrency.get("budgetSchemeId");
        String currencyId = (String)budgetSchemeIdAndCurrency.get("currencyId");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("calSubmitItemIdSet", calSubmitItemIdSet);
        params.put("submitSchemeId", submitSchemeId);
        params.put("billId", billId);
        params.put("operateDate", operateDate);
        params.put("currencyId", currencyId);
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String entryIdInSql = cmpInSql.createInSqlBaseOnFId(ctx, entryIdSet);
        params.put("entryIdInSql", entryIdInSql);
        params.put("entryIdSet", entryIdSet);
        params.put("dataStateEnum", (Object)DataStateEnum.DEDUCT);
        params.put("updateNodeEnum", (Object)updateNodeEnum);
        Map<String, Object> submitDataAndInitSnapshot = this.getSubmitDataAndInitSnapshot(ctx, params);
        Map submitSnDataMap = (Map)submitDataAndInitSnapshot.get("submitSnDataMap");
        Map snapshotMap = (Map)submitDataAndInitSnapshot.get("snapshotMap");
        List entryDataList = (List)submitDataAndInitSnapshot.get("entryDataList");
        int balanceTypeEnumValue = this.getBalanceTypeEnumValue(ctx, budgetSchemeId);
        Map<String, String> costOrgAndCostTypeMap = this.getCostOrgAndCostTypeByBillId(ctx, billId);
        BudgetPeriodEnum budgetPeriodEnum = this.getBudgetPeriodEnum(ctx, submitSchemeId);
        if (budgetPeriodEnum == null) {
            return;
        }
        for (int i = 0; i < configCollection.size(); ++i) {
            String templateStbItemId;
            BudgetTemplateSTBItemInfo templateSTBItemInfo;
            SchemeDeduConfigInfo configInfo = configCollection.get(i);
            CalSubmitItemInfo calSubmitItem = configInfo.getCalSubmitItem();
            if (calSubmitItem == null || calSubmitItem.getId() == null) continue;
            calSubmitItem = submitItemSnMap.get(calSubmitItem.getId().toString());
            CmpBudgetItemInfo cmpBudgetItem = configInfo.getCmpBudgetItem();
            if (cmpBudgetItem == null || cmpBudgetItem.getId() == null) continue;
            cmpBudgetItem = cmpBudgetItemInfoMap.get(cmpBudgetItem.getId().toString());
            BudgetTemplateSTBItemInfo templateStbItem = configInfo.getTemplateStbItem();
            if (templateStbItem == null || templateStbItem.getId() == null || (templateSTBItemInfo = stbItemInfoMap.get(templateStbItemId = templateStbItem.getId().toString())) == null || templateSTBItemInfo.getStandingBookItem() == null || templateSTBItemInfo.getStandingBookItem().getId() == null || templateSTBItemInfo.getBalanceLedgerItem() == null || templateSTBItemInfo.getBalanceLedgerItem().getId() == null) continue;
            String stbSnCol = "S" + templateSTBItemInfo.getStandingBookItem().getFieldSn();
            String budgetSnCol = "T" + cmpBudgetItem.getFieldSn();
            String submitSnCol = "S" + calSubmitItem.getFieldSn();
            String leftSnCol = "S" + templateSTBItemInfo.getBalanceLedgerItem().getFieldSn();
            MethodParam methodParam = new MethodParam();
            methodParam.setOperateDate(operateDate);
            methodParam.setBudgetSchemeId(budgetSchemeId);
            methodParam.setSubmitSchemeId(submitSchemeId);
            methodParam.setSubmitSnDataMap(submitSnDataMap);
            methodParam.setSnapshotMap(snapshotMap);
            methodParam.setDeduNodeEnum(deduNodeEnum);
            methodParam.setBalanceTypeEnumValue(balanceTypeEnumValue);
            methodParam.setCostOrgAndCostTypeMap(costOrgAndCostTypeMap);
            methodParam.setCmpBudgetItem(cmpBudgetItem);
            methodParam.setCalSubmitItemInfo(calSubmitItem);
            methodParam.setTemplateSTBItemInfo(templateSTBItemInfo);
            methodParam.setBudgetSnCol(budgetSnCol);
            methodParam.setSubmitSnCol(submitSnCol);
            methodParam.setStbSnCol(stbSnCol);
            methodParam.setLeftSnCol(leftSnCol);
            methodParam.setEntryDataList(entryDataList);
            if (0 == budgetPeriodEnum.getValue()) {
                this.deductDataOfYearPeriod(ctx, methodParam);
                continue;
            }
            this.deductDataOfNotYearPeriod(ctx, methodParam);
        }
    }

    protected int getBudgetYear(java.util.Date operateDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(operateDate);
        return calendar.get(1);
    }

    protected void deductDataOfYearPeriod(Context ctx, MethodParam methodParam) throws BOSException, EASBizException {
        String standingBookId;
        BigDecimal leftAmount;
        BigDecimal submitBigDecimal;
        String budgetSchemeId = methodParam.getBudgetSchemeId();
        Map<String, String> costOrgAndCostTypeMap = methodParam.getCostOrgAndCostTypeMap();
        CmpBudgetItemInfo cmpBudgetItem = methodParam.getCmpBudgetItem();
        String stbSnCol = methodParam.getStbSnCol();
        String budgetSnCol = methodParam.getBudgetSnCol();
        String submitSnCol = methodParam.getSubmitSnCol();
        String leftSnCol = methodParam.getLeftSnCol();
        String costBearOrgId = costOrgAndCostTypeMap.get("costBearOrgId");
        String costTypeId = costOrgAndCostTypeMap.get("costTypeId");
        String nowDate = BudgetUtil.getNowDateStr();
        String sqlBuild = " SELECT b.FState,s.FID as SFID,b.FID as BDIF,c.FUsedAmount as FUSEDAMOUNT, b." + budgetSnCol + ", s." + stbSnCol + " ,s." + leftSnCol + " FROM T_HR_SBudgetManage b  LEFT JOIN T_HR_SCmpBudgetScheme cbs on b.FBudgetSchemeId = cbs.fid  LEFT JOIN T_HR_SCmpStandingBook s on b.FID = s.FBudgetManageID  LEFT JOIN T_HR_SCmpUsedAmount c on c.FBudgetManageID=b.FID and c.FCmpBudgetItemID = '" + cmpBudgetItem.getId() + "' where b.FAdminOrgUnitID = '" + costBearOrgId + "' and b.FCostTypeID = '" + costTypeId + "' and cbs.FEffectDate <= " + nowDate + " and cbs.FExpiryDate >= " + nowDate + " and b.FBudgetSchemeID = '" + budgetSchemeId + "'";
        IRowSet yearRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuild);
        BigDecimal usedAmount = BigDecimal.ZERO;
        BigDecimal budgetAmount = BigDecimal.ZERO;
        BigDecimal stbAmount = BigDecimal.ZERO;
        String bookId = "";
        String budgetId = "";
        boolean hasLeft = false;
        BigDecimal leftBudgetData = BigDecimal.ZERO;
        try {
            while (yearRowSet.next()) {
                int state = yearRowSet.getInt("FState");
                if (2 == state) {
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION11);
                }
                bookId = yearRowSet.getString("SFID");
                budgetId = yearRowSet.getString("BDIF");
                usedAmount = yearRowSet.getBigDecimal("FUSEDAMOUNT") == null ? BigDecimal.ZERO : yearRowSet.getBigDecimal("FUSEDAMOUNT");
                stbAmount = yearRowSet.getBigDecimal(stbSnCol) == null ? BigDecimal.ZERO : yearRowSet.getBigDecimal(stbSnCol);
                budgetAmount = yearRowSet.getBigDecimal(budgetSnCol) == null ? BigDecimal.ZERO : yearRowSet.getBigDecimal(budgetSnCol);
                BigDecimal leftData = yearRowSet.getBigDecimal(leftSnCol);
                if (leftData != null) {
                    hasLeft = true;
                }
                if (leftData == null) {
                    leftData = BigDecimal.ZERO;
                }
                leftBudgetData = leftData;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        Map<String, BigDecimal> submitSnDataMap = methodParam.getSubmitSnDataMap();
        BigDecimal bigDecimal = submitBigDecimal = submitSnDataMap.get(submitSnCol) == null ? BigDecimal.ZERO : submitSnDataMap.get(submitSnCol);
        if (hasLeft) {
            BigDecimal isEnoughData = leftBudgetData.subtract(submitBigDecimal);
            if (BigDecimal.ZERO.compareTo(isEnoughData) > 0) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION12);
            }
            leftAmount = leftBudgetData.subtract(submitBigDecimal);
        } else {
            leftAmount = budgetAmount.subtract(usedAmount).subtract(stbAmount).subtract(submitBigDecimal);
            if (BigDecimal.ZERO.compareTo(leftAmount) > 0) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION12);
            }
        }
        BigDecimal newStbDecimal = stbAmount.add(submitBigDecimal);
        if (StringUtils.isEmpty((String)bookId)) {
            String insertStbSqlBuilder = " insert into T_HR_SCmpStandingBook (FID,FBudgetManageID," + stbSnCol + "," + leftSnCol + ") values(?,?,?,?)";
            standingBookId = BOSUuid.create((String)"8B07DDF4").toString();
            DbUtil.execute((Context)ctx, (String)insertStbSqlBuilder, (Object[])new Object[]{standingBookId, budgetId, newStbDecimal, leftAmount});
        } else {
            String updateStbSql = "update T_HR_SCmpStandingBook set " + stbSnCol + " = ?," + leftSnCol + " = ? where FID = ? ";
            standingBookId = bookId;
            DbUtil.execute((Context)ctx, (String)updateStbSql, (Object[])new Object[]{newStbDecimal, leftAmount, bookId});
        }
        CoreBaseCollection snapshotCoreBaseColl = this.saveSnapshotData(ctx, methodParam, standingBookId);
        this.saveOffsetSnapshotData(ctx, methodParam, snapshotCoreBaseColl);
    }

    protected void saveOffsetSnapshotData(Context ctx, MethodParam methodParam, CoreBaseCollection snapshotCoreBaseColl) throws BOSException, EASBizException {
        String submitSchemeId = methodParam.getSubmitSchemeId();
        CalSubmitItemInfo submitItemInfo = methodParam.getCalSubmitItemInfo();
        CmpBudgetItemInfo budgetItemInfo = methodParam.getCmpBudgetItem();
        DeduNodeEnum deduNodeEnum = methodParam.getDeduNodeEnum();
        if (StringUtils.isEmpty((String)submitSchemeId) || submitItemInfo == null || submitItemInfo.getId() == null || budgetItemInfo == null || budgetItemInfo.getId() == null || deduNodeEnum == null) {
            return;
        }
        String offsetSqlBuild = " SELECT a.FID,a.FTemplateStbItemID,b.FStandingBookItemID,b.FBalanceLedgerItemID  FROM T_HR_SSchemeDeduConfig a  left join T_HR_SBudgetTemplateSTBItem b on b.FID = a.FTemplateStbItemID  where a.FCalSubmitSchemeID = ? and a.FCalSubmitItemID = ? and a.FCmpBudgetItemID =? and a.FOffsetNode = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)offsetSqlBuild, (Object[])new Object[]{submitSchemeId, submitItemInfo.getId().toString(), budgetItemInfo.getId().toString(), deduNodeEnum.getValue()});
        CalSubmitSchemeInfo calSubmitSchemeInfo = new CalSubmitSchemeInfo();
        calSubmitSchemeInfo.setId(BOSUuid.read((String)submitSchemeId));
        try {
            CoreBaseCollection insertCoreBaseColl = new CoreBaseCollection();
            Timestamp timestamp = new Timestamp(new java.util.Date().getTime());
            while (rowSet.next()) {
                String templateStbItemID = rowSet.getString("FTemplateStbItemID");
                if (StringUtils.isEmpty((String)templateStbItemID)) continue;
                BudgetTemplateSTBItemInfo budgetTemplateSTBItemInfo = new BudgetTemplateSTBItemInfo();
                budgetTemplateSTBItemInfo.setId(BOSUuid.read((String)templateStbItemID));
                String standingBookItemID = rowSet.getString("FStandingBookItemID");
                StandingBookItemInfo standingBookItemInfo = null;
                if (!StringUtils.isEmpty((String)standingBookItemID)) {
                    standingBookItemInfo = new StandingBookItemInfo();
                    standingBookItemInfo.setId(BOSUuid.read((String)standingBookItemID));
                }
                String balanceLedgerItemID = rowSet.getString("FBalanceLedgerItemID");
                StandingBookItemInfo balanceItem = null;
                if (!StringUtils.isEmpty((String)balanceLedgerItemID)) {
                    balanceItem = new StandingBookItemInfo();
                    balanceItem.setId(BOSUuid.read((String)balanceLedgerItemID));
                }
                for (int j = 0; j < snapshotCoreBaseColl.size(); ++j) {
                    BudgetSnapshotInfo snapshotInfo = (BudgetSnapshotInfo)snapshotCoreBaseColl.get(j);
                    snapshotInfo.setId(null);
                    snapshotInfo.setCalSubmitScheme(calSubmitSchemeInfo);
                    snapshotInfo.setCalSubmitItem(submitItemInfo);
                    snapshotInfo.setCmpBudgetItem(budgetItemInfo);
                    snapshotInfo.setDataState(DataStateEnum.OFFSET);
                    snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
                    snapshotInfo.setIsOffset(false);
                    snapshotInfo.setIsRollback(false);
                    snapshotInfo.setIsRollbackOffset(false);
                    snapshotInfo.setTemplateStbItem(budgetTemplateSTBItemInfo);
                    snapshotInfo.setStandingBookItem(standingBookItemInfo);
                    snapshotInfo.setBalanceLedgerItem(balanceItem);
                    snapshotInfo.setCreateTime(timestamp);
                    snapshotInfo.setLastUpdateTime(timestamp);
                    insertCoreBaseColl.add((CoreBaseInfo)snapshotInfo);
                }
            }
            if (insertCoreBaseColl.size() > 0) {
                BudgetSnapshotFactory.getLocalInstance(ctx).saveBatchData(insertCoreBaseColl);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected CurrencyInfo getBudgetCurrency(Context ctx, String budgetSchemeId) throws BOSException {
        if (StringUtils.isEmpty((String)budgetSchemeId)) {
            return null;
        }
        CmpBudgetSchemeCollection budgetSchemeCollection = CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeCollection("select currency where id = '" + budgetSchemeId + "'");
        if (budgetSchemeCollection != null && !budgetSchemeCollection.isEmpty()) {
            CmpBudgetSchemeInfo cmpBudgetSchemeInfo = budgetSchemeCollection.get(0);
            return cmpBudgetSchemeInfo.getCurrency();
        }
        return null;
    }

    protected CoreBaseCollection saveSnapshotData(Context ctx, MethodParam methodParam, String standingBookId) throws BOSException, EASBizException {
        CmpBudgetItemInfo cmpBudgetItem = methodParam.getCmpBudgetItem();
        Timestamp currentTimeStamp = new Timestamp(new java.util.Date().getTime());
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)currentUserId));
        String submitSnCol = methodParam.getSubmitSnCol();
        Map<String, List<BudgetSnapshotInfo>> snapshotMap = methodParam.getSnapshotMap();
        List<BudgetSnapshotInfo> snapshotInfoList = snapshotMap.get(submitSnCol);
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        BudgetTemplateSTBItemInfo templateSTBItemInfo = methodParam.getTemplateSTBItemInfo();
        String budgetSchemeId = methodParam.getBudgetSchemeId();
        CmpBudgetSchemeInfo budgetSchemeInfo = null;
        if (!StringUtils.isEmpty((String)budgetSchemeId)) {
            budgetSchemeInfo = new CmpBudgetSchemeInfo();
            budgetSchemeInfo.setId(BOSUuid.read((String)budgetSchemeId));
        }
        CurrencyInfo budgetCurrency = this.getBudgetCurrency(ctx, budgetSchemeId);
        for (int j = 0; j < snapshotInfoList.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotInfoList.get(j);
            if (budgetSchemeInfo != null) {
                snapshotInfo.setBudgetScheme(budgetSchemeInfo);
            }
            snapshotInfo.setBudgetCurrency(budgetCurrency);
            snapshotInfo.setBudgetMangeTb("T_HR_SBudgetManage");
            snapshotInfo.setCmpBudgetItem(cmpBudgetItem);
            snapshotInfo.setStandingBookItem(templateSTBItemInfo.getStandingBookItem());
            snapshotInfo.setBalanceLedgerItem(templateSTBItemInfo.getBalanceLedgerItem());
            snapshotInfo.setTemplateStbItem(templateSTBItemInfo);
            snapshotInfo.setBookTable("T_HR_SCmpStandingBook");
            snapshotInfo.setBookTableId(standingBookId);
            snapshotInfo.setCreateTime(currentTimeStamp);
            snapshotInfo.setLastUpdateTime(currentTimeStamp);
            snapshotInfo.setCreator(userInfo);
            snapshotInfo.setLastUpdateUser(userInfo);
            snapshotInfo.setSubBookTable("T_HR_SCmpStandingBook");
            snapshotInfo.setSubBookTableId(standingBookId);
            coreBaseCollection.add((CoreBaseInfo)snapshotInfo);
        }
        BudgetSnapshotFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
        return coreBaseCollection;
    }

    protected void deductDataOfNotYearPeriod(Context ctx, MethodParam methodParam) throws BOSException, EASBizException {
        String stbSnCol = methodParam.getStbSnCol();
        String budgetSnCol = methodParam.getBudgetSnCol();
        String submitSnCol = methodParam.getSubmitSnCol();
        String leftSnCol = methodParam.getLeftSnCol();
        List<Map<String, Object>> entryDataList = methodParam.getEntryDataList();
        Map<String, Object> budgetDataMap = this.getBudgetAndStandingData(ctx, methodParam);
        List rowSetDataList = (List)budgetDataMap.get("sourceDataList");
        List leftDataList = (List)budgetDataMap.get("sourceDataListOfCopy");
        if (!rowSetDataList.isEmpty()) {
            List<BudgetSnapshotInfo> realSnapshotList;
            BigDecimal totalLeftDataOfSub = BigDecimal.ZERO;
            BigDecimal curUsedData = BigDecimal.ZERO;
            BigDecimal outerUsedData = BigDecimal.ZERO;
            BigDecimal totalBudgetTotalTable = BigDecimal.ZERO;
            BigDecimal totalLeftOfTotalTable = BigDecimal.ZERO;
            BigDecimal totalUsedOfTotalTable = BigDecimal.ZERO;
            boolean hasLeftDataOfSub = false;
            boolean hasLeftDataOfTotal = false;
            for (int j = 0; j < rowSetDataList.size(); ++j) {
                BigDecimal totalLeft;
                Map dataMap = (Map)rowSetDataList.get(j);
                BigDecimal usedData = dataMap.get(stbSnCol) == null ? BigDecimal.ZERO : (BigDecimal)dataMap.get(stbSnCol);
                curUsedData = curUsedData.add(usedData);
                BigDecimal bigDecimal = outerUsedData = dataMap.get("usedAmount") == null ? BigDecimal.ZERO : (BigDecimal)dataMap.get("usedAmount");
                if (dataMap.get(leftSnCol) != null) {
                    hasLeftDataOfSub = true;
                }
                if ((totalLeft = (BigDecimal)dataMap.get("totalLeft")) != null) {
                    hasLeftDataOfTotal = true;
                }
                BigDecimal leftData = dataMap.get(leftSnCol) == null ? BigDecimal.ZERO : (BigDecimal)dataMap.get(leftSnCol);
                totalLeftDataOfSub = totalLeftDataOfSub.add(leftData);
                totalBudgetTotalTable = dataMap.get("totalBudget") == null ? BigDecimal.ZERO : (BigDecimal)dataMap.get("totalBudget");
                totalLeftOfTotalTable = totalLeft == null ? BigDecimal.ZERO : totalLeft;
                totalUsedOfTotalTable = dataMap.get("totalUsed") == null ? BigDecimal.ZERO : (BigDecimal)dataMap.get("totalUsed");
            }
            BigDecimal submitBigDecimalOfSum = BigDecimal.ZERO;
            for (int i = 0; i < entryDataList.size(); ++i) {
                Map<String, Object> entryDataMap = entryDataList.get(i);
                BigDecimal submitData = entryDataMap.get(submitSnCol) == null ? BigDecimal.ZERO : (BigDecimal)entryDataMap.get(submitSnCol);
                submitBigDecimalOfSum = submitBigDecimalOfSum.add(submitData);
            }
            if (hasLeftDataOfSub) {
                this.checkBudgetEnoughWhenHasLeft(ctx, totalLeftDataOfSub, submitBigDecimalOfSum);
                realSnapshotList = this.deductSubmitData(methodParam, entryDataList, leftDataList, true);
            } else {
                List allSubBudgetDataList = (List)budgetDataMap.get("allSubBudgetDataList");
                this.deductOuterUsedData(budgetSnCol, outerUsedData, allSubBudgetDataList);
                this.updateDataAfterOuterUsed(budgetSnCol, leftDataList, allSubBudgetDataList);
                this.checkBudgetEnough(ctx, budgetSnCol, leftDataList, curUsedData, submitBigDecimalOfSum);
                this.deductUsedData(stbSnCol, budgetSnCol, leftDataList);
                realSnapshotList = this.deductSubmitData(methodParam, entryDataList, leftDataList, false);
                this.fillData(stbSnCol, budgetSnCol, leftSnCol, leftDataList, allSubBudgetDataList);
            }
            BigDecimal totalLeftData = hasLeftDataOfTotal ? totalLeftOfTotalTable.subtract(submitBigDecimalOfSum) : totalBudgetTotalTable.subtract(outerUsedData).subtract(curUsedData).subtract(submitBigDecimalOfSum);
            BigDecimal totalUsedData = submitBigDecimalOfSum.add(totalUsedOfTotalTable);
            Map rowSetDataMap = (Map)rowSetDataList.get(0);
            String standingBookId = (String)rowSetDataMap.get("standingBookId");
            String budgetId = (String)rowSetDataMap.get("budgetId");
            if (StringUtils.isEmpty((String)standingBookId)) {
                standingBookId = this.insertStandingBookDataOfDeduct(ctx, stbSnCol, budgetSnCol, leftSnCol, leftDataList, totalLeftData, totalUsedData, budgetId);
            } else {
                this.updateStandingBookDataOfDeduct(ctx, stbSnCol, budgetSnCol, leftSnCol, rowSetDataList, leftDataList, totalLeftData, totalUsedData, standingBookId);
            }
            this.updateNullLeftDataSubPeriod(ctx, leftSnCol, budgetDataMap);
            Timestamp currentTimeStamp = new Timestamp(new java.util.Date().getTime());
            String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)currentUserId));
            CmpBudgetSchemeInfo budgetSchemeInfo = null;
            String budgetSchemeId = methodParam.getBudgetSchemeId();
            if (!StringUtils.isEmpty((String)budgetSchemeId)) {
                budgetSchemeInfo = new CmpBudgetSchemeInfo();
                budgetSchemeInfo.setId(BOSUuid.read((String)budgetSchemeId));
            }
            CurrencyInfo budgetCurrency = this.getBudgetCurrency(ctx, budgetSchemeId);
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < realSnapshotList.size(); ++i) {
                BudgetSnapshotInfo snapshotInfo = realSnapshotList.get(i);
                snapshotInfo.setBookTableId(standingBookId);
                snapshotInfo.setBudgetCurrency(budgetCurrency);
                UserInfo creator = snapshotInfo.getCreator();
                if (creator == null || creator.getId() == null) {
                    snapshotInfo.setCreator(userInfo);
                    snapshotInfo.setCreateTime(currentTimeStamp);
                }
                if (budgetSchemeInfo != null) {
                    snapshotInfo.setBudgetScheme(budgetSchemeInfo);
                }
                snapshotInfo.setLastUpdateTime(currentTimeStamp);
                snapshotInfo.setLastUpdateUser(userInfo);
                coreBaseCollection.add((CoreBaseInfo)snapshotInfo);
            }
            BudgetSnapshotFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
            this.saveOffsetSnapshotData(ctx, methodParam, coreBaseCollection);
        }
    }

    protected void updateNullLeftDataSubPeriod(Context ctx, String leftSnCol, Map<String, Object> budgetDataMap) throws BOSException {
        Map subBudgetDataMap = (Map)budgetDataMap.get("subBudgetDataMap");
        if (subBudgetDataMap != null) {
            String updateSql = "update T_HR_SubCmpStandingBook set " + leftSnCol + " = ? where FID = ? and " + leftSnCol + " is null";
            Iterator iterator = subBudgetDataMap.entrySet().iterator();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String subStandingBookId = (String)next.getKey();
                if (StringUtils.isEmpty((String)subStandingBookId)) continue;
                Object[] paramArr = new Object[2];
                BigDecimal budgetData = (BigDecimal)next.getValue();
                paramArr[0] = budgetData;
                paramArr[1] = subStandingBookId;
                paramList.add(paramArr);
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        }
    }

    private void fillData(String stbSnCol, String budgetSnCol, String leftSnCol, List<Map<String, Object>> leftDataList, List<Map<String, Object>> allSubBudgetDataList) {
        String subBudgetQueryId;
        HashSet<String> leftDataIdSet = new HashSet<String>();
        for (int i = 0; i < leftDataList.size(); ++i) {
            Map<String, Object> leftMap = leftDataList.get(i);
            if (leftMap == null || StringUtils.isEmpty((String)(subBudgetQueryId = (String)leftMap.get("subBudgetQueryId")))) continue;
            leftDataIdSet.add(subBudgetQueryId);
        }
        for (int j = 0; j < allSubBudgetDataList.size(); ++j) {
            Map<String, Object> subBudgetMap = allSubBudgetDataList.get(j);
            if (subBudgetMap == null || leftDataIdSet.contains(subBudgetQueryId = (String)subBudgetMap.get("subBudgetQueryId"))) continue;
            HashMap<String, Object> leftDataMap = new HashMap<String, Object>();
            leftDataMap.put("isFromFillData", true);
            leftDataMap.put("budgetId", subBudgetMap.get("budgetId"));
            leftDataMap.put("subBudgetQueryId", subBudgetMap.get("subBudgetQueryId"));
            leftDataMap.put("trueSubStandingBookId", subBudgetMap.get("trueSubStandingBookId"));
            leftDataMap.put(budgetSnCol, subBudgetMap.get(budgetSnCol));
            leftDataMap.put(stbSnCol, null);
            leftDataMap.put(leftSnCol, subBudgetMap.get(budgetSnCol));
            leftDataList.add(leftDataMap);
        }
    }

    protected void checkBudgetEnoughWhenHasLeft(Context ctx, BigDecimal totalLeftDataOfSub, BigDecimal submitBigDecimalOfSum) throws EASBizException {
        BigDecimal leftBudget = totalLeftDataOfSub.subtract(submitBigDecimalOfSum);
        if (BigDecimal.ZERO.compareTo(leftBudget) > 0) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)ctx.getLocale())));
        }
    }

    protected void checkBudgetEnough(Context ctx, String budgetSnCol, List<Map<String, Object>> leftDataList, BigDecimal curUsedData, BigDecimal submitBigDecimalOfSum) throws EASBizException {
        BigDecimal leftBudgetSum = BigDecimal.ZERO;
        for (int i = 0; i < leftDataList.size(); ++i) {
            Map<String, Object> map = leftDataList.get(i);
            if (map == null) continue;
            BigDecimal leftBudget = map.get(budgetSnCol) == null ? BigDecimal.ZERO : (BigDecimal)map.get(budgetSnCol);
            leftBudgetSum = leftBudgetSum.add(leftBudget);
        }
        BigDecimal leftData = leftBudgetSum.subtract(curUsedData).subtract(submitBigDecimalOfSum);
        if (BigDecimal.ZERO.compareTo(leftData) > 0) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)ctx.getLocale())));
        }
    }

    protected void updateDataAfterOuterUsed(String budgetSnCol, List<Map<String, Object>> leftDataList, List<Map<String, Object>> allSubBudgetDataList) {
        for (int i = 0; i < leftDataList.size(); ++i) {
            String subBudgetQueryId;
            Map<String, Object> leftMap = leftDataList.get(i);
            if (leftMap == null || StringUtils.isEmpty((String)(subBudgetQueryId = (String)leftMap.get("subBudgetQueryId")))) continue;
            for (int j = 0; j < allSubBudgetDataList.size(); ++j) {
                String subBudgetQueryId1;
                Map<String, Object> subBudgetMap = allSubBudgetDataList.get(j);
                if (subBudgetMap == null || !subBudgetQueryId.equals(subBudgetQueryId1 = (String)subBudgetMap.get("subBudgetQueryId"))) continue;
                leftMap.put(budgetSnCol, subBudgetMap.get(budgetSnCol));
            }
        }
    }

    protected void updateStandingBookDataOfDeduct(Context ctx, String stbSnCol, String budgetSnCol, String leftSnCol, List<Map<String, Object>> rowSetDataList, List<Map<String, Object>> leftDataList, BigDecimal totalLeftData, BigDecimal totalUsedData, String standingBookId) throws BOSException {
        StringBuilder updateBuilder = new StringBuilder();
        updateBuilder.append("update T_HR_SCmpStandingBook set ").append(stbSnCol).append(" = ?,");
        updateBuilder.append(leftSnCol).append("= ? where FID = ? ");
        DbUtil.execute((Context)ctx, (String)updateBuilder.toString(), (Object[])new Object[]{totalUsedData, totalLeftData, standingBookId});
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int k = 0; k < rowSetDataList.size(); ++k) {
            Map<String, Object> leftMap = leftDataList.get(k);
            BigDecimal leftMapOfLeftData = leftMap.get(budgetSnCol) == null ? BigDecimal.ZERO : (BigDecimal)leftMap.get(budgetSnCol);
            BigDecimal usedData = leftMap.get(stbSnCol) == null ? BigDecimal.ZERO : (BigDecimal)leftMap.get(stbSnCol);
            Object[] dbParams = new Object[]{usedData, leftMapOfLeftData, leftMap.get("trueSubStandingBookId")};
            paramList.add(dbParams);
        }
        updateBuilder = new StringBuilder();
        updateBuilder.append("update T_HR_SubCmpStandingBook set ").append(stbSnCol).append(" = ?,");
        updateBuilder.append(leftSnCol).append(" = ? where FID = ?");
        DbUtil.executeBatchAndReturn((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected String insertStandingBookDataOfDeduct(Context ctx, String stbSnCol, String budgetSnCol, String leftSnCol, List<Map<String, Object>> leftDataList, BigDecimal totalLeftData, BigDecimal totalUsedData, String budgetId) throws BOSException {
        String insertBuild = " insert into T_HR_SCmpStandingBook (FID,FBudgetManageID," + stbSnCol + "," + leftSnCol + ") values (?,?,?,?)";
        String newStandingBookId = BOSUuid.create((String)"8B07DDF4").toString();
        DbUtil.execute((Context)ctx, (String)insertBuild, (Object[])new Object[]{newStandingBookId, budgetId, totalUsedData, totalLeftData});
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int k = 0; k < leftDataList.size(); ++k) {
            Map<String, Object> leftMap = leftDataList.get(k);
            BigDecimal leftMapOfLeftData = leftMap.get(budgetSnCol) == null ? BigDecimal.ZERO : (BigDecimal)leftMap.get(budgetSnCol);
            Boolean isFromFillData = (Boolean)leftMap.get("isFromFillData");
            BigDecimal usedAmount = (BigDecimal)leftMap.get(stbSnCol);
            if (isFromFillData == null || !isFromFillData.booleanValue()) {
                usedAmount = usedAmount == null ? BigDecimal.ZERO : usedAmount;
            }
            Object[] dbParams = new Object[]{leftMap.get("trueSubStandingBookId") == null ? BOSUuid.create((String)"81534082").toString() : leftMap.get("trueSubStandingBookId"), newStandingBookId, leftMap.get("subBudgetQueryId"), usedAmount, leftMapOfLeftData};
            paramList.add(dbParams);
        }
        if (!paramList.isEmpty()) {
            String subBookSqlBuild = " insert into T_HR_SubCmpStandingBook (FID,FCmpStandingBookID,FSubBudgetQueryID," + stbSnCol + "," + leftSnCol + ") values (?,?,?,?,?)";
            DbUtil.executeBatchAndReturn((Context)ctx, (String)subBookSqlBuild, paramList);
        }
        return newStandingBookId;
    }

    protected List<BudgetSnapshotInfo> deductSubmitData(MethodParam methodParam, List<Map<String, Object>> entryDataList, List<Map<String, Object>> leftDataList, boolean hasLeftData) {
        Map<String, List<BudgetSnapshotInfo>> snapshotMap = methodParam.getSnapshotMap();
        CmpBudgetItemInfo cmpBudgetItem = methodParam.getCmpBudgetItem();
        BudgetTemplateSTBItemInfo templateSTBItemInfo = methodParam.getTemplateSTBItemInfo();
        String budgetSnCol = methodParam.getBudgetSnCol();
        String stbSnCol = methodParam.getStbSnCol();
        String leftSnCol = methodParam.getLeftSnCol();
        String submitSnCol = methodParam.getSubmitSnCol();
        List<BudgetSnapshotInfo> snapshotInfoList = snapshotMap.get(submitSnCol);
        Map<String, BudgetSnapshotInfo> entrySnapshotMap = this.getEntrySnapshotMap(snapshotInfoList);
        this.setLeftDataListId(leftDataList);
        if (hasLeftData) {
            for (int i1 = 0; i1 < leftDataList.size(); ++i1) {
                Map<String, Object> leftDataMap = leftDataList.get(i1);
                BigDecimal leftBudget = leftDataMap.get(leftSnCol) == null ? BigDecimal.ZERO : (BigDecimal)leftDataMap.get(leftSnCol);
                leftDataMap.put(budgetSnCol, leftBudget);
            }
        }
        ArrayList<BudgetSnapshotInfo> realSnapshotList = new ArrayList<BudgetSnapshotInfo>();
        block1: for (int i = 0; i < entryDataList.size(); ++i) {
            Map<String, Object> entryDataMap = entryDataList.get(i);
            String entryId = (String)entryDataMap.get("entryId");
            BudgetSnapshotInfo initSnapshotInfo = entrySnapshotMap.get(entryId);
            BigDecimal submitData = entryDataMap.get(submitSnCol) == null ? BigDecimal.ZERO : (BigDecimal)entryDataMap.get(submitSnCol);
            for (int i1 = 0; i1 < leftDataList.size(); ++i1) {
                BigDecimal curUsedData;
                BigDecimal leftBudgetData;
                Map<String, Object> leftDataMap = leftDataList.get(i1);
                BigDecimal bigDecimal = leftBudgetData = leftDataMap.get(budgetSnCol) == null ? BigDecimal.ZERO : (BigDecimal)leftDataMap.get(budgetSnCol);
                if (BigDecimal.ZERO.compareTo(leftBudgetData) == 0) continue;
                BudgetSnapshotInfo realSnapshot = new BudgetSnapshotInfo();
                BigDecimal data = leftBudgetData.subtract(submitData);
                boolean isEnoughBudget = false;
                BigDecimal bigDecimal2 = curUsedData = leftDataMap.get(stbSnCol) == null ? BigDecimal.ZERO : (BigDecimal)leftDataMap.get(stbSnCol);
                if (BigDecimal.ZERO.compareTo(data) > 0) {
                    curUsedData = curUsedData.add(leftBudgetData);
                    submitData = submitData.subtract(leftBudgetData);
                    realSnapshot.setValue(leftBudgetData);
                    leftBudgetData = leftBudgetData.subtract(leftBudgetData);
                } else {
                    curUsedData = curUsedData.add(submitData);
                    leftBudgetData = leftBudgetData.subtract(submitData);
                    realSnapshot.setValue(submitData);
                    isEnoughBudget = true;
                }
                leftDataMap.put(stbSnCol, curUsedData);
                leftDataMap.put(budgetSnCol, leftBudgetData);
                realSnapshot.setSubBookTableId((String)leftDataMap.get("trueSubStandingBookId"));
                realSnapshot.setPeriod((String)leftDataMap.get("budgetPeriod"));
                realSnapshot.setRate(initSnapshotInfo.getRate());
                realSnapshot.setSubmitShemeBillEntry(initSnapshotInfo.getSubmitShemeBillEntry());
                realSnapshot.setBillEntry(initSnapshotInfo.getBillEntry());
                realSnapshot.setSubmitShemeBill(initSnapshotInfo.getSubmitShemeBill());
                realSnapshot.setBill(initSnapshotInfo.getBill());
                realSnapshot.setCalSubmitScheme(initSnapshotInfo.getCalSubmitScheme());
                realSnapshot.setScheme(initSnapshotInfo.getScheme());
                realSnapshot.setCalSubmitItem(initSnapshotInfo.getCalSubmitItem());
                realSnapshot.setItem(initSnapshotInfo.getItem());
                realSnapshot.setPerson(initSnapshotInfo.getPerson());
                realSnapshot.setAdminOrgUnit(initSnapshotInfo.getAdminOrgUnit());
                realSnapshot.setCostBearOrg(initSnapshotInfo.getCostBearOrg());
                realSnapshot.setCostType(initSnapshotInfo.getCostType());
                realSnapshot.setBusinessType(initSnapshotInfo.getBusinessType());
                realSnapshot.setHrOrgUnit(initSnapshotInfo.getHrOrgUnit());
                realSnapshot.setCurrency(initSnapshotInfo.getCurrency());
                realSnapshot.setIsRollback(initSnapshotInfo.isIsRollback());
                realSnapshot.setIsOffset(initSnapshotInfo.isIsOffset());
                realSnapshot.setIsRollbackOffset(false);
                realSnapshot.setBudgetTemplate(initSnapshotInfo.getBudgetTemplate());
                realSnapshot.setUpdateDirection(initSnapshotInfo.getUpdateDirection());
                realSnapshot.setStandingBookItem(templateSTBItemInfo.getStandingBookItem());
                realSnapshot.setBalanceLedgerItem(templateSTBItemInfo.getBalanceLedgerItem());
                realSnapshot.setTemplateStbItem(templateSTBItemInfo);
                realSnapshot.setBudgetYear(initSnapshotInfo.getBudgetYear());
                realSnapshot.setCmpBudgetItem(cmpBudgetItem);
                realSnapshot.setDataState(DataStateEnum.DEDUCT);
                realSnapshot.setUpdateNode(initSnapshotInfo.getUpdateNode());
                realSnapshotList.add(realSnapshot);
                if (isEnoughBudget) continue block1;
            }
        }
        return realSnapshotList;
    }

    protected Map<String, BudgetSnapshotInfo> getEntrySnapshotMap(List<BudgetSnapshotInfo> snapshotInfoList) {
        HashMap<String, BudgetSnapshotInfo> entrySnapshotMap = new HashMap<String, BudgetSnapshotInfo>();
        for (int i = 0; i < snapshotInfoList.size(); ++i) {
            BudgetSnapshotInfo snapshotInfo = snapshotInfoList.get(i);
            BatchSubmitShemeBillEntryInfo billEntryInfo = snapshotInfo.getSubmitShemeBillEntry();
            if (billEntryInfo == null) continue;
            entrySnapshotMap.put(billEntryInfo.getId().toString(), snapshotInfo);
        }
        return entrySnapshotMap;
    }

    protected void setLeftDataListId(List<Map<String, Object>> leftDataList) {
        for (int k = 0; k < leftDataList.size(); ++k) {
            Map<String, Object> leftDataMap = leftDataList.get(k);
            String subStandingBookId = (String)leftDataMap.get("subStandingBookId");
            String trueSubStandingBookId = StringUtils.isEmpty((String)subStandingBookId) ? BOSUuid.create((String)"81534082").toString() : subStandingBookId;
            leftDataMap.put("trueSubStandingBookId", trueSubStandingBookId);
        }
    }

    protected void deductUsedData(String stbSnCol, String budgetSnCol, List<Map<String, Object>> leftDataList) {
        for (int i = 0; i < leftDataList.size(); ++i) {
            Map<String, Object> map = leftDataList.get(i);
            BigDecimal budget = map.get(budgetSnCol) == null ? BigDecimal.ZERO : (BigDecimal)map.get(budgetSnCol);
            BigDecimal usedData = map.get(stbSnCol) == null ? BigDecimal.ZERO : (BigDecimal)map.get(stbSnCol);
            BigDecimal newLeftBudget = budget.subtract(usedData);
            map.put(budgetSnCol, newLeftBudget);
        }
    }

    protected void deductOuterUsedData(String budgetSnCol, BigDecimal outerUsedData, List<Map<String, Object>> leftDataList) {
        int leftDataSize = leftDataList.size();
        BigDecimal outerUsedDataCopy = new BigDecimal(outerUsedData.toString());
        if (BigDecimal.ZERO.compareTo(outerUsedDataCopy) == 0) {
            return;
        }
        for (int j = leftDataSize - 1; j >= 0; --j) {
            BigDecimal subBudgetData;
            Map<String, Object> map = leftDataList.get(j);
            BigDecimal bigDecimal = subBudgetData = map.get(budgetSnCol) == null ? BigDecimal.ZERO : (BigDecimal)map.get(budgetSnCol);
            if (BigDecimal.ZERO.compareTo(outerUsedDataCopy) == 0) continue;
            if (subBudgetData.compareTo(outerUsedDataCopy) < 0) {
                outerUsedDataCopy = outerUsedDataCopy.subtract(subBudgetData);
                subBudgetData = subBudgetData.subtract(subBudgetData);
            } else {
                subBudgetData = subBudgetData.subtract(outerUsedDataCopy);
                outerUsedDataCopy = outerUsedDataCopy.subtract(outerUsedDataCopy);
            }
            map.put(budgetSnCol, subBudgetData);
        }
    }

    protected Map<String, Object> getBudgetAndStandingData(Context ctx, MethodParam methodParam) throws BOSException, BudgetEASBizException {
        String operateKsqlDate;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        java.util.Date operateDate = methodParam.getOperateDate();
        String budgetSchemeId = methodParam.getBudgetSchemeId();
        CmpBudgetItemInfo cmpBudgetItem = methodParam.getCmpBudgetItem();
        String stbSnCol = methodParam.getStbSnCol();
        String budgetSnCol = methodParam.getBudgetSnCol();
        String leftSnCol = methodParam.getLeftSnCol();
        Map<String, String> costOrgAndCostTypeMap = methodParam.getCostOrgAndCostTypeMap();
        String costBearOrgId = costOrgAndCostTypeMap.get("costBearOrgId");
        String costTypeId = costOrgAndCostTypeMap.get("costTypeId");
        Integer balanceTypeEnumValue = methodParam.getBalanceTypeEnumValue();
        String nowDate = BudgetUtil.getNowDateStr();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" SELECT s.FState, s.FID as BID,ss.FID as BBID,b.FID as SID,sb.FID as SSID,ss.FPeriod,c.FUsedAmount as FUSEDAMOUNT,");
        sqlBuilder.append(" s.").append(budgetSnCol).append(" as TOTALBUDGET,").append("b.").append(leftSnCol).append(" as totalLeft,b.").append(stbSnCol).append(" as totalUsed ,");
        sqlBuilder.append(" ss.").append(budgetSnCol).append(",sb.").append(stbSnCol).append(",sb.").append(leftSnCol);
        sqlBuilder.append(" FROM T_HR_SSubBudgetQuery ss ");
        sqlBuilder.append(" left join T_HR_SBudgetManage s on s.FID = ss.FBudgetManageID ");
        sqlBuilder.append(" left join T_HR_SCmpBudgetScheme cbs on s.FBudgetSchemeID = cbs.fid ");
        sqlBuilder.append(" left join T_HR_SCmpStandingBook b on b.FBudgetManageID=s.FID ");
        sqlBuilder.append(" left join T_HR_SubCmpStandingBook sb on sb.FCmpStandingBookID=b.FID and sb.FSubBudgetQueryID=ss.FID ");
        sqlBuilder.append(" LEFT JOIN T_HR_SCmpUsedAmount c on c.FBudgetManageID = s.FID and c.FCmpBudgetItemID = '").append(cmpBudgetItem.getId()).append("'");
        sqlBuilder.append(" where s.FAdminOrgUnitID = '").append(costBearOrgId).append("'");
        sqlBuilder.append(" and s.FCostTypeID = '").append(costTypeId).append("'");
        sqlBuilder.append(" and s.FBudgetSchemeID = '").append(budgetSchemeId).append("'");
        sqlBuilder.append(" and cbs.FEffectDate <= ").append(nowDate);
        sqlBuilder.append(" and cbs.FExpiryDate >= ").append(nowDate);
        if (2 == balanceTypeEnumValue) {
            operateKsqlDate = CmpDateUtil.toKSqlDate(operateDate);
            sqlBuilder.append(" and ss.FEffectDate <= ").append(operateKsqlDate);
            sqlBuilder.append(" and ss.FExpiryDate >= ").append(operateKsqlDate);
        } else if (1 == balanceTypeEnumValue) {
            operateKsqlDate = CmpDateUtil.toKSqlDate(operateDate);
            sqlBuilder.append(" and ss.FEffectDate <= ").append(operateKsqlDate);
        }
        sqlBuilder.append(" order by ss.FEffectDate asc,ss.FExpiryDate asc ");
        IRowSet subRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        List<Map<String, Object>> rowSetDataList = this.rowSet2ListMap(stbSnCol, budgetSnCol, leftSnCol, subRowSet);
        try {
            subRowSet.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        List<Map<String, Object>> rowSetDataListOfCopy = this.rowSet2ListMap(stbSnCol, budgetSnCol, leftSnCol, subRowSet);
        String budgetManageId = "";
        for (int i = 0; i < rowSetDataList.size(); ++i) {
            String budgetId;
            Map<String, Object> map = rowSetDataList.get(i);
            if (map == null || StringUtils.isEmpty((String)(budgetId = (String)map.get("budgetId")))) continue;
            budgetManageId = budgetId;
        }
        BigDecimal subBudgetSum = BigDecimal.ZERO;
        String allSubSqlBuild = " select ss.FID,ss." + budgetSnCol + ",sb.FID as subStandingBookId  FROM T_HR_SSubBudgetQuery ss  left join T_HR_SBudgetManage s on s.FID = ss.FBudgetManageID  left join T_HR_SCmpStandingBook b on b.FBudgetManageID=s.FID  left join T_HR_SubCmpStandingBook sb on sb.FCmpStandingBookID=b.FID and sb.FSubBudgetQueryID=ss.FID  where ss.FBudgetManageID = ?  order by ss.FEffectDate asc,ss.FExpiryDate asc ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)allSubSqlBuild, (Object[])new Object[]{budgetManageId});
        HashMap<String, BigDecimal> subBudgetDataMap = new HashMap<String, BigDecimal>();
        ArrayList allSubBudgetDataList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, Object> subBudgetMap = new HashMap<String, Object>();
                BigDecimal data = rowSet.getBigDecimal(budgetSnCol) == null ? BigDecimal.ZERO : rowSet.getBigDecimal(budgetSnCol);
                subBudgetMap.put("budgetId", budgetManageId);
                subBudgetMap.put("subBudgetQueryId", rowSet.getString("FID"));
                String subStandingBookId = rowSet.getString("subStandingBookId");
                subBudgetMap.put("subStandingBookId", subStandingBookId);
                subBudgetMap.put("trueSubStandingBookId", subStandingBookId);
                subBudgetMap.put(budgetSnCol, data);
                allSubBudgetDataList.add(subBudgetMap);
                subBudgetSum = subBudgetSum.add(data);
                subBudgetDataMap.put(subStandingBookId, data);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        returnMap.put("subBudgetSum", subBudgetSum);
        returnMap.put("allSubBudgetDataList", allSubBudgetDataList);
        returnMap.put("sourceDataList", rowSetDataList);
        returnMap.put("sourceDataListOfCopy", rowSetDataListOfCopy);
        returnMap.put("subBudgetDataMap", subBudgetDataMap);
        return returnMap;
    }

    protected List<Map<String, Object>> rowSet2ListMap(String stbSnCol, String budgetSnCol, String leftSnCol, IRowSet subRowSet) throws BOSException, BudgetEASBizException {
        ArrayList<Map<String, Object>> rowSetDataList = new ArrayList<Map<String, Object>>();
        try {
            while (subRowSet.next()) {
                int state = subRowSet.getInt("FState");
                if (2 == state) {
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION11);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("budgetId", subRowSet.getString("BID"));
                map.put("subBudgetQueryId", subRowSet.getString("BBID"));
                map.put("standingBookId", subRowSet.getString("SID"));
                map.put("subStandingBookId", subRowSet.getString("SSID"));
                map.put("usedAmount", subRowSet.getBigDecimal("FUSEDAMOUNT"));
                map.put("totalBudget", subRowSet.getBigDecimal("TOTALBUDGET"));
                map.put("totalLeft", subRowSet.getBigDecimal("totalLeft"));
                map.put("totalUsed", subRowSet.getBigDecimal("totalUsed"));
                map.put("budgetPeriod", subRowSet.getString("FPeriod"));
                map.put(budgetSnCol, subRowSet.getBigDecimal(budgetSnCol));
                map.put(stbSnCol, subRowSet.getBigDecimal(stbSnCol));
                map.put(leftSnCol, subRowSet.getBigDecimal(leftSnCol));
                rowSetDataList.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return rowSetDataList;
    }
}

