/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetAssignTypeEnum;
import com.kingdee.shr.compensation.app.budget.SubBudgetDifferenceFactory;
import com.kingdee.shr.compensation.app.budget.SubBudgetDifferenceInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageFacadeFactory;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.updateType;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SubBudgetAssignService {
    public static final String SPLIT_FLAG = "###";

    protected BudgetPeriodEnum getBudgetPeriod(Context ctx, String budgetSchemeId) throws BOSException {
        CmpBudgetSchemeInfo budgetSchemeInfo;
        String oql = " select id,template.id,template.budgetPeriod where id = '" + budgetSchemeId + "'";
        CmpBudgetSchemeCollection collection = CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeCollection(oql);
        if (collection != null && !collection.isEmpty() && (budgetSchemeInfo = collection.get(0)) != null && budgetSchemeInfo.getTemplate() != null) {
            return budgetSchemeInfo.getTemplate().getBudgetPeriod();
        }
        return null;
    }

    protected Map<String, BudgetManageInfo> getBasicInfoManageMap(Context ctx, List<SubBudgetManageInfo> subBudgetManageInfoList) throws BOSException, SQLException {
        HashSet<String> budgetManageIdSet = new HashSet<String>();
        for (SubBudgetManageInfo subBudgetManageInfo : subBudgetManageInfoList) {
            if (subBudgetManageInfo == null || subBudgetManageInfo.getBudgetMange() == null || subBudgetManageInfo.getBudgetMange().getId() == null) continue;
            budgetManageIdSet.add(subBudgetManageInfo.getBudgetMange().getId().toString());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String inSqlBaseOnFId = cmpInSql.createInSqlBaseOnFId(ctx, budgetManageIdSet);
        String sqlBuilder = " SELECT FID,FAdminOrgUnitID,FCostTypeID  FROM T_HR_SBudgetManage where FID in " + inSqlBaseOnFId;
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder);
        HashMap<String, BudgetManageInfo> budgetBasicDataMap = new HashMap<String, BudgetManageInfo>();
        while (iRowSet.next()) {
            String id = iRowSet.getString("FID");
            if (StringUtils.isEmpty((String)id)) continue;
            String adminOrgUnitID = iRowSet.getString("FAdminOrgUnitID");
            String costTypeID = iRowSet.getString("FCostTypeID");
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            if (!StringUtils.isEmpty((String)adminOrgUnitID)) {
                adminOrgUnitInfo = new AdminOrgUnitInfo();
                adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitID));
            }
            CostTypeInfo costTypeInfo = null;
            if (!StringUtils.isEmpty((String)costTypeID)) {
                costTypeInfo = new CostTypeInfo();
                costTypeInfo.setId(BOSUuid.read((String)costTypeID));
            }
            BudgetManageInfo budgetManageInfo = new BudgetManageInfo();
            budgetManageInfo.setId(BOSUuid.read((String)id));
            budgetManageInfo.setAdminOrgUnit(adminOrgUnitInfo);
            budgetManageInfo.setCostType(costTypeInfo);
            budgetBasicDataMap.put(id, budgetManageInfo);
        }
        return budgetBasicDataMap;
    }

    protected CoreBaseCollection checkBudgetLimitAndReturnDifference(Context ctx, String budgetSchemeId, Map<String, BigDecimal> budgetDataMap, List<SubBudgetManageInfo> subBudgetManageInfoList, BudgetPeriodEnum budgetPeriod) throws BOSException, SQLException, EASBizException {
        String getBudgetSchemeSql = "SELECT FID,FCurrencyID,FSubBudgetAssignType FROM T_HR_SCmpBudgetScheme where FID = ?";
        IRowSet budgetSchemeRowSet = DbUtil.executeQuery((Context)ctx, (String)getBudgetSchemeSql, (Object[])new Object[]{budgetSchemeId});
        CurrencyInfo currencyInfo = null;
        SubBudgetAssignTypeEnum subBudgetAssignTypeEnum = null;
        while (budgetSchemeRowSet.next()) {
            String currencyID = budgetSchemeRowSet.getString("FCurrencyID");
            int subBudgetAssignType = budgetSchemeRowSet.getInt("FSubBudgetAssignType");
            if (!StringUtils.isEmpty((String)currencyID)) {
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)currencyID));
            }
            subBudgetAssignTypeEnum = SubBudgetAssignTypeEnum.getEnum(subBudgetAssignType);
        }
        Map<String, BudgetManageInfo> basicInfoManageMap = this.getBasicInfoManageMap(ctx, subBudgetManageInfoList);
        CoreBaseCollection differenceColl = new CoreBaseCollection();
        for (int i = 0; i < subBudgetManageInfoList.size() && budgetPeriod != null; ++i) {
            BigDecimal budgetData;
            SubBudgetManageInfo subBudgetManageInfo = subBudgetManageInfoList.get(i);
            if (subBudgetManageInfo == null || subBudgetManageInfo.getBudgetMange() == null || subBudgetManageInfo.getBudgetMange().getId() == null || subBudgetManageInfo.getCmpBudgetItem() == null || subBudgetManageInfo.getCmpBudgetItem().getId() == null) {
                // empty if block
            }
            BigDecimal sumData = BigDecimal.ZERO;
            int periodValue = budgetPeriod.getValue();
            if (1 == periodValue) {
                BigDecimal firstHalfYear = subBudgetManageInfo.getFirstHalfYear() == null ? BigDecimal.ZERO : subBudgetManageInfo.getFirstHalfYear();
                BigDecimal lastHalfYear = subBudgetManageInfo.getLastHalfYear() == null ? BigDecimal.ZERO : subBudgetManageInfo.getLastHalfYear();
                sumData = sumData.add(firstHalfYear).add(lastHalfYear);
            } else if (2 == periodValue) {
                BigDecimal quarter1 = subBudgetManageInfo.getQuarter1() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter1();
                BigDecimal quarter2 = subBudgetManageInfo.getQuarter2() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter2();
                BigDecimal quarter3 = subBudgetManageInfo.getQuarter3() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter3();
                BigDecimal quarter4 = subBudgetManageInfo.getQuarter4() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter4();
                sumData = sumData.add(quarter1).add(quarter2).add(quarter3).add(quarter4);
            } else if (3 == periodValue) {
                for (int j = 1; j <= 12; ++j) {
                    String monthKey = "month" + j;
                    BigDecimal monthData = subBudgetManageInfo.get(monthKey) == null ? BigDecimal.ZERO : (BigDecimal)subBudgetManageInfo.get(monthKey);
                    sumData = sumData.add(monthData);
                }
            }
            String budgetManageId = subBudgetManageInfo.getBudgetMange().getId().toString();
            String budgetItemId = subBudgetManageInfo.getCmpBudgetItem().getId().toString();
            String key = budgetManageId + SPLIT_FLAG + budgetItemId;
            BigDecimal bigDecimal = budgetData = budgetDataMap.get(key) == null ? BigDecimal.ZERO : budgetDataMap.get(key);
            if (budgetData.compareTo(sumData) < 0) {
                String message = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label17", (Locale)ctx.getLocale()), sumData, budgetData);
                throw new EASBizException(new NumericExceptionSubItem("CMP_COMOM_INFO", message));
            }
            SubBudgetDifferenceInfo subBudgetDifferenceInfo = new SubBudgetDifferenceInfo();
            subBudgetDifferenceInfo.setBudgetManage(subBudgetManageInfo.getBudgetMange());
            BudgetManageInfo budgetManageInfo = basicInfoManageMap.get(budgetManageId);
            if (budgetManageInfo != null) {
                subBudgetDifferenceInfo.setAdminOrgUnit(budgetManageInfo.getAdminOrgUnit());
                subBudgetDifferenceInfo.setCostType(budgetManageInfo.getCostType());
            }
            subBudgetDifferenceInfo.setCurrency(currencyInfo);
            subBudgetDifferenceInfo.setCmpBudgetItem(subBudgetManageInfo.getCmpBudgetItem());
            subBudgetDifferenceInfo.setYearAmount(budgetData);
            subBudgetDifferenceInfo.setSubBudgetAssignType(subBudgetAssignTypeEnum);
            if (budgetData.compareTo(sumData) == 0) {
                subBudgetDifferenceInfo.setIsConsistent(true);
            } else {
                subBudgetDifferenceInfo.setIsConsistent(false);
            }
            subBudgetDifferenceInfo.setDifferenceValue(sumData.subtract(budgetData));
            subBudgetDifferenceInfo.setUpdateType(updateType.Manual);
            int periodVal = budgetPeriod.getValue();
            if (1 == periodVal) {
                subBudgetDifferenceInfo.setYear1(subBudgetManageInfo.getFirstHalfYear());
                subBudgetDifferenceInfo.setYear2(subBudgetManageInfo.getLastHalfYear());
            } else if (2 == periodVal) {
                subBudgetDifferenceInfo.setQuarter1(subBudgetManageInfo.getQuarter1());
                subBudgetDifferenceInfo.setQuarter2(subBudgetManageInfo.getQuarter2());
                subBudgetDifferenceInfo.setQuarter3(subBudgetManageInfo.getQuarter3());
                subBudgetDifferenceInfo.setQuarter4(subBudgetManageInfo.getQuarter4());
            } else if (3 == periodVal) {
                for (int j = 1; j <= 12; ++j) {
                    String monthKey = "month" + j;
                    subBudgetDifferenceInfo.put(monthKey, subBudgetManageInfo.get(monthKey));
                }
            }
            differenceColl.add((CoreBaseInfo)subBudgetDifferenceInfo);
        }
        return differenceColl;
    }

    protected BigDecimal getData(BigDecimal data) {
        if (data == null) {
            return BigDecimal.ZERO;
        }
        return data;
    }

    public void assignSubBudgetData(Context ctx, String budgetSchemeId, Map budgetDataMap, List<SubBudgetManageInfo> subBudgetManageInfoList, Map otherParamMap) throws BOSException, EASBizException {
        CoreBaseCollection differencesCoreBaseColl;
        BudgetPeriodEnum budgetPeriod = this.getBudgetPeriod(ctx, budgetSchemeId);
        try {
            differencesCoreBaseColl = this.checkBudgetLimitAndReturnDifference(ctx, budgetSchemeId, budgetDataMap, subBudgetManageInfoList, budgetPeriod);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!subBudgetManageInfoList.isEmpty()) {
            SubBudgetManageFacadeFactory.getLocalInstance(ctx).updateSubBudgetManage(budgetSchemeId, subBudgetManageInfoList);
        }
        if (differencesCoreBaseColl != null && !differencesCoreBaseColl.isEmpty()) {
            SubBudgetDifferenceFactory.getLocalInstance(ctx).save(differencesCoreBaseColl);
        }
    }
}

