/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpPeriodUsedAmountFactory;
import com.kingdee.shr.compensation.app.budget.CmpPeriodUsedAmountInfo;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountInfo;
import com.kingdee.shr.compensation.app.budget.SubCmpStandingBookInfo;
import com.kingdee.shr.compensation.service.budget.BudgetColumn;
import com.kingdee.shr.compensation.service.budget.DeductionParamUsedAmount;
import com.kingdee.shr.compensation.service.budget.StandBookColumn;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public abstract class AbstractUsedAmountDeductionService {
    private static final Logger LOG = Logger.getLogger(AbstractUsedAmountDeductionService.class);
    public static final String BUDGET_COLUMN_PREFIX = "T";
    public static final String STD_COLUMN_PREFIX = "S";
    protected BudgetTemplateInfo budgetTemplate;
    protected String budgetTemplateId;
    protected DeductionParamUsedAmount paramUsedAmount;
    protected Context ctx;
    private CmpBudgetItemInfo cmpBudgetItemInfo;
    private CmpUsedAmountInfo usedAmountInfo;

    public void genPeriodUsedAmount(Context ctx, DeductionParamUsedAmount paramUsedAmount) throws BOSException {
        this.ctx = ctx;
        this.budgetTemplate = paramUsedAmount.getBudgetTemplate();
        this.budgetTemplateId = this.budgetTemplate.getId().toString();
        this.paramUsedAmount = paramUsedAmount;
        this.doGenerate();
    }

    protected void doGenerate() throws BOSException {
        String budgetManageId = this.paramUsedAmount.getBudgetManageList().get(0).getId().toString();
        BudgetColumn budgetColumn = this.getBudgetColumnByDeductionConfig(this.cmpBudgetItemInfo);
        if (null == budgetColumn) {
            budgetColumn = this.getBudgetColumnByTemplate(this.cmpBudgetItemInfo);
        }
        if (null != budgetColumn) {
            this.genPeriodUsedAmountByExpense(budgetColumn, budgetManageId);
            return;
        }
        String budgetCol = BUDGET_COLUMN_PREFIX + this.cmpBudgetItemInfo.getFieldSn();
        this.genPeriodUsedAmountByBudget(budgetCol, budgetManageId);
    }

    private void genPeriodUsedAmountByExpense(BudgetColumn budgetColumn, String budgetManageId) {
        String queryColumn = this.concatColumns(budgetColumn);
        String subStandingBookSQL = "select " + queryColumn + " csb.fid standingBookId from T_HR_SSubBudgetQuery sbq inner join T_HR_SubCmpStandingBook csb on sbq.fid = csb.FSubBudgetQueryID where sbq.FBudgetManageID = '" + budgetManageId + "' order by sbq.FEffectDate desc";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)subStandingBookSQL);
            boolean isBalanceNull = false;
            CoreBaseCollection periods = new CoreBaseCollection();
            while (rs.next()) {
                String subStandingBookId = rs.getString("standingBookId");
                BigDecimal budget = rs.getBigDecimal(budgetColumn.getBudget());
                if (budget == null) continue;
                BigDecimal balance = rs.getBigDecimal(budgetColumn.getStandBookColumnList().get(0).getBalance());
                if (null == balance) {
                    isBalanceNull = true;
                    break;
                }
                BigDecimal expenseSum = BigDecimal.ZERO;
                for (StandBookColumn standBookColumn : budgetColumn.getStandBookColumnList()) {
                    BigDecimal expense = rs.getBigDecimal(standBookColumn.getExpense());
                    expense = expense == null ? BigDecimal.ZERO : expense;
                    expenseSum = expenseSum.add(expense);
                }
                BigDecimal usedAmount = budget.subtract(expenseSum).subtract(balance);
                CmpPeriodUsedAmountInfo periodUsedAmount = new CmpPeriodUsedAmountInfo();
                periodUsedAmount.setAmount(usedAmount);
                periodUsedAmount.setBill(this.usedAmountInfo);
                periodUsedAmount.setBudgetTemplate(this.budgetTemplate);
                SubCmpStandingBookInfo subCmpStandingBookInfo = new SubCmpStandingBookInfo();
                subCmpStandingBookInfo.setId(BOSUuid.read((String)subStandingBookId));
                periodUsedAmount.setSubStandingBook(subCmpStandingBookInfo);
                periodUsedAmount.setCmpBudgetItem(this.cmpBudgetItemInfo);
                periodUsedAmount.setCostType(this.usedAmountInfo.getCostType());
                periodUsedAmount.setAdminOrgUnit(this.usedAmountInfo.getAdminOrgUnit());
                periodUsedAmount.setBudgetYear(this.usedAmountInfo.getBudgetYear());
                periods.add((CoreBaseInfo)periodUsedAmount);
            }
            if (!isBalanceNull && !periods.isEmpty()) {
                CmpPeriodUsedAmountFactory.getLocalInstance(this.ctx).saveBatchData(periods);
            } else if (isBalanceNull) {
                this.genPeriodUsedAmountByBudget(budgetColumn.getBudget(), budgetManageId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"doGenerate error: ", (Throwable)e);
        }
    }

    protected void genPeriodUsedAmountByBudget(String budgetColumn, String budgetManageId) {
        CoreBaseCollection periods = new CoreBaseCollection();
        String subStandingBookSQL = "select " + budgetColumn + ", csb.fid standingBookId from T_HR_SSubBudgetQuery sbq inner join T_HR_SubCmpStandingBook csb on sbq.fid = csb.FSubBudgetQueryID where sbq.FBudgetManageID = '" + budgetManageId + "' order by sbq.FEffectDate desc";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)subStandingBookSQL);
            BigDecimal usedAmount = this.usedAmountInfo.getUsedAmount();
            while (rs.next() && usedAmount.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal periodUsedAmount;
                BigDecimal budget = rs.getBigDecimal(budgetColumn);
                if (budget == null) continue;
                String subStandingBookId = rs.getString("standingBookId");
                BigDecimal val = budget.subtract(usedAmount);
                if (val.compareTo(BigDecimal.ZERO) < 0) {
                    periodUsedAmount = budget;
                    usedAmount = usedAmount.subtract(budget);
                } else {
                    periodUsedAmount = usedAmount;
                    usedAmount = BigDecimal.ZERO;
                }
                CmpPeriodUsedAmountInfo period = new CmpPeriodUsedAmountInfo();
                period.setAmount(periodUsedAmount);
                period.setBill(this.usedAmountInfo);
                period.setBudgetTemplate(this.budgetTemplate);
                SubCmpStandingBookInfo subCmpStandingBookInfo = new SubCmpStandingBookInfo();
                subCmpStandingBookInfo.setId(BOSUuid.read((String)subStandingBookId));
                period.setSubStandingBook(subCmpStandingBookInfo);
                period.setCmpBudgetItem(this.cmpBudgetItemInfo);
                period.setCostType(this.usedAmountInfo.getCostType());
                period.setAdminOrgUnit(this.usedAmountInfo.getAdminOrgUnit());
                period.setBudgetYear(this.usedAmountInfo.getBudgetYear());
                periods.add((CoreBaseInfo)period);
            }
            if (!periods.isEmpty()) {
                CmpPeriodUsedAmountFactory.getLocalInstance(this.ctx).saveBatchData(periods);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"genPeriodUsedAmountByBudget error: ", (Throwable)e);
        }
    }

    public void refreshBalanceByUsedAmount(Context ctx, DeductionParamUsedAmount paramUsedAmount) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.budgetTemplate = paramUsedAmount.getBudgetTemplate();
        this.budgetTemplateId = this.budgetTemplate.getId().toString();
        this.paramUsedAmount = paramUsedAmount;
        this.doRefresh();
    }

    protected void doRefresh() throws BOSException, EASBizException {
        String oql = "select budgetItem.id where template.id = '" + this.budgetTemplateId + "'";
        BudgetTemplateItemCollection templateItems = BudgetTemplateItemFactory.getLocalInstance(this.ctx).getBudgetTemplateItemCollection(oql);
        if (templateItems.isEmpty()) {
            return;
        }
        for (int i = 0; i < templateItems.size(); ++i) {
            CmpBudgetItemInfo cmpBudgetItemInfo = templateItems.get(i).getBudgetItem();
            String budgetItemId = cmpBudgetItemInfo.getId().toString();
            BudgetColumn budgetColumn = this.getBudgetColumnByDeductionConfig(cmpBudgetItemInfo);
            if (null != budgetColumn) {
                this.refreshYearlyBalanceByDeductionConfig(budgetColumn, budgetItemId);
                if (this.budgetTemplate.getBudgetPeriod() == BudgetPeriodEnum.YEAR) continue;
                this.refreshPeriodBalanceByDeductionConfig(budgetColumn, budgetItemId);
                continue;
            }
            budgetColumn = this.getBudgetColumnByTemplate(cmpBudgetItemInfo);
            if (null == budgetColumn) continue;
            this.refreshYearlyBalanceByTemplate(budgetColumn, budgetItemId);
            if (this.budgetTemplate.getBudgetPeriod() == BudgetPeriodEnum.YEAR) continue;
            this.refreshPeriodBalanceByTemplate(budgetColumn, budgetItemId);
        }
    }

    protected void refreshPeriodBalanceByDeductionConfig(BudgetColumn budgetColumn, String budgetItemId) throws BOSException, EASBizException {
        IRowSet rs = this.getSubBudgetStandingBookRowSet(budgetColumn, budgetItemId);
        List<StandBookColumn> standBookColumnList = budgetColumn.getStandBookColumnList();
        int balanceColumnCount = standBookColumnList.size();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try {
            while (rs.next()) {
                BigDecimal budget = rs.getBigDecimal(budgetColumn.getBudget());
                if (null == budget) continue;
                BigDecimal usedAmount = rs.getBigDecimal("usedAmount");
                usedAmount = usedAmount == null ? BigDecimal.ZERO : usedAmount;
                BigDecimal balanceVal = budget.subtract(usedAmount);
                String standingBookId = rs.getString("standingBookId");
                if (StringUtils.isEmpty((String)standingBookId)) continue;
                Object[] param = new Object[balanceColumnCount + 1];
                String period = rs.getString("FPeriod");
                for (int i = 0; i < balanceColumnCount; ++i) {
                    BigDecimal accumulateExpense = this.getCurrentAndAfterExpense(rs, standBookColumnList, i);
                    BigDecimal balance = balanceVal.subtract(accumulateExpense);
                    if (balance.compareTo(BigDecimal.ZERO) < 0) {
                        BigDecimal totalUsed = usedAmount.add(accumulateExpense);
                        this.dealWithError(period, budget, totalUsed);
                    }
                    param[i] = balance;
                }
                param[balanceColumnCount] = standingBookId;
                params.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!params.isEmpty()) {
            String updateSQL = this.getStandingBookUpdateSQL(budgetColumn, "T_HR_SubCmpStandingBook");
            DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
        }
    }

    protected abstract void dealWithError(String var1, BigDecimal var2, BigDecimal var3) throws EASBizException;

    protected BigDecimal getCurrentAndAfterExpense(IRowSet rs, List<StandBookColumn> standBookColumnList, int i) throws SQLException {
        int balanceColumnCount = standBookColumnList.size();
        BigDecimal accumulateExpense = BigDecimal.ZERO;
        for (int j = i; j < balanceColumnCount; ++j) {
            String expenseCol = standBookColumnList.get(j).getExpense();
            BigDecimal expense = rs.getBigDecimal(expenseCol);
            expense = expense == null ? BigDecimal.ZERO : expense;
            accumulateExpense = accumulateExpense.add(expense);
        }
        return accumulateExpense;
    }

    protected IRowSet getSubBudgetStandingBookRowSet(BudgetColumn budgetColumn, String budgetItemId) throws BOSException {
        List<String> budgetManageIds = this.paramUsedAmount.getBudgetManageList().stream().map(e -> e.getId().toString()).collect(Collectors.toList());
        String queryColumn = this.concatColumns(budgetColumn);
        String subStandingBookSQL = "select " + queryColumn + " csb.fid standingBookId, pua.FAmount usedAmount, sbq.FPeriod  from T_HR_SSubBudgetQuery sbq inner join T_HR_SubCmpStandingBook csb on sbq.fid = csb.FSubBudgetQueryID left join T_HR_SCmpPeriodUsedAmount pua on csb.fid = pua.FSubStandingBookId and pua.FCmpBudgetItemId = '" + budgetItemId + "' where sbq.FBudgetManageID in (" + CmpStrUtil.convertListToString(budgetManageIds) + ")";
        return DbUtil.executeQuery((Context)this.ctx, (String)subStandingBookSQL);
    }

    protected void refreshYearlyBalanceByDeductionConfig(BudgetColumn budgetColumn, String budgetItemId) throws BOSException {
        IRowSet rs = this.getYearlyBudgetStandingBookRowSet(budgetColumn, budgetItemId);
        List<StandBookColumn> standBookColumnList = budgetColumn.getStandBookColumnList();
        int balanceColumnCount = standBookColumnList.size();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try {
            while (rs.next()) {
                BigDecimal budget = rs.getBigDecimal(budgetColumn.getBudget());
                if (null == budget) continue;
                BigDecimal usedAmount = rs.getBigDecimal("FUsedAmount");
                usedAmount = usedAmount == null ? BigDecimal.ZERO : usedAmount;
                BigDecimal balanceVal = budget.subtract(usedAmount);
                String standingBookId = rs.getString("fid");
                if (StringUtils.isEmpty((String)standingBookId)) continue;
                Object[] param = new Object[balanceColumnCount + 1];
                for (int i = 0; i < balanceColumnCount; ++i) {
                    BigDecimal accumulateExpense = this.getCurrentAndAfterExpense(rs, standBookColumnList, i);
                    param[i] = balanceVal.subtract(accumulateExpense);
                }
                param[balanceColumnCount] = standingBookId;
                params.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!params.isEmpty()) {
            String updateSQL = this.getStandingBookUpdateSQL(budgetColumn, "T_HR_SCmpStandingBook");
            DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
        }
    }

    private IRowSet getYearlyBudgetStandingBookRowSet(BudgetColumn budgetColumn, String budgetItemId) throws BOSException {
        List<String> budgetManageIds = this.paramUsedAmount.getBudgetManageList().stream().map(e -> e.getId().toString()).collect(Collectors.toList());
        String queryColumn = this.concatColumns(budgetColumn);
        String standingBookSQL = "select " + queryColumn + " cua.FUsedAmount, csb.fid  from T_HR_SCmpStandingBook csb  inner join T_HR_SBudgetManage bm on csb.FBudgetManageID = bm.fid left join T_HR_SCmpUsedAmount cua on bm.fid = cua.FBudgetManageID and cua.FCmpBudgetItemID = '" + budgetItemId + "' inner join T_HR_SCmpBudgetScheme cbs on bm.FBudgetSchemeID = cbs.fid where bm.fid in (" + CmpStrUtil.convertCollectionToSql(budgetManageIds) + ")";
        return DbUtil.executeQuery((Context)this.ctx, (String)standingBookSQL);
    }

    protected void refreshPeriodBalanceByTemplate(BudgetColumn budgetColumn, String budgetItemId) throws BOSException, EASBizException {
        IRowSet rs = this.getSubBudgetStandingBookRowSet(budgetColumn, budgetItemId);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int balanceColumnCount = budgetColumn.getStandBookColumnList().size();
        try {
            while (rs.next()) {
                BigDecimal budget = rs.getBigDecimal(budgetColumn.getBudget());
                if (null == budget) continue;
                BigDecimal usedAmount = rs.getBigDecimal("usedAmount");
                usedAmount = usedAmount == null ? BigDecimal.ZERO : usedAmount;
                BigDecimal balanceVal = budget.subtract(usedAmount);
                String standingBookId = rs.getString("standingBookId");
                if (StringUtils.isEmpty((String)standingBookId)) continue;
                String period = rs.getString("FPeriod");
                if (balanceVal.compareTo(BigDecimal.ZERO) < 0) {
                    this.dealWithError(period, budget, usedAmount);
                }
                Object[] param = new Object[balanceColumnCount + 1];
                for (int i = 0; i < balanceColumnCount; ++i) {
                    param[i] = balanceVal;
                }
                param[balanceColumnCount] = standingBookId;
                params.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!params.isEmpty()) {
            String updateSQL = this.getStandingBookUpdateSQL(budgetColumn, "T_HR_SubCmpStandingBook");
            DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
        }
    }

    protected void refreshYearlyBalanceByTemplate(BudgetColumn budgetColumn, String budgetItemId) throws BOSException {
        IRowSet rs = this.getYearlyBudgetStandingBookRowSet(budgetColumn, budgetItemId);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int balanceColumnCount = budgetColumn.getStandBookColumnList().size();
        try {
            while (rs.next()) {
                BigDecimal budget = rs.getBigDecimal(budgetColumn.getBudget());
                if (null == budget) continue;
                BigDecimal usedAmount = rs.getBigDecimal("FUsedAmount");
                usedAmount = usedAmount == null ? BigDecimal.ZERO : usedAmount;
                BigDecimal balanceVal = budget.subtract(usedAmount);
                String standingBookId = rs.getString("fid");
                if (StringUtils.isEmpty((String)standingBookId)) continue;
                Object[] param = new Object[balanceColumnCount + 1];
                for (int i = 0; i < balanceColumnCount; ++i) {
                    param[i] = balanceVal;
                }
                param[balanceColumnCount] = standingBookId;
                params.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!params.isEmpty()) {
            String updateSQL = this.getStandingBookUpdateSQL(budgetColumn, "T_HR_SCmpStandingBook");
            DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
        }
    }

    private String getStandingBookUpdateSQL(BudgetColumn budgetColumn, String standingBookTable) {
        List<StandBookColumn> standBookColumnList = budgetColumn.getStandBookColumnList();
        StringBuilder updateSQL = new StringBuilder("update " + standingBookTable + " set ");
        for (StandBookColumn standBookColumn : standBookColumnList) {
            if (standBookColumnList.indexOf(standBookColumn) > 0) {
                updateSQL.append(", ");
            }
            String balanceCol = standBookColumn.getBalance();
            updateSQL.append(balanceCol).append(" = ?");
        }
        updateSQL.append(" where fid = ?");
        return updateSQL.toString();
    }

    private BudgetColumn getBudgetColumnByTemplate(CmpBudgetItemInfo cmpBudgetItemInfo) throws BOSException {
        String oql = "select cmpBudgetItem.fieldSn, standingBookItem.fieldSn, balanceLedgerItem.fieldSn where template.id = '" + this.budgetTemplateId + "' and cmpBudgetItem.id = '" + cmpBudgetItemInfo.getId().toString() + "'";
        BudgetTemplateSTBItemCollection collection = BudgetTemplateSTBItemFactory.getLocalInstance(this.ctx).getBudgetTemplateSTBItemCollection(oql);
        if (collection.isEmpty()) {
            return null;
        }
        BudgetColumn budgetColumn = new BudgetColumn();
        ArrayList<StandBookColumn> list = new ArrayList<StandBookColumn>();
        for (int i = 0; i < collection.size(); ++i) {
            budgetColumn.setBudget(BUDGET_COLUMN_PREFIX + collection.get(i).getCmpBudgetItem().getFieldSn());
            StandBookColumn standBookColumn = new StandBookColumn();
            standBookColumn.setBalance(STD_COLUMN_PREFIX + collection.get(i).getBalanceLedgerItem().getFieldSn());
            standBookColumn.setExpense(STD_COLUMN_PREFIX + collection.get(i).getStandingBookItem().getFieldSn());
            list.add(standBookColumn);
        }
        budgetColumn.setStandBookColumnList(list);
        return budgetColumn;
    }

    protected abstract BudgetColumn getBudgetColumnByDeductionConfig(CmpBudgetItemInfo var1) throws BOSException;

    private String concatColumns(BudgetColumn budgetColumn) {
        String budget = budgetColumn.getBudget();
        StringBuilder columns = new StringBuilder();
        columns.append(budget).append(", ");
        List<StandBookColumn> standBookColumns = budgetColumn.getStandBookColumnList();
        for (StandBookColumn standBookColumn : standBookColumns) {
            columns.append(standBookColumn.getExpense()).append(", ").append(standBookColumn.getBalance()).append(",");
        }
        return columns.toString();
    }

    public BudgetTemplateInfo getBudgetTemplate() {
        return this.budgetTemplate;
    }

    public void setBudgetTemplate(BudgetTemplateInfo budgetTemplate) {
        this.budgetTemplate = budgetTemplate;
    }

    public String getBudgetTemplateId() {
        return this.budgetTemplateId;
    }

    public void setBudgetTemplateId(String budgetTemplateId) {
        this.budgetTemplateId = budgetTemplateId;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setCmpBudgetItemInfo(CmpBudgetItemInfo cmpBudgetItemInfo) {
        this.cmpBudgetItemInfo = cmpBudgetItemInfo;
    }

    public void setUsedAmountInfo(CmpUsedAmountInfo usedAmountInfo) {
        this.usedAmountInfo = usedAmountInfo;
    }
}

