/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.sql.wizard;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.util.StringUtils;
import java.util.Map;
import java.util.Set;

public abstract class CostBearSQL {
    public static String needVerifyDataSql(Context ctx) {
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select cost.fid id, per.fid personId, per.FName_" + l + " personName, per.FNumber personNum, ");
        str.append(" hr.fid hrId, hr.FName_" + l + " as hrName, ");
        str.append(" cmpEmp.fid cmpEmpId, empOrg.fid empOrgId,empOrg.FNumber as empOrgNum, empOrg.FName_" + l + " empOrgName, pos.fid posFid, pos.FName_" + l + " posName, ");
        str.append(" item.fid itemId, item.FName_" + l + " itemName, ");
        str.append(" org.Fid orgFid, org.FNumber orgNum, org.FName_" + l + " orgName, ");
        str.append(" cost.FEffactDate effactDate, cost.FLeffectDate leffectDate, cost.FCostBearPerc perc, cost.FState state, ");
        str.append(" cost.FCommitmentCurrencyID commitCurrencyId, currency.FName_" + l + " currencyName ");
        str.append(" from T_HR_SCostBearOrg cost ");
        str.append(" inner join T_BD_Person per on cost.FPersonId = per.fid ");
        str.append(" inner join T_ORG_Admin org on cost.FCostBearOrgID = org.fid ");
        str.append(" inner join T_ORG_HRO hr on cost.FHrOrgUnitID = hr.fid ");
        str.append(" left join T_HR_SCmpItem item on cost.FCmpItemID = item.fid ");
        str.append(" inner join T_HR_SCmpEmpORelation cmpEmp on cost.FCmpEmpORelationID = cmpEmp.fid ");
        str.append(" inner join T_HR_EmpOrgRelation emp on cmpEmp.FEmpOrgRelationID = emp.fid ");
        str.append(" inner join T_ORG_Admin empOrg on emp.FAdminOrgID = empOrg.fid ");
        str.append(" inner join T_ORG_Position pos on emp.FPositionID = pos.fid ");
        str.append(" left join T_BD_Currency currency on currency.fid = cost.FCommitmentCurrencyID ");
        str.append(" where cost.FState = 1 ");
        return str.toString();
    }

    public static String getNeedVerifyDataSql(String personFilter, String ubableIds, Context ctx) {
        StringBuffer str = new StringBuffer(CostBearSQL.needVerifyDataSql(ctx));
        if (!CmpStrUtil.isEmpty(personFilter)) {
            str.append(" and per.fid in (").append(personFilter).append(") ");
        }
        if (!CmpStrUtil.isEmpty(ubableIds)) {
            str.append(" and cost.fid not in (" + ubableIds + ")");
        }
        str.append(" order by cost.FPersonId, cost.FHrOrgUnitID, cost.FCmpEmpORelationID, cost.FCmpItemID ");
        return str.toString();
    }

    public static String getNeedVerifyDataSqlForPerm(Context ctx, String personIds, String hrOrgIds, String permId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String adminIds = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permId);
        String hrIds = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permId);
        StringBuffer str = new StringBuffer(CostBearSQL.needVerifyDataSql(ctx));
        str.append(" and per.fid in (").append(personIds).append(") ");
        if (!CmpStrUtil.isEmpty(hrOrgIds)) {
            str.append(" and cost.FHrOrgUnitID in (" + hrOrgIds + ") ");
        }
        str.append(" and (cost.FHrOrgUnitID in (" + hrIds + ") and empOrg.fid in (" + adminIds + ")  ");
        str.append(" or cost.FHrOrgUnitID in (" + hrIds + ") and cmpEmp.FUseDefault = 0)");
        return str.toString();
    }

    public static String buildCostBearSql(Context ctx, String tableName, String perc) {
        try {
            Map<String, Set<String>> tableCloumnSetMap = SQLHandleUtil.getTableCloumnSetMap(ctx, tableName);
            if (tableName.contains(" ")) {
                tableName = "(" + tableName + ")";
            }
            Set<String> numberSet = tableCloumnSetMap.get("numberSet");
            Set<String> intSet = tableCloumnSetMap.get("intSet");
            Set<String> dateSet = tableCloumnSetMap.get("dateSet");
            Set<String> strSet = tableCloumnSetMap.get("strSet");
            Set<String> nclobSet = tableCloumnSetMap.get("nclobSet");
            Set<String> uidSet = tableCloumnSetMap.get("uidSet");
            StringBuffer costbuf = new StringBuffer();
            for (String field : numberSet) {
                costbuf.append(",case when \"" + perc + "\" is null then \"" + field + "\" else \"" + perc + "\"*\"" + field + "\"/100  end AS \"" + field + "\"");
            }
            for (String field : intSet) {
                costbuf.append(",\"" + field + "\"");
            }
            for (String field : dateSet) {
                costbuf.append(",\"" + field + "\"");
            }
            for (String field : strSet) {
                costbuf.append(",\"" + field + "\"");
            }
            for (String field : nclobSet) {
                costbuf.append(",\"" + field + "\"");
            }
            for (String field : uidSet) {
                costbuf.append(",\"" + field + "\"");
            }
            if (StringUtils.isEmpty((String)costbuf.toString())) {
                return null;
            }
            StringBuffer costBearSql = new StringBuffer();
            costBearSql.append("select ");
            costBearSql.append(costbuf.toString().replaceFirst(",", ""));
            costBearSql.append(" from ");
            costBearSql.append(tableName);
            costBearSql.append(" AS costBearSql");
            return costBearSql.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

