/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.compensation.TaxExceptionEnum;
import com.kingdee.shr.compensation.app.tax.HousingCollection;
import com.kingdee.shr.compensation.app.tax.HousingFactory;
import com.kingdee.shr.compensation.app.tax.HousingInfo;
import com.kingdee.shr.compensation.app.tax.TenementCollection;
import com.kingdee.shr.compensation.app.tax.TenementFactory;
import com.kingdee.shr.compensation.app.tax.TenementInfo;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.shr.compensation.tax.service.TaxCommonService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TeneAndHousingService
extends TaxCommonService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.tax.service.TeneAndHousingService");

    @Override
    public String getInfo(Context ctx, String billId) {
        Map<Object, Object> map = new HashMap();
        String ksql = "select *, city.*, province.*, bill.* where bill.id = '" + billId + "'";
        if (StringUtils.isEmpty((String)billId)) {
            return TaxUtil.success(ctx, map);
        }
        TenementCollection teneColl = null;
        try {
            teneColl = TenementFactory.getLocalInstance(ctx).getTenementCollection(ksql);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getValue(), TaxExceptionEnum.BILL_KEY_INVALID.getName());
        }
        if (null == teneColl || teneColl.size() < 1) {
            ksql = "select *, bill.* where bill.id = '" + billId + "'";
            HousingCollection houColl = null;
            try {
                houColl = HousingFactory.getLocalInstance(ctx).getHousingCollection(ksql);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getValue(), TaxExceptionEnum.BILL_KEY_INVALID.getName());
            }
            if (null == houColl || houColl.size() < 1) {
                return TaxUtil.success(ctx, map);
            }
            CoreBaseCollection baseColl = new CoreBaseCollection();
            for (int i = 0; i < houColl.size(); ++i) {
                baseColl.add((CoreBaseInfo)houColl.get(i));
            }
            map = this.convertInfoToJson(ctx, baseColl);
        } else {
            map = this.convertInfoToJson(ctx, teneColl.get(0));
        }
        return TaxUtil.success(ctx, map);
    }

    @Override
    public String getHisInfo(Context ctx) throws Exception {
        Map<String, Object> map;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String personId = TaxUtil.getPersonId(ctx);
        CoreBaseCollection dataColl = new CoreBaseCollection();
        String ksql = " select *, bill.* where bill.person.id = '" + personId + "' and bill.state in (20, 30, 40) order by bill.state asc, bill.id ";
        HousingCollection coll = HousingFactory.getLocalInstance(ctx).getHousingCollection(ksql);
        if (null != coll && coll.size() > 0) {
            String billId = coll.get(0).getBill().getId().toString();
            for (int i = 0; i < coll.size(); ++i) {
                String newBillId = coll.get(i).getBill().getId().toString();
                if (billId.equals(newBillId)) {
                    dataColl.add((CoreBaseInfo)coll.get(i));
                    continue;
                }
                map = this.convertInfoToJson(ctx, dataColl);
                list.add(map);
                billId = newBillId;
                dataColl = new CoreBaseCollection();
            }
            if (dataColl.size() > 0) {
                map = this.convertInfoToJson(ctx, dataColl);
                list.add(map);
            }
        }
        ksql = "select *, bill.*, province*, city.* where bill.person.id = '" + personId + "' and bill.state in (20, 30, 40)  order by bill.state asc";
        TenementCollection teneColl = TenementFactory.getLocalInstance(ctx).getTenementCollection(ksql);
        for (int i = 0; i < teneColl.size(); ++i) {
            map = this.convertInfoToJson(ctx, teneColl.get(i));
            list.add(map);
        }
        return TaxUtil.success(ctx, list);
    }

    @Override
    protected Map<String, Object> convertInfoToJson(Context ctx, CoreBaseCollection coll) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<Object, Object> dataMap = new HashMap();
        HashMap<String, Object> loanMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> loanList = new ArrayList<HashMap<String, Object>>();
        HousingInfo info = (HousingInfo)coll.get(0);
        this.setBillHeadMapForWeb(info.getBill(), map);
        dataMap = TaxUtil.getMapDataFromCoreInfo(ctx, info, "com.kingdee.shr.compensation.app.tax.Housing");
        loanMap.put("loanType", dataMap.get("loanType"));
        loanMap.put("bank", dataMap.get("bank"));
        loanMap.put("loanNumber", dataMap.get("loanNumber"));
        loanMap.put("firstDate", dataMap.get("firstDate"));
        loanMap.put("term", dataMap.get("term"));
        loanList.add(loanMap);
        dataMap.remove("loanType");
        dataMap.remove("bank");
        dataMap.remove("loanNumber");
        dataMap.remove("firstDate");
        dataMap.remove("term");
        for (int i = 1; i < coll.size(); ++i) {
            info = (HousingInfo)coll.get(i);
            Map<String, Object> entryMap = TaxUtil.getMapDataFromCoreInfo(ctx, info, "com.kingdee.shr.compensation.app.tax.Housing");
            loanMap = new HashMap();
            loanMap.put("loanType", entryMap.get("loanType"));
            loanMap.put("bank", entryMap.get("bank"));
            loanMap.put("loanNumber", entryMap.get("loanNumber"));
            loanMap.put("firstDate", entryMap.get("firstDate"));
            loanMap.put("term", entryMap.get("term"));
            loanList.add(loanMap);
        }
        dataMap.put("loan", loanList);
        map.put(this.getTaxTypeEnum().getName().toLowerCase(Locale.ENGLISH), dataMap);
        return map;
    }

    @Override
    protected Map<String, Object> convertInfoToJson(Context ctx, CoreBaseInfo info) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<Object, Object> dataMap = new HashMap();
        if (info instanceof HousingInfo) {
            HousingInfo housingInfo = (HousingInfo)info;
            dataMap = TaxUtil.getMapDataFromCoreInfo(ctx, housingInfo, "com.kingdee.shr.compensation.app.tax.Housing");
            this.setBillHeadMapForWeb(housingInfo.getBill(), map);
            map.put("housing", dataMap);
        } else {
            TenementInfo tenementInfo = (TenementInfo)info;
            dataMap = TaxUtil.getMapDataFromCoreInfo(ctx, tenementInfo, "com.kingdee.shr.compensation.app.tax.Tenement");
            this.setBillHeadMapForWeb(tenementInfo.getBill(), map);
            map.put("rent", dataMap);
        }
        return map;
    }
}

