/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentServiceFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.vo.ResponseVO;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TaxPaymentService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(TaxPaymentService.class);

    @Override
    public boolean isData4Resolving(String code) {
        return "0000".equals(code) || "0251".equals(code);
    }

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        ResponseVO responseVO = (ResponseVO)JSON.parseObject((String)response, ResponseVO.class);
        String msg = responseVO.getMsg();
        String taskId = taskInfo.getId().toString();
        TaxCalTaskFactory.getLocalInstance(ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, StringUtils.isEmpty((String)msg) ? "\u7a0e\u6b3e\u7f34\u7eb3\u7f34\u6b3e\u5b8c\u6210" : msg);
        TaxPaymentServiceFacadeFactory.getLocalInstance(ctx).handleAfterPayment(taskId, response);
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updatesql = "update T_HR_STaxCalTask Set FSTATE = ? , FMsg = ? where fid = ?";
        String taskId = taskInfo.getId().toString();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)errMsg) ? "\u53d1\u8d77\u7f34\u6b3e\u5931\u8d25" : errMsg, taskId};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updatesql, paramList);
        updatesql = "update T_HR_STaxPaymentService set FPaymentState = 40 where FPaymentServiceTaskID = '" + taskId + "'";
        DbUtil.execute((Context)ctx, (String)updatesql);
        this.sendMsg2Commander(ctx, taskInfo);
    }

    public void sendMsg2Commander(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String number = taxCalTaskInfo.getNumber();
            String state = taxCalTaskInfo.getState().getAlias();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            String title = "\u7a0e\u6b3e\u7f34\u7eb3\u7684\u4efb\u52a1\u7f16\u7801\u3010{0}\u3011\u5df2\u5b8c\u6210\uff0c\u8be6\u60c5\u67e5\u770b\u7a0e\u6b3e\u7f34\u7eb3\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
            title = MessageFormat.format(title, number);
            String msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d\u3010{0}\u3011\u3010{1}\u3011\u7f34\u6b3e\u5b8c\u6210-\u3010{2}\u3011\u3002";
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String msg = MessageFormat.format(msgTemplate, taxUnitName, period, state);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, title, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

