/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.compensation.exception.CmpEASDbException;
import com.kingdee.shr.easupgrade.compensation.InterfaceCmpUpGradeException;
import com.kingdee.shr.easupgrade.compensation.UpGradeConnectionCollection;
import com.kingdee.shr.easupgrade.compensation.UpGradeConnectionFactory;
import com.kingdee.shr.easupgrade.compensation.UpGradeConnectionInfo;
import com.kingdee.shr.easupgrade.compensation.util.UpGradeUtil;
import com.kingdee.shr.voucher_inte.ConnectionCollection;
import com.kingdee.shr.voucher_inte.ConnectionFactory;
import com.kingdee.shr.voucher_inte.ConnectionInfo;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class CmpEASDbUtil {
    private static Logger logger = Logger.getLogger(UpGradeUtil.class);
    private static final int MAX_DATA_ROW = 8000;

    public static String getDbType(Connection conn) {
        String dbType = "oracle";
        try {
            DatabaseMetaData meta = conn.getMetaData();
            dbType = meta.getDatabaseProductName();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dbType;
    }

    public static ResultSetMetaData getHisTabMetaData(Context ctx, Connection conn, String hisTable, boolean isRelease) throws BOSException, SQLException {
        String dbType = CmpEASDbUtil.getDbType(conn);
        String columnSql = "";
        columnSql = "oracle".equalsIgnoreCase(dbType) ? "select * from " + hisTable + " where rownum<1" : "select top 0 * from " + hisTable;
        IRowSet tempRs = CmpEASDbUtil.executeQuery(ctx, columnSql, conn, isRelease);
        ResultSetMetaData metaData = tempRs.getMetaData();
        return metaData;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Connection conn, boolean release) throws BOSException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement(sql);
            rs = statement.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("333 sql is:" + exc.getMessage()), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + exc.getMessage(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement);
                if (release) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        if (release) {
            SQLUtils.cleanup((Connection)conn);
        }
        return jdbcRowSet;
    }

    public static Connection getOuterConnection(Context ctx, String connName) throws BOSException, SQLException, EASBizException {
        UpGradeConnectionCollection configColl = null;
        configColl = StringUtils.isEmpty((String)connName) ? UpGradeConnectionFactory.getLocalInstance((Context)ctx).getUpGradeConnectionCollection() : UpGradeConnectionFactory.getLocalInstance((Context)ctx).getUpGradeConnectionCollection("where name='" + connName + "'");
        UpGradeConnectionInfo ConnectionInfo = null;
        if (configColl.size() <= 0) {
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.NULL_CONNECT_ERROR);
        }
        ConnectionInfo = configColl.get(0);
        String IP = null;
        String DB = null;
        String username = null;
        String password = null;
        String DBtype = ConnectionInfo.getDBType().getName().toString();
        IP = ConnectionInfo.getIP();
        DB = ConnectionInfo.getInstance();
        int port = ConnectionInfo.getPort();
        username = ConnectionInfo.getUsername();
        password = ConnectionInfo.getPassword();
        if (DBtype.equalsIgnoreCase("SQLserver")) {
            try {
                Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver").newInstance();
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            String url = "jdbc:microsoft:sqlserver://" + IP + ":" + port + ";databaseName=" + DB + "";
            DriverManager.setLoginTimeout(300);
            try {
                logger.info((Object)">>>>>>>>>>22222222DBtype=SQLserver");
                return DriverManager.getConnection(url, username, password);
            }
            catch (SQLException e1) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        if (DBtype.equalsIgnoreCase("oracle")) {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
                String url = "jdbc:oracle:thin:@" + IP + ":" + port + ":" + DB + "";
                logger.info((Object)">>>>>>>>>>22222222DBtype=oracle");
                return DriverManager.getConnection(url, username, password);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                try {
                    String dbType = DBType.Oracle.getValue().toString();
                    return KSQLUtil.getKSQLConnection((DataBaseType)DataBaseType.getInstance((String)dbType), (String)IP, (int)port, (String)DB, (String)username, (String)password);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
                }
            }
        }
        if (DBtype.equalsIgnoreCase("db2")) {
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                String url = "jdbc:db2://" + IP + ":" + port + "/" + DB + "";
                Properties props = new Properties();
                props.setProperty("user", username);
                props.setProperty("password", password);
                logger.info((Object)">>>>>>>>>>22222222DBtype=db2");
                return DriverManager.getConnection(url, props);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        logger.info((Object)">>>>>>>>>>22222222DBtype=null");
        return null;
    }

    public static Connection getVoucherInteConnection(Context ctx, String connName) throws BOSException, InterfaceDataBaseException, EASBizException {
        ConnectionCollection configColl = null;
        configColl = StringUtils.isEmpty((String)connName) ? ConnectionFactory.getLocalInstance((Context)ctx).getConnectionCollection() : ConnectionFactory.getLocalInstance((Context)ctx).getConnectionCollection("where name='" + connName + "'");
        ConnectionInfo ConnectionInfo2 = null;
        if (configColl.size() <= 0) {
            throw new CmpEASDbException(CmpEASDbException.NULLPOINTER);
        }
        ConnectionInfo2 = configColl.get(0);
        String IP = null;
        String DB = null;
        String username = null;
        String password = null;
        String DBtype = ConnectionInfo2.getDBType().getName().toString();
        IP = ConnectionInfo2.getIP();
        DB = ConnectionInfo2.getInstance();
        int port = ConnectionInfo2.getPort();
        username = ConnectionInfo2.getUsername();
        password = ConnectionInfo2.getPassword();
        if (DBtype.equalsIgnoreCase("SQLserver")) {
            try {
                Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver").newInstance();
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            String url = "jdbc:microsoft:sqlserver://" + IP + ":" + port + ";databaseName=" + DB + "";
            DriverManager.setLoginTimeout(300);
            try {
                logger.info((Object)">>>>>>>>>>22222222DBtype=SQLserver");
                return DriverManager.getConnection(url, username, password);
            }
            catch (SQLException e1) {
                NumericExceptionSubItem src_conn_error = new NumericExceptionSubItem("001", e1.getMessage());
                throw new InterfaceDataBaseException(src_conn_error);
            }
        }
        if (DBtype.equalsIgnoreCase("oracle")) {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
                String url = "jdbc:oracle:thin:@" + IP + ":" + port + ":" + DB + "";
                logger.info((Object)">>>>>>>>>>22222222DBtype=oracle");
                return DriverManager.getConnection(url, username, password);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        if (DBtype.equalsIgnoreCase("db2")) {
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                String url = "jdbc:db2://" + IP + ":" + port + "/" + DB + "";
                Properties props = new Properties();
                props.setProperty("user", username);
                props.setProperty("password", password);
                logger.info((Object)">>>>>>>>>>22222222DBtype=db2");
                return DriverManager.getConnection(url, props);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        logger.info((Object)">>>>>>>>>>22222222DBtype=null");
        return null;
    }
}

