/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.IMailServerSet;
import com.kingdee.eas.hr.base.MailServerSetFactory;
import com.kingdee.eas.hr.base.MailServerSetInfo;
import com.kingdee.eas.mobile.util.MailServerConfigPropUtil;
import com.kingdee.shr.compensation.util.NewByteArrayDataSource;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class NewMailUtil {
    private Context ctx = null;
    private static NewMailUtil mailUtil = null;

    private NewMailUtil() {
    }

    public static NewMailUtil getInstance(Context contex) {
        if (mailUtil == null) {
            mailUtil = new NewMailUtil();
        }
        NewMailUtil.mailUtil.ctx = contex;
        return mailUtil;
    }

    public static NewMailUtil getInstance() {
        if (mailUtil == null) {
            mailUtil = new NewMailUtil();
        }
        NewMailUtil.mailUtil.ctx = null;
        return mailUtil;
    }

    public void sendHtmlMail(String from, String to, String subject, String body) throws Exception {
        this.sendHtmlMail(from, to, null, null, subject, body);
    }

    public void sendHtmlMail(String from, String to, String cc, String subject, String body) throws Exception {
        this.sendHtmlMail(from, to, cc, null, subject, body);
    }

    public void sendHtmlMail(String from, String to, String cc, String bcc, String subject, String body) throws Exception {
        IMailServerSet iMSS = null;
        String oql = null;
        boolean flag = false;
        if (this.ctx == null) {
            iMSS = MailServerSetFactory.getRemoteInstance();
            oql = SysContext.getSysContext().getCurrentCtrlUnit() != null ? "where CU='" + SysContext.getSysContext().getCurrentCtrlUnit().getId() + "'" : "where CU is not null";
        } else {
            iMSS = MailServerSetFactory.getLocalInstance((Context)this.ctx);
            oql = SysContext.getSysContext().getCurrentCtrlUnit() != null ? "where CU='" + SysContext.getSysContext().getCurrentCtrlUnit().getId() + "'" : "where CU is not null";
        }
        MailServerSetInfo mssInfo = new MailServerSetInfo();
        Properties properties = MailServerConfigPropUtil.getProperties();
        String host = properties.getProperty("mail.smtp.host");
        String userName = properties.getProperty("mail.login.username");
        String passWord = properties.getProperty("mail.login.password");
        String fromAccount = properties.getProperty("mail.from.account");
        String smtpAuthEnable = properties.getProperty("mail.smtpAuthEnable");
        System.out.println("smtpAuthEnable:" + smtpAuthEnable + "," + "false".equals(smtpAuthEnable));
        mssInfo.setIsAuth(true);
        if ("false".equals(smtpAuthEnable) || "".equals(smtpAuthEnable) || "null".equals(smtpAuthEnable)) {
            mssInfo.setIsAuth(false);
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        MyAuthenticator authen = null;
        if (mssInfo.isIsAuth()) {
            props.put("mail.smtp.auth", "true");
            authen = new MyAuthenticator(userName, passWord);
        } else {
            props.put("mail.smtp.auth", "false");
        }
        Session mailSession = Session.getInstance((Properties)props, authen);
        MimeMessage mimeMsg = new MimeMessage(mailSession);
        mimeMsg.setFrom((Address)new InternetAddress(fromAccount));
        if (to != null) {
            mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        }
        if (cc != null) {
            mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if (bcc != null) {
            mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        mimeMsg.setSubject(subject, "GBK");
        mimeMsg.setDataHandler(new DataHandler((DataSource)new NewByteArrayDataSource(body, "text/html;charset=GBK")));
        mimeMsg.setSentDate(new Date());
        if (mssInfo.isIsAuth()) {
            Transport transport = mailSession.getTransport("smtp");
            transport.connect(host, userName, passWord);
            transport.sendMessage((Message)mimeMsg, mimeMsg.getAllRecipients());
            transport.close();
        } else {
            Transport.send((Message)mimeMsg);
        }
    }

    static class MyAuthenticator
    extends Authenticator {
        String user = null;
        String pass = null;

        public MyAuthenticator(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass);
        }
    }
}

