/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.updateData.DataUpgradeState;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MiaBudgetUpgradeUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.util.budget.MiaBudgetUpgradeUtil");
    private static final String MIA_UPGRADE_LOCK_ENTRANCE_NAME = "MiaBudgetDataUpgradeFacadeControllerBean";
    private static final String MIA_UPGRADE_LOCK_RESOURCE = "upgrade";
    private static final String BUDGET_SNAPSHOT_BOSTYPE = "72770CD0";

    private MiaBudgetUpgradeUtil() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataUpgradeState isMiaBudgetUpgradeComplete(Context ctx) {
        DataUpgradeState result = DataUpgradeState.NOT_BEGIN;
        String checkSQL = "select Flag from T_HR_SCommonDataUpgrade where FBusinessType = 10";
        boolean isLock = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSQL);
            boolean flag = false;
            while (rowSet.next()) {
                flag = rowSet.getBoolean("Flag");
                if (!flag) continue;
                result = DataUpgradeState.FINISHED;
            }
            if (!flag) {
                boolean isRunning = CmpDistributedLockUtils.tryLock(ctx, MiaBudgetUpgradeUtil.getLockEntranceName(), MiaBudgetUpgradeUtil.getLockResource());
                if (!isRunning) {
                    result = DataUpgradeState.RUNNING;
                } else {
                    isLock = true;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"query upgrade flag error!", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"query upgrade flag error!", (Throwable)e);
        }
        finally {
            if (isLock) {
                CmpDistributedLockUtils.unlock(ctx, MiaBudgetUpgradeUtil.getLockEntranceName(), MiaBudgetUpgradeUtil.getLockResource());
            }
        }
        return result;
    }

    public static boolean isMiaBudgetUpgrade(Context ctx) {
        return DataUpgradeState.FINISHED == MiaBudgetUpgradeUtil.isMiaBudgetUpgradeComplete(ctx);
    }

    public static String getLockEntranceName() {
        return MIA_UPGRADE_LOCK_ENTRANCE_NAME;
    }

    public static String getLockResource() {
        return MIA_UPGRADE_LOCK_RESOURCE;
    }

    public static String getMulRes(Context ctx, String labelName, Locale locale) {
        return EASResource.getString((String)"com.kingdee.shr.compensation.app.budget.MiaBudgetDataUpgradeResource", (String)labelName, (Locale)(null == locale ? ctx.getLocale() : locale));
    }

    public static String createSnapShotId(Context ctx) {
        BOSUuid bosUuid = BOSUuid.create((String)BUDGET_SNAPSHOT_BOSTYPE);
        return bosUuid.toString();
    }
}

