/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.domain.AbstractBizMetaSourceDomain;
import com.kingdee.shr.data.domain.AbstractDataSourceDomain;
import com.kingdee.shr.data.domain.imp.EntitySourceDomain;
import com.kingdee.shr.data.domain.imp.ShrDBCenterSourceDomain;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.AbstractBizMetaSource;
import com.kingdee.shr.data.model.designtime.source.MetaSource;
import com.kingdee.shr.data.model.designtime.type.SourceType;
import com.kingdee.shr.dataplatform.DataSetException;
import java.util.HashMap;
import java.util.Map;

public class SourceDomainFactory {
    private static Map<String, AbstractBizMetaSourceDomain> bizMetaSourceDomainImplMap = new HashMap<String, AbstractBizMetaSourceDomain>(16);

    private SourceDomainFactory() {
    }

    public static <T extends AbstractBizMetaSourceDomain> void setBizMetaSourceDomainImp(String bizMetaType, T bizMetaSourceDomain) {
        bizMetaSourceDomainImplMap.put(bizMetaType, bizMetaSourceDomain);
    }

    private static AbstractBizMetaSourceDomain newBizMetaSourceDomainInstance(AbstractSource source) throws EASBizException {
        AbstractBizMetaSource bizMetaSource = (AbstractBizMetaSource)source;
        String bizMetaType = bizMetaSource.getBizMetaType();
        AbstractBizMetaSourceDomain bizMetaSourceDomain = bizMetaSourceDomainImplMap.get(bizMetaType);
        if (bizMetaSourceDomain == null) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"unsupport BizMetaType:" + bizMetaType});
        }
        return bizMetaSourceDomain;
    }

    public static AbstractBizMetaSourceDomain newBizMetaSourceDomainInstance(String bizMetaType) throws EASBizException {
        AbstractBizMetaSourceDomain bizMetaSourceDomain = bizMetaSourceDomainImplMap.get(bizMetaType);
        if (bizMetaSourceDomain == null) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"unsupport BizMetaType:" + bizMetaType});
        }
        return bizMetaSourceDomain;
    }

    public static AbstractDataSourceDomain getSourceDomain(AbstractSource source) throws EASBizException {
        if (source == null) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"params [sourceType] is empty."});
        }
        AbstractDataSourceDomain domain = SourceDomainFactory.getSourceDomainSilence(source);
        if (null == domain) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"unsupport sourceType:" + (Object)((Object)source.getType())});
        }
        return domain;
    }

    public static AbstractDataSourceDomain getSourceDomainSilence(AbstractSource source) throws EASBizException {
        SourceType sourceType = source.getType();
        AbstractBizMetaSourceDomain sourceDomain = null;
        switch (sourceType) {
            case BizMeta: {
                sourceDomain = SourceDomainFactory.newBizMetaSourceDomainInstance(source);
                break;
            }
        }
        return sourceDomain;
    }

    static {
        bizMetaSourceDomainImplMap.put(MetaSource.MetaType.SHREntity.name(), new EntitySourceDomain());
        bizMetaSourceDomainImplMap.put(MetaSource.MetaType.SHRDBCenter.name(), new ShrDBCenterSourceDomain());
    }
}

