/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.secrity.SecrityTableAndFieldCheckUtil;
import com.kingdee.shr.common.util.CloseUtil;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.data.domain.db.AbstractDBTableCreator;
import com.kingdee.shr.data.domain.db.handler.LeafNodeHandler;
import com.kingdee.shr.data.domain.db.handler.MapHandler;
import com.kingdee.shr.data.domain.db.impl.DB2SourceJDBCAdapter;
import com.kingdee.shr.data.domain.db.impl.DMSourceJDBCAdapter;
import com.kingdee.shr.data.domain.db.impl.KingBaseSourceJDBCAdapter;
import com.kingdee.shr.data.domain.db.impl.OracleSourceJDBCAdapter;
import com.kingdee.shr.data.domain.db.impl.PostgreSQLSourceJDBCAdapter;
import com.kingdee.shr.data.domain.db.impl.SQLServerSourceJDBCAdapter;
import com.kingdee.shr.data.domain.db.query.DBQueryRunner;
import com.kingdee.shr.data.domain.service.IConnectionFactory;
import com.kingdee.shr.data.domain.service.JDBCConnectionPool;
import com.kingdee.shr.data.domain.util.SQLHelperUtils;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.runtime.Table;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FolderNode;
import com.kingdee.shr.data.model.vo.LeafNode;
import com.kingdee.shr.dataplatform.CustomSQLFactory;
import com.kingdee.shr.dataplatform.CustomSQLInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.ICustomSQL;
import com.kingdee.shr.dataset.model.CustomSQLItem;
import com.kingdee.shr.dataset.service.util.SQLExcuteHelper;
import com.kingdee.shr.dataset.util.DataSetUtils;
import com.kingdee.shr.pageset.util.PageSetUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractDBSourceJDBCAdapter {
    protected static final int LOGIN_TIMEOUT = 10;
    public static final String KSQL_DIALECT = "/*dialect*/";
    public static final String KSQL_SHR = "/*shr*/";
    private IConnectionFactory connectionFactory;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter");

    public static AbstractDBSourceJDBCAdapter newInstance(AbstractSource source) throws BOSException {
        DBSource dataBase = (DBSource)source;
        DBSource.DBType dbType = dataBase.getDbType();
        AbstractDBSourceJDBCAdapter dbSourceJDBCAdapter = null;
        switch (dbType) {
            case SQLSERVER: {
                dbSourceJDBCAdapter = SQLServerSourceJDBCAdapter.newInstance();
                break;
            }
            case ORACLE: {
                dbSourceJDBCAdapter = OracleSourceJDBCAdapter.newInstance();
                break;
            }
            case DB2: {
                dbSourceJDBCAdapter = DB2SourceJDBCAdapter.newInstance();
                break;
            }
            case POSTGRESQL: {
                dbSourceJDBCAdapter = PostgreSQLSourceJDBCAdapter.newInstance();
                break;
            }
            case DM: {
                dbSourceJDBCAdapter = DMSourceJDBCAdapter.newInstance();
                break;
            }
            case KINGBASE: {
                dbSourceJDBCAdapter = KingBaseSourceJDBCAdapter.newInstance();
                break;
            }
        }
        if (null == dbSourceJDBCAdapter) {
            throw new BOSException("unsupport DBType:" + (Object)((Object)dbType));
        }
        return dbSourceJDBCAdapter;
    }

    public final void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public final IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Connection getConnectionImpl(DBSource dataBase) throws BOSException {
        Connection connection;
        JDBCConnectionPool.JDBCModel jdbcModel = this.checkerDataBaseParams(dataBase);
        try {
            connection = JDBCConnectionPool.getConnectionFromPool(jdbcModel);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            this.setConnectionAttribute(dataBase, connection);
            return connection;
        }
        catch (SQLException e) {
            CloseUtil.close(connection);
            throw new BOSException((Throwable)e);
        }
    }

    public List<Map<String, Object>> getCustomData(Context ctx, DBSource source) throws BOSException, EASBizException {
        String sql = "";
        try {
            DBQueryRunner queryRunner = new DBQueryRunner(this.getConnection(source));
            DBSource.UserSQL userSQL = source.getUserSql();
            if (null == userSQL) {
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"userSQL is null"});
            }
            SQLHelperUtils.RuntimeUserSQL runtimeUserSQL = SQLHelperUtils.processUserSQL(ctx, userSQL, source.getPermItemId());
            sql = runtimeUserSQL.getSQL();
            SecrityTableAndFieldCheckUtil.checkPrivateInSQL((Context)ctx, (String)sql);
            Object[] params = runtimeUserSQL.getParam().toArray();
            PagingHelper helper = new PagingHelper();
            sql = helper.getPagingSqlNoOptmize(ctx, sql, 0, 50);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sql);
            }
            return queryRunner.query(sql, new MapHandler(), helper.getParamData(), params);
        }
        catch (SQLException e) {
            logger.error((Object)sql);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public abstract AbstractNode getUsableEntities(Context var1, AbstractSource var2) throws BOSException, EASBizException;

    protected final void queryTableLeafNodes(Context ctx, FolderNode root, DBSource dataBase, String tableQuerySql, Object[] params) throws BOSException, EASBizException {
        this.queryLeafNodes(ctx, root, dataBase, tableQuerySql, params, "table");
    }

    protected void queryLeafNodes(Context ctx, FolderNode root, DBSource dataBase, String tableQuerySql, Object[] params, String leafNodeType) throws BOSException, EASBizException {
        try {
            tableQuerySql = SQLExcuteHelper.getTranslateDialectSQL(ctx, tableQuerySql);
            DBQueryRunner queryRunner = new DBQueryRunner(this.getConnection(dataBase));
            List<LeafNode> nodeList = queryRunner.query(tableQuerySql, new LeafNodeHandler(leafNodeType), null, params);
            for (LeafNode leafNode : nodeList) {
                root.addChild(leafNode);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected abstract String getJDBCUrl(DBSource var1) throws BOSException;

    protected abstract String getDriverClassName();

    protected JDBCConnectionPool.JDBCModel checkerDataBaseParams(DBSource dataBase) throws BOSException {
        String connectUrl = this.getJDBCUrl(dataBase);
        String driverClassName = this.getDriverClassName();
        try {
            Class.forName(driverClassName);
            Driver driver = DriverManager.getDriver(connectUrl);
            if (null == driver) {
                throw new BOSException(driverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String enCodePsw = dataBase.getPassword();
        String password = StringUtils.decodeBase64ToString(enCodePsw);
        return new JDBCConnectionPool.JDBCModel(driverClassName, connectUrl, dataBase.getUserName(), password);
    }

    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(true);
        connection.setAutoCommit(false);
    }

    public boolean isConnSupportKsql() {
        return null != this.connectionFactory && this.connectionFactory.supportKSql();
    }

    public final Connection getConnection(DBSource dataBase) throws BOSException {
        if (null != this.connectionFactory) {
            return this.connectionFactory.createConnect();
        }
        return this.getConnectionImpl(dataBase);
    }

    public String wrapTableAssociateName(DBSource dbSource, String tableName) {
        return tableName;
    }

    public String getLeftDelimiter() {
        return "";
    }

    public String getRightDelimiter() {
        return "";
    }

    public AbstractDBTableCreator createDBTableCreator(DBSource dbSource, String associateName) {
        if (dbSource.isUserSql()) {
            return new UserSqlDBTableCreator(dbSource, associateName);
        }
        return new GeneralDBTableCreator(dbSource, associateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Table getTable(Connection conn, Table table, String sql, DBSource.DBType dbType) throws SQLException, BOSException {
        Table table2;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sql = SQLExcuteHelper.getTranslateDialectSQL(DBSource.DBType.getKTargetDbType(dbType), sql);
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            AbstractDBTableCreator.addTablePeerFields(table, resultSetMetaData);
            table2 = table;
        }
        catch (Throwable throwable) {
            CloseUtil.close(ps, rs);
            throw throwable;
        }
        CloseUtil.close(ps, rs);
        return table2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Table getTable(Connection conn, Table table, DBSource.DBType dbType, DBSource.UserSQL.SQLType sqlType, SQLHelperUtils.RuntimeUserSQL runtimeUserSQL) throws SQLException, BOSException {
        Table table2;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = runtimeUserSQL.getSQL();
        List<Object> params = runtimeUserSQL.getParam();
        try {
            sql = SQLExcuteHelper.getTranslateDialectSQL(DBSource.DBType.getKTargetDbType(dbType), sql);
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params);
            rs = ps.executeQuery();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            AbstractDBTableCreator.addTablePeerFields(table, resultSetMetaData);
            table2 = table;
        }
        catch (Throwable throwable) {
            CloseUtil.close(ps, rs);
            throw throwable;
        }
        CloseUtil.close(ps, rs);
        return table2;
    }

    protected void setParams(PreparedStatement ps, List<Object> params) throws SQLException {
        int size = params.size();
        for (int idx = 0; idx < size; ++idx) {
            Object param = params.get(idx);
            SQLHelperUtils.setParams(ps, idx + 1, param);
        }
    }

    static {
        DriverManager.setLoginTimeout(10);
    }

    private class UserSqlDBTableCreator
    extends AbstractDBTableCreator {
        public UserSqlDBTableCreator(DBSource dbSource, String associateName) {
            this.dbSource = dbSource;
            this.associateName = associateName;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Table getTablePeer(Context ctx) throws BOSException {
            Table table;
            Connection conn = null;
            DBSource.UserSQL userSQL = null;
            CustomSQLInfo sqlInfo = null;
            CustomSQLItem customSQLItem = null;
            String sql = "";
            try {
                conn = AbstractDBSourceJDBCAdapter.this.getConnection(this.dbSource);
                userSQL = this.dbSource.getUserSql();
                ICustomSQL iCustomSQL = CustomSQLFactory.getLocalInstance(ctx);
                if (PageSetUtils.isVaild(this.associateName, (ICoreBase)iCustomSQL)) {
                    sqlInfo = iCustomSQL.getCustomSQLInfo((IObjectPK)new ObjectUuidPK(this.associateName));
                    customSQLItem = (CustomSQLItem)JSONUtils.convertJsonToObject((Context)ctx, (String)sqlInfo.getContent(), CustomSQLItem.class);
                    userSQL = new DBSource.UserSQL(this.getName(sqlInfo), sqlInfo.getNumber(), sqlInfo.isIsKSQL() ? DBSource.UserSQL.SQLType.KSQL.name() : DBSource.UserSQL.SQLType.SQL.name(), customSQLItem.getSql().getText(), customSQLItem.getParams());
                }
                if (null == userSQL) {
                    throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"userSQL is null"});
                }
                SQLHelperUtils.RuntimeUserSQL runtimeUserSQL = SQLHelperUtils.processUserSQL(ctx, userSQL, this.dbSource.getPermItemId());
                sql = String.format("select * from ( %s ) t where 1=0", runtimeUserSQL.getSQL());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)sql);
                }
                Table table2 = new Table();
                table2.setName(userSQL.getNumber());
                table2.setDisplayName(userSQL.getName());
                table2.setSource(this.dbSource.getName());
                table2.setCustomSQLItem(customSQLItem);
                table = table2 = AbstractDBSourceJDBCAdapter.this.getTable(conn, table2, this.dbSource.getDbType(), DBSource.UserSQL.SQLType.valueOf(userSQL.getSqlType()), runtimeUserSQL);
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)sql);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                    catch (Exception e2) {
                        throw new BOSException(e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    CloseUtil.close(conn);
                    throw throwable;
                }
            }
            CloseUtil.close(conn);
            return table;
        }

        private Map<String, String> getName(CustomSQLInfo info) {
            HashMap<String, String> map = new HashMap<String, String>();
            List<String> mul = DataSetUtils.getSupportLangue();
            for (int i = 0; i < mul.size(); ++i) {
                map.put(mul.get(i), info.getName(new Locale(mul.get(i))));
            }
            return map;
        }
    }

    private class GeneralDBTableCreator
    extends AbstractDBTableCreator {
        public GeneralDBTableCreator(DBSource dbSource, String associateName) {
            this.dbSource = dbSource;
            this.associateName = associateName;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Table getTablePeer(Context ctx) throws BOSException {
            Table table;
            Connection conn = null;
            String sql = "";
            try {
                conn = AbstractDBSourceJDBCAdapter.this.getConnection(this.dbSource);
                sql = String.format("select * from %s where 1=0", AbstractDBSourceJDBCAdapter.this.getLeftDelimiter() + AbstractDBSourceJDBCAdapter.this.wrapTableAssociateName(this.dbSource, this.associateName) + AbstractDBSourceJDBCAdapter.this.getRightDelimiter());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)sql);
                }
                Table table2 = new Table();
                table2.setName(this.associateName);
                table = AbstractDBSourceJDBCAdapter.this.getTable(conn, table2, sql, this.dbSource.getDbType());
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)sql);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                    catch (Exception e2) {
                        throw new BOSException(e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    CloseUtil.close(conn);
                    throw throwable;
                }
            }
            CloseUtil.close(conn);
            return table;
        }
    }
}

