/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.handler;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.domain.db.handler.AbstractListHandler;
import com.kingdee.shr.data.domain.util.DataTypeUtil;
import com.kingdee.shr.data.model.designtime.type.DataType;
import com.kingdee.shr.dataplatform.DataSetException;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class MapHandler
extends AbstractListHandler<Map<String, Object>> {
    @Override
    protected Map<String, Object> handleRow(ResultSet rs, boolean isNull) throws SQLException, EASBizException {
        boolean isNonSupportType = false;
        StringBuilder exceptionMessage = new StringBuilder();
        ResultSetMetaData md = rs.getMetaData();
        int num = md.getColumnCount();
        HashMap<String, Object> mapOfColValues = new HashMap<String, Object>(num);
        for (int i = 1; i <= num; ++i) {
            String columnName = md.getColumnName(i);
            if ("tempcolumn".equalsIgnoreCase(columnName) || "temprownumber".equalsIgnoreCase(columnName)) continue;
            int type = md.getColumnType(i);
            DataType dataType = DataTypeUtil.parseDataType(type);
            if (null != dataType) {
                mapOfColValues.put(columnName, isNull ? null : rs.getObject(i));
                continue;
            }
            isNonSupportType = true;
            exceptionMessage.append("{").append(columnName).append(":").append(JDBCType.valueOf(type).getName()).append("}");
        }
        if (isNonSupportType) {
            throw new DataSetException(DataSetException.NOT_SUPPORT_COLUMN_TYPE_EXCEPTION, new Object[]{exceptionMessage.toString()});
        }
        return mapOfColValues;
    }
}

