/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.model;

import com.kingdee.shr.data.domain.util.JsonUtil;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.AbstractBizMetaSource;
import com.kingdee.shr.data.model.designtime.source.MetaSource;
import com.kingdee.shr.data.model.designtime.source.ShrDBCenterSource;
import com.kingdee.shr.data.model.designtime.type.SourceType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SourceFactory {
    private static Map<String, Class<? extends AbstractBizMetaSource>> bizMetaSourceImpMap = new HashMap<String, Class<? extends AbstractBizMetaSource>>();
    private static EnumMap<SourceType, ISourceCreator> map = new EnumMap(SourceType.class);
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();

    private SourceFactory() {
    }

    public static void regist(SourceType sourceType, ISourceCreator sourceCreator) {
        map.put(sourceType, sourceCreator);
    }

    public static void registBizMetaSource(String bizMetaType, Class<? extends AbstractBizMetaSource> bizMetaSourceClass) {
        bizMetaSourceImpMap.put(bizMetaType, bizMetaSourceClass);
    }

    public static <T> T decodeFromJson(String jsonString, Class<T> clz) {
        return JsonUtil.decodeFromString(customJsonParser, jsonString, clz);
    }

    public static AbstractSource instancefromJson(String jsonString) {
        return JsonUtil.decodeFromString(customJsonParser, jsonString, AbstractSource.class);
    }

    static {
        map.put(SourceType.BizMeta, new BizMetaSourceCreator());
        customJsonParser.addCustomDecoder(AbstractSource.class, new SourceJsonDecoder());
        bizMetaSourceImpMap.put(MetaSource.MetaType.SHREntity.name(), MetaSource.class);
        bizMetaSourceImpMap.put(MetaSource.MetaType.SHRDBCenter.name(), ShrDBCenterSource.class);
    }

    private static class BizMetaSourceCreator
    implements ISourceCreator {
        private BizMetaSourceCreator() {
        }

        @Override
        public AbstractSource instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, SourceJsonDecoder jsonDecoder) {
            if (json.hasAttr("bizMetaType")) {
                String bizMetaType = json.getAttrValue("bizMetaType");
                Class bizMetaSourceClass = (Class)bizMetaSourceImpMap.get(bizMetaType);
                if (bizMetaSourceClass != null) {
                    return jsonDecoder.fromJson2(json, bizMetaSourceClass);
                }
            }
            return null;
        }
    }

    public static interface ISourceCreator {
        public AbstractSource instanceFromJson(JsonUtil.AbstractJsonDecoder.Json var1, SourceJsonDecoder var2);
    }

    public static class SourceJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractSource> {
        @Override
        protected final AbstractSource decode(JsonUtil.AbstractJsonDecoder.Json json) {
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                ISourceCreator sourceCreator = (ISourceCreator)entry.getValue();
                AbstractSource source = sourceCreator.instanceFromJson(json, this);
                if (source == null) continue;
                return source;
            }
            return null;
        }

        public <U extends AbstractSource> AbstractSource fromJson2(JsonUtil.AbstractJsonDecoder.Json json, Class<U> clz) {
            return (AbstractSource)this.fromJson(json, clz);
        }
    }
}

