/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.variable;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.dataplatform.DataplatformException;
import com.kingdee.shr.dataplatform.VariableConfigCollection;
import com.kingdee.shr.dataplatform.VariableConfigException;
import com.kingdee.shr.dataplatform.VariableConfigFactory;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataplatform.variable.IVariableService;
import com.kingdee.shr.dataset.model.VariableItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableServiceFactory {
    private VariableServiceFactory() {
    }

    public static Object getSystemVariableResult(Context ctx, String variableName, Map<String, Object> param) throws BOSException, EASBizException {
        VariableItem variableResult = VariableServiceFactory.getVariableItem(ctx, variableName);
        IVariableService service = VariableServiceFactory.getIVariableService(variableResult);
        if (null != service) {
            param.put("content", variableResult.getContent());
            return service.process(ctx, param);
        }
        return null;
    }

    public static VariableItem getVariableItem(Context ctx, String variableName) throws BOSException, EASBizException {
        VariableItem vi = (VariableItem)DataplatformCacheHelper.get(ctx, 1, variableName);
        if (null == vi) {
            throw new VariableConfigException(VariableConfigException.VARIABLE_NOT_EXISTS, new Object[]{variableName});
        }
        return vi;
    }

    private static IVariableService getIVariableService(VariableItem variableResult) throws EASBizException {
        try {
            Class<?> clzz = Class.forName(variableResult.getClz());
            return (IVariableService)clzz.newInstance();
        }
        catch (Exception e) {
            throw new DataplatformException(DataplatformException.CLASS_INIT_EXCEPTION, e, new Object[]{variableResult.getClz()});
        }
    }

    public static List<Map<String, String>> getVariableListData(Context ctx, EntityViewInfo viewInfo) throws BOSException {
        if (null == ctx || null == viewInfo) {
            return Collections.EMPTY_LIST;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("type"));
        viewInfo.setSelector(selector);
        VariableConfigCollection coll = VariableConfigFactory.getLocalInstance(ctx).getVariableConfigCollection(viewInfo);
        if (null == coll || coll.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int total = coll.size();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>(total);
        HashMap<String, String> row = null;
        for (int i = 0; i < total; ++i) {
            row = new HashMap<String, String>(3);
            row.put("name", coll.get(i).getName());
            row.put("number", coll.get(i).getNumber());
            row.put("description", coll.get(i).getDescription());
            row.put("type", coll.get(i).getType().getName());
            data.add(row);
        }
        return data;
    }
}

