/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.common.util.SHREnumUtil;
import com.kingdee.shr.common.util.ShrSyssettingDbUtil;
import com.kingdee.shr.data.model.designtime.type.DataType;
import com.kingdee.shr.dataplatform.DataplatformException;
import com.kingdee.shr.dataplatform.NumberFormatEnum;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.ExcuteSQLResult;
import com.kingdee.shr.dataset.model.RuntimeSQLInfo;
import com.kingdee.shr.dataset.model.SQLFieldMappingItem;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.IDataQueryService;
import com.kingdee.shr.dataset.service.util.ExcuteSQLResultUtil;
import com.kingdee.shr.dataset.service.util.SQLExcuteHelper;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractDataQueryService
implements IDataQueryService {
    private static Logger logger = Logger.getLogger(AbstractDataQueryService.class);
    protected SQLExcuteHelper sqlHelper;

    protected final IRowSet getIRowSet(Context ctx, DataResult dataResult, ParamData param) throws BOSException, EASBizException {
        ExcuteSQLResult excuteSQLResult = new ExcuteSQLResult();
        excuteSQLResult.setRuntimeSQL(dataResult.getRuntimeSQL());
        excuteSQLResult.setParams(ExcuteSQLResultUtil.getStringParams(dataResult.getParams()));
        IRowSet rs = null;
        long cost = 0L;
        double logThresholdValue = 0.0;
        try {
            if (null != ParamManager.getParamValue((Context)ctx, null, (String)"SHR_DataPlatformCost_Log")) {
                logThresholdValue = Double.parseDouble(ParamManager.getParamValue((Context)ctx, null, (String)"SHR_DataPlatformCost_Log"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("DataQueryService sql={0}, params={1}", dataResult.getRuntimeSQL(), ExcuteSQLResultUtil.getStringParams(dataResult.getParams())));
            }
            long begin = System.currentTimeMillis();
            rs = null == dataResult.getParams() || dataResult.getParams().length <= 0 ? (null == param ? ShrSyssettingDbUtil.executeQuery((Context)ctx, (String)dataResult.getRuntimeSQL()) : ShrSyssettingDbUtil.executeQuery((Context)ctx, (String)dataResult.getRuntimeSQL(), (ParamData)param)) : (null == param ? ShrSyssettingDbUtil.executeQuery((Context)ctx, (String)dataResult.getRuntimeSQL(), (Object[])dataResult.getParams()) : ShrSyssettingDbUtil.executeQuery((Context)ctx, (String)dataResult.getRuntimeSQL(), (Object[])dataResult.getParams(), (ParamData)param));
            long end = System.currentTimeMillis();
            cost = end - begin;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("DataQueryService sql cost:{0} ms, {1} s", cost, (double)cost / 1000.0));
            }
            dataResult.setQueryCost(cost);
            excuteSQLResult.setIssuccess(true);
            excuteSQLResult.setQueryCost(dataResult.getQueryCost());
            excuteSQLResult.setErrorMessage("");
            IRowSet iRowSet = rs;
            return iRowSet;
        }
        catch (BOSException e) {
            excuteSQLResult.setIssuccess(false);
            excuteSQLResult.setErrorMessage(ExcuteSQLResultUtil.getStackTraceInfo(e));
            if (!(StringUtils.isEmpty((String)e.getMessage()) || e.getMessage().indexOf("Sql3 execute exception") == -1 && e.getMessage().indexOf("Sql execute exception") == -1)) {
                throw new DataplatformException(DataplatformException.SQL_EXCUTE_ERROR, new Object[]{"Sql Execute Error<a href='/shr/dynamic.do?method=downLoadLog&logType=apusic&handler=com.kingdee.shr.base.syssetting.web.handler.LogJarClassInfoToolsHandler'>Download Log</a>"});
            }
            throw new DataplatformException(DataplatformException.SQL_EXCUTE_ERROR, new Object[]{e.getMessage()});
        }
        catch (NumberFormatException e) {
            excuteSQLResult.setIssuccess(false);
            excuteSQLResult.setErrorMessage(ExcuteSQLResultUtil.getStackTraceInfo(e));
            e.printStackTrace();
            throw new DataplatformException(DataplatformException.SQL_EXCUTE_ERROR, new Object[]{e.getMessage()});
        }
        catch (EASBizException e) {
            excuteSQLResult.setIssuccess(false);
            excuteSQLResult.setErrorMessage(ExcuteSQLResultUtil.getStackTraceInfo(e));
            throw e;
        }
        finally {
            if ((double)cost / 1000.0 >= logThresholdValue) {
                ExcuteSQLResultUtil.saveExcuteSQLLog(ctx, excuteSQLResult);
            }
        }
    }

    @Override
    public DataResult getAllData(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        SQLResult sqlResult = (SQLResult)param.get("sqlResult");
        DataResult dataResult = new DataResult();
        this.sqlHelper = new SQLExcuteHelper(ctx, param);
        RuntimeSQLInfo sqlInfo = this.sqlHelper.convertVariableAndParam(sqlResult.getSql());
        dataResult.setSourceSQL(sqlResult.getSql());
        dataResult.setRuntimeSQL(sqlInfo.getSql());
        dataResult.setParams(sqlInfo.getParams());
        ArrayList<Map<String, Object>> dataResultList = new ArrayList<Map<String, Object>>();
        IRowSet rs = this.getIRowSet(ctx, dataResult, null);
        try {
            while (rs.next()) {
                this.convertRowData(ctx, dataResultList, sqlResult.getSqlFieldMapping(), rs);
            }
            dataResult.setPage(1);
            dataResult.setRecords(dataResultList.size());
            dataResult.setRows(dataResultList);
            dataResult.setTotal(dataResult.getRecords());
            return dataResult;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public DataResult getPageData(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        int page = 1;
        int rows = 50;
        if (param.get("page") instanceof Integer) {
            page = (Integer)param.get("page");
        }
        if (param.get("rows") instanceof Integer) {
            rows = (Integer)param.get("rows");
        }
        DataResult dataResult = new DataResult();
        this.sqlHelper = new SQLExcuteHelper(ctx, param);
        SQLResult sqlResult = (SQLResult)param.get("sqlResult");
        RuntimeSQLInfo sqlInfo = this.sqlHelper.convertVariableAndParam(sqlResult.getSql());
        SQLExcuteHelper.queryTotal(ctx, sqlInfo, dataResult);
        PagingHelper p = new PagingHelper();
        String realSql = p.getPagingSqlNoOptmize(ctx, SQLExcuteHelper.removeOrderByForGroupSQL(ctx, sqlInfo.getSql()), (page - 1) * rows, rows);
        dataResult.setSourceSQL(sqlResult.getSql());
        dataResult.setRuntimeSQL(realSql);
        dataResult.setParams(sqlInfo.getParams());
        ArrayList<Map<String, Object>> dataResultList = new ArrayList<Map<String, Object>>();
        IRowSet rs = this.getIRowSet(ctx, dataResult, p.getParamData());
        try {
            while (rs.next()) {
                this.convertRowData(ctx, dataResultList, sqlResult.getSqlFieldMapping(), rs);
            }
            dataResult.setPage(page);
            dataResult.setRecords(dataResultList.size());
            dataResult.setRows(dataResultList);
            return dataResult;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void convertRowData(Context ctx, List<Map<String, Object>> dataResult, List<SQLFieldMappingItem> sqlFieldMapping, IRowSet rs) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        for (SQLFieldMappingItem item : sqlFieldMapping) {
            this.convertResultByDataType(item, rs, row);
        }
        dataResult.add(row);
    }

    private Object getNumberFormatEnumValue(NumberFormatEnum format, Object value) {
        if (null == format || NumberFormatEnum.auto.equals((Object)format)) {
            return value;
        }
        if (NumberFormatEnum.integer.equals((Object)format)) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Long) {
                return ((Long)value).intValue();
            }
            if (value instanceof Double) {
                return ((Double)value).intValue();
            }
            if (value instanceof Float) {
                return ((Float)value).intValue();
            }
        } else {
            if (NumberFormatEnum.one_decimal.equals((Object)format)) {
                BigDecimal bd = this.getBigDecimalValue(value, 1);
                return bd.doubleValue();
            }
            if (NumberFormatEnum.two_decimals.equals((Object)format)) {
                BigDecimal bd = this.getBigDecimalValue(value, 2);
                return bd.doubleValue();
            }
            if (NumberFormatEnum.percentage.equals((Object)format)) {
                return this.getPercentValue(value);
            }
            if (NumberFormatEnum.percentage_with_one_decimal.equals((Object)format)) {
                BigDecimal bd = this.getBigDecimalValue(this.getPercentValue(value), 1);
                return bd.doubleValue();
            }
            if (NumberFormatEnum.percentage_with_two_decimals.equals((Object)format)) {
                BigDecimal bd = this.getBigDecimalValue(this.getPercentValue(value), 2);
                return bd.doubleValue();
            }
        }
        return value;
    }

    private Object getPercentValue(Object value) {
        if (value instanceof Integer) {
            return (double)((Integer)value).intValue() * 100.0;
        }
        if (value instanceof Long) {
            return (double)((Long)value).longValue() * 100.0;
        }
        if (value instanceof Double) {
            return (Double)value * 100.0;
        }
        if (value instanceof Float) {
            return (double)((Float)value).floatValue() * 100.0;
        }
        return value;
    }

    private BigDecimal getBigDecimalValue(Object value, int scale) {
        BigDecimal bd = new BigDecimal(String.valueOf(value));
        return bd.setScale(scale, 4);
    }

    private void convertResultByDataType(SQLFieldMappingItem item, IRowSet rs, Map<String, Object> row) throws SQLException {
        String field = item.getFieldName().replace("\"", "");
        int sqlType = rs.getRowSetMetaData().getColumnType(rs.getRowSetMetaData().getColumnIndex(field.toUpperCase()));
        if (DataType.DataTypeTran.NUMBER.toString().equals(item.getShowDataType())) {
            NumberFormatEnum format = NumberFormatEnum.getEnum(item.getFormat());
            if (4 == sqlType) {
                row.put(field, this.getNumberFormatEnumValue(format, rs.getInt(field)));
            } else if (8 == sqlType) {
                row.put(field, this.getNumberFormatEnumValue(format, rs.getDouble(field)));
            } else if (6 == sqlType) {
                row.put(field, this.getNumberFormatEnumValue(format, Float.valueOf(rs.getFloat(field))));
            } else if (3 == sqlType) {
                BigDecimal bd = rs.getBigDecimal(field);
                if (null == bd) {
                    row.put(field, this.getNumberFormatEnumValue(format, Float.valueOf(0.0f)));
                } else {
                    row.put(field, this.getNumberFormatEnumValue(format, bd.doubleValue()));
                }
            } else {
                Object o = rs.getObject(field);
                if (null == o) {
                    row.put(field, 0);
                } else {
                    row.put(field, this.getNumberFormatEnumValue(format, o));
                }
            }
        } else if (DataType.DataTypeTran.DATE.toString().equals(item.getShowDataType())) {
            row.put(field, this.getDate(item.getFormat(), field, item.getDataType(), rs));
        } else if (DataType.DataTypeTran.STRING.toString().equals(item.getShowDataType())) {
            if (DataType.ENUM.getName().equals(item.getDataType()) || com.kingdee.shr.data.model.designtime.type.DataType.ENUM.toString().equals(item.getDataType())) {
                if (!StringUtils.isEmpty((String)item.getRefSource()) && ("ENUM".equals(item.getShowDataType()) || "STRING".equals(item.getShowDataType()))) {
                    if (!this.sqlHelper.getEnumConvert().containsKey(item.getRefSource())) {
                        this.sqlHelper.getEnumConvert().put(item.getRefSource(), SHREnumUtil.getEnumMap((String)item.getRefSource()));
                    }
                    row.put(field, this.sqlHelper.getEnumConvert().get(item.getRefSource()).get(rs.getString(field)));
                } else {
                    row.put(field, rs.getObject(field));
                }
            } else if (DataType.BOOLEAN.getName().equals(item.getDataType()) || com.kingdee.shr.data.model.designtime.type.DataType.BOOLEAN.toString().equals(item.getDataType())) {
                if ("BOOLEAN".equals(item.getShowDataType()) || "STRING".equals(item.getShowDataType())) {
                    row.put(field, this.sqlHelper.getBooleanConvert().get(rs.getString(field)));
                } else {
                    row.put(field, rs.getBoolean(field));
                }
            } else if (DataType.STRING.getName().equals(item.getDataType()) || com.kingdee.shr.data.model.designtime.type.DataType.STRING.toString().equals(item.getDataType()) || DataType.UUID.getName().equals(item.getDataType()) || DataType.BOSUUID.getName().equals(item.getDataType()) || DataType.CHAR.getName().equals(item.getDataType()) || com.kingdee.shr.data.model.designtime.type.DataType.F7.toString().equals(item.getDataType())) {
                row.put(field, rs.getString(field));
            } else {
                row.put(field, rs.getObject(field));
            }
        } else if (4 == sqlType) {
            row.put(field, this.getNumberFormatEnumValue(NumberFormatEnum.getEnum(item.getFormat()), rs.getInt(field)));
        } else if (8 == sqlType) {
            row.put(field, this.getNumberFormatEnumValue(NumberFormatEnum.getEnum(item.getFormat()), rs.getDouble(field)));
        } else if (6 == sqlType) {
            row.put(field, this.getNumberFormatEnumValue(NumberFormatEnum.getEnum(item.getFormat()), Float.valueOf(rs.getFloat(field))));
        } else if (3 == sqlType) {
            BigDecimal bd = rs.getBigDecimal(field);
            if (null == bd) {
                row.put(field, this.getNumberFormatEnumValue(NumberFormatEnum.getEnum(item.getFormat()), Float.valueOf(0.0f)));
            } else {
                row.put(field, this.getNumberFormatEnumValue(NumberFormatEnum.getEnum(item.getFormat()), bd.doubleValue()));
            }
        } else if (12 == sqlType || -9 == sqlType) {
            row.put(field, rs.getString(field));
        } else if (91 == sqlType || 93 == sqlType || 92 == sqlType) {
            row.put(field, this.getDate(item.getFormat(), field, item.getDataType(), rs));
        } else if (16 == sqlType) {
            row.put(field, rs.getBoolean(field));
        } else if (1 == sqlType || -15 == sqlType) {
            row.put(field, rs.getCharacterStream(field));
        } else {
            row.put(field, rs.getObject(field));
        }
    }

    private String getDate(String format, String field, String dataType, IRowSet rs) throws SQLException {
        String formatStr = format;
        if (StringUtils.isEmpty((String)formatStr)) {
            formatStr = DataType.DATE.getName().equals(dataType) || com.kingdee.shr.data.model.designtime.type.DataType.DATE.toString().equals(dataType) ? "yyyy-MM-dd" : (DataType.TIMESTAMP.getName().equals(dataType) || com.kingdee.shr.data.model.designtime.type.DataType.TIMESTAMP.toString().equals(dataType) ? "yyyy-MM-dd HH:mm:ss" : "HH:mm:ss");
        }
        if (DataType.DATE.getName().equals(dataType) || com.kingdee.shr.data.model.designtime.type.DataType.DATE.toString().equals(dataType)) {
            Date d = rs.getDate(field);
            if (null == d) {
                return "";
            }
            return DateTimeUtils.format((java.util.Date)d, (String)formatStr);
        }
        if (DataType.TIMESTAMP.getName().equals(dataType) || com.kingdee.shr.data.model.designtime.type.DataType.TIMESTAMP.toString().equals(dataType)) {
            Timestamp d = rs.getTimestamp(field);
            if (null == d) {
                return "";
            }
            return DateTimeUtils.format((java.util.Date)d, (String)formatStr);
        }
        Time d = rs.getTime(field);
        if (null == d) {
            return "";
        }
        return DateTimeUtils.format((java.util.Date)d, (String)formatStr);
    }
}

