/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.java;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.ServiceCollection;
import com.kingdee.shr.base.syssetting.ServiceFactory;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.shr.base.syssetting.ServiceSubCategoryInfo;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PersonSelfMenusService
extends AbstractJavaDataQueryService {
    @Override
    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    @Override
    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    private List<Map<String, Object>> getData(Context ctx, JavaAPIParam param) throws EASBizException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("alias"));
        sic.add(new SelectorItemInfo("urlValue"));
        sic.add(new SelectorItemInfo("urlType"));
        sic.add(new SelectorItemInfo("iconType"));
        sic.add(new SelectorItemInfo("iconName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("category.index"));
        sic.add(new SelectorItemInfo("category.name"));
        sic.add(new SelectorItemInfo("category.number"));
        sic.add(new SelectorItemInfo("category.iconName"));
        sic.add(new SelectorItemInfo("category.iconType"));
        sic.add(new SelectorItemInfo("subCategory.id"));
        sic.add(new SelectorItemInfo("subCategory.index"));
        sic.add(new SelectorItemInfo("subCategory.name"));
        sic.add(new SelectorItemInfo("subCategory.number"));
        entityViewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("category.index"));
        sorter.add(new SorterItemInfo("subCategory.index"));
        sorter.add(new SorterItemInfo("index"));
        entityViewInfo.setSorter(sorter);
        String permissionSql = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissionsByMenu();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("permission", null));
        filter.getFilterItems().add(new FilterItemInfo("permission", (Object)permissionSql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("category.workPlatform.id", (Object)"Qz9UfhLqB0+vmMJ4+80EykRLkh4=", CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3");
        entityViewInfo.setFilter(filter);
        ServiceCollection coll = ServiceFactory.getLocalInstance((Context)ctx).getServiceCollection(entityViewInfo);
        if (null == coll || coll.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet<String> parent = new HashSet<String>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            ServiceInfo model = coll.get(i);
            if (parent.contains(model.getSubCategory().getId().toString())) {
                list.add(this.genServiceModelItem(model));
                continue;
            }
            parent.add(model.getSubCategory().getId().toString());
            list.add(this.genSubCategoryModelItem(model.getSubCategory()));
            list.add(this.genServiceModelItem(model));
        }
        return list;
    }

    private Map<String, Object> genSubCategoryModelItem(ServiceSubCategoryInfo subCategory) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("id", subCategory.getId().toString());
        item.put("name", subCategory.getName());
        item.put("number", subCategory.getNumber());
        item.put("alias", subCategory.getName());
        item.put("parentId", "");
        item.put("description", "");
        item.put("isLeaf", false);
        item.put("level", 1);
        return item;
    }

    private Map<String, Object> genServiceModelItem(ServiceInfo model) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("id", model.getId().toString());
        item.put("name", model.getName());
        item.put("number", "");
        item.put("parentId", model.getSubCategory().getId().toString());
        item.put("description", model.getDescription());
        item.put("isLeaf", true);
        item.put("level", 2);
        item.put("alias", model.getAlias());
        item.put("iconName", model.getIconName());
        if (null != model.getIconType()) {
            item.put("iconType", model.getIconType().getValue());
        }
        if (null != model.getUrlType()) {
            item.put("urlType", model.getUrlType().getValue());
        }
        item.put("urlValue", model.getUrlValue());
        return item;
    }
}

