/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.secrity.SecrityTableAndFieldCheckUtil;
import com.kingdee.shr.data.model.designtime.type.DataType;
import com.kingdee.shr.dataplatform.AggregationEnum;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.NumberFormatEnum;
import com.kingdee.shr.dataplatform.SQLParseLevel;
import com.kingdee.shr.dataplatform.variable.VariableServiceFactory;
import com.kingdee.shr.dataset.model.BizObjectItem;
import com.kingdee.shr.dataset.model.ConditionItem;
import com.kingdee.shr.dataset.model.DesignDataSetCommon;
import com.kingdee.shr.dataset.model.DimensionCallItem;
import com.kingdee.shr.dataset.model.FilterConditionItem;
import com.kingdee.shr.dataset.model.HtmlContentItem;
import com.kingdee.shr.dataset.model.OrderItem;
import com.kingdee.shr.dataset.model.ParamsItem;
import com.kingdee.shr.dataset.model.SQLFieldMappingItem;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.model.SelectorItem;
import com.kingdee.shr.dataset.model.SelectorObjItem;
import com.kingdee.shr.dataset.model.VariableItem;
import com.kingdee.shr.dataset.service.sql.AbstractSqlParsingService;
import com.kingdee.shr.dataset.service.sql.CaseSqlServiceFactory;
import com.kingdee.shr.dataset.service.sql.ICaseSqlService;
import com.kingdee.shr.dataset.service.util.CheckHelper;
import com.kingdee.shr.dataset.service.util.DateFunctionMappingUtil;
import com.kingdee.shr.dataset.service.util.SelectorHelper;
import com.kingdee.shr.pageset.model.Drill;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SqlParsingService
extends AbstractSqlParsingService {
    protected static Logger logger = Logger.getLogger(SqlParsingService.class);
    protected Map<String, String> selectMap = new HashMap<String, String>();
    protected SelectorHelper helper;
    protected DesignDataSetCommon designDataSetCommon;

    @Override
    public SQLResult execute(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        this.designDataSetCommon = (DesignDataSetCommon)param.get("designDataSetCommon");
        long begin = System.currentTimeMillis();
        SQLResult result = new SQLResult();
        SQLResult resultDataset = new SQLResult();
        if (null == this.designDataSetCommon) {
            return null;
        }
        this.helper = new SelectorHelper(this.designDataSetCommon);
        String from = this.assembleSQLFrom(ctx, result);
        Map<String, String> select = this.assembleSQLSelect(ctx, result, resultDataset);
        String where = this.assembleSQLWhere(ctx, result);
        String orderBy = this.assembleSQLOderBy(resultDataset, select.get("selectDimension"), select.get("selectMeasure"));
        String sql = this.assembleSQL(select.get("selectDimension"), select.get("selectDimensionGroup"), select.get("selectMeasure"), from, where, orderBy);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("AbstractSqlParsingService getSql cost={0} ms,sql={1} ", end - begin, sql));
        }
        SecrityTableAndFieldCheckUtil.checkPrivateInSQL((Context)ctx, (String)sql);
        result.setSql(sql);
        result.setSourceParam(this.designDataSetCommon.getParams());
        result.setSqlParseLevel(SQLParseLevel.DATASET.toString());
        return result;
    }

    protected final String assembleSQLFrom(Context ctx, SQLResult result) throws EASBizException {
        BizObjectItem bizObjectItem = this.designDataSetCommon.getBizObject();
        StringBuilder from = new StringBuilder();
        String tableName = this.getTableName(ctx, bizObjectItem);
        from.append(tableName).append(" AS ").append(bizObjectItem.getId()).append(" ");
        this.assembleSQLFromChildren(ctx, bizObjectItem, from, result);
        return from.toString();
    }

    protected final void assembleSQLFromChildren(Context ctx, BizObjectItem bizObjectItem, StringBuilder from, SQLResult result) throws EASBizException {
        if (null == bizObjectItem.getChildren() || bizObjectItem.getChildren().isEmpty()) {
            return;
        }
        for (BizObjectItem each : bizObjectItem.getChildren()) {
            String tableName = this.getTableName(ctx, each);
            this.assembleSQLFromEachOn(ctx, tableName, each, bizObjectItem, from, result);
            if (null == each.getChildren() || each.getChildren().isEmpty()) continue;
            this.assembleSQLFromChildren(ctx, each, from, result);
        }
    }

    protected final void assembleSQLFromEachOn(Context ctx, String currentTableName, BizObjectItem current, BizObjectItem parent, StringBuilder from, SQLResult result) throws EASBizException {
        from.append(current.getRelation().getLinkType()).append(" ").append(currentTableName).append(" AS ").append(current.getId()).append(" ON ");
        for (ConditionItem codition : current.getRelation().getCondition()) {
            String field;
            if (!StringUtils.isEmpty((String)codition.getLeftBracket())) {
                from.append(codition.getLeftBracket());
            }
            if ("field".equals(codition.getCompareType())) {
                String pField = this.getField(codition.getParentLinkKey(), parent.getId());
                String cField = this.getField(codition.getCurrentLinkKey(), current.getId());
                from.append(pField).append(codition.getCompareSymbol()).append(cField);
            } else if ("constant".equals(codition.getCompareType())) {
                field = this.getSignField(codition, parent, current);
                String dataType = codition.getDataType();
                String symbol = codition.getCompareSymbol();
                this.doCompareValue(ctx, field, dataType, symbol, codition.getValue(), result, from, this.getSignFieldSourceRef(codition, parent, current));
            } else if ("param".equals(codition.getCompareType())) {
                field = this.getSignField(codition, parent, current);
                from.append(this.assembleParamStr(field, codition.getCompareSymbol(), (String)codition.getValue()));
            } else if ("variable".equals(codition.getCompareType())) {
                field = this.getSignField(codition, parent, current);
                from.append(this.assembleVariableStr(field, codition.getCompareSymbol(), (String)codition.getValue()));
            }
            if (!StringUtils.isEmpty((String)codition.getRightBracket())) {
                from.append(codition.getRightBracket());
            }
            if (StringUtils.isEmpty((String)codition.getLogicSymbol())) continue;
            from.append(codition.getLogicSymbol());
        }
        from.append(" ");
    }

    protected final void setFieldToSelectMap(SelectorItem selector, String fieldName) {
        if (this.selectMap.containsKey(selector.getId())) {
            return;
        }
        this.selectMap.put(selector.getId(), fieldName);
    }

    protected final String getMeasureField(String aggregation, String tableAlias, String fieldName) {
        return MessageFormat.format("{0}({1})", aggregation, this.getField(fieldName, tableAlias));
    }

    protected final String getCountDMeasureField(String tableAlias, String fieldName) {
        return MessageFormat.format("COUNT(DISTINCT {0})", this.getField(fieldName, tableAlias));
    }

    protected final String getCalculateField(SelectorItem selector) throws EASBizException {
        int beginIndex;
        HtmlContentItem contenct = selector.getCalculateContent();
        if (null == contenct || StringUtils.isEmpty((String)contenct.getText())) {
            return null;
        }
        String text = contenct.getText();
        while (-1 != (beginIndex = text.indexOf("["))) {
            int endIndex;
            String tempStr = text.substring(beginIndex);
            String selectorVariable = tempStr.substring(0, (endIndex = tempStr.indexOf("]")) + 1);
            String tempField = selectorVariable.replace("[", "").replace("]", "");
            if (StringUtils.isEmpty((String)tempField) || tempField.split("\\.").length != 2) {
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("calculate field formatter error : {0}.", tempField)});
            }
            String[] temp = tempField.split("\\.");
            String field = this.getField(temp[1], temp[0]);
            if (StringUtils.isEmpty((String)field)) {
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("calculate field not exits : {0}.", tempField)});
            }
            text = text.replace(selectorVariable, field);
        }
        return text;
    }

    protected String assembleMeasureSQLSelect(SelectorItem selector, StringBuilder selectMeasure, SQLResult result) throws EASBizException {
        String fieldAlias = this.getFieldAlias(selector);
        AggregationEnum aggregationEnum = null;
        String field = "";
        field = selector.isCalculateField() ? this.getCalculateField(selector) : (AggregationEnum.count_distinct.equals((Object)(aggregationEnum = AggregationEnum.getEnum(selector.getAggregation()))) ? this.getCountDMeasureField(selector.getTableId(), selector.getPhysicsName()) : this.getMeasureField(aggregationEnum.getValue(), selector.getTableId(), selector.getPhysicsName()));
        this.setFieldToSelectMap(selector, field);
        SQLFieldMappingItem item = this.assembleSQLFieldMappingItem(field, fieldAlias, selector);
        this.setMeasureDataType(selector, item, aggregationEnum);
        item.setMeasure(true);
        if (null != aggregationEnum) {
            item.setAggregation(aggregationEnum.getValue());
        }
        result.getSqlFieldMapping().add(item);
        selectMeasure.append(field).append(" AS ").append(fieldAlias);
        return field;
    }

    protected String assembleDimensionSQLSelect(SelectorItem selector, StringBuilder selectDimension, StringBuilder selectDimensionGroup, SQLResult result) {
        String fieldAlias = this.getFieldAlias(selector);
        String field = this.getField(selector.getPhysicsName(), selector.getTableId());
        SQLFieldMappingItem item = this.assembleSQLFieldMappingItem(field, fieldAlias, selector);
        this.setSQLFieldMappingItemRefSource(selector, item);
        result.getSqlFieldMapping().add(item);
        this.setFieldToSelectMap(selector, field);
        selectDimension.append(field).append(" AS ").append(fieldAlias);
        selectDimensionGroup.append(field);
        return field;
    }

    protected String assembleDimensionGroupSQLSelect(Context ctx, SelectorItem selector, StringBuilder selectDimension, StringBuilder selectDimensionGroup, SQLResult result) throws EASBizException {
        String fieldAlias = this.getFieldAlias(selector);
        String field = this.getField(selector.getPhysicsName(), selector.getTableId());
        DimensionCallItem dimensionCallItem = selector.getDimensionCal();
        ICaseSqlService caseService = CaseSqlServiceFactory.getICaseSqlService(dimensionCallItem.getValueType(), selector.getSource());
        String calField = caseService.parsingCaseSql(ctx, dimensionCallItem, field, result);
        result.getSqlFieldMapping().add(this.assembleSQLFieldMappingItem(calField, fieldAlias, selector));
        this.setFieldToSelectMap(selector, calField);
        selectDimension.append(calField).append(" AS ").append(fieldAlias);
        selectDimensionGroup.append(calField);
        return calField;
    }

    protected String assembleDimensionCalculateFieldSQLSelect(SelectorItem selector, StringBuilder select, StringBuilder group, SQLResult result) throws EASBizException {
        String fieldAlias = this.getFieldAlias(selector);
        String text = this.getCalculateField(selector);
        this.setFieldToSelectMap(selector, text);
        result.getSqlFieldMapping().add(this.assembleSQLFieldMappingItem(text, fieldAlias, selector));
        select.append(text).append(" AS ").append(fieldAlias);
        if (null != selector.getCalculateContent() && !StringUtils.isEmpty((String)selector.getCalculateContent().getText()) && selector.getCalculateContent().getText().indexOf("[") != -1 && selector.getCalculateContent().getText().indexOf("]") != -1) {
            group.append(text);
        } else {
            int index = group.lastIndexOf(",");
            int length = group.length();
            if (length > 0 && index != -1 && length > index) {
                group.delete(index, length);
            }
        }
        return text;
    }

    protected final String assembleSQLSelectBySelectorItem(Context ctx, SelectorItem selector, StringBuilder selectDimension, StringBuilder selectDimensionGroup, StringBuilder selectMeasure, SQLResult result) throws EASBizException {
        if (selector.isMeasureField() && (!StringUtils.isEmpty((String)selector.getAggregation()) || selector.isCalculateField())) {
            return this.assembleMeasureSQLSelect(selector, selectMeasure, result);
        }
        if (selector.isDimensionGroup()) {
            return this.assembleDimensionGroupSQLSelect(ctx, selector, selectDimension, selectDimensionGroup, result);
        }
        if (selector.isCalculateField()) {
            return this.assembleDimensionCalculateFieldSQLSelect(selector, selectDimension, selectDimensionGroup, result);
        }
        return this.assembleDimensionSQLSelect(selector, selectDimension, selectDimensionGroup, result);
    }

    protected final Map<String, String> assembleSQLSelect(Context ctx, SQLResult result, SQLResult resultDataset) throws EASBizException {
        int i;
        int total;
        int i2;
        int total2;
        SelectorObjItem soi = this.designDataSetCommon.getSelector();
        StringBuilder selectDimensionDataset = new StringBuilder();
        StringBuilder selectDimensionGroupDataset = new StringBuilder();
        StringBuilder selectMeasureDataset = new StringBuilder();
        if (null != soi.getMeasure() && !soi.getMeasure().isEmpty()) {
            total2 = soi.getMeasure().size();
            for (i2 = 0; i2 < total2; ++i2) {
                if (i2 > 0) {
                    selectMeasureDataset.append(", ");
                }
                this.assembleSQLSelectBySelectorItem(ctx, soi.getMeasure().get(i2), selectDimensionDataset, selectDimensionGroupDataset, selectMeasureDataset, resultDataset);
            }
        }
        if (null != soi.getDimension() && !soi.getDimension().isEmpty()) {
            total2 = soi.getDimension().size();
            for (i2 = 0; i2 < total2; ++i2) {
                if (i2 > 0) {
                    selectDimensionDataset.append(", ");
                    selectDimensionGroupDataset.append(", ");
                }
                this.assembleSQLSelectBySelectorItem(ctx, soi.getDimension().get(i2), selectDimensionDataset, selectDimensionGroupDataset, selectMeasureDataset, resultDataset);
            }
        }
        List<SelectorItem> dimension = this.helper.getDimensionSelector(soi.getDimension(), this.designDataSetCommon.getInitConfig());
        List<SelectorItem> measure = this.helper.getMeasureSelector(soi.getMeasure(), this.designDataSetCommon.getInitConfig());
        this.initOrderBySelector(dimension, measure);
        StringBuilder selectDimension = new StringBuilder();
        StringBuilder selectDimensionGroup = new StringBuilder();
        StringBuilder selectMeasure = new StringBuilder();
        boolean isGroupBy = false;
        if (null != measure && !measure.isEmpty()) {
            isGroupBy = true;
            total = measure.size();
            for (i = 0; i < total; ++i) {
                if (i > 0) {
                    selectMeasure.append(", ");
                }
                String field = this.selectMap.get(measure.get(i).getId());
                SQLFieldMappingItem item = this.findSQLFieldMappingItem(field, resultDataset);
                selectMeasure.append(field).append(" AS ").append(item.getFieldName());
                result.getSqlFieldMapping().add(item);
            }
        }
        if (null != dimension && !dimension.isEmpty()) {
            total = dimension.size();
            for (i = 0; i < total; ++i) {
                if (i > 0) {
                    selectDimension.append(", ");
                    selectDimensionGroup.append(", ");
                }
                SelectorItem selectorItem = dimension.get(i);
                String field = this.selectMap.get(selectorItem.getId());
                SQLFieldMappingItem item = this.findSQLFieldMappingItem(field, resultDataset);
                boolean isDrillField = selectorItem.isDrillField();
                if (isDrillField) {
                    field = this.assembleField(field, selectorItem.getDrill());
                    item.setShowDataType(DataType.STRING.toString());
                }
                selectDimension.append(field).append(" AS ").append(item.getFieldName());
                if (selectDimensionGroupDataset.indexOf(field) != -1 || isDrillField) {
                    selectDimensionGroup.append(field);
                } else {
                    int index = selectDimensionGroup.lastIndexOf(",");
                    int length = selectDimensionGroup.length();
                    if (length > 0 && index != -1 && length > index) {
                        selectDimensionGroup.delete(index, length);
                    }
                }
                result.getSqlFieldMapping().add(item);
            }
        }
        result.setGroupBy(isGroupBy);
        HashMap<String, String> resultSelect = new HashMap<String, String>(3);
        resultSelect.put("selectDimension", selectDimension.toString());
        resultSelect.put("selectDimensionGroup", selectDimensionGroup.toString());
        resultSelect.put("selectMeasure", selectMeasure.toString());
        return resultSelect;
    }

    private void initOrderBySelector(List<SelectorItem> dimension, List<SelectorItem> measure) {
        List<OrderItem> orders = this.designDataSetCommon.getOrder();
        if (null == orders || orders.isEmpty()) {
            return;
        }
        for (OrderItem order : orders) {
            SelectorItem selector = this.helper.getSelectMapping().get(order.getSelectId());
            if (this.isExistsSelector(dimension, measure, selector)) continue;
            if (selector.isMeasureField()) {
                measure.add(selector);
                continue;
            }
            dimension.add(selector);
        }
    }

    private boolean isExistsSelector(List<SelectorItem> dimension, List<SelectorItem> measure, SelectorItem selector) {
        if (!dimension.isEmpty()) {
            for (SelectorItem s : dimension) {
                if (!s.getId().equals(selector.getId())) continue;
                return true;
            }
        }
        if (!measure.isEmpty()) {
            for (SelectorItem s : measure) {
                if (!s.getId().equals(selector.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private SQLFieldMappingItem findSQLFieldMappingItem(String field, SQLResult resultDataset) {
        for (SQLFieldMappingItem item : resultDataset.getSqlFieldMapping()) {
            if (!field.equals(item.getQueryFieldName())) continue;
            return item;
        }
        return null;
    }

    protected final String assembleSQLWhere(Context ctx, SQLResult result) throws BOSException, EASBizException {
        StringBuilder whereStr = new StringBuilder();
        List<FilterConditionItem> filters = this.designDataSetCommon.getFilter();
        if (null != filters && !filters.isEmpty()) {
            for (FilterConditionItem filter : filters) {
                if (!StringUtils.isEmpty((String)filter.getLeftBracket())) {
                    whereStr.append(filter.getLeftBracket());
                }
                whereStr.append(this.assembleSQLDataSetWhere(ctx, filter, this.designDataSetCommon.getParams(), result));
                if (!StringUtils.isEmpty((String)filter.getRightBracket())) {
                    whereStr.append(filter.getRightBracket()).append(" ");
                }
                if (StringUtils.isEmpty((String)filter.getLogicSymbol())) continue;
                whereStr.append(filter.getLogicSymbol()).append(" ");
            }
        }
        return whereStr.toString();
    }

    protected String assembleSQLDataSetWhere(Context ctx, FilterConditionItem filter, List<ParamsItem> params, SQLResult result) throws EASBizException, BOSException {
        StringBuilder whereStr = new StringBuilder();
        String field = this.getFilterField(filter);
        String symbol = filter.getCompareSymbol();
        String dataType = filter.getDataType();
        if ("field".equals(filter.getCompareType())) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Not support compareType:{0} , field : {1}.", filter.getCompareType(), field)});
        }
        if ("constant".equals(filter.getCompareType())) {
            this.doCompareValue(ctx, field, dataType, symbol, filter.getValue(), result, whereStr, this.getFilterFieldSourceRef(filter));
        } else if ("param".equals(filter.getCompareType())) {
            ParamsItem p = this.getParamItem(filter.getValue(), params);
            if (null == p) {
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("param missing , paramName : {0}.", field, filter.getValue())});
            }
            if ("variable".equals(p.getDataType())) {
                this.doParamVariable(ctx, p.getParamName(), (String)p.getValue(), symbol, field, whereStr);
            } else if ("in".equals(symbol = this.getSymbol(p, symbol)) || "not in".equals(symbol)) {
                whereStr.append(this.assembleParamStrWithBracket(field, symbol, (String)filter.getValue()));
            } else {
                whereStr.append(this.assembleParamStr(field, symbol, (String)filter.getValue()));
            }
        } else if ("variable".equals(filter.getCompareType())) {
            this.doVariable(ctx, (String)filter.getValue(), symbol, field, whereStr);
        }
        return whereStr.toString();
    }

    protected final String getCardFilterField(Context ctx, String fieldAlias, SQLResult result) throws EASBizException {
        String field = this.getFieldBySQLResult(fieldAlias, result);
        SelectorItem selector = this.helper.getSelectorItemByFieldAlias(fieldAlias);
        if (StringUtils.isEmpty((String)field)) {
            StringBuilder selectDimension = new StringBuilder();
            StringBuilder selectDimensionGroup = new StringBuilder();
            StringBuilder selectMeasure = new StringBuilder();
            field = this.assembleSQLSelectBySelectorItem(ctx, selector, selectDimension, selectDimensionGroup, selectMeasure, result);
        }
        if (selector.isMeasureField()) {
            field = this.getField(selector.getPhysicsName(), selector.getTableId());
        }
        return field;
    }

    protected final String getFieldBySQLResult(String fieldAlias, SQLResult result) {
        List<SQLFieldMappingItem> ll = result.getSqlFieldMapping();
        if (!ll.isEmpty()) {
            for (SQLFieldMappingItem item : ll) {
                if (!item.getFieldName().equals(fieldAlias)) continue;
                return item.getQueryFieldName();
            }
        }
        return null;
    }

    private void doParamVariable(Context ctx, String paramName, String vName, String symbol, String field, StringBuilder whereStr) throws BOSException, EASBizException {
        VariableItem vi = VariableServiceFactory.getVariableItem(ctx, vName);
        if (null == vi) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{vName + " is not exists."});
        }
        if (30 == vi.getType() || 20 == vi.getType()) {
            symbol = "in";
            whereStr.append(this.assembleParamStrWithBracket(field, symbol, paramName));
        } else if (40 == vi.getType()) {
            whereStr.append(" (");
            whereStr.append(this.assembleParamStr(field, ">=", paramName, "_###BEGIN###"));
            whereStr.append(" AND ");
            whereStr.append(this.assembleParamStr(field, "<=", paramName, "_###END###"));
            whereStr.append(") ");
        } else {
            whereStr.append(this.assembleParamStr(field, symbol, vName));
        }
    }

    private void doVariable(Context ctx, String vName, String symbol, String field, StringBuilder whereStr) throws BOSException, EASBizException {
        VariableItem vi = VariableServiceFactory.getVariableItem(ctx, vName);
        if (null == vi) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{vName + " is not exists."});
        }
        this.checkVariable(vi);
        if (30 == vi.getType() || 20 == vi.getType()) {
            symbol = "in";
            whereStr.append(this.assembleVariableStrWithBracket(field, symbol, vName));
        } else if (40 == vi.getType()) {
            whereStr.append(" (");
            whereStr.append(this.assembleVariableStr(field, ">=", vName, "_###BEGIN###"));
            whereStr.append(" AND ");
            whereStr.append(this.assembleVariableStr(field, "<=", vName, "_###END###"));
            whereStr.append(") ");
        } else {
            whereStr.append(this.assembleVariableStr(field, symbol, vName));
        }
    }

    protected abstract void checkVariable(VariableItem var1) throws BOSException, EASBizException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSymbol(ParamsItem p, String symbol) throws EASBizException {
        String dataType = p.getDataType();
        Object value = p.getValue();
        String paramName = p.getParamName();
        String realSymbol = symbol;
        CheckHelper.checkCompareSymbolByDataType(dataType, symbol);
        if ("NUMBER".equals(dataType) || "INT".equals(dataType)) {
            if (value instanceof Number) return realSymbol;
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Number Type.", paramName, String.valueOf(String.valueOf(value)))});
        }
        if ("DATE".equals(dataType) || "TIMESTAMP".equals(dataType) || "TIME".equals(dataType)) {
            if (!(value instanceof String)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Date Type.", paramName, String.valueOf(String.valueOf(value)))});
            String d = (String)value;
            try {
                new Timestamp(DateTimeUtils.parseDate((String)d).getTime());
                return realSymbol;
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Date Type.", paramName, String.valueOf(String.valueOf(value)))});
            }
        } else {
            if ("ENUM".equals(dataType)) {
                if (!(value instanceof List)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Enum Type.", paramName, String.valueOf(value))});
                return CheckHelper.getCompareSymbolForEnumOrF7(symbol);
            }
            if ("STRING".equals(dataType)) return realSymbol;
            if ("BOOLEAN".equals(dataType)) {
                if (value instanceof Boolean) return realSymbol;
                if (!(value instanceof String)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Boolean Type.", paramName, String.valueOf(value))});
                String temp = String.valueOf(value);
                if ("1".equals(temp)) return realSymbol;
                if ("0".equals(temp)) return realSymbol;
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Boolean Type.", paramName, String.valueOf(value))});
            }
            if (!"F7".equals(dataType)) return realSymbol;
            if (!(value instanceof List)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not F7 Type.", paramName, String.valueOf(value))});
            return CheckHelper.getCompareSymbolForEnumOrF7(symbol);
        }
    }

    private ParamsItem getParamItem(Object paramName, List<ParamsItem> params) {
        if (params.isEmpty()) {
            return null;
        }
        for (ParamsItem p : params) {
            if (!p.getParamName().equals(paramName)) continue;
            return p;
        }
        return null;
    }

    private String assembleField(String field, Drill drill) {
        String f = null;
        if ("time".equals(drill.getType())) {
            f = this.parseDate(field, drill.getValue());
        }
        return f;
    }

    private String parseDate(String field, String value) {
        StringBuilder sBuilder = new StringBuilder();
        switch (value) {
            case "y": {
                this.parseAppendTwo(sBuilder, "y", field);
                break;
            }
            case "M": {
                this.parseAppendTwo(sBuilder, "y", field);
                this.parseAppendThree(sBuilder, "M", field, "-");
                break;
            }
            case "Md": {
                this.parseAppendTwo(sBuilder, "y", field);
                this.parseAppendThree(sBuilder, "M", field, "-");
                this.parseAppendThree(sBuilder, "Md", field, "-");
                break;
            }
            case "H": {
                this.parseAppendTwo(sBuilder, "y", field);
                this.parseAppendThree(sBuilder, "M", field, "-");
                this.parseAppendThree(sBuilder, "Md", field, "-");
                this.parseAppendThree(sBuilder, "H", field, " ");
                break;
            }
            case "m": {
                this.parseAppendTwo(sBuilder, "y", field);
                this.parseAppendThree(sBuilder, "M", field, "-");
                this.parseAppendThree(sBuilder, "Md", field, "-");
                this.parseAppendThree(sBuilder, "H", field, " ");
                this.parseAppendThree(sBuilder, "m", field, ":");
                break;
            }
            case "s": {
                this.parseAppendTwo(sBuilder, "y", field);
                this.parseAppendThree(sBuilder, "M", field, "-");
                this.parseAppendThree(sBuilder, "Md", field, "-");
                this.parseAppendThree(sBuilder, "H", field, " ");
                this.parseAppendThree(sBuilder, "m", field, ":");
                this.parseAppendThree(sBuilder, "s", field, ":");
                break;
            }
        }
        return sBuilder.toString();
    }

    private void parseAppendYear(StringBuilder sBuilder, String value, String field) {
        sBuilder.append(DateFunctionMappingUtil.parseDateFunction(value)).append("(").append(field).append(")");
    }

    private void parseAppend(StringBuilder sBuilder, String value, String field) {
        sBuilder.append("Right(100 + ").append(DateFunctionMappingUtil.parseDateFunction(value)).append("(").append(field).append(")").append(", 2)");
    }

    private void parseAppendTwo(StringBuilder sBuilder, String value, String field) {
        sBuilder.append("TO_CHAR(");
        if ("y".equals(value)) {
            this.parseAppendYear(sBuilder, value, field);
        } else {
            this.parseAppend(sBuilder, value, field);
        }
        sBuilder.append(")");
    }

    private void parseAppendThree(StringBuilder sBuilder, String value, String field, String sym) {
        sBuilder.append(" ||").append(" '").append(sym).append("' ").append("|| ");
        this.parseAppendTwo(sBuilder, value, field);
    }

    protected String assembleSQLOderBy(SQLResult resultDataset, String selectd, String selectm) {
        List<OrderItem> orders = this.designDataSetCommon.getOrder();
        if (null == orders || orders.isEmpty()) {
            return null;
        }
        int index = 0;
        StringBuilder orderStr = new StringBuilder();
        for (OrderItem order : orders) {
            String field = this.selectMap.get(order.getSelectId());
            SQLFieldMappingItem item = this.findSQLFieldMappingItem(field, resultDataset);
            if (!StringUtils.isEmpty((String)selectd) && selectd.indexOf(field) != -1) {
                if (index > 0) {
                    orderStr.append(",");
                }
                orderStr.append(item.getFieldName()).append(" ").append(order.getSorterMethod());
                ++index;
            }
            if (StringUtils.isEmpty((String)selectm) || selectm.indexOf(field) == -1) continue;
            if (index > 0) {
                orderStr.append(",");
            }
            orderStr.append(item.getFieldName()).append(" ").append(order.getSorterMethod());
            ++index;
        }
        return orderStr.toString();
    }

    protected final String getSignField(ConditionItem codition, BizObjectItem parent, BizObjectItem current) {
        if (!StringUtils.isEmpty((String)codition.getParentLinkKey())) {
            return this.getField(codition.getParentLinkKey(), parent.getId());
        }
        if (!StringUtils.isEmpty((String)codition.getCurrentLinkKey())) {
            return this.getField(codition.getCurrentLinkKey(), current.getId());
        }
        return null;
    }

    protected final String getSignFieldSourceRef(ConditionItem codition, BizObjectItem parent, BizObjectItem current) {
        if (!StringUtils.isEmpty((String)codition.getParentLinkKey())) {
            return this.getFieldSourceRef(codition.getParentLinkKey(), parent.getId());
        }
        if (!StringUtils.isEmpty((String)codition.getCurrentLinkKey())) {
            return this.getFieldSourceRef(codition.getCurrentLinkKey(), current.getId());
        }
        return null;
    }

    protected final String getFilterField(FilterConditionItem filter) {
        if (StringUtils.isEmpty((String)filter.getPhysicsName())) {
            return filter.getName();
        }
        return this.getField(filter.getPhysicsName(), filter.getTableId());
    }

    protected final String getFilterFieldSourceRef(FilterConditionItem filter) {
        if (StringUtils.isEmpty((String)filter.getPhysicsName())) {
            return filter.getName();
        }
        return this.getFieldSourceRef(filter.getPhysicsName(), filter.getTableId());
    }

    protected SQLFieldMappingItem assembleSQLFieldMappingItem(String field, String fieldAlias, SelectorItem selector) {
        SQLFieldMappingItem item = new SQLFieldMappingItem();
        item.setQueryFieldName(field);
        item.setFieldName(fieldAlias);
        item.setAlias(selector.getAlias());
        item.setDataType(selector.getDataType());
        item.setShowDataType(selector.getDataTypeTran());
        if (!StringUtils.isEmpty((String)selector.getFormat())) {
            item.setFormat(selector.getFormat());
            if ("NUMBER".equals(selector.getDataTypeTran())) {
                item.setFormat(NumberFormatEnum.getEnum(selector.getFormat()).getValue());
            }
        }
        return item;
    }

    protected abstract String getTableName(Context var1, BizObjectItem var2);

    protected abstract void setMeasureDataType(SelectorItem var1, SQLFieldMappingItem var2, AggregationEnum var3);

    protected abstract void setSQLFieldMappingItemRefSource(SelectorItem var1, SQLFieldMappingItem var2);

    protected abstract String getField(String var1, String var2);

    protected abstract String getFieldSourceRef(String var1, String var2);
}

