/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.util;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.model.designtime.type.DataType;
import com.kingdee.shr.dataplatform.DataSetException;
import java.text.MessageFormat;

public class CheckHelper {
    public static void checkCompareSymbolByDataType(String dataType, String compareSymbol) throws EASBizException {
        boolean checkResult = true;
        if (DataType.STRING.toString().equals(dataType)) {
            checkResult = CheckHelper.checkCompareSymbolString(compareSymbol);
        } else if (DataType.INT.toString().equals(dataType) || DataType.NUMBER.toString().equals(dataType)) {
            String[] css;
            checkResult = compareSymbol.indexOf("|") == -1 ? CheckHelper.checkCompareSymbolNumber(compareSymbol) : ((css = compareSymbol.split("\\|")).length != 2 ? false : CheckHelper.checkCompareSymbolNumber(css[0]) && CheckHelper.checkCompareSymbolNumber(css[1]));
        } else if (DataType.DATE.toString().equals(dataType) || DataType.TIME.toString().equals(dataType) || DataType.TIMESTAMP.toString().equals(dataType)) {
            String[] css;
            checkResult = compareSymbol.indexOf("|") == -1 ? CheckHelper.checkCompareSymbolDate(compareSymbol) : ((css = compareSymbol.split("\\|")).length != 2 ? false : CheckHelper.checkCompareSymbolDate(css[0]) && CheckHelper.checkCompareSymbolDate(css[1]));
        } else if (DataType.BOOLEAN.toString().equals(dataType)) {
            checkResult = CheckHelper.checkCompareSymbolBoolean(compareSymbol);
        } else if (DataType.ENUM.toString().equals(dataType)) {
            checkResult = CheckHelper.checkCompareSymbolEnum(compareSymbol);
        } else if (DataType.F7.toString().equals(dataType)) {
            checkResult = CheckHelper.checkCompareSymbolF7(compareSymbol);
        }
        if (!checkResult) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("data type : {0}, not suport compare symbol:{1}", dataType, compareSymbol)});
        }
    }

    public static boolean checkCompareSymbolString(String compareSymbol) {
        return "=".equals(compareSymbol) || "<>".equals(compareSymbol) || "is not null".equals(compareSymbol) || "is null".equals(compareSymbol);
    }

    public static boolean checkCompareSymbolNumber(String compareSymbol) {
        return "=".equals(compareSymbol) || "<>".equals(compareSymbol) || ">".equals(compareSymbol) || "<".equals(compareSymbol) || ">=".equals(compareSymbol) || "<=".equals(compareSymbol);
    }

    public static boolean checkCompareSymbolDate(String compareSymbol) {
        return "=".equals(compareSymbol) || "<>".equals(compareSymbol) || ">".equals(compareSymbol) || "<".equals(compareSymbol) || ">=".equals(compareSymbol) || "<=".equals(compareSymbol);
    }

    public static boolean checkCompareSymbolBoolean(String compareSymbol) {
        return "=".equals(compareSymbol) || "<>".equals(compareSymbol);
    }

    public static boolean checkCompareSymbolEnum(String compareSymbol) {
        return "=".equals(compareSymbol) || "<>".equals(compareSymbol) || "in".equals(compareSymbol) || "not in".equals(compareSymbol);
    }

    public static boolean checkCompareSymbolF7(String compareSymbol) {
        return "=".equals(compareSymbol) || "<>".equals(compareSymbol) || "in".equals(compareSymbol) || "not in".equals(compareSymbol);
    }

    public static String getCompareSymbolForEnumOrF7(String compareSymbol) {
        if ("=".equals(compareSymbol) || "in".equals(compareSymbol)) {
            return "in";
        }
        if ("<>".equals(compareSymbol) || "not in".equals(compareSymbol)) {
            return "not in";
        }
        return "in";
    }
}

