/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRBillBaseEntryFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.contract.ContractChangeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.ISHRElectronicTemplate;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.OtherFollowLaborConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowLaborConEntryInfo;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryInfo;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateCollection;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateFactory;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.SignTypeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.cloudservice.util.TSPServerInstance;
import com.kingdee.shr.econtractservice.AutoPassJobInfoCollection;
import com.kingdee.shr.econtractservice.AutoPassJobInfoFactory;
import com.kingdee.shr.econtractservice.AutoPassJobInfoInfo;
import com.kingdee.shr.econtractservice.EContractCompanyTaskFactory;
import com.kingdee.shr.econtractservice.EContractCompanyTaskInfo;
import com.kingdee.shr.econtractservice.EContractSendMessageFacadeFactory;
import com.kingdee.shr.econtractservice.EContractServiceFacadeFactory;
import com.kingdee.shr.econtractservice.IAutoPassJobInfo;
import com.kingdee.shr.econtractservice.IEContractCompanyTask;
import com.kingdee.shr.econtractservice.ISSCEContractRecord;
import com.kingdee.shr.econtractservice.SSCEContractRecordCollection;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.SSCEContractTaskCollection;
import com.kingdee.shr.econtractservice.SSCEContractTaskFactory;
import com.kingdee.shr.econtractservice.SSCEContractTaskInfo;
import com.kingdee.shr.econtractservice.app.AbstractSSCEContractTaskFacadeControllerBean;
import com.kingdee.shr.econtractservice.app.EContractServiceException;
import com.kingdee.shr.econtractservice.service.ContractBizBillService;
import com.kingdee.shr.econtractservice.service.EContractService;
import com.kingdee.shr.econtractservice.util.EContractConstants;
import com.kingdee.shr.elecontract.EContractSignCallBackRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordFactory;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.shr.shareservice.AssembleRuleFacadeFactory;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSCEContractTaskFacadeControllerBean
extends AbstractSSCEContractTaskFacadeControllerBean {
    private static final long serialVersionUID = -8904669092661944542L;
    private static final Logger logger = LoggerFactory.getLogger(SSCEContractTaskFacadeControllerBean.class);
    private static final String EMPLOYEE_SIGN = "0";
    private static final String ENTERPRISE_SIGN = "1";

    @Override
    protected IObjectCollection _autoProcessTask(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isNeedProcess", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isProcess", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isAutoClose", (Object)1));
        view.setFilter(filter);
        SSCEContractTaskCollection taskCollection = SSCEContractTaskFactory.getLocalInstance(ctx).getSSCEContractTaskCollection(view);
        if (taskCollection.size() > 0) {
            StringBuilder billBuf = new StringBuilder();
            for (int dex = 0; dex < taskCollection.size(); ++dex) {
                SSCEContractTaskInfo taskInfo = taskCollection.get(dex);
                this._processCompanySignTask(ctx, (IObjectValue)taskInfo);
                if (null == taskInfo.getBillId()) continue;
                if (billBuf.length() != 0) {
                    billBuf.append(",");
                }
                billBuf.append(taskInfo.getBillId().toString());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("billIDs", billBuf.toString());
            params.put("billType", "SSC_SignContractBill");
            params.put("isGetHis", true);
            AssembleRuleFacadeFactory.getLocalInstance((Context)ctx).backDataPush(params);
        }
        return null;
    }

    @Override
    protected SSCEContractTaskInfo _processCompanySignTask(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SSCEContractTaskInfo taskInfo = (SSCEContractTaskInfo)model;
        String jobId = taskInfo.getJobId();
        String paramStr = taskInfo.getParam();
        JSONObject param = JSONObject.parseObject((String)paramStr);
        String jobClassification = param.getString("jobClassification");
        String message = param.getString("message");
        String decision = param.getString("decision");
        String decisionId = param.getString("decisionId");
        String innerMsg = param.getString("innerMsg");
        UserInfo processUser = taskInfo.getUser();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobId", jobId);
        params.put("userId", processUser.getId().toString());
        params.put("unpassReaId", "");
        params.put("jobClassification", jobClassification);
        params.put("message", message);
        params.put("mesTitle", "");
        params.put("jobPriority", "");
        params.put("decision", decision);
        params.put("decisionId", decisionId);
        params.put("plainText", "");
        params.put("signature", "");
        params.put("innerMsg", innerMsg);
        logger.error("SSCEContractTaskFacadeControllerBean _processCompanyTask : " + params);
        String action = taskInfo.getAction();
        SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)action, params);
        taskInfo.setIsDelete(true);
        taskInfo.setIsNeedProcess(false);
        taskInfo.setProcessTime(EContractService.getCurTimestamp());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isDelete"));
        selector.add(new SelectorItemInfo("isNeedProcess"));
        SSCEContractTaskFactory.getLocalInstance(ctx).updatePartial(taskInfo, selector);
        try {
            ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)taskInfo.getBillId().getType());
            HRBillBaseInfo billBaseInfo = (HRBillBaseInfo)bizInterface.getValue((IObjectPK)new ObjectUuidPK(taskInfo.getBillId().toString()));
            if (billBaseInfo.get("entrys") != null) {
                IObjectCollection entrys = (IObjectCollection)billBaseInfo.get("entrys");
                HRBillBaseEntryInfo billEntryInfo = (HRBillBaseEntryInfo)entrys.getObject(0);
                bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billEntryInfo.getId().getType());
                billEntryInfo = (HRBillBaseEntryInfo)bizInterface.getValue((IObjectPK)new ObjectUuidPK(billEntryInfo.getId()));
                ISSCEContractRecord iSSCEContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
                SSCEContractRecordCollection sscEContractRecordCollection = iSSCEContractRecord.getSSCEContractRecordCollection("where billId = '" + taskInfo.getBillId().toString() + "'");
                boolean isSigned = true;
                for (int i = 0; i < sscEContractRecordCollection.size(); ++i) {
                    if (sscEContractRecordCollection.get(i).isIsSigned()) continue;
                    isSigned = false;
                    break;
                }
                if (isSigned) {
                    logger.error("_processCompanySignTask sendSignCompleteMessage ");
                    EContractSendMessageFacadeFactory.getLocalInstance(ctx).sandSignCompleteMessage(billBaseInfo, billEntryInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return taskInfo;
    }

    @Override
    protected Object _processCompanySignTask(Context ctx, String jobId, String billId, Map dataMap, Map otherParamMap) throws BOSException, EASBizException {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object sendCompanySignatureRequest(Context ctx, HRBillBaseInfo hrBillBaseInfo, HRBillBaseEntryInfo billEntryInfo, SSCEContractRecordInfo recordInfo, SSCEContractTaskInfo taskInfo) throws BOSException, EASBizException {
        String lcfpName;
        Map<String, String> processInfo = EContractService.getProcessInfoNew(ctx, hrBillBaseInfo, billEntryInfo);
        String contractNo = processInfo.get("contractNo");
        String entryId = processInfo.get("entryId");
        String templateTypeId = processInfo.get("templateId");
        if (StringUtils.isEmpty((String)entryId) || StringUtils.isEmpty((String)contractNo) || StringUtils.isEmpty((String)templateTypeId)) throw new EContractServiceException(EContractServiceException.PARAM_ERROR);
        ISHRElectronicTemplate electronicTemplate = SHRElectronicTemplateFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractTemplet.id", (Object)templateTypeId));
        view.setSelector(this.getElectronicTemplateSelector());
        view.setFilter(filter);
        SHRElectronicTemplateCollection electronicTemplateInfoColl = electronicTemplate.getSHRElectronicTemplateCollection(view);
        if (electronicTemplateInfoColl.size() < 1) throw new EContractServiceException(EContractServiceException.E_TEMPLATE_NOT_FOUND);
        SHRElectronicTemplateInfo electronicTemplateInfo = electronicTemplateInfoColl.get(0);
        if (!electronicTemplateInfo.isIsRegister()) {
            throw new EContractServiceException(EContractServiceException.E_TEMPLATE_NOT_REGISTER);
        }
        String taskType = taskInfo.getType();
        LabContractFirstPartyInfo partyInfo = null;
        String clientEnterpriseId = "";
        HashMap<String, Object> osfDataMap = new HashMap<String, Object>();
        partyInfo = EContractService.getLabContractFirstParty(ctx, hrBillBaseInfo, billEntryInfo);
        if (partyInfo == null) {
            throw new EContractServiceException(EContractServiceException.COMPANY_SIGN_ERROR, new Object[]{500});
        }
        if (StringUtils.isEmpty((String)partyInfo.getName())) {
            partyInfo = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(partyInfo.getId().toString()));
        }
        if (!StringUtils.isEmpty((String)(lcfpName = EContractService.getLCFPNameByBillId(hrBillBaseInfo))) && !lcfpName.equals(partyInfo.getName())) {
            throw new EContractServiceException(EContractServiceException.LCFPNAME_NOT_SAME_BILL);
        }
        KDContractConfigInfo contractConfigInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + partyInfo.getId().toString() + "'");
        if (contractConfigInfo == null) {
            throw new EContractServiceException(EContractServiceException.CONTRACT_CONFIG_IS_NOT_OPEN);
        }
        if (!contractConfigInfo.getEnterpriseName().equals(partyInfo.getName())) {
            throw new EContractServiceException(EContractServiceException.LCFPNAME_NOT_SAME_CONFIG);
        }
        clientEnterpriseId = contractConfigInfo.getClientEnterpriseId();
        KDContractConfigInfo signatureKdContractConfig = contractConfigInfo;
        if ("COMPANY_B".equalsIgnoreCase(taskType)) {
            LabContractFirstPartyInfo partyBInfo = EContractService.getLabContractPartyB(ctx, hrBillBaseInfo, billEntryInfo);
            if (partyBInfo == null) {
                throw new EContractServiceException(EContractServiceException.COMPANY_SIGN_ERROR, new Object[]{500});
            }
            if (StringUtils.isEmpty((String)partyBInfo.getName())) {
                partyBInfo = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(partyBInfo.getId().toString()));
            }
            KDContractConfigInfo contractBConfigInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + partyBInfo.getId().toString() + "'");
            osfDataMap.put("userIds", Collections.singletonList(contractBConfigInfo.getClientEnterpriseId()));
            clientEnterpriseId = contractBConfigInfo.getClientEnterpriseId();
            ElectronicContractUtils.checkKDContractConfigIsAuth((Context)ctx, (KDContractConfigInfo)contractBConfigInfo);
            signatureKdContractConfig = contractBConfigInfo;
        }
        String eContractSealTypeId = electronicTemplateInfo.getEContractSealType().getId().toString();
        String signatureId = com.kingdee.eas.hr.contract.util.ElectronicContractUtils.getSignatureId((Context)ctx, (String)eContractSealTypeId, (KDContractConfigInfo)signatureKdContractConfig);
        String eContractNO = recordInfo.getEContractNO();
        processInfo.put("kdappEContractNumber", eContractNO);
        osfDataMap.put("kdContractConfigId", contractConfigInfo.getId().toString());
        osfDataMap.put("contractNo", eContractNO);
        osfDataMap.put("billId", hrBillBaseInfo.getId().toString());
        osfDataMap.put("entryId", billEntryInfo.getId().toString());
        if (null != osfDataMap.get("userIds")) {
            osfDataMap.put("signatureIds", Collections.singletonList(signatureId));
        } else {
            osfDataMap.put("signatureId", signatureId);
        }
        logger.error("ElectroniContractTaskEditHandler OSFparam osfDataMap: {}", osfDataMap);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject osfResult = (JSONObject)osfServiceFacade.processService("electronicLaborCompanySignService", osfDataMap);
        logger.error("ElectroniContractTaskEditHandler OSFresult : " + osfResult.toJSONString());
        int resStatus = osfResult.getIntValue("code");
        if (resStatus != 0) throw new EContractServiceException(EContractServiceException.COMPANY_SIGN_ERROR, new Object[]{resStatus + " : " + osfResult.getString("msg")});
        EContractCompanyTaskInfo companyTaskInfo = EContractService.getEContractCompanyTaskInfoNew(ctx, hrBillBaseInfo.getId().toString(), taskInfo.getJobId(), entryId, eContractNO);
        boolean isNew = false;
        if (companyTaskInfo == null) {
            companyTaskInfo = new EContractCompanyTaskInfo();
            companyTaskInfo.setBillId(hrBillBaseInfo.getId());
            companyTaskInfo.setJobId(BOSUuid.read((String)taskInfo.getJobId()));
            companyTaskInfo.setContractNo(eContractNO);
            companyTaskInfo.setTaskType(taskType);
            companyTaskInfo.setEntryId(BOSUuid.read((String)entryId));
            isNew = true;
        }
        companyTaskInfo.setIsRequest(true);
        companyTaskInfo.setRequestTime(EContractService.getCurTimestamp());
        companyTaskInfo.setUserId(clientEnterpriseId);
        IEContractCompanyTask ieContractCompanyTask = EContractCompanyTaskFactory.getLocalInstance(ctx);
        if (isNew) {
            ieContractCompanyTask.save((CoreBaseInfo)companyTaskInfo);
            return null;
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isRequest"));
            selector.add(new SelectorItemInfo("requestTime"));
            selector.add(new SelectorItemInfo("userId"));
            ieContractCompanyTask.updatePartial(companyTaskInfo, selector);
        }
        return null;
    }

    @Override
    protected Object _processPersonSignTask(Context ctx, String jobId, String billId, Map dataMap, Map otherParamMap) throws BOSException, EASBizException {
        IObjectCollection otherEntrys;
        SSCEContractTaskInfo taskInfo = EContractService.getEContractTaskInfo(ctx, jobId, billId, "PERSON");
        boolean hasSave = false;
        if (taskInfo == null) {
            taskInfo = EContractService.saveSSCEContractTaskInfo(ctx, jobId, billId, dataMap, otherParamMap, true, "PERSON");
            hasSave = true;
        }
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        logger.info("billBosType---->:" + billBosType);
        ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
        CoreBaseCollection coreBaseCollection = bizInterface.getCollection("where id = '" + billId + "'");
        HRBillBaseInfo billBaseInfo = null;
        logger.info("_processPersonSignTask coreBaseCollection_size is " + coreBaseCollection.size());
        if (coreBaseCollection.size() <= 0) {
            throw new BOSException("get bill fail!");
        }
        billBaseInfo = (HRBillBaseInfo)coreBaseCollection.get(0);
        HRBillBaseEntryInfo billEntryInfo = null;
        IHRBillBaseEntry iHRBillBaseEntry = HRBillBaseEntryFactory.getLocalInstance((Context)ctx);
        if (billBaseInfo.get("entrys") != null) {
            IObjectCollection entrys = (IObjectCollection)billBaseInfo.get("entrys");
            billEntryInfo = (HRBillBaseEntryInfo)entrys.getObject(0);
            bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billEntryInfo.getId().getType());
            billEntryInfo = (HRBillBaseEntryInfo)bizInterface.getValue((IObjectPK)new ObjectUuidPK(billEntryInfo.getId()));
        }
        logger.info("_processPersonSignTask entryInfo11 : " + billEntryInfo);
        if (billEntryInfo == null) {
            throw new BOSException("get entry fail!");
        }
        ArrayList<HRBillBaseEntryInfo> hrBillBaseEntryInfoList = new ArrayList<HRBillBaseEntryInfo>();
        IContractTemplet iContractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx);
        ContractTempletInfo contractTempletInfo = iContractTemplet.getContractTempletInfo((IObjectPK)new ObjectUuidPK(((ContractTempletInfo)billEntryInfo.get("contractTemplet")).getId()));
        this.singleSignComplete(ctx, contractTempletInfo, billEntryInfo, billBaseInfo);
        hrBillBaseEntryInfoList.add(billEntryInfo);
        HRBillBaseEntryInfo otherEntryBillEntryInfo = null;
        if (billBaseInfo.get("otherEntrys") != null && (otherEntrys = (IObjectCollection)billBaseInfo.get("otherEntrys")).size() > 0) {
            for (int i = 0; i < otherEntrys.size(); ++i) {
                logger.info("enter_ singleSignComplete, otherEntrys size is " + otherEntrys.size());
                otherEntryBillEntryInfo = (HRBillBaseEntryInfo)otherEntrys.getObject(i);
                ContractTempletInfo otherContractTempletInfo = iContractTemplet.getContractTempletInfo((IObjectPK)new ObjectUuidPK(((ContractTempletInfo)otherEntryBillEntryInfo.get("contractTemplet")).getId()));
                logger.info("enter_ singleSignComplete, otherContractTempletInfo id is " + otherContractTempletInfo.getId().toString());
                this.singleSignComplete(ctx, otherContractTempletInfo, otherEntryBillEntryInfo, billBaseInfo);
                hrBillBaseEntryInfoList.add(otherEntryBillEntryInfo);
            }
        }
        try {
            String jobClassification = "";
            if (otherParamMap.get("jobClassification") instanceof Double) {
                Double souble = (Double)otherParamMap.get("jobClassification");
                jobClassification = String.valueOf(souble.intValue());
            } else {
                jobClassification = String.valueOf(otherParamMap.get("jobClassification"));
            }
            String message = String.valueOf(otherParamMap.get("message"));
            String decision = String.valueOf(otherParamMap.get("decision"));
            String decisionId = String.valueOf(otherParamMap.get("decisionId"));
            String innerMsg = String.valueOf(otherParamMap.get("innerMsg"));
            HashMap<String, String> params = new HashMap<String, String>();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            params.put("jobId", jobId);
            params.put("userId", userId);
            params.put("unpassReaId", "");
            params.put("jobClassification", jobClassification);
            params.put("message", message);
            params.put("mesTitle", "");
            params.put("jobPriority", "");
            params.put("decision", decision);
            params.put("decisionId", decisionId);
            params.put("plainText", "");
            params.put("signature", "");
            params.put("innerMsg", innerMsg);
            logger.error("EContractServiceFacadeControllerBean processPersonSignTask : " + params);
            SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"PASS", params);
            try {
                if (SignTypeEnum.SINGLESIGN.equals((Object)contractTempletInfo.getSignType())) {
                    logger.info("SINGLESIGN_ ");
                    EContractSendMessageFacadeFactory.getLocalInstance(ctx).sandSignCompleteMessage(billBaseInfo, billEntryInfo);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!hasSave) {
            this.saveModel(ctx, (CoreBaseInfo)taskInfo);
        }
        return taskInfo;
    }

    private void singleSignComplete(Context ctx, ContractTempletInfo contractTempletInfo, HRBillBaseEntryInfo billEntryInfo, HRBillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        IContractTemplet iContractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx);
        contractTempletInfo = iContractTemplet.getContractTempletInfo("where id = '" + contractTempletInfo.getId() + "'");
        logger.info("singleSignComplete,  contractTempletInfo SignType is " + contractTempletInfo.getSignType().getValue());
        if (SignTypeEnum.SINGLESIGN.equals((Object)contractTempletInfo.getSignType())) {
            Object signStateObj = billEntryInfo.get("signState");
            String contractNO = (String)billEntryInfo.get("contractNo");
            logger.info("singleSignComplete, contractNO is " + contractNO);
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByContractNo(ctx, contractNO, billBaseInfo.getId().toString());
            logger.info("singleSignComplete, recordInfo id is " + recordInfo.getId());
            if (recordInfo == null) {
                EContractSignState currentSignState = null;
                if (signStateObj instanceof EContractSignState) {
                    currentSignState = (EContractSignState)signStateObj;
                } else if (signStateObj instanceof Integer) {
                    currentSignState = EContractSignState.getEnum((int)((Integer)signStateObj));
                } else {
                    Integer intObj = Integer.parseInt(String.valueOf(signStateObj));
                    currentSignState = EContractSignState.getEnum((int)intObj);
                }
                HashMap<String, Boolean> repairParam = new HashMap<String, Boolean>();
                if (EContractSignState.signing.equals((Object)currentSignState)) {
                    repairParam.put("isPersonSigned", true);
                }
                recordInfo = (SSCEContractRecordInfo)EContractServiceFacadeFactory.getLocalInstance(ctx).repairEContractRecordData(billBaseInfo, billEntryInfo, repairParam);
            }
            Timestamp curTimestamp = EContractService.getCurTimestamp();
            recordInfo.setIsSigned(true);
            recordInfo.setSignedTime(curTimestamp);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isSigned"));
            selector.add(new SelectorItemInfo("signedTime"));
            SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selector);
        }
    }

    protected void updateSSCEContractRecord(Context ctx, String jobId, HRBillBaseEntryInfo billEntryInfo, HRBillBaseInfo billBaseInfo, Map otherParamMap) throws BOSException, EASBizException {
        ContractTempletInfo contractTempletInfo = (ContractTempletInfo)billEntryInfo.get("contractTemplet");
        IContractTemplet iContractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx);
        contractTempletInfo = iContractTemplet.getContractTempletInfo("where id = '" + contractTempletInfo.getId() + "'");
        if (SignTypeEnum.SINGLESIGN.equals((Object)contractTempletInfo.getSignType())) {
            Object newSignState = null;
            Object signStateObj = billEntryInfo.get("signState");
            EContractSignState currentSignState = null;
            if (signStateObj instanceof EContractSignState) {
                currentSignState = (EContractSignState)signStateObj;
            } else if (signStateObj instanceof Integer) {
                currentSignState = EContractSignState.getEnum((int)((Integer)signStateObj));
            } else {
                Integer intObj = Integer.parseInt(String.valueOf(signStateObj));
                currentSignState = EContractSignState.getEnum((int)intObj);
            }
            String contractNO = (String)billEntryInfo.get("contractNo");
            logger.info("updateSSCEContractRecord_contractNO is " + contractNO);
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByContractNo(ctx, contractNO, billBaseInfo.getId().toString());
            if (recordInfo == null) {
                HashMap<String, Boolean> repairParam = new HashMap<String, Boolean>();
                if (EContractSignState.signing.equals((Object)currentSignState)) {
                    repairParam.put("isPersonSigned", true);
                }
                recordInfo = (SSCEContractRecordInfo)EContractServiceFacadeFactory.getLocalInstance(ctx).repairEContractRecordData(billBaseInfo, billEntryInfo, repairParam);
            }
            Timestamp curTimestamp = EContractService.getCurTimestamp();
            recordInfo.setCompanySignTime(curTimestamp);
            recordInfo.setIsSigned(true);
            recordInfo.setSignedTime(curTimestamp);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("companySignTime"));
            selector.add(new SelectorItemInfo("isSigned"));
            selector.add(new SelectorItemInfo("signedTime"));
            SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _processSignCallBack(Context ctx, Map param, IObjectValue billInfo) throws BOSException, EASBizException {
        HRBillBaseEntryInfo billEntryInfo;
        HRBillBaseInfo billBaseInfo;
        boolean isPersonSignCallBack;
        Timestamp curTimestamp;
        int resultCode;
        String contractNO;
        block32: {
            IObjectCollection entrys;
            contractNO = (String)param.get("contractNO");
            resultCode = Integer.parseInt(String.valueOf(param.get("resultCode")));
            curTimestamp = EContractService.getCurTimestamp();
            isPersonSignCallBack = this.isPersonSignCallBack(ctx, param);
            billBaseInfo = (HRBillBaseInfo)billInfo;
            billEntryInfo = null;
            if (billBaseInfo.get("entrys") != null) {
                entrys = (IObjectCollection)billBaseInfo.get("entrys");
                billEntryInfo = (HRBillBaseEntryInfo)entrys.getObject(0);
            }
            if (billEntryInfo != null) break block32;
            entrys = null;
            return entrys;
        }
        try {
            SignTypeEnum signType;
            EContractSignState newSignState = null;
            Object signStateObj = billEntryInfo.get("signState");
            EContractSignState currentSignState = null;
            if (signStateObj instanceof EContractSignState) {
                currentSignState = (EContractSignState)signStateObj;
            } else if (signStateObj instanceof Integer) {
                currentSignState = EContractSignState.getEnum((int)((Integer)signStateObj));
            } else {
                Integer intObj = Integer.parseInt(String.valueOf(signStateObj));
                currentSignState = EContractSignState.getEnum((int)intObj);
            }
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByEContractNo(ctx, contractNO, billBaseInfo.getId().toString());
            if (recordInfo == null) {
                HashMap<String, Boolean> repairParam = new HashMap<String, Boolean>();
                if (EContractSignState.signing.equals((Object)currentSignState)) {
                    repairParam.put("isPersonSigned", true);
                }
                recordInfo = (SSCEContractRecordInfo)EContractServiceFacadeFactory.getLocalInstance(ctx).repairEContractRecordData(billBaseInfo, billEntryInfo, repairParam);
            }
            if ((signType = recordInfo.getSignType()) == null) {
                signType = SignTypeEnum.DOUBLESIGN;
            }
            logger.error("SignContractPersonInfoService isPersonSignCallBack : " + isPersonSignCallBack);
            logger.error("SignContractPersonInfoService recordInfo.isIsCompanySign() : " + recordInfo.isIsCompanySign());
            if (isPersonSignCallBack && EContractSignState.nosign.equals((Object)currentSignState)) {
                logger.error("SignContractPersonInfoService process person sign call back start");
                if (!this.hasPersonSignCallBackSuccessRecord(ctx, param)) {
                    logger.error("SignContractPersonInfoService process person sign call back");
                    if (1 == resultCode) {
                        recordInfo.setIsPersonSign(true);
                        recordInfo.setPersonSignTime(new Timestamp(System.currentTimeMillis()));
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("isPersonSign"));
                        selector.add(new SelectorItemInfo("personSignTime"));
                        if (SignTypeEnum.SINGLESIGN.equals((Object)signType)) {
                            recordInfo.setSignedTime(new Timestamp(System.currentTimeMillis()));
                            recordInfo.setIsSigned(true);
                            selector.add(new SelectorItemInfo("signedTime"));
                            selector.add(new SelectorItemInfo("isSigned"));
                        }
                        SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selector);
                        newSignState = EContractSignState.signing;
                        billEntryInfo.put("signState", (Object)newSignState);
                        this.updateBillEntrySignState(ctx, billEntryInfo, null);
                        this.reduceLicenseIfSingleSign(ctx, billBaseInfo, billEntryInfo, recordInfo, param, contractNO);
                        this.afterPersonSignCallBackSuccess(ctx, billBaseInfo, billEntryInfo, param, contractNO);
                    } else if (0 == resultCode) {
                        this.afterPersonSignCallBackFail(ctx, billBaseInfo, billEntryInfo, param, contractNO);
                    }
                }
            } else if (EContractSignState.signing.equals((Object)currentSignState) || EContractSignState.partyASigned.equals((Object)currentSignState)) {
                logger.error("SignContractPersonInfoService process company sign call back start");
                if (!this.hasCompanySignCallBackSuccessRecord(ctx, param)) {
                    logger.error("SignContractPersonInfoService process company sign call back");
                    String billId = billBaseInfo.getId().toString();
                    String userId = String.valueOf(param.get("userId"));
                    if (1 == resultCode) {
                        EContractCompanyTaskInfo companyTaskInfo = EContractService.getEContractCompanyTaskInfoByContractNOAndUserId(ctx, userId, contractNO);
                        SelectorItemCollection selector = new SelectorItemCollection();
                        companyTaskInfo.setIsCallback(true);
                        companyTaskInfo.setCallbackTime(curTimestamp);
                        companyTaskInfo.setResultCode(String.valueOf(param.get("resultCode")));
                        companyTaskInfo.setResultDesc(String.valueOf(param.get("resultDesc")));
                        companyTaskInfo.setIsFinish(true);
                        selector.clear();
                        selector.add(new SelectorItemInfo("isCallback"));
                        selector.add(new SelectorItemInfo("callbackTime"));
                        selector.add(new SelectorItemInfo("resultCode"));
                        selector.add(new SelectorItemInfo("resultDesc"));
                        selector.add(new SelectorItemInfo("isFinish"));
                        EContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(companyTaskInfo, selector);
                        String taskType = companyTaskInfo.getTaskType();
                        SSCEContractTaskInfo taskInfo = EContractService.getEContractTaskInfo(ctx, billId, null, taskType);
                        if ("COMPANY_B".equalsIgnoreCase(taskType)) {
                            recordInfo.setCompanyBSignTime(curTimestamp);
                            recordInfo.setIsCompanyBSign(true);
                            selector.clear();
                            selector.add(new SelectorItemInfo("CompanyBSignTime"));
                            selector.add(new SelectorItemInfo("isCompanyBSign"));
                            newSignState = EContractSignState.partyASigned;
                        } else if ("COMPANY".equalsIgnoreCase(taskType)) {
                            recordInfo.setIsCompanySign(true);
                            recordInfo.setCompanySignTime(curTimestamp);
                            recordInfo.setIsSigned(true);
                            recordInfo.setSignedTime(curTimestamp);
                            selector.clear();
                            selector.add(new SelectorItemInfo("isCompanySign"));
                            selector.add(new SelectorItemInfo("companySignTime"));
                            selector.add(new SelectorItemInfo("isSigned"));
                            selector.add(new SelectorItemInfo("signedTime"));
                            newSignState = EContractSignState.complete;
                        }
                        if (!recordInfo.isIsPersonSign()) {
                            recordInfo.setIsPersonSign(true);
                            recordInfo.setPersonSignTime(curTimestamp);
                            selector.add(new SelectorItemInfo("isPersonSign"));
                            selector.add(new SelectorItemInfo("personSignTime"));
                        }
                        SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selector);
                        if (taskInfo != null) {
                            selector.clear();
                            taskInfo.setCallbackTime(curTimestamp);
                            taskInfo.setIsNeedProcess(false);
                            selector.add(new SelectorItemInfo("callbackTime"));
                            selector.add(new SelectorItemInfo("isNeedProcess"));
                            SSCEContractTaskFactory.getLocalInstance(ctx).updatePartial(taskInfo, selector);
                        }
                        EContractService.updateKDContractConfigRecordState(ctx, billBaseInfo, billEntryInfo, contractNO, userId);
                        logger.error("SignContractPersonInfoService newSignState \uff1a " + newSignState);
                        billEntryInfo.put("signState", (Object)newSignState);
                        this.updateBillEntrySignState(ctx, billEntryInfo, null);
                        if ("COMPANY".equalsIgnoreCase(taskType)) {
                            // empty if block
                        }
                        this.afterCompanySignCallBackSuccess(ctx, billBaseInfo, billEntryInfo, param, contractNO);
                    } else if (0 == resultCode) {
                        EContractCompanyTaskInfo companyTaskInfo = EContractService.getEContractCompanyTaskInfoByContractNOAndUserId(ctx, userId, contractNO);
                        companyTaskInfo.setIsCallback(true);
                        companyTaskInfo.setCallbackTime(curTimestamp);
                        companyTaskInfo.setResultCode(String.valueOf(param.get("resultCode")));
                        companyTaskInfo.setResultDesc(String.valueOf(param.get("resultDesc")));
                        companyTaskInfo.setIsFinish(false);
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("isCallback"));
                        selector.add(new SelectorItemInfo("callbackTime"));
                        selector.add(new SelectorItemInfo("resultCode"));
                        selector.add(new SelectorItemInfo("resultDesc"));
                        selector.add(new SelectorItemInfo("isFinish"));
                        EContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(companyTaskInfo, selector);
                        this.afterCompanySignCallBackFail(ctx, billBaseInfo, billEntryInfo, param, contractNO);
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void reduceLicenseIfSingleSign(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, SSCEContractRecordInfo recordInfo, Map param, String contractNo) throws BOSException, EASBizException {
        ContractTempletInfo contractTempletInfo = EContractService.getContractTempletInfo(ctx, billBaseInfo, billEntryInfo);
        if (contractTempletInfo != null) {
            if (contractTempletInfo.get("signType") == null) {
                contractTempletInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTempletInfo.getId()));
            }
            if (SignTypeEnum.SINGLESIGN.equals((Object)contractTempletInfo.getSignType())) {
                logger.error("SSCEContractTaskFacadeControllerBean reduceLicenseIfSingleSign " + contractNo);
                try {
                    Map serverMap = null;
                    serverMap = TSPServerInstance.getServerInfo((Context)ctx);
                    String serviceId = (String)serverMap.get("service_id");
                    CheckHRCloudLicenseUtils.reduceLicenseCount((Context)ctx, (String)serviceId, (String)"8", (String)ENTERPRISE_SIGN, (String)contractNo);
                }
                catch (EASBizException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void afterPersonSignCallBackSuccess(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, Map param, String contractNO) throws BOSException, EASBizException {
        ContractTempletInfo contractTempletInfo = EContractService.getContractTempletInfo(ctx, billBaseInfo, billEntryInfo);
        if (contractTempletInfo != null) {
            if (contractTempletInfo.get("signType") == null) {
                contractTempletInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTempletInfo.getId()));
            }
            String billId = billBaseInfo.getId().toString();
            String jobId = null;
            String userId = "";
            boolean isAuto = false;
            IAutoPassJobInfo iAutoPassJobInfo = AutoPassJobInfoFactory.getLocalInstance(ctx);
            AutoPassJobInfoInfo autoPassJobInfo = null;
            AutoPassJobInfoCollection autoPassJobInfoCollection = iAutoPassJobInfo.getAutoPassJobInfoCollection("where billId = '" + billId + "'");
            if (autoPassJobInfoCollection.size() > 0) {
                autoPassJobInfo = autoPassJobInfoCollection.get(0);
                jobId = autoPassJobInfo.getJobId();
                userId = autoPassJobInfo.getHandlerId();
                isAuto = autoPassJobInfo.isIsAuto();
            }
            if (SignTypeEnum.SINGLESIGN.equals((Object)contractTempletInfo.getSignType()) && isAuto) {
                EContractSendMessageFacadeFactory.getLocalInstance(ctx).sandSignCompleteMessage(billBaseInfo, billEntryInfo);
                logger.error("SSCEContractTaskFacadeControllerBean afterPersonSignCallBackSuccess singleSign : " + contractNO);
                HashMap<String, String> otherParamMap = new HashMap<String, String>();
                otherParamMap.put("jobId", jobId);
                otherParamMap.put("billId", billId);
                otherParamMap.put("jobClassification", "");
                otherParamMap.put("message", "");
                otherParamMap.put("decision", "");
                otherParamMap.put("decisionId", "");
                otherParamMap.put("innerMsg", "");
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("bussAttrID", "ahYlKVCPRT2PRvCLZWrtqrxcg58=");
                SSCEContractTaskInfo taskInfo = EContractService.getEContractTaskInfo(ctx, jobId, billId, "PERSON");
                boolean hasSave = false;
                if (taskInfo == null) {
                    taskInfo = EContractService.saveSSCEContractTaskInfo(ctx, jobId, billId, dataMap, otherParamMap, true, "PERSON");
                    hasSave = true;
                }
                try {
                    String jobClassification = "";
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("jobId", jobId);
                    params.put("userId", userId);
                    params.put("unpassReaId", "");
                    params.put("jobClassification", jobClassification);
                    params.put("message", "");
                    params.put("mesTitle", "");
                    params.put("jobPriority", "");
                    params.put("decision", "");
                    params.put("decisionId", "");
                    params.put("plainText", "");
                    params.put("signature", "");
                    params.put("innerMsg", "");
                    SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"PASS", params);
                    HashMap<String, Object> assMap = new HashMap<String, Object>();
                    assMap.put("billIDs", billId);
                    assMap.put("billType", "SSC_SignContractBill");
                    assMap.put("isGetHis", true);
                    AssembleRuleFacadeFactory.getLocalInstance((Context)ctx).backDataPush(assMap);
                    HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                    paramsMap.put("billIDs", billId);
                    paramsMap.put("isUpdateHis", true);
                    JSONObject dyValues = new JSONObject();
                    JSONObject contractData = new JSONObject();
                    contractData.put("certificationStatus", (Object)EContractSignState.signing.getValue());
                    dyValues.put(billId, (Object)contractData);
                    paramsMap.put("dyValues", dyValues.toJSONString());
                    IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "updateDynamicVal");
                    imsf.process(ctx, paramsMap);
                }
                catch (EASBizException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                if (!hasSave) {
                    this.saveModel(ctx, (CoreBaseInfo)taskInfo);
                }
            }
        }
    }

    protected void afterPersonSignCallBackFail(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, Map param, String contractNO) throws BOSException, EASBizException {
    }

    protected void afterCompanySignCallBackSuccess(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, Map param, String contractNO) throws BOSException, EASBizException {
    }

    protected void afterCompanySignCallBackFail(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, Map param, String contractNO) throws BOSException, EASBizException {
    }

    protected boolean hasCompanySignCallBackSuccessRecord(Context ctx, Map param) throws BOSException, EASBizException {
        String contractNO = (String)param.get("contractNO");
        String userId = (String)param.get("userId");
        String signBackId = (String)param.get("signBackId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultCode", (Object)ENTERPRISE_SIGN));
        filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultDesc", (Object)this.getAutoSignSuccessResultDesc(ctx)));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)signBackId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 AND #1 AND #2 AND #3 AND #4");
        boolean exists = EContractSignCallBackRecordFactory.getLocalInstance((Context)ctx).exists(filterInfo);
        return exists;
    }

    protected boolean hasPersonSignCallBackSuccessRecord(Context ctx, Map param) throws BOSException, EASBizException {
        String contractNO = (String)param.get("contractNO");
        String userId = (String)param.get("userId");
        String signBackId = (String)param.get("signBackId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultCode", (Object)ENTERPRISE_SIGN));
        filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultDesc", (Object)this.getHandSignSuccessResultDesc(ctx)));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)signBackId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 AND #1 AND #2 AND #3 AND #4");
        boolean exists = EContractSignCallBackRecordFactory.getLocalInstance((Context)ctx).exists(filterInfo);
        return exists;
    }

    protected boolean isPersonSignCallBack(Context ctx, Map param) throws BOSException, EASBizException {
        String kdAppId = (String)param.get("kdAppId");
        String resultDesc = (String)param.get("resultDesc");
        String userId = (String)param.get("userId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("kdContractConfig.clientKDAppId", (Object)kdAppId));
        filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        String label177 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceWebResource", (String)"label177", (Context)ctx);
        return SSCPersonAuthRecordFactory.getLocalInstance((Context)ctx).exists(filterInfo) || resultDesc.contains(label177);
    }

    @Override
    protected Object _terminateContractSign(Context ctx, String billId, String entryId, String signType, Map taskParam) throws BOSException, EASBizException {
        Integer signState = null;
        if (EMPLOYEE_SIGN.equals(signType)) {
            signState = 3;
        }
        if (ENTERPRISE_SIGN.equals(signType)) {
            signState = 4;
        }
        CoreBaseInfo billInfo = null;
        CoreBaseInfo entryInfo = null;
        SelectorItemCollection selectorBill = new SelectorItemCollection();
        selectorBill.add(new SelectorItemInfo("billState"));
        SelectorItemCollection selectorEntry = new SelectorItemCollection();
        selectorEntry.add(new SelectorItemInfo("signState"));
        BOSObjectType billBosType = BOSUuid.read((String)billId).getType();
        BOSObjectType entryBosType = BOSUuid.read((String)entryId).getType();
        ICoreBase iCoreBaseBill = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBosType);
        ICoreBase iCoreBaseEntry = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entryBosType);
        if (iCoreBaseBill.exists((IObjectPK)new ObjectUuidPK(billId))) {
            billInfo = iCoreBaseBill.getValue((IObjectPK)new ObjectUuidPK(billId));
        }
        if (iCoreBaseEntry.exists((IObjectPK)new ObjectUuidPK(entryId))) {
            entryInfo = iCoreBaseEntry.getValue((IObjectPK)new ObjectUuidPK(entryId));
        }
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        SSCEContractRecordCollection sscEContractRecordColl = issceContractRecord.getSSCEContractRecordCollection("where billId = '" + billId + "'");
        for (int i = 0; i < sscEContractRecordColl.size(); ++i) {
            ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)sscEContractRecordColl.get(i).getEntryId().getType());
            String entryInRecord = sscEContractRecordColl.get(i).getEntryId().toString();
            CoreBaseInfo entryInRecordInfo = null;
            if (!bizInterface.exists((IObjectPK)new ObjectUuidPK(entryInRecord))) continue;
            entryInRecordInfo = bizInterface.getValue((IObjectPK)new ObjectUuidPK(entryInRecord));
            entryInRecordInfo.setInt("signState", signState.intValue());
            bizInterface.updatePartial(entryInRecordInfo, selectorEntry);
        }
        if (billInfo != null) {
            billInfo.setInt("billState", HRBillStateEnum.AUDITEND.getValue());
            if (EContractService.isPackage(billId)) {
                billInfo.put("totalState", (Object)signState);
                selectorBill.add(new SelectorItemInfo("totalState"));
            }
            iCoreBaseBill.updatePartial(billInfo, selectorBill);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        if (!StringUtils.isEmpty((String)entryId)) {
            filter.getFilterItems().add(new FilterItemInfo("entryID", (Object)entryId));
        }
        selectorEntry.clear();
        selectorEntry.add(new SelectorItemInfo("id"));
        selectorEntry.add(new SelectorItemInfo("billState"));
        view.setFilter(filter);
        view.setSelector(selectorEntry);
        IHRContractInfo ihrContractInfo = HRContractInfoFactory.getLocalInstance((Context)ctx);
        HRContractInfoCollection hrContractInfoCollection = ihrContractInfo.getHRContractInfoCollection(view);
        for (int k = 0; k < hrContractInfoCollection.size(); ++k) {
            HRContractInfoInfo infoInfo = hrContractInfoCollection.get(k);
            infoInfo.setBillState(HRBillStateEnum.AUDITEND);
            ihrContractInfo.updatePartial((CoreBaseInfo)infoInfo, selectorEntry);
        }
        String jobId = String.valueOf(taskParam.get("jobId"));
        String unpassReaId = String.valueOf(taskParam.get("unpassReaId"));
        String jobClassification = String.valueOf(taskParam.get("jobClassification"));
        String message = String.valueOf(taskParam.get("message"));
        String decision = String.valueOf(taskParam.get("decision"));
        String decisionId = String.valueOf(taskParam.get("decisionId"));
        String innerMsg = String.valueOf(taskParam.get("innerMsg"));
        boolean pullNextJob = Boolean.valueOf(String.valueOf(taskParam.get("pullNextJob")));
        HashMap<String, Object> params = new HashMap<String, Object>();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        params.put("jobId", jobId);
        params.put("userId", currentUserInfo.getId().toString());
        params.put("unpassReaId", unpassReaId);
        params.put("jobClassification", jobClassification);
        params.put("message", message);
        params.put("mesTitle", "");
        params.put("jobPriority", "");
        params.put("decision", decision);
        params.put("decisionId", decisionId);
        params.put("plainText", "");
        params.put("signature", "");
        params.put("innerMsg", innerMsg);
        params.put("pullNextJob", pullNextJob);
        SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"UNPASS", params);
        return true;
    }

    protected Object _processCompanySignBackTask(Context ctx) throws BOSException {
        return null;
    }

    private void saveModel(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        ((ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)model.getBOSType())).save(model);
    }

    protected void updateBillEntrySignState(Context ctx, HRBillBaseEntryInfo entryInfo, SelectorItemCollection selector) throws EASBizException, BOSException {
        if (selector == null || selector.size() == 0) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signState"));
        }
        ((ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entryInfo.getBOSType())).updatePartial((CoreBaseInfo)entryInfo, selector);
    }

    @Override
    protected Object _sendCompanySign(Context ctx, String jobId, String billId, Map dataMap, Map otherParamMap) throws BOSException, EASBizException {
        OtherContractChangeBizBillEntryInfo otherContractChangeBizBillEntryInfo;
        OtherContractRenewBizBillEntryInfo otherContractRenewBizBillEntryInfo;
        OtherFollowPreConEntryInfo otherFollowPreConEntryInfo;
        OtherFollowLaborConEntryInfo otherFollowLaborConEntryInfo;
        HRBillBaseInfo hrBillBaseInfo = EContractService.getHRBillBaseInfo(ctx, billId);
        HRBillBaseEntryInfo billEntryInfo = null;
        IObjectCollection entryColls = (IObjectCollection)hrBillBaseInfo.get("entrys");
        if (entryColls != null && entryColls.size() > 0) {
            billEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
        }
        String entryId = (String)dataMap.get("entryId");
        logger.error("_sendCompanySign entryId is:" + entryId);
        if (billEntryInfo != null) {
            logger.error("_billEntryInfo id is:" + billEntryInfo.getId().toString());
            if (entryId.equals(billEntryInfo.getId().toString())) {
                return this.sendCompanySignEntry(ctx, jobId, dataMap, otherParamMap, hrBillBaseInfo, billEntryInfo);
            }
        }
        if (hrBillBaseInfo instanceof ContractSignBizBillInfo && (otherFollowLaborConEntryInfo = OtherFollowLaborConEntryFactory.getLocalInstance((Context)ctx).getOtherFollowLaborConEntryInfo((IObjectPK)new ObjectUuidPK(entryId))) != null) {
            logger.error("_sendCompanySign entryId is:" + entryId + ",otherFollowLaborConEntryInfo id is:" + otherFollowLaborConEntryInfo.getId().toString());
            return this.sendCompanySignEntry(ctx, jobId, dataMap, otherParamMap, hrBillBaseInfo, (HRBillBaseEntryInfo)otherFollowLaborConEntryInfo);
        }
        if (hrBillBaseInfo instanceof ContractPreSignBizBillInfo && (otherFollowPreConEntryInfo = OtherFollowPreConEntryFactory.getLocalInstance((Context)ctx).getOtherFollowPreConEntryInfo((IObjectPK)new ObjectUuidPK(entryId))) != null) {
            logger.error("_sendCompanySign entryId is:" + entryId + ",otherFollowPreConEntryInfo id is:" + otherFollowPreConEntryInfo.getId().toString());
            return this.sendCompanySignEntry(ctx, jobId, dataMap, otherParamMap, hrBillBaseInfo, (HRBillBaseEntryInfo)otherFollowPreConEntryInfo);
        }
        if (hrBillBaseInfo instanceof ContractRenewBizBillInfo && (otherContractRenewBizBillEntryInfo = OtherContractRenewBizBillEntryFactory.getLocalInstance((Context)ctx).getOtherContractRenewBizBillEntryInfo((IObjectPK)new ObjectUuidPK(entryId))) != null) {
            logger.error("_sendCompanySign entryId is:" + entryId + ",otherContractRenewBizBillEntryInfo id is:" + otherContractRenewBizBillEntryInfo.getId().toString());
            return this.sendCompanySignEntry(ctx, jobId, dataMap, otherParamMap, hrBillBaseInfo, (HRBillBaseEntryInfo)otherContractRenewBizBillEntryInfo);
        }
        if (hrBillBaseInfo instanceof ContractChangeBizBillInfo && (otherContractChangeBizBillEntryInfo = OtherContractChangeBizBillEntryFactory.getLocalInstance((Context)ctx).getOtherContractChangeBizBillEntryInfo((IObjectPK)new ObjectUuidPK(entryId))) != null) {
            logger.error("_sendCompanySign entryId is:" + entryId + ",otherFollowPreConEntryInfo id is:" + otherContractChangeBizBillEntryInfo.getId().toString());
            return this.sendCompanySignEntry(ctx, jobId, dataMap, otherParamMap, hrBillBaseInfo, (HRBillBaseEntryInfo)otherContractChangeBizBillEntryInfo);
        }
        return null;
    }

    private SSCEContractTaskInfo sendCompanySignEntry(Context ctx, String jobId, Map dataMap, Map otherParamMap, HRBillBaseInfo hrBillBaseInfo, HRBillBaseEntryInfo billEntryInfo) throws BOSException, EASBizException {
        SSCEContractTaskInfo taskInfo;
        SSCEContractRecordInfo recordInfo;
        String billId = hrBillBaseInfo.getId().toString();
        String entryId = billEntryInfo.getId().toString();
        String bussAttrID = (String)dataMap.get("bussAttrID");
        if (StringUtils.isEmpty((String)bussAttrID)) {
            bussAttrID = (String)dataMap.get("bussAttrID.id");
        }
        String taskType = "COMPANY";
        if (!StringUtils.isEmpty((String)bussAttrID) && EContractConstants.COMPANY_PARTY_B_TASK_BUSSATTRID_MAP.containsKey(bussAttrID)) {
            taskType = "COMPANY_B";
        }
        if ((recordInfo = EContractService.getSSCEContractRecord(ctx, billId, entryId)) == null) {
            HashMap<String, Boolean> param = new HashMap<String, Boolean>();
            EContractSignState currentSignState = null;
            Object signStateObj = billEntryInfo.get("signState");
            if (signStateObj instanceof EContractSignState) {
                currentSignState = (EContractSignState)signStateObj;
            } else if (signStateObj instanceof Integer) {
                currentSignState = EContractSignState.getEnum((int)((Integer)signStateObj));
            } else {
                Integer intObj = Integer.parseInt(String.valueOf(signStateObj));
                currentSignState = EContractSignState.getEnum((int)intObj);
            }
            if (EContractSignState.signing.equals((Object)currentSignState)) {
                param.put("isPersonSigned", true);
            }
            if (EContractSignState.partyASigned.equals((Object)currentSignState)) {
                param.put("isCompanyBSigned", true);
            }
            recordInfo = (SSCEContractRecordInfo)EContractServiceFacadeFactory.getLocalInstance(ctx).repairEContractRecordData(hrBillBaseInfo, billEntryInfo, param);
        }
        if (recordInfo.getEntryId() != null) {
            logger.error("sendCompanySignEntry recordInfo entryId is:" + recordInfo.getEntryId().toString());
        }
        if ((taskInfo = EContractService.getEContractTaskInfo(ctx, jobId, billId, taskType)) == null) {
            taskInfo = EContractService.saveSSCEContractTaskInfo(ctx, jobId, billId, dataMap, otherParamMap, false, taskType);
        }
        if (taskInfo.isIsProcess() && taskInfo.getProcessTime() != null) {
            String label3 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label3", (Context)ctx);
            throw new BOSException(label3);
        }
        this.sendCompanySignatureRequest(ctx, hrBillBaseInfo, billEntryInfo, recordInfo, taskInfo);
        return taskInfo;
    }

    @Override
    protected Object _sendCompanySign(Context ctx, IObjectValue bill, IObjectValue entry, IObjectValue record, IObjectValue task) throws BOSException, EASBizException {
        HRBillBaseInfo hrBillBaseInfo = (HRBillBaseInfo)bill;
        HRBillBaseEntryInfo billEntryInfo = (HRBillBaseEntryInfo)entry;
        SSCEContractRecordInfo recordInfo = (SSCEContractRecordInfo)record;
        SSCEContractTaskInfo taskInfo = (SSCEContractTaskInfo)task;
        if (taskInfo.isIsProcess() && taskInfo.getProcessTime() != null) {
            String label3 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label3", (Context)ctx);
            throw new BOSException(label3);
        }
        this.sendCompanySignatureRequest(ctx, hrBillBaseInfo, billEntryInfo, recordInfo, taskInfo);
        return taskInfo;
    }

    protected SelectorItemCollection getElectronicTemplateSelector() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("isRegister"));
        coll.add(new SelectorItemInfo("templateId"));
        coll.add(new SelectorItemInfo("isSameTime"));
        coll.add(new SelectorItemInfo("contractTemplet"));
        coll.add(new SelectorItemInfo("csTemplateId"));
        coll.add(new SelectorItemInfo("contractTemplet.id"));
        coll.add(new SelectorItemInfo("contractTemplet.signType"));
        coll.add(new SelectorItemInfo("eContractSealType"));
        return coll;
    }

    protected String getAutoSignSuccessResultDesc(Context ctx) {
        return "\u81ea\u52a8\u7b7e\u6210\u529f";
    }

    protected String getHandSignSuccessResultDesc(Context ctx) {
        return "\u624b\u7b7e\u6210\u529f";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _processPackageSignCallBack(Context ctx, Map param, String entryId) throws BOSException, EASBizException {
        boolean isPersonSignCallBack;
        String contractNO;
        HRBillBaseEntryInfo billEntryInfo;
        block12: {
            BOSObjectType billBosType = BOSUuid.read((String)entryId).getType();
            billEntryInfo = null;
            billEntryInfo = ((IHRBillBaseEntry)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBosType)).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
            contractNO = (String)param.get("contractNO");
            isPersonSignCallBack = this.isPersonSignCallBack(ctx, param);
            if (billEntryInfo != null) break block12;
            Object var8_10 = null;
            return var8_10;
        }
        try {
            EContractSignState currentSignState = this.getCurrentSignState(billEntryInfo);
            HRBillBaseInfo billBaseInfo = (HRBillBaseInfo)billEntryInfo.get("bill");
            String billId = billBaseInfo.getId().toString();
            logger.error("_processPackageSignCallBack : billId = " + billId);
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByEContractNo(ctx, contractNO, billId);
            if (recordInfo == null) {
                HashMap<String, Boolean> repairParam = new HashMap<String, Boolean>();
                if (EContractSignState.signing.equals((Object)currentSignState)) {
                    repairParam.put("isPersonSigned", true);
                }
                recordInfo = (SSCEContractRecordInfo)EContractServiceFacadeFactory.getLocalInstance(ctx).repairEContractRecordData(billId, entryId, repairParam);
            }
            if (isPersonSignCallBack) {
                if (EContractSignState.nosign.equals((Object)currentSignState)) {
                    this.personSignCallbackUpdate(ctx, recordInfo, param, billBaseInfo, billEntryInfo);
                }
            } else if (EContractSignState.signing.equals((Object)currentSignState) && !recordInfo.isIsCompanySign()) {
                this.entSignCallbackUpdate(ctx, recordInfo, param, billBaseInfo, billEntryInfo);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void personSignCallbackUpdate(Context ctx, SSCEContractRecordInfo recordInfo, Map param, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo) throws BOSException, EASBizException {
        logger.error("SignContractPersonInfoService process person sign call back start");
        int resultCode = Integer.parseInt(String.valueOf(param.get("resultCode")));
        String contractNO = (String)param.get("contractNO");
        if (!this.hasPersonSignCallBackSuccessRecord(ctx, param)) {
            logger.error("SignContractPersonInfoService process person sign call back");
            if (1 == resultCode) {
                recordInfo.setIsPersonSign(true);
                recordInfo.setPersonSignTime(new Timestamp(System.currentTimeMillis()));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("isPersonSign"));
                selector.add(new SelectorItemInfo("personSignTime"));
                SignTypeEnum signType = recordInfo.getSignType();
                if (signType == null) {
                    signType = SignTypeEnum.DOUBLESIGN;
                }
                if (SignTypeEnum.SINGLESIGN.equals((Object)signType)) {
                    recordInfo.setSignedTime(new Timestamp(System.currentTimeMillis()));
                    recordInfo.setIsSigned(true);
                    selector.add(new SelectorItemInfo("signedTime"));
                    selector.add(new SelectorItemInfo("isSigned"));
                }
                SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selector);
                EContractSignState newSignState = EContractSignState.signing;
                billEntryInfo.put("signState", (Object)newSignState);
                this.updateBillEntrySignState(ctx, billEntryInfo, null);
                this.reduceLicenseIfSingleSign(ctx, billBaseInfo, billEntryInfo, param, contractNO);
                this.updateSignState(ctx, billBaseInfo, billEntryInfo, newSignState);
                this.afterPersonSignCallBackSuccess(ctx, billBaseInfo, billEntryInfo, param, contractNO);
            } else if (0 == resultCode) {
                this.afterPersonSignCallBackFail(ctx, billBaseInfo, billEntryInfo, param, contractNO);
            }
        }
    }

    protected void entSignCallbackUpdate(Context ctx, SSCEContractRecordInfo recordInfo, Map param, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo) throws BOSException, EASBizException {
        logger.error("SignContractPersonInfoService process company sign call back start");
        int resultCode = Integer.parseInt(String.valueOf(param.get("resultCode")));
        String contractNO = (String)param.get("contractNO");
        String userId = String.valueOf(param.get("userId"));
        Timestamp curTimestamp = EContractService.getCurTimestamp();
        EContractSignState newSignState = null;
        if (!this.hasCompanySignCallBackSuccessRecord(ctx, param)) {
            logger.error("SignContractPersonInfoService process company sign call back");
            String billId = billBaseInfo.getId().toString();
            String entryId = billEntryInfo.getId().toString();
            EContractCompanyTaskInfo eContractCompanyTaskInfo = EContractService.getEContractCompanyTaskInfoByContractNOAndUserId(ctx, userId, contractNO);
            String taskType = "";
            if (1 == resultCode) {
                SelectorItemCollection selector = new SelectorItemCollection();
                if (eContractCompanyTaskInfo != null) {
                    eContractCompanyTaskInfo.setIsCallback(true);
                    eContractCompanyTaskInfo.setCallbackTime(curTimestamp);
                    eContractCompanyTaskInfo.setResultCode(String.valueOf(param.get("resultCode")));
                    eContractCompanyTaskInfo.setResultDesc(String.valueOf(param.get("resultDesc")));
                    eContractCompanyTaskInfo.setIsFinish(true);
                    selector.clear();
                    selector.add(new SelectorItemInfo("isCallback"));
                    selector.add(new SelectorItemInfo("callbackTime"));
                    selector.add(new SelectorItemInfo("resultCode"));
                    selector.add(new SelectorItemInfo("resultDesc"));
                    selector.add(new SelectorItemInfo("isFinish"));
                    EContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(eContractCompanyTaskInfo, selector);
                    taskType = eContractCompanyTaskInfo.getTaskType();
                    SSCEContractTaskInfo taskInfo = EContractService.getEContractTaskInfo(ctx, billId, null, taskType);
                    if ("COMPANY_B".equalsIgnoreCase(taskType)) {
                        recordInfo.setCompanyBSignTime(curTimestamp);
                        recordInfo.setIsCompanyBSign(true);
                        selector.clear();
                        selector.add(new SelectorItemInfo("CompanyBSignTime"));
                        selector.add(new SelectorItemInfo("isCompanyBSign"));
                        newSignState = EContractSignState.partyASigned;
                    } else if ("COMPANY".equalsIgnoreCase(taskType)) {
                        recordInfo.setIsCompanySign(true);
                        recordInfo.setCompanySignTime(curTimestamp);
                        recordInfo.setIsSigned(true);
                        recordInfo.setSignedTime(curTimestamp);
                        selector.clear();
                        selector.add(new SelectorItemInfo("isCompanySign"));
                        selector.add(new SelectorItemInfo("companySignTime"));
                        selector.add(new SelectorItemInfo("isSigned"));
                        selector.add(new SelectorItemInfo("signedTime"));
                        newSignState = EContractSignState.complete;
                    }
                    if (!recordInfo.isIsPersonSign()) {
                        recordInfo.setIsPersonSign(true);
                        recordInfo.setPersonSignTime(curTimestamp);
                        selector.add(new SelectorItemInfo("isPersonSign"));
                        selector.add(new SelectorItemInfo("personSignTime"));
                    }
                    SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selector);
                    if (taskInfo != null) {
                        selector.clear();
                        taskInfo.setCallbackTime(curTimestamp);
                        selector.add(new SelectorItemInfo("callbackTime"));
                        SSCEContractTaskFactory.getLocalInstance(ctx).updatePartial(taskInfo, selector);
                    }
                    EContractService.updateKDContractConfigRecordState(ctx, billBaseInfo, billEntryInfo, contractNO, userId);
                    logger.error("SignContractPersonInfoService newSignState \uff1a " + newSignState);
                    billEntryInfo.put("signState", (Object)newSignState);
                    this.updateBillEntrySignState(ctx, billEntryInfo, null);
                    this.updateSignState(ctx, billBaseInfo, billEntryInfo, newSignState);
                    this.afterCompanySignCallBackSuccess(ctx, billBaseInfo, billEntryInfo, param, contractNO);
                }
            } else if (0 == resultCode) {
                eContractCompanyTaskInfo.setIsCallback(true);
                eContractCompanyTaskInfo.setCallbackTime(curTimestamp);
                eContractCompanyTaskInfo.setResultCode(String.valueOf(param.get("resultCode")));
                eContractCompanyTaskInfo.setResultDesc(String.valueOf(param.get("resultDesc")));
                eContractCompanyTaskInfo.setIsFinish(false);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("isCallback"));
                selector.add(new SelectorItemInfo("callbackTime"));
                selector.add(new SelectorItemInfo("resultCode"));
                selector.add(new SelectorItemInfo("resultDesc"));
                selector.add(new SelectorItemInfo("isFinish"));
                EContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(eContractCompanyTaskInfo, selector);
                this.afterCompanySignCallBackFail(ctx, billBaseInfo, billEntryInfo, param, contractNO);
            }
        }
    }

    protected void updateSignState(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, EContractSignState eContractSignState) throws BOSException, EASBizException {
        if (!EContractService.isPackage(billBaseInfo.getId().toString())) {
            return;
        }
        ISSCEContractRecord iSSCEContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        SSCEContractRecordCollection sSCEContractRecordColl = iSSCEContractRecord.getSSCEContractRecordCollection("where billId = '" + billBaseInfo.getId() + "'");
        boolean isComplete = true;
        boolean isSigningOrComplete = true;
        int sSCEContractRecordCollSize = sSCEContractRecordColl.size();
        for (int i = 0; i < sSCEContractRecordCollSize; ++i) {
            boolean isCompleteInOne = false;
            boolean isSigningOrCompleteInOne = false;
            SSCEContractRecordInfo sSCEContractRecordInfo = sSCEContractRecordColl.get(i);
            if (sSCEContractRecordInfo.isIsSigned()) {
                isCompleteInOne = true;
            }
            if (sSCEContractRecordInfo.isIsPersonSign()) {
                isSigningOrCompleteInOne = true;
            }
            isComplete = isComplete && isCompleteInOne;
            isSigningOrComplete = isSigningOrComplete && isSigningOrCompleteInOne;
        }
        SelectorItemCollection totalSelector = new SelectorItemCollection();
        totalSelector.add(new SelectorItemInfo("totalState"));
        String billBosType = billBaseInfo.getId().getType().toString();
        logger.info("billBosType---->:" + billBosType);
        ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billBaseInfo.getId().getType());
        if (isComplete) {
            billBaseInfo.put("totalState", (Object)EContractSignState.complete);
            bizInterface.updatePartial((CoreBaseInfo)billBaseInfo, totalSelector);
        } else if (!isComplete && isSigningOrComplete) {
            billBaseInfo.put("totalState", (Object)EContractSignState.signing);
            bizInterface.updatePartial((CoreBaseInfo)billBaseInfo, totalSelector);
        }
        this.updateSSCRule(ctx, billBaseInfo, billEntryInfo);
    }

    private void updateSSCRule(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("certificationStatus", (Object)String.valueOf(((EContractSignState)billBaseInfo.get("totalState")).getValue()));
        JSONObject dyValues = new JSONObject();
        dyValues.put(billBaseInfo.getId().toString(), (Object)paramJson);
        HashMap<String, Object> taskParam = new HashMap<String, Object>();
        taskParam.put("mapValue", dyValues);
        taskParam.put("isUpdateHis", true);
        try {
            SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"UPDATEDYNAMICVALUE", taskParam);
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.econtractservice.app.SSCEContractTaskFacadeControllerBean.updateSSCRule:" + e.getMessage(), (Throwable)e);
        }
    }

    private EContractSignState getCurrentSignState(HRBillBaseEntryInfo billEntryInfo) {
        Object signStateObj = billEntryInfo.get("signState");
        EContractSignState currentSignState = null;
        if (signStateObj instanceof EContractSignState) {
            currentSignState = (EContractSignState)signStateObj;
        } else if (signStateObj instanceof Integer) {
            currentSignState = EContractSignState.getEnum((int)((Integer)signStateObj));
        } else {
            Integer intObj = Integer.parseInt(String.valueOf(signStateObj));
            currentSignState = EContractSignState.getEnum((int)intObj);
        }
        return currentSignState;
    }

    protected void reduceLicenseIfSingleSign(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, Map param, String contractNo) throws BOSException, EASBizException {
        ContractTempletInfo contractTempletInfo = ContractBizBillService.getContractTempletInfo(billBaseInfo, billEntryInfo);
        if (contractTempletInfo != null) {
            if (contractTempletInfo.get("signType") == null) {
                contractTempletInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTempletInfo.getId()));
            }
            if (SignTypeEnum.SINGLESIGN.equals((Object)contractTempletInfo.getSignType())) {
                logger.error("SSCEContractTaskFacadeControllerBean reduceLicenseIfSingleSign " + contractNo);
                try {
                    Map serverMap = null;
                    serverMap = TSPServerInstance.getServerInfo((Context)ctx);
                    String serviceId = (String)serverMap.get("service_id");
                    CheckHRCloudLicenseUtils.reduceLicenseCount((Context)ctx, (String)serviceId, (String)"8", (String)ENTERPRISE_SIGN, (String)contractNo);
                }
                catch (EASBizException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

