/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service.classloader;

import com.kingdee.bos.bsf.service.classloader.LibPackeInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class PackageGenerator {
    private static final Logger logger = Logger.getLogger(PackageGenerator.class);
    protected static final String SPLIT_D = "[;" + File.pathSeparator + "]";

    public static LibPackeInfo libToPackage(String path, Properties packageToJarMap) {
        int homepathLen = System.getProperty("EAS_HOME").length();
        LibPackeInfo libPackeInfo = new LibPackeInfo();
        String[] paths = path.split(SPLIT_D);
        File file = null;
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].trim().length() == 0 || !(file = new File(FilenameUtils.normalize((String)paths[i]))).exists()) continue;
            Vector<String> packages = PackageGenerator.scanPackage(file);
            if (!file.isDirectory() && (file.getName().endsWith(".zip") || file.getName().endsWith("jar"))) {
                String jarPath = PackageGenerator.getJarPath(homepathLen, file);
                PackageGenerator.addPackes(packages, packageToJarMap, jarPath);
                libPackeInfo.getPackageCache().put(jarPath, file);
                try {
                    libPackeInfo.getJarFileCache().put(jarPath, new JarFile(file));
                }
                catch (IOException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (file.isDirectory()) {
                String filePath = paths[i];
                libPackeInfo.getPackageCache().put(filePath, file);
                PackageGenerator.addPackes(packages, packageToJarMap, filePath);
                continue;
            }
            logger.debug((Object)("packageError  file=" + file.getAbsolutePath()));
        }
        libPackeInfo.setPackageToJarMap(packageToJarMap);
        return libPackeInfo;
    }

    private static String getJarPath(int homepathlength, File file) {
        String filename = null;
        String jarPath = "";
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        if (filename != null && (jarPath = (filename = filename.replace('\\', '/'))).length() > homepathlength) {
            jarPath = filename.substring(homepathlength);
        }
        return jarPath;
    }

    public static Vector<String> scanPackage(File file) {
        Vector<String> vector = new Vector<String>();
        String filename = file.getName();
        if (file.isDirectory()) {
            vector = PackageGenerator.scanDir(file.getAbsolutePath(), file, vector);
        } else if (filename.substring(filename.lastIndexOf(".") + 1).equalsIgnoreCase("jar") || filename.substring(filename.lastIndexOf(".") + 1).equalsIgnoreCase("zip") || filename.substring(filename.lastIndexOf(".") + 1).equalsIgnoreCase("rar")) {
            vector = PackageGenerator.ScanJar(file);
        }
        return vector;
    }

    private static Vector<String> scanDir(String originPath, File file, Vector<String> vector) {
        File[] children = file.listFiles();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (!child.isDirectory()) {
                    String sperator;
                    String packageName = child.getAbsolutePath();
                    if (packageName.lastIndexOf(sperator = PackageGenerator.getFileSeperator(packageName)) < 0) continue;
                    packageName = packageName.substring(0, packageName.lastIndexOf(sperator));
                    if (vector.contains(packageName = packageName.substring(originPath.length() + 1).replace('\\', '/'))) continue;
                    vector.add(packageName);
                    continue;
                }
                PackageGenerator.scanDir(originPath, child, vector);
            }
        }
        return vector;
    }

    private static String getFileSeperator(String fileName) {
        if (fileName.lastIndexOf("/") > 0) {
            return "/";
        }
        if (fileName.lastIndexOf("\\") > 0) {
            return "\\";
        }
        return "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<String> ScanJar(File file) {
        Vector<String> vector = new Vector<String>();
        ZipFile lib = null;
        try {
            lib = new ZipFile(file);
            Enumeration<? extends ZipEntry> en = lib.entries();
            while (en.hasMoreElements()) {
                String sperator;
                ZipEntry entry = en.nextElement();
                if (entry.isDirectory()) continue;
                String packageName = entry.getName();
                if (packageName.lastIndexOf(sperator = PackageGenerator.getFileSeperator(packageName)) >= 0) {
                    packageName = packageName.substring(0, packageName.lastIndexOf(sperator));
                }
                if (vector.contains(packageName)) continue;
                vector.add(packageName);
            }
        }
        catch (Exception e) {
            file.delete();
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (lib != null) {
                try {
                    lib.close();
                }
                catch (IOException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return vector;
    }

    private static void addPackes(Vector<String> packages, Properties packageToJarMap, String jarPath) {
        String packageStr = null;
        for (int i = 0; i < packages.size(); ++i) {
            packageStr = packages.get(i);
            PackageGenerator.addPackageToList(packageStr, jarPath, packageToJarMap);
        }
    }

    public static void addPackageToList(String packageName, String jarPath, Properties resList) {
        String jarList = resList.getProperty(packageName, "");
        if (jarList.length() > 0) {
            String[] packageList = jarList.split(";");
            List<String> pkList = Arrays.asList(packageList);
            if (!pkList.contains(jarPath)) {
                resList.setProperty(packageName, jarList + ";" + jarPath);
            }
        } else {
            resList.setProperty(packageName, jarPath);
        }
    }
}

