/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.api.file;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.api.file.IMultiEngineExcutor;
import com.kingdee.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiEngineExcutorFactory
implements IMultiEngineExcutor {
    private static Logger logger = Logger.getLogger(MultiEngineExcutorFactory.class);
    private List<Object> servers = new ArrayList<Object>();
    private List<String> urls = new ArrayList<String>();

    private MultiEngineExcutorFactory() {
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    public static IMultiEngineExcutor getInstance(String className) {
        MultiEngineExcutorFactory syn = new MultiEngineExcutorFactory();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"------RPCServerView is null :");
            }
            try {
                String ipAddress = InetAddress.getLocalHost().getHostAddress();
                syn.urls.add(ipAddress);
            }
            catch (UnknownHostException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            Object obj = MultiEngineExcutorFactory.getObject(className);
            if (obj instanceof IMultiEngineExcutor) {
                IMultiEngineExcutor pcs = (IMultiEngineExcutor)obj;
                syn.servers.add(pcs);
            }
            return syn;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            IRPCServer s = ss[i];
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("find server :" + s.getUrl()));
            }
            if (s.connectionFailed()) continue;
            String url = s.getUrl();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("detected server :" + url));
            }
            if (StringUtils.isEmpty((String)url)) continue;
            syn.urls.add(url);
            if (MultiEngineExcutorFactory.isLocal(url)) {
                Object obj = MultiEngineExcutorFactory.getObject(className);
                if (obj instanceof IMultiEngineExcutor) {
                    IMultiEngineExcutor pcs = (IMultiEngineExcutor)obj;
                    syn.servers.add(pcs);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("-----MultiEngineFileOperate regited server :" + url));
                continue;
            }
            IMultiEngineExcutor pcs = (IMultiEngineExcutor)RPCEngineFactory.getEngine((String)url).createObject(className, IMultiEngineExcutor.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("-----" + className + " regited server :" + url));
            }
            syn.servers.add(pcs);
        }
        return syn;
    }

    @Override
    public void excute(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            if (null != this.urls && !this.urls.isEmpty()) {
                param.put("url", this.urls.get(i));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("-----" + this.servers.get(i) + " excute server :" + null != this.urls.get(i) ? this.urls.get(i) : null);
            }
            ((IMultiEngineExcutor)this.servers.get(i)).excute(ctx, param);
        }
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }

    private static Object getObject(String className) {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className);
            instance = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return instance;
    }
}

