/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.cloud.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.SHRXTForewarnMessageCollection;
import com.kingdee.shr.base.syssetting.SHRXTForewarnMessageFactory;
import com.kingdee.shr.base.syssetting.SHRXTForewarnMessageInfo;
import com.kingdee.shr.base.syssetting.SHRXTForewarnMessageItemCollection;
import com.kingdee.shr.base.syssetting.SHRXTForewarnMessageItemFactory;
import com.kingdee.shr.base.syssetting.SHRXTForewarnMessageItemInfo;
import com.kingdee.shr.base.syssetting.cloud.tool.EncodeUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.lightapp.xt.XTServiceConfig;
import com.kingdee.util.ConfigurationItem;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForewarnMessageConfigUtil {
    public static final String XT_FW_MESSAGE = "XTForewarnMessage";
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Logger l = LoggerFactory.getLogger(ForewarnMessageConfigUtil.class);

    public static Map<String, Object> getXTFwMessage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ConfigurationItem ct = XTServiceConfig.getInstance().getConfiguration().getConfigItem(XT_FW_MESSAGE);
        List cl = ct.getAllChildren();
        for (int i = 0; i < cl.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)cl.get(i);
            Map itemMap = item.getProperties();
            map.put(item.getName(), itemMap);
        }
        return map;
    }

    public JSONObject convertInfoToMap(Context ctx, String xtId, Map<String, Object> humanBriefInfo, String category) throws Exception {
        Map<String, Object> configMessageInfoMap = ForewarnMessageConfigUtil.getXTFwMessage();
        JSONObject MessageInfo = new JSONObject();
        String oql = "where messagetype.number = '" + category + "'";
        SHRXTForewarnMessageCollection shrxtForewarnMessageCollection = SHRXTForewarnMessageFactory.getLocalInstance(ctx).getSHRXTForewarnMessageCollection(oql);
        if (shrxtForewarnMessageCollection != null && shrxtForewarnMessageCollection.size() > 0) {
            SHRXTForewarnMessageInfo shrxtForewarnMessageInfo = shrxtForewarnMessageCollection.get(0);
            JSONObject fromObj = this.initFromJSONObject(configMessageInfoMap);
            MessageInfo.put((Object)"from", (Object)fromObj);
            JSONArray toArr = this.initToJSONArray(configMessageInfoMap, xtId);
            MessageInfo.put((Object)"to", (Object)toArr);
            MessageInfo.put((Object)"type", (Object)Integer.parseInt(shrxtForewarnMessageInfo.getType().getValue()));
            JSONObject msgMap = this.initMsgJSONObject(ctx, shrxtForewarnMessageInfo, humanBriefInfo);
            MessageInfo.put((Object)"msg", (Object)msgMap);
        }
        return MessageInfo;
    }

    private JSONObject initFromJSONObject(Map<String, Object> configMessageInfoMap) throws BOSException {
        Map<String, String> fromMap = this.getFromInfoByConfigMessage(configMessageInfoMap);
        JSONObject fromObj = new JSONObject();
        if (fromMap != null && fromMap.size() > 0) {
            fromObj.put((Object)"no", (Object)fromMap.get("no"));
            fromObj.put((Object)"pub", (Object)fromMap.get("pub"));
            fromObj.put((Object)"time", (Object)fromMap.get("time"));
            fromObj.put((Object)"nonce", (Object)fromMap.get("nonce"));
            fromObj.put((Object)"publicToken", (Object)fromMap.get("publicToken"));
        }
        return fromObj;
    }

    private Map<String, String> getFromInfoByConfigMessage(Map<String, Object> configMessageInfoMap) throws BOSException {
        Map map = (Map)configMessageInfoMap.get("HumanBriefFrom");
        if (map != null && map.size() > 0) {
            String publicToken = EncodeUtil.getToken(map);
            map.put("time", Long.valueOf(System.currentTimeMillis()) + "");
            SecureRandom random = null;
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new BOSException();
            }
            String nonce = "";
            if (null != random) {
                nonce = String.valueOf((int)(random.nextDouble() * 1000000.0));
            }
            map.put("nonce", nonce);
            map.put("publicToken", publicToken);
        }
        return map;
    }

    private JSONArray initToJSONArray(Map<String, Object> configMessageInfoMap, String xtId) {
        Map<String, String> toMap = this.getToInfoByConfigMessage(configMessageInfoMap);
        this.l.error("User Push: " + xtId);
        JSONArray toArr = new JSONArray();
        JSONObject itemObj = new JSONObject();
        JSONArray userArr = new JSONArray();
        userArr.add((Object)xtId);
        itemObj.put((Object)"no", (Object)toMap.get("no"));
        itemObj.put((Object)"user", (Object)userArr);
        toArr.add((Object)itemObj);
        return toArr;
    }

    private Map<String, String> getToInfoByConfigMessage(Map<String, Object> configMessageInfoMap) {
        Map map = (Map)configMessageInfoMap.get("HumanBriefTo");
        return map;
    }

    private JSONObject initMsgJSONObject(Context ctx, SHRXTForewarnMessageInfo shrxtForewarnMessageInfo, Map<String, Object> humanBriefInfo) throws BOSException, Exception {
        String text = this.assembleMessage(ctx, humanBriefInfo);
        JSONObject msgObj = new JSONObject();
        msgObj.put((Object)"todo", (Object)Integer.parseInt(shrxtForewarnMessageInfo.getTodo().getValue()));
        msgObj.put((Object)"model", (Object)Integer.parseInt(shrxtForewarnMessageInfo.getModel().getValue()));
        JSONArray arr = new JSONArray();
        String oql = "where forewarnmessage.id = '" + shrxtForewarnMessageInfo.getId().toString() + "'";
        SHRXTForewarnMessageItemCollection shrxtForewarnMessageCollection = SHRXTForewarnMessageItemFactory.getLocalInstance(ctx).getSHRXTForewarnMessageItemCollection(oql);
        for (int i = 0; i < shrxtForewarnMessageCollection.size(); ++i) {
            JSONObject itemObj = new JSONObject();
            SHRXTForewarnMessageItemInfo shrxtForewarnMessageItemInfo = shrxtForewarnMessageCollection.get(i);
            itemObj.put((Object)"title", (Object)shrxtForewarnMessageItemInfo.getTitle());
            itemObj.put((Object)"text", (Object)text);
            itemObj.put((Object)"date", (Object)this.df.format(new Date()));
            itemObj.put((Object)"appid", (Object)shrxtForewarnMessageItemInfo.getAppid());
            itemObj.put((Object)"url", (Object)shrxtForewarnMessageItemInfo.getUrl());
            itemObj.put((Object)"pic", (Object)shrxtForewarnMessageItemInfo.getTitlePic());
            itemObj.put((Object)"name", (Object)shrxtForewarnMessageItemInfo.getName());
            itemObj.put((Object)"zip", (Object)shrxtForewarnMessageItemInfo.getZip());
            arr.add((Object)itemObj);
        }
        msgObj.put((Object)"list", (Object)arr);
        return msgObj;
    }

    private String assembleMessage(Context ctx, Map<String, Object> humanBriefInfo) {
        return SHRSysSettingResourceUtil.getResource("org_current_info", ctx, humanBriefInfo.get("orgName").toString(), humanBriefInfo.get("actualStaffing").toString(), humanBriefInfo.get("enrollHeadcount").toString(), humanBriefInfo.get("resignHeadcount").toString());
    }

    public Map<String, Object> getPrimaryAdminOrg(Context ctx, String userId) {
        String l = LocaleUtils.getShortCode(ctx);
        String sql = "select t0.fid, t0.fname_" + l + " from T_ORG_Admin t0 inner join T_HR_PersonPosition pp on t0.fid = pp.fpersonDep inner join T_PM_User pmuser on pmuser.fpersonid = pp.fpersonid where pmuser.fid='" + userId + "'";
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowset.next()) {
                map.put("orgId", rowset.getString("fid"));
                map.put("orgName", rowset.getString("fname_" + l));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getOpenIdByUserId(Context ctx, String userId) throws BOSException, Exception {
        String sql;
        IRowSet rowSet;
        if (!StringUtils.isEmpty((CharSequence)userId) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fxtid from t_pm_easxtusermap where fuserid = (select fid from t_pm_user where fid = '" + userId + "')").toString())).next()) {
            return rowSet.getString("fxtid");
        }
        return "";
    }
}

