/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.expr;

import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.CodeExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Position;

public class CharExpr
extends CodeExpr {
    public char val;

    public CharExpr(String text) {
        this(null, text);
    }

    public CharExpr(char ch) {
        this((Position)null, ch);
    }

    public CharExpr(Position pos, String text) {
        super(pos, 5);
        this.val = text.charAt(0);
    }

    public CharExpr(Position pos, char ch) {
        super(pos, 5);
        this.val = ch;
    }

    @Override
    public Class<?> getExprClass() {
        return Character.TYPE;
    }

    @Override
    public void setExprClass(Class<?> val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void output(StringBuffer buff) {
        buff.append('\'');
        switch (this.val) {
            case '\\': {
                buff.append("\\\\");
                break;
            }
            case '\"': {
                buff.append("\\\"");
                break;
            }
            case '\t': {
                buff.append("\\t");
                break;
            }
            case '\r': {
                buff.append("\\r");
                break;
            }
            case '\n': {
                buff.append("\\n");
                break;
            }
            default: {
                buff.append(this.val);
            }
        }
        buff.append('\'');
    }
}

