/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.expr;

import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.CodeExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Position;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObjectCreateExpr
extends CodeExpr {
    public String objType;
    public final List<CodeExpr> paramList = new ArrayList<CodeExpr>();
    public final List<CodeExpr> initExprList = new ArrayList<CodeExpr>();
    private Class<?> _class;

    public ObjectCreateExpr() {
        super(null, 23);
    }

    public ObjectCreateExpr(Position pos) {
        super(pos, 23);
    }

    public ObjectCreateExpr(String objType) {
        this(null, objType);
    }

    public ObjectCreateExpr(Position pos, String objType) {
        super(pos, 23);
        this.objType = objType;
    }

    @Override
    public void output(StringBuffer buff) {
        buff.append("new ");
        if (this.objType.startsWith("[")) {
            String componentType;
            boolean isRefType;
            char ch;
            int dim = 0;
            for (int i = 0; i < this.objType.length() && (ch = this.objType.charAt(i)) == '['; ++i) {
                ++dim;
            }
            boolean bl = isRefType = this.objType.charAt(dim) == 'L';
            if (isRefType) {
                componentType = this.objType.substring(dim + 1, this.objType.length() - 1);
            } else {
                switch (this.objType.charAt(dim)) {
                    case 'C': {
                        componentType = "char";
                        break;
                    }
                    case 'B': {
                        componentType = "byte";
                        break;
                    }
                    case 'S': {
                        componentType = "short";
                        break;
                    }
                    case 'I': {
                        componentType = "int";
                        break;
                    }
                    case 'J': {
                        componentType = "long";
                        break;
                    }
                    case 'F': {
                        componentType = "float";
                        break;
                    }
                    case 'D': {
                        componentType = "double";
                        break;
                    }
                    default: {
                        componentType = "ErrorType.";
                    }
                }
            }
            buff.append(componentType);
            for (int i = 0; i < dim; ++i) {
                CodeExpr pramExpr;
                buff.append('[');
                if (i < this.paramList.size() && (pramExpr = this.paramList.get(i)) != null) {
                    pramExpr.output(buff);
                }
                buff.append(']');
            }
        } else {
            buff.append(this.objType);
            buff.append('(');
            for (int i = 0; i < this.paramList.size(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                CodeExpr paramExpr = this.paramList.get(i);
                paramExpr.output(buff);
            }
            buff.append(')');
        }
        if (this.initExprList.size() != 0) {
            buff.append(" {");
            Iterator<CodeExpr> iter = this.initExprList.iterator();
            boolean flag = false;
            while (iter.hasNext()) {
                if (flag) {
                    buff.append(", ");
                }
                CodeExpr initExpr = iter.next();
                initExpr.output(buff);
                flag = true;
            }
            buff.append("}");
        }
    }

    @Override
    public final Class<?> getExprClass() {
        return this._class;
    }

    @Override
    public void setExprClass(Class<?> c) {
        this._class = c;
    }
}

