/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.DesktopItemCollection;
import com.kingdee.shr.base.syssetting.DesktopItemFactory;
import com.kingdee.shr.base.syssetting.DesktopItemInfo;
import com.kingdee.shr.base.syssetting.DesktopItemSortCollection;
import com.kingdee.shr.base.syssetting.DesktopItemSortFactory;
import com.kingdee.shr.base.syssetting.DesktopItemSortInfo;
import com.kingdee.shr.base.syssetting.IDesktopItemSort;
import com.kingdee.shr.base.syssetting.IconTypeEnum;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DeskTopItemUtil {
    public static List getDesktopItemList(Context ctx, EntityViewInfo viewInfo) throws BOSException {
        viewInfo.setSelector(DeskTopItemUtil.getDeskTopItemSelectorItemCollection());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("item.category", (Object)0));
        viewInfo.getFilter().mergeFilter(filterInfo, "AND");
        DesktopItemSortCollection coll = DesktopItemSortFactory.getLocalInstance(ctx).getDesktopItemSortCollection(viewInfo);
        return DeskTopItemUtil.getDesktopItemList(coll);
    }

    public static boolean isNeedSyncUserDesktopItemSort(Context ctx, String userId) throws BOSException {
        DesktopItemCollection itemColl = DeskTopItemUtil.getNotSortDesktopItemCollection(ctx, userId);
        return itemColl.size() > 0;
    }

    public static void addDefaultDesktopItemSort(Context ctx, String userId) throws BOSException, EASBizException {
        DesktopItemCollection itemColl = DeskTopItemUtil.getNotSortDesktopItemCollection(ctx, userId);
        DesktopItemSortInfo sortInfo = null;
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)userId));
        IDesktopItemSort iDesktopItemSort = DesktopItemSortFactory.getLocalInstance(ctx);
        int size = itemColl.size();
        for (int i = 0; i < size; ++i) {
            sortInfo = new DesktopItemSortInfo();
            sortInfo.setUser(user);
            sortInfo.setItem(itemColl.get(i));
            sortInfo.setSortCode(itemColl.get(i).getDefaultSortCode());
            iDesktopItemSort.addnew(sortInfo);
        }
    }

    public static DesktopItemCollection syncDesktopItemSortCode(Context ctx, DesktopItemCollection coll) throws BOSException {
        String idStr = DeskTopItemUtil.convertColToString((IObjectCollection)coll);
        String sql = "select FItemID,FSortCode from T_BS_DesktopItemSort where FItemID in (" + idStr + ") order by FSortCode";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        DesktopItemInfo info = null;
        DesktopItemCollection sortColl = new DesktopItemCollection();
        try {
            while (rs.next()) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    if (!info.getId().toString().equals(rs.getString("FItemID"))) continue;
                    info.put("sortCode", rs.getString("FSortCode"));
                }
                sortColl.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    public static SelectorItemCollection getDeskTopItemSelectorItemCollection() {
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("item.id"));
        selColl.add(new SelectorItemInfo("item.name"));
        selColl.add(new SelectorItemInfo("item.isInner"));
        selColl.add(new SelectorItemInfo("item.url"));
        selColl.add(new SelectorItemInfo("item.urlType"));
        selColl.add(new SelectorItemInfo("item.itemType"));
        selColl.add(new SelectorItemInfo("item.iconPath"));
        selColl.add(new SelectorItemInfo("item.iconType"));
        selColl.add(new SelectorItemInfo("item.parent.id"));
        selColl.add(new SelectorItemInfo("item.parent.name"));
        selColl.add(new SelectorItemInfo("item.user.id"));
        selColl.add(new SelectorItemInfo("item.user.name"));
        selColl.add(new SelectorItemInfo("item.serviceName"));
        selColl.add(new SelectorItemInfo("item.service.id"));
        selColl.add(new SelectorItemInfo("item.service.name"));
        selColl.add(new SelectorItemInfo("item.defaultSortCode"));
        selColl.add(new SelectorItemInfo("item.isLeaf"));
        selColl.add(new SelectorItemInfo("sortCode"));
        return selColl;
    }

    public static List getDesktopItemList(DesktopItemSortCollection coll) {
        DesktopItemInfo info = null;
        ArrayList result = new ArrayList();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i).getItem();
            HashMap<String, Object> each = new HashMap<String, Object>();
            each.put("id", info.getId().toString());
            if (StringUtils.isEmpty((String)info.getName())) {
                each.put("name", "");
            } else {
                each.put("name", info.getName());
            }
            each.put("isInner", "" + info.isIsInner());
            if (StringUtils.isEmpty((String)info.getUrl())) {
                each.put("url", "");
            } else {
                each.put("url", "" + info.getUrl());
            }
            if (StringUtils.isEmpty((String)info.getUrlType())) {
                each.put("urlType", "");
            } else {
                each.put("urlType", "" + info.getUrlType());
            }
            if (StringUtils.isEmpty((String)info.getItemType())) {
                each.put("itemType", "");
            } else {
                each.put("itemType", "" + info.getItemType());
            }
            if (StringUtils.isEmpty((String)info.getIconPath())) {
                each.put("iconPath", "");
            } else {
                each.put("iconPath", "" + info.getIconPath());
            }
            if (info.getIconType() == null) {
                each.put("iconType", "");
            } else {
                each.put("iconType", "" + (Object)((Object)info.getIconType()));
            }
            each.put("defaultSortCode", info.getDefaultSortCode());
            each.put("isLeaf", info.isIsLeaf());
            each.put("sortCode", "" + coll.get(i).getSortCode());
            if (info.getParent() != null) {
                HashMap<String, String> parentMap = new HashMap<String, String>();
                parentMap.put("id", info.getParent().getId().toString());
                parentMap.put("name", info.getParent().getName());
                each.put("parent", "" + parentMap);
            } else {
                each.put("parent", "");
            }
            if (info.getUser() != null) {
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("id", info.getUser().getId().toString());
                userMap.put("name", info.getUser().getName());
                each.put("user", "" + userMap);
            } else {
                each.put("user", "");
            }
            ServiceInfo serviceInfo = info.getService();
            if (serviceInfo != null) {
                if (serviceInfo.getId() == null) {
                    each.put("serviceId", "");
                } else {
                    each.put("serviceId", serviceInfo.getId().toString());
                }
                if (StringUtils.isEmpty((String)serviceInfo.getName())) {
                    each.put("serviceName", "");
                } else {
                    each.put("serviceName", serviceInfo.getName());
                }
            }
            result.add(each);
        }
        return result;
    }

    public static String convertColToString(IObjectCollection col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        StringBuffer values = new StringBuffer();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                values.append(",");
            }
            values.append("'");
            values.append(((CoreBaseInfo)col.getObject(i)).getId());
            values.append("'");
        }
        return values.toString();
    }

    public static DesktopItemInfo getDesktopItemInfo(Context ctx, HashMap<String, String> paramMap) {
        DesktopItemInfo itemInfo = new DesktopItemInfo();
        if (paramMap.get("id") != null) {
            itemInfo.setId(BOSUuid.read((String)paramMap.get("id")));
        }
        if (paramMap.get("name") != null) {
            itemInfo.setName(paramMap.get("name"));
        }
        if (paramMap.get("isInner") != null) {
            boolean isInner = Boolean.valueOf(paramMap.get("isInner"));
            itemInfo.setIsInner(isInner);
            if (!isInner) {
                String userId = paramMap.get("userId");
                if (!StringUtils.isEmpty((String)userId)) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)userId));
                    itemInfo.setUser(userInfo);
                } else {
                    itemInfo.setUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                }
            }
        }
        if (paramMap.get("url") != null) {
            itemInfo.setUrl(paramMap.get("url"));
        }
        if (paramMap.get("urlType") != null) {
            itemInfo.setUrlType(paramMap.get("urlType"));
        }
        if (paramMap.get("itemType") != null) {
            itemInfo.setItemType(paramMap.get("itemType"));
        }
        if (paramMap.get("iconPath") != null) {
            itemInfo.setIconPath(paramMap.get("iconPath"));
        }
        if (paramMap.get("iconType") != null) {
            itemInfo.setIconType(IconTypeEnum.getEnum(paramMap.get("iconType")));
        }
        if (paramMap.get("isLeaf") != null) {
            boolean isLeaf = Boolean.valueOf(paramMap.get("isLeaf"));
            itemInfo.setIsLeaf(isLeaf);
        } else {
            itemInfo.setIsLeaf(true);
        }
        String parentId = paramMap.get("parentId");
        if (!StringUtils.isEmpty((String)parentId)) {
            DesktopItemInfo parentItemInfo = new DesktopItemInfo();
            parentItemInfo.setId(BOSUuid.read((String)parentId));
            itemInfo.setParent(parentItemInfo);
        } else if ("".equals(parentId)) {
            itemInfo.setParent(null);
        }
        if (!StringUtils.isEmpty((String)paramMap.get("sortCode"))) {
            String sortCode = paramMap.get("sortCode");
            itemInfo.put("sortCode", sortCode);
        }
        return itemInfo;
    }

    private static DesktopItemCollection getNotSortDesktopItemCollection(Context ctx, String userId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FItemID from T_BS_DesktopItemSort where FUserID='").append(userId).append("'");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        filter.getFilterItems().add(new FilterItemInfo("category", (Object)0));
        viewInfo.setFilter(filter);
        DesktopItemCollection itemColl = DesktopItemFactory.getLocalInstance(ctx).getDesktopItemCollection(viewInfo);
        return itemColl;
    }

    public static boolean isEmpty(String s) {
        return StringUtils.isEmpty((String)s) || "null".equals(s);
    }

    public static boolean isLeaf(Context ctx, String itemId) throws BOSException {
        boolean isLeaf = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)itemId));
        filter.getFilterItems().add(new FilterItemInfo("category", (Object)0));
        viewInfo.setFilter(filter);
        DesktopItemCollection coll = DesktopItemFactory.getLocalInstance(ctx).getDesktopItemCollection(viewInfo);
        isLeaf = coll.size() <= 0;
        return isLeaf;
    }

    public static void updateIsLeafState(Context ctx, String itemId, boolean isLeaf) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int val = 0;
        val = isLeaf ? 1 : 0;
        sql.append("update T_BS_DesktopItem set FIsLeaf=").append(val).append(" where fid='").append(itemId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void syncParentIsLeafState(Context ctx, DesktopItemInfo itemInfo) throws BOSException {
        if (itemInfo.getParent() != null) {
            String itemId = itemInfo.getParent().getId().toString();
            DeskTopItemUtil.syncIsLeafState(ctx, itemId);
        }
    }

    public static void syncIsLeafState(Context ctx, String itemId) throws BOSException {
        boolean isLeaf = DeskTopItemUtil.isLeaf(ctx, itemId);
        if (isLeaf) {
            DeskTopItemUtil.updateIsLeafState(ctx, itemId, true);
        } else {
            DeskTopItemUtil.updateIsLeafState(ctx, itemId, false);
        }
    }
}

