/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import java.io.File;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SHRCheck {
    private static final Logger logger = Logger.getLogger(SHRCheck.class);
    private static String characteristic = "--------------";
    private static String regexRedirectUrl = "(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
    private static String refexIp = "[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(/.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+/.?";

    private SHRCheck() {
    }

    public static String checkFilePath(String filePath) {
        String normalFilePath;
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("filePath IS NULL !" + characteristic));
            }
            return filePath;
        }
        if (!(filePath.contains(File.separator) || filePath.contains("/") || filePath.contains("\\"))) {
            return filePath;
        }
        String ignoreFilePath = filePath.replace("//", File.separator).replace("\\", File.separator).replace("/", File.separator);
        if (!ignoreFilePath.equals(normalFilePath = FilenameUtils.normalize((String)ignoreFilePath))) {
            throw new IllegalArgumentException("IllegalArgumentFilePath: " + characteristic + normalFilePath.substring(normalFilePath.lastIndexOf(File.separator)));
        }
        return normalFilePath;
    }

    public static String checkFileNameForSetResponseHeader(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("fileName IS NULL !" + characteristic));
            }
            return fileName;
        }
        String checkedFileName = StringUtils.normalizeSpace((String)fileName);
        if (!fileName.equals(checkedFileName)) {
            throw new IllegalArgumentException("IllegalArgumentSendRedirectParams: " + characteristic + checkedFileName);
        }
        return checkedFileName;
    }

    public static String checkUrlParamsForSendRedirect(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("URL IS NULL !" + characteristic));
            }
            return null;
        }
        if (Pattern.matches(regexRedirectUrl, url)) {
            throw new IllegalArgumentException("IllegalArgumentRedirectUrl" + characteristic + url);
        }
        return url;
    }

    public static String vaildLog(String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("URL IS NULL !" + characteristic));
            }
            return message;
        }
        String encodeMessage = Normalizer.normalize(message, Normalizer.Form.NFC);
        List<String> vaildList = Arrays.asList("%0d", "\r", "%0a", "\n");
        for (int i = 0; i < vaildList.size(); ++i) {
            encodeMessage = encodeMessage.replace(vaildList.get(i), "");
        }
        return encodeMessage;
    }

    public static String vaildIp(String ip) {
        return ip;
    }
}

