/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;

public class SystemContextUtil {
    public static String getUserAuthPattern(Context ctx) {
        return ctx.get((Object)"UserAuthPattern") == null ? "" : ctx.get((Object)"UserAuthPattern").toString();
    }

    public static boolean isBaseDBUserAuthPattern(Context ctx) {
        return "BaseDB".equalsIgnoreCase(SystemContextUtil.getUserAuthPattern(ctx));
    }

    public static String getLoginType(Context ctx) {
        return ctx.get((Object)"LOGIN_TYPE") == null ? "" : ctx.get((Object)"LOGIN_TYPE").toString();
    }

    public static boolean isSQLServerDB(Context ctx) {
        return DbType.getName((int)3).equalsIgnoreCase(ContextUtil.getDbType((Context)ctx));
    }

    public static boolean isOracleDB(Context ctx) {
        return DbType.getName((int)2).equalsIgnoreCase(ContextUtil.getDbType((Context)ctx)) || DbType.getName((int)8).equalsIgnoreCase(ContextUtil.getDbType((Context)ctx)) || DbType.getName((int)7).equalsIgnoreCase(ContextUtil.getDbType((Context)ctx));
    }

    public static String getDbTypeByDataCenter(String datacenter) {
        String value = DbType.getName((int)0);
        DCInfo dc = SystemContextUtil.getDCInfoByDataCenter(datacenter);
        if (null != dc) {
            value = DbType.getName((int)dc.getDBType());
        }
        return value;
    }

    public static DCInfo getDCInfoByDataCenter(String datacenter) {
        try {
            ArrayList newList = DCManager.getInstance().getDCList();
            int total = newList.size();
            for (int i = 0; i < total; ++i) {
                DCInfo dc = (DCInfo)newList.get(i);
                if (!dc.getNumber().equals(datacenter)) continue;
                return dc;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getClientIp(Context ctx) {
        Object obj = ctx.getClientHostIP();
        if (obj == null) {
            obj = ctx.get((Object)"ClientIP");
        }
        return obj == null ? "" : obj.toString();
    }

    public static String getClientName(Context ctx) {
        Object obj = ctx.getClientHostName();
        if (obj == null) {
            obj = ctx.get((Object)"ClientName");
        }
        if (obj == null || obj.toString().isEmpty()) {
            obj = SystemContextUtil.getClientIp(ctx);
        }
        return obj == null ? "" : obj.toString();
    }
}

