/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.util;

import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.common.util.ShrSensitiveBean;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ShrSensitiveConfigUtil {
    private static final Logger logger = Logger.getLogger(ShrSensitiveConfigUtil.class);
    private static final String ENTITY_CONFIG_FILENAME = "entity_sensitive_config.xml";
    private static final String ENTITY_CONFIG_EXT_FILENAME = "entity_sensitive_config_ext.xml";
    private static final String UIPK_CONFIG_FILENAME = "uipk_sensitive_config.xml";
    private static final String UIPK_CONFIG_EXT_FILENAME = "uipk_sensitive_config_ext.xml";
    private Map<String, Map<String, ShrSensitiveBean>> entityMap;
    private Map<String, Map<String, ShrSensitiveBean>> uipkMap;
    private static ShrSensitiveConfigUtil instance;

    private ShrSensitiveConfigUtil() {
    }

    public Map<String, ShrSensitiveBean> getEntityConfigByEntityFullName(String entityFullName) {
        if (StringUtils.isEmpty((String)entityFullName)) {
            return null;
        }
        return this.entityMap.get(entityFullName);
    }

    public Map<String, ShrSensitiveBean> getUipkConfigByUipk(String uipk) {
        if (StringUtils.isEmpty((String)uipk)) {
            return null;
        }
        return this.uipkMap.get(uipk);
    }

    public static ShrSensitiveConfigUtil getInstance() {
        if (null == instance) {
            instance = new ShrSensitiveConfigUtil();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.entityMap = new ConcurrentHashMap<String, Map<String, ShrSensitiveBean>>();
        this.uipkMap = new ConcurrentHashMap<String, Map<String, ShrSensitiveBean>>();
        StringBuffer format = new StringBuffer();
        format.append(SHRSyssettingUtil.getShrPropertiesSensitive()).append(File.separator).append("{0}");
        String[] entityConfigs = new String[]{MessageFormat.format(format.toString(), ENTITY_CONFIG_EXT_FILENAME), MessageFormat.format(format.toString(), ENTITY_CONFIG_FILENAME)};
        String[] uipkConfigs = new String[]{MessageFormat.format(format.toString(), UIPK_CONFIG_EXT_FILENAME), MessageFormat.format(format.toString(), UIPK_CONFIG_FILENAME)};
        this.initMap(entityConfigs, "entity");
        this.initMap(uipkConfigs, "uipk");
    }

    private void initMap(String[] configs, String type) {
        Document doc = null;
        Element rootElement = null;
        try {
            for (String path : configs) {
                List items;
                doc = SHRSyssettingUtil.getXmlFileByPath(path);
                if (null == doc || null == (rootElement = doc.getRootElement()) || null == (items = rootElement.getChildren("items")) || items.size() <= 0) continue;
                for (Element items0 : items) {
                    List item = items0.getChildren("item");
                    if (null == item || item.size() <= 0) continue;
                    for (Element item0 : item) {
                        if ("entity".equals(type)) {
                            this.initEntityMapDetail(item0);
                            continue;
                        }
                        this.initUipkMapDetail(item0);
                    }
                }
            }
        }
        catch (JDOMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initEntityMapDetail(Element entityConfigItem) {
        String entityFullName = entityConfigItem.getAttributeValue("entityFullName");
        String propertyName = null;
        ShrSensitiveBean bean = null;
        if (!StringUtils.isEmpty((String)entityFullName)) {
            Map<String, ShrSensitiveBean> properties = this.entityMap.get(entityFullName);
            if (null == properties) {
                properties = new ConcurrentHashMap<String, ShrSensitiveBean>();
                this.entityMap.put(entityFullName, properties);
            }
            if (!StringUtils.isEmpty((String)(propertyName = entityConfigItem.getAttributeValue("propertyName"))) && !properties.containsKey(propertyName)) {
                bean = new ShrSensitiveBean(propertyName, entityConfigItem.getAttributeValue("sensitiveRule"), true, entityConfigItem.getAttributeValue("desc"), entityConfigItem.getAttributeValue("respPerson"));
                properties.put(propertyName, bean);
            }
        }
    }

    private void initUipkMapDetail(Element uipkConfigItem) {
        String uipk = uipkConfigItem.getAttributeValue("uipk");
        String field = null;
        ShrSensitiveBean bean = null;
        if (!StringUtils.isEmpty((String)uipk)) {
            Map<String, ShrSensitiveBean> properties = this.uipkMap.get(uipk);
            if (null == properties) {
                properties = new ConcurrentHashMap<String, ShrSensitiveBean>();
                this.uipkMap.put(uipk, properties);
            }
            if (!StringUtils.isEmpty((String)(field = uipkConfigItem.getAttributeValue("field"))) && !properties.containsKey(field)) {
                String issensitive = uipkConfigItem.getAttributeValue("issensitive");
                boolean issensitive0 = false;
                if (!StringUtils.isEmpty((String)issensitive) && "true".equalsIgnoreCase(issensitive)) {
                    issensitive0 = true;
                }
                bean = new ShrSensitiveBean(field, uipkConfigItem.getAttributeValue("sensitiveRule"), issensitive0, uipkConfigItem.getAttributeValue("desc"), uipkConfigItem.getAttributeValue("respPerson"));
                properties.put(field, bean);
            }
        }
    }
}

