/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.crypto;

import com.google.common.collect.Maps;
import com.kingdee.shr.inte.cq.crypto.Encryptor;
import com.kingdee.shr.inte.cq.ex.EncryptException;
import com.kingdee.shr.inte.cq.extension.ExtensionFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptorFactory {
    private static final Logger log = LoggerFactory.getLogger(EncryptorFactory.class);
    private static final String REGEX = ",";
    private static final String DEFAULT_ENCRYPTORS = "com.kingdee.shr.inte.cq.crypto.impl.AESGCMEncryptor,com.kingdee.shr.inte.cq.crypto.impl.SM4GCMEncryptor";
    private static final Map<String, Encryptor> encryptorMap = Maps.newHashMap();

    private static void loadDefault(String classesStr) throws ClassNotFoundException {
        String[] encryptorsClazz;
        String[] var2 = encryptorsClazz = classesStr.split(REGEX);
        int var3 = encryptorsClazz.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String clazz = var2[var4];
            if (EncryptorFactory.load(Class.forName(clazz))) continue;
            log.warn("default implementation be overwritten, ensure this is you want. overwritten={}", (Object)clazz);
        }
    }

    private static void loadCumstom() {
        ExtensionFactory<Encryptor> factory = ExtensionFactory.getExtensionFacotry(Encryptor.class);
        Map<String, Class<?>> clazzMap = factory.getExtensionClasses();
        clazzMap.forEach((k, cls) -> EncryptorFactory.load(cls));
    }

    private static boolean load(Class<?> cls) {
        try {
            Encryptor me = (Encryptor)cls.newInstance();
            if (encryptorMap.get(me.transformation()) == null) {
                encryptorMap.putIfAbsent(me.transformation(), me);
                log.info("loaded implement: {}", (Object)cls.toString());
                return true;
            }
            return false;
        }
        catch (Exception var2) {
            log.error("load impl class error", (Throwable)var2);
            throw new EncryptException("load impl class error: " + var2.getMessage());
        }
    }

    public static Map<String, Encryptor> getEncryptorMap() {
        return encryptorMap;
    }

    public static Encryptor getEncryptor(String algorithm) {
        Encryptor encryptor = encryptorMap.get(algorithm);
        if (encryptor == null) {
            throw new EncryptException("not support algorithm: " + algorithm);
        }
        return encryptor;
    }

    static {
        log.info("begin encryptor factory init");
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            EncryptorFactory.loadCumstom();
            EncryptorFactory.loadDefault(DEFAULT_ENCRYPTORS);
        }
        catch (Exception var1) {
            throw new EncryptException(var1);
        }
        log.info("all loaded:" + encryptorMap.toString());
    }
}

