/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.AuthCQTypeEnum;
import com.kingdee.shr.base.syssetting.CallStatusEnum;
import com.kingdee.shr.base.syssetting.InteCQConfigInfo;
import com.kingdee.shr.base.syssetting.InteCQException;
import com.kingdee.shr.base.syssetting.InteCQLogFactory;
import com.kingdee.shr.base.syssetting.InteCQLogInfo;
import com.kingdee.shr.base.syssetting.InteSystemEnum;
import com.kingdee.shr.base.syssetting.StateEnum;
import com.kingdee.shr.base.syssetting.UIViewTreeInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.inte.cq.IInteCQSystemService;
import com.kingdee.shr.inte.cq.bean.APIAndCallInfo;
import com.kingdee.shr.inte.cq.bean.CQResponseBean;
import com.kingdee.shr.inte.cq.bean.CQSignResponseBean;
import com.kingdee.shr.inte.cq.bean.EncryptInfo;
import com.kingdee.shr.inte.cq.bean.EncryptionEnum;
import com.kingdee.shr.inte.cq.ex.APIException;
import com.kingdee.shr.inte.cq.token.TokenManger;
import com.kingdee.shr.inte.cq.util.HttpClientUtil;
import com.kingdee.shr.inte.cq.util.InteCQConfigUtil;
import com.kingdee.shr.inte.cq.util.OpenApiSecurityService;
import com.kingdee.shr.inte.cq.util.SignUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class InteCQSystemService
implements IInteCQSystemService {
    private String language = "zh_CN";
    private boolean isTest = false;
    private static final Logger logger = Logger.getLogger(InteCQSystemService.class);
    private boolean isNoException = false;

    private boolean isOpenLog(Context ctx) {
        try {
            return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"Inte_cq_log_open", null, (boolean)false));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return true;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return true;
        }
    }

    private IObjectPK preLog(Context ctx, String data) throws EASBizException, BOSException {
        if (!this.isOpenLog(ctx)) {
            return null;
        }
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        InteCQLogInfo log = new InteCQLogInfo();
        log.setReqData(InteCQConfigUtil.encrypt(data));
        log.setStatus(CallStatusEnum.failure);
        log.setUserName(u.getName());
        log.setUserNumber(u.getNumber());
        return InteCQLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)log);
    }

    private void updateLogData(Context ctx, String data, APIAndCallInfo callInfo) throws EASBizException, BOSException {
        if (null == callInfo.getLogPK()) {
            return;
        }
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        InteCQLogInfo log = new InteCQLogInfo();
        log.setId(BOSUuid.read((String)callInfo.getLogPK().toString()));
        log.setUrl(callInfo.getServerUrl() + callInfo.getServiceUrl());
        log.setAuthType(callInfo.getAuthType());
        log.setApiName(callInfo.getApiConfigName());
        log.setApiNumber(callInfo.getApiConfigNumber());
        log.setInteSystem(callInfo.getInteSystem());
        log.setInteConfigName(callInfo.getInteCQConfigName());
        log.setInteConfigNumber(callInfo.getInteCQConfigNumber());
        log.setDomain(callInfo.getDomain());
        log.setReqHeader(InteCQConfigUtil.encrypt(data));
        log.setLastUpdateUser(u);
        log.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("url");
        selector.add("authType");
        selector.add("apiName");
        selector.add("apiNumber");
        selector.add("inteSystem");
        selector.add("inteConfigName");
        selector.add("inteConfigNumber");
        selector.add("domain");
        selector.add("reqHeader");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        InteCQLogFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)log, selector);
    }

    private void afterLog(Context ctx, IObjectPK pk, String data, CallStatusEnum status) throws EASBizException, BOSException {
        if (null == pk) {
            return;
        }
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        InteCQLogInfo log = new InteCQLogInfo();
        log.setId(BOSUuid.read((String)pk.toString()));
        log.setStatus(status);
        log.setResData(InteCQConfigUtil.encrypt(data));
        log.setLastUpdateUser(u);
        log.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("status");
        selector.add("resData");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        InteCQLogFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)log, selector);
    }

    private void deleteLog(Context ctx, IObjectPK pk) {
        if (null == pk) {
            return;
        }
        try {
            InteCQLogFactory.getLocalInstance(ctx).delete(pk);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void checkData(APIAndCallInfo callInfo, String jsondata) throws EASBizException {
        if (StringUtils.isEmpty((String)callInfo.getServiceUrl())) {
            throw new InteCQException(InteCQException.SERVICE_URL_ISNULL, new Object[]{callInfo.getInteCQConfigNumber(), callInfo.getApiConfigNumber()});
        }
        try {
            JSON.parseObject((String)jsondata, HashMap.class);
        }
        catch (Exception e) {
            throw new InteCQException(InteCQException.DATA_NOT_JSON);
        }
        if (InteSystemEnum.XKQJ.equals((Object)callInfo.getInteSystem()) && StringUtils.isEmpty((String)callInfo.getXacgwi())) {
            throw new InteCQException(InteCQException.X_ACGW_IDENTITY_NOT_NULL);
        }
        if (!StateEnum.Enable.equals((Object)callInfo.getStatus())) {
            throw new InteCQException(InteCQException.REQ_API_STATUS_NOTENABLE, new Object[]{callInfo.getInteCQConfigNumber(), callInfo.getApiConfigNumber()});
        }
        if (AuthCQTypeEnum.advance.equals((Object)callInfo.getAuthType()) || AuthCQTypeEnum.jwt.equals((Object)callInfo.getAuthType())) {
            if (StringUtils.isEmpty((String)callInfo.getAgentUser())) {
                throw new InteCQException(InteCQException.REQ_AGENTUSER_ISNULL, new Object[]{callInfo.getInteCQConfigNumber()});
            }
            if (StringUtils.isEmpty((String)callInfo.getAppSecret())) {
                throw new InteCQException(InteCQException.REQ_APPSECRET_ISNULL, new Object[]{callInfo.getInteCQConfigNumber()});
            }
        }
        if (AuthCQTypeEnum.digest.equals((Object)callInfo.getAuthType()) && StringUtils.isEmpty((String)callInfo.getDigestSecret())) {
            throw new InteCQException(InteCQException.REQ_DIGEST_SECRET_ISNULL, new Object[]{callInfo.getInteCQConfigNumber()});
        }
        if (AuthCQTypeEnum.sign.equals((Object)callInfo.getAuthType())) {
            if (StringUtils.isEmpty((String)callInfo.getSignSecret())) {
                throw new InteCQException(InteCQException.REQ_SIGN_SECRET_ISNULL, new Object[]{callInfo.getInteCQConfigNumber()});
            }
            if (StringUtils.isEmpty((String)callInfo.getSignKey())) {
                throw new InteCQException(InteCQException.REQ_SIGN_KEY_ISNULL, new Object[]{callInfo.getInteCQConfigNumber()});
            }
            if (null == callInfo.getEncryptType()) {
                throw new InteCQException(InteCQException.REQ_ENCRYTPTYPE_ISNULL, new Object[]{callInfo.getInteCQConfigNumber()});
            }
            if (StringUtils.isEmpty((String)callInfo.getCertKey())) {
                throw new InteCQException(InteCQException.REQ_CERTKEY_ISNULL, new Object[]{callInfo.getInteCQConfigNumber()});
            }
        }
    }

    @Override
    public String callByAdvance(Context ctx, APIAndCallInfo callInfo, String jsondata) throws Exception {
        return (String)this.callByAdvance(ctx, callInfo, jsondata, false);
    }

    private static String getExceptionStackErrorMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    @Override
    public String callByJWT(Context ctx, APIAndCallInfo callInfo, String jsondata) throws Exception {
        return (String)this.callByJWT(ctx, callInfo, jsondata, false);
    }

    private StringBuilder getSignatureString(String datetimeString, String signatureNonce, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append(body);
        sb.append(datetimeString);
        sb.append(signatureNonce);
        return sb;
    }

    @Override
    public String callByDigest(Context ctx, APIAndCallInfo callInfo, String jsondata) throws Exception {
        return (String)this.callByDigest(ctx, callInfo, jsondata, false);
    }

    private String signing(String appSecret, String content, String uuid, String timestamp) throws Exception {
        StringBuilder sb = this.getSignatureString(timestamp, uuid, content);
        String encyptString = SignUtils.HMACSHA256StrByKey(sb.toString(), appSecret);
        return encyptString;
    }

    @Override
    public String callBySign(Context ctx, APIAndCallInfo callInfo, String jsondata) throws Exception {
        return (String)this.callBySign(ctx, callInfo, jsondata, false);
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    private String getCallParamsData(InteSystemEnum inteSystem, String number, String jsondata, String agentUser, String lan) {
        StringBuilder sb = new StringBuilder();
        sb.append("inteSystem=");
        if (null != inteSystem) {
            sb.append(inteSystem.getAlias());
        }
        sb.append(",number=").append(number).append(",jsondata=").append(jsondata).append(",agentUser=").append(agentUser).append(",lan=").append(lan);
        return sb.toString();
    }

    @Override
    public String call(Context ctx, InteSystemEnum inteSystem, String number, String jsondata, String agentUser, String lan) throws EASBizException, BOSException {
        String result = null;
        APIAndCallInfo info = null;
        IObjectPK pk = this.preLog(ctx, this.getCallParamsData(inteSystem, number, jsondata, agentUser, lan));
        try {
            if (null == inteSystem) {
                throw new InteCQException(InteCQException.PARAM1_ISNULL);
            }
            if (StringUtils.isEmpty((String)number)) {
                throw new InteCQException(InteCQException.PARAM2_ISNULL);
            }
            info = InteCQConfigUtil.getCallInfo(ctx, inteSystem, number);
            if (null == info) {
                throw new InteCQException(InteCQException.API_CONFIG_NOTFOUND, new Object[]{inteSystem.getAlias(), number});
            }
            if (!ctx.getAIS().equals(info.getDatacenter())) {
                throw new InteCQException(InteCQException.DATACENTER_ERROR, new Object[]{info.getInteCQConfigNumber(), info.getDatacenter(), ctx.getAIS()});
            }
            if (!InteCQConfigUtil.isValidURL(info.getServerUrl())) {
                throw new InteCQException(InteCQException.URL_FORMATTER_ERROR);
            }
            if (info.isOpenLog()) {
                info.setLogPK(pk);
            } else {
                this.deleteLog(ctx, pk);
                pk = null;
            }
            if (!StringUtils.isEmpty((String)agentUser)) {
                info.setAgentUser(agentUser);
            }
            if (!StringUtils.isEmpty((String)lan)) {
                this.setLanguage(lan);
            }
            result = AuthCQTypeEnum.sign.equals((Object)info.getAuthType()) ? this.callBySign(ctx, info, jsondata) : (AuthCQTypeEnum.digest.equals((Object)info.getAuthType()) ? this.callByDigest(ctx, info, jsondata) : (AuthCQTypeEnum.jwt.equals((Object)info.getAuthType()) ? this.callByJWT(ctx, info, jsondata) : this.callByAdvance(ctx, info, jsondata)));
        }
        catch (EASBizException e) {
            if (null != info) {
                this.updateLogData(ctx, null, info);
            }
            this.afterLog(ctx, pk, InteCQSystemService.getExceptionStackErrorMessage((Exception)((Object)e)), CallStatusEnum.failure);
            throw e;
        }
        catch (BOSException e) {
            if (null != info) {
                this.updateLogData(ctx, null, info);
            }
            this.afterLog(ctx, pk, InteCQSystemService.getExceptionStackErrorMessage((Exception)((Object)e)), CallStatusEnum.failure);
            throw e;
        }
        catch (APIException e) {
            if (null != info) {
                this.updateLogData(ctx, e.getTokenData(), info);
            }
            this.afterLog(ctx, pk, e.getTokenRes(), CallStatusEnum.failure);
            result = e.getTokenRes();
            if (this.isNoException) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (null != info) {
                this.updateLogData(ctx, null, info);
            }
            this.afterLog(ctx, pk, InteCQSystemService.getExceptionStackErrorMessage(e), CallStatusEnum.failure);
            if (this.isNoException) {
                e.printStackTrace();
            }
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public String demoCall(Context ctx, InteCQConfigInfo model, String jsondata) throws EASBizException, BOSException {
        String result = null;
        APIAndCallInfo info = null;
        try {
            if (null == model.getInteSystem()) {
                throw new InteCQException(InteCQException.PARAM1_ISNULL);
            }
            String number = "demo001";
            info = this.getCallInfo(model);
            if (!ctx.getAIS().equals(info.getDatacenter())) {
                throw new InteCQException(InteCQException.DATACENTER_ERROR, new Object[]{info.getInteCQConfigNumber(), info.getDatacenter(), ctx.getAIS()});
            }
            info.setInteSystem(model.getInteSystem());
            info.setApiConfigNumber(number);
            info.setAgentUser(model.getAgentUser());
            this.setLanguage(LocaleUtils.getLocaleString((Locale)LocaleUtils.getFirstOriginLocale((Locale)ctx.getLocale())));
            result = AuthCQTypeEnum.sign.equals((Object)info.getAuthType()) ? this.callBySign(ctx, info, jsondata) : (AuthCQTypeEnum.digest.equals((Object)info.getAuthType()) ? this.callByDigest(ctx, info, jsondata) : (AuthCQTypeEnum.jwt.equals((Object)info.getAuthType()) ? this.callByJWT(ctx, info, jsondata) : this.callByAdvance(ctx, info, jsondata)));
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (APIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private APIAndCallInfo getCallInfo(InteCQConfigInfo model) {
        APIAndCallInfo info = new APIAndCallInfo();
        info.setDatacenter(model.getDatacenter());
        info.setInteCQConfigNumber(model.getNumber());
        info.setInteCQConfigName(model.getName());
        info.setApiConfigName("\u67e5\u8be2\u5355\u4e2aCU\u4fe1\u606f");
        info.setServerUrl(model.getUrl());
        info.setServiceUrl("/kapi/v2/base/bos_org/queryOne");
        info.setAccountId(model.getAccountId());
        info.setClientId(model.getAppId());
        info.setAppSecret(model.getAppSecret());
        UIViewTreeInfo typeinfo = new UIViewTreeInfo();
        typeinfo.setId(BOSUuid.read((String)"aijtJrDmSra9v+BGcKDrfndTPHE="));
        info.setDomain(typeinfo);
        info.setAgentUser(model.getAgentUser());
        info.setAuthType(model.getAuthType());
        info.setStatus(StateEnum.Enable);
        info.setDigestType(model.getDigestType());
        info.setDigestSecret(model.getDigestSecret());
        info.setSignType(model.getSignType());
        info.setSignSecret(model.getSignSecret());
        info.setSignUser(model.getSignUser());
        info.setSignKey(model.getSignKey());
        info.setEncryptType(model.getEncryptType());
        info.setCertKey(model.getCertKey());
        info.setOpenLog(true);
        info.setJwtType(model.getJwtType());
        info.setXacgwi(model.getXacgwi());
        return info;
    }

    @Override
    public void setIsTest(boolean isTest) {
        this.isTest = isTest;
    }

    @Override
    public void setIsNoException(boolean isNoException) {
        this.isNoException = isNoException;
    }

    @Override
    public CQResponseBean call2Trans(Context ctx, InteSystemEnum inteSystem, String number, String jsondata, String agentUser, String lan) throws EASBizException, BOSException {
        CQResponseBean result = null;
        APIAndCallInfo info = null;
        IObjectPK pk = this.preLog(ctx, this.getCallParamsData(inteSystem, number, jsondata, agentUser, lan));
        try {
            if (null == inteSystem) {
                throw new InteCQException(InteCQException.PARAM1_ISNULL);
            }
            if (StringUtils.isEmpty((String)number)) {
                throw new InteCQException(InteCQException.PARAM2_ISNULL);
            }
            info = InteCQConfigUtil.getCallInfo(ctx, inteSystem, number);
            if (null == info) {
                throw new InteCQException(InteCQException.API_CONFIG_NOTFOUND, new Object[]{inteSystem.getAlias(), number});
            }
            if (!ctx.getAIS().equals(info.getDatacenter())) {
                throw new InteCQException(InteCQException.DATACENTER_ERROR, new Object[]{info.getInteCQConfigNumber(), info.getDatacenter(), ctx.getAIS()});
            }
            if (info.isOpenLog()) {
                info.setLogPK(pk);
            } else {
                this.deleteLog(ctx, pk);
                pk = null;
            }
            if (!StringUtils.isEmpty((String)agentUser)) {
                info.setAgentUser(agentUser);
            }
            if (!StringUtils.isEmpty((String)lan)) {
                this.setLanguage(lan);
            }
            result = AuthCQTypeEnum.sign.equals((Object)info.getAuthType()) ? (CQResponseBean)this.callBySign(ctx, info, jsondata, true) : (AuthCQTypeEnum.digest.equals((Object)info.getAuthType()) ? (CQResponseBean)this.callByDigest(ctx, info, jsondata, true) : (AuthCQTypeEnum.jwt.equals((Object)info.getAuthType()) ? (CQResponseBean)this.callByJWT(ctx, info, jsondata, true) : (CQResponseBean)this.callByAdvance(ctx, info, jsondata, true)));
        }
        catch (EASBizException e) {
            if (null != info) {
                this.updateLogData(ctx, null, info);
            }
            this.afterLog(ctx, pk, InteCQSystemService.getExceptionStackErrorMessage((Exception)((Object)e)), CallStatusEnum.failure);
            throw e;
        }
        catch (BOSException e) {
            if (null != info) {
                this.updateLogData(ctx, null, info);
            }
            this.afterLog(ctx, pk, InteCQSystemService.getExceptionStackErrorMessage((Exception)((Object)e)), CallStatusEnum.failure);
            throw e;
        }
        catch (APIException e) {
            if (null != info) {
                this.updateLogData(ctx, e.getTokenData(), info);
            }
            this.afterLog(ctx, pk, e.getTokenRes(), CallStatusEnum.failure);
            result = (CQResponseBean)JSON.parseObject((String)e.getTokenRes(), CQResponseBean.class);
            result.setCallInfo(info);
            if (this.isNoException) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (null != info) {
                this.updateLogData(ctx, null, info);
            }
            this.afterLog(ctx, pk, InteCQSystemService.getExceptionStackErrorMessage(e), CallStatusEnum.failure);
            if (this.isNoException) {
                e.printStackTrace();
            }
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Object callByAdvance(Context ctx, APIAndCallInfo callInfo, String jsondata, boolean isTrans) throws Exception {
        this.checkData(callInfo, jsondata);
        HashMap<String, String> header = new HashMap<String, String>();
        String token = TokenManger.getInstance().getAccessToken(ctx, callInfo.getServerUrl(), callInfo.getClientId(), callInfo.getAccountId(), callInfo.getAppSecret(), callInfo.getAgentUser(), this.language, this.isTest);
        String uuid = UUID.randomUUID().toString();
        header.put("Content-Type", "application/json");
        header.put("accesstoken", token);
        header.put("Idempotency-Key", uuid);
        header.put("x-acgw-identity", callInfo.getXacgwi());
        this.updateLogData(ctx, JSONUtils.convertObjectToJson(ctx, header), callInfo);
        String responseString = HttpClientUtil.post(callInfo.getServerUrl() + callInfo.getServiceUrl(), header, jsondata);
        CQResponseBean resBean = this.convertResponse2CQResponseBean(responseString, callInfo);
        if (!"0".equals(resBean.getErrorCode())) {
            this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.failure);
            String message = InteCQConfigUtil.getErrorMsg(resBean, this.isTest);
            throw new APIException(resBean.getErrorCode(), message, JSONUtils.convertObjectToJson(ctx, header) + "\n" + jsondata, responseString);
        }
        this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.success);
        if (isTrans) {
            return resBean;
        }
        return responseString;
    }

    private Object callByJWT(Context ctx, APIAndCallInfo callInfo, String jsondata, boolean isTrans) throws Exception {
        this.checkData(callInfo, jsondata);
        String responseString = null;
        HashMap<String, String> header = new HashMap<String, String>();
        String token = TokenManger.getInstance().getIdToken(ctx, callInfo.getServerUrl(), callInfo.getClientId(), callInfo.getAccountId(), callInfo.getAppSecret(), callInfo.getAgentUser(), this.language, this.isTest);
        header.put("Content-Type", "application/json");
        header.put("client_id", callInfo.getClientId());
        header.put("accountId", callInfo.getAccountId());
        header.put("JWT", token);
        header.put("x-acgw-identity", callInfo.getXacgwi());
        this.updateLogData(ctx, JSONUtils.convertObjectToJson(ctx, header), callInfo);
        responseString = HttpClientUtil.post(callInfo.getServerUrl() + callInfo.getServiceUrl(), header, jsondata);
        CQResponseBean resBean = this.convertResponse2CQResponseBean(responseString, callInfo);
        if (!"0".equals(resBean.getErrorCode())) {
            this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.failure);
            String message = InteCQConfigUtil.getErrorMsg(resBean, this.isTest);
            throw new APIException(resBean.getErrorCode(), message, JSONUtils.convertObjectToJson(ctx, header) + "\n" + jsondata, responseString);
        }
        this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.success);
        if (isTrans) {
            return resBean;
        }
        return responseString;
    }

    private CQResponseBean convertResponse2CQResponseBean(String responseString, APIAndCallInfo callInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("res:" + responseString));
        }
        CQResponseBean cq = null;
        if (HttpClientUtil.isValidJson(responseString)) {
            cq = (CQResponseBean)JSON.parseObject((String)responseString, CQResponseBean.class);
        } else {
            cq = new CQResponseBean();
            cq.setErrorCode("500");
            cq.setMessage(responseString);
            cq.setStatus(false);
            cq.setData(null);
        }
        cq.setCallInfo(callInfo);
        return cq;
    }

    private Object callByDigest(Context ctx, APIAndCallInfo callInfo, String jsondata, boolean isTrans) throws Exception {
        this.checkData(callInfo, jsondata);
        String responseString = null;
        HashMap<String, String> header = new HashMap<String, String>();
        String uuid = UUID.randomUUID().toString();
        String timestamp = DateUtils.format(new Date(), SignUtils.SIGNATUR_TIME_FORMAT);
        StringBuilder sb = this.getSignatureString(timestamp, uuid, jsondata);
        String encyptString = SignUtils.HMACSHA256StrByKey(sb.toString(), callInfo.getDigestSecret());
        header.put("appId", callInfo.getClientId());
        header.put("user", callInfo.getAgentUser());
        header.put("timestamp", timestamp);
        header.put("signatureNonce", uuid);
        header.put("usertype", "UserName");
        header.put("accountId", callInfo.getAccountId());
        header.put("x-acgw-identity", callInfo.getXacgwi());
        header.put(SignUtils.SIGNATUR_PARAMS, encyptString);
        this.updateLogData(ctx, JSONUtils.convertObjectToJson(ctx, header), callInfo);
        responseString = HttpClientUtil.post(callInfo.getServerUrl() + callInfo.getServiceUrl(), header, jsondata);
        CQResponseBean resBean = this.convertResponse2CQResponseBean(responseString, callInfo);
        if (!"0".equals(resBean.getErrorCode())) {
            this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.failure);
            String message = InteCQConfigUtil.getErrorMsg(resBean, this.isTest);
            throw new APIException(resBean.getErrorCode(), message, JSONUtils.convertObjectToJson(ctx, header) + "\n" + jsondata, responseString);
        }
        this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.success);
        if (isTrans) {
            return resBean;
        }
        return responseString;
    }

    private CQSignResponseBean convertResponse2CQSignResponseBean(String responseString, APIAndCallInfo callInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("res:" + responseString));
        }
        CQSignResponseBean cq = null;
        if (HttpClientUtil.isValidJson(responseString)) {
            cq = (CQSignResponseBean)JSON.parseObject((String)responseString, CQSignResponseBean.class);
        } else {
            cq = new CQSignResponseBean();
            CQResponseBean cq0 = new CQResponseBean();
            cq0.setErrorCode("500");
            cq0.setMessage(responseString);
            cq0.setStatus(false);
            cq0.setData(null);
            cq0.setCallInfo(callInfo);
            cq.setData(cq0);
        }
        cq.setCallInfo(callInfo);
        return cq;
    }

    private Object callBySign(Context ctx, APIAndCallInfo callInfo, String jsondata, boolean isTrans) throws Exception {
        this.checkData(callInfo, jsondata);
        String responseString = null;
        CQResponseBean result = null;
        String resultStr = null;
        HashMap<String, String> header = new HashMap<String, String>();
        String uuid = UUID.randomUUID().toString();
        String timestamp = DateUtils.format(new Date(), SignUtils.SIGNATUR_TIME_FORMAT);
        String bosPublickBase64Key = callInfo.getCertKey();
        long encryptMethod = Integer.valueOf(callInfo.getEncryptType().getValue()).longValue();
        EncryptInfo encodeInfo = OpenApiSecurityService.encrypt(jsondata, EncryptionEnum.getEncryption(encryptMethod), bosPublickBase64Key);
        JSONObject jb = new JSONObject();
        jb.put("encryptData", (Object)encodeInfo.getEncryptInfo());
        jb.put("dgtlEnvlp", (Object)encodeInfo.getDgtlEnvlp());
        jb.put("signatureNonce", (Object)uuid);
        jb.put("timestamp", (Object)timestamp);
        String signString = jb.toJSONString();
        String sign = this.signing(callInfo.getSignSecret(), signString, uuid, timestamp);
        jb.put("signature", (Object)sign);
        String requestString = jb.toJSONString();
        header.put("Content-Type", "application/json");
        header.put("OpenApiAuth", "5");
        header.put("OpenApiSign", callInfo.getSignKey());
        header.put("x-acgw-identity", callInfo.getXacgwi());
        this.updateLogData(ctx, JSONUtils.convertObjectToJson(ctx, header) + ",body:" + requestString, callInfo);
        responseString = HttpClientUtil.post(callInfo.getServerUrl() + callInfo.getServiceUrl(), header, requestString);
        CQSignResponseBean resBean = this.convertResponse2CQSignResponseBean(responseString, callInfo);
        if (!StringUtils.isEmpty((String)resBean.getErrorCode()) && !"0".equals(resBean.getErrorCode())) {
            this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.failure);
            String message = InteCQConfigUtil.getErrorMsg(resBean, this.isTest);
            throw new APIException(resBean.getErrorCode(), message, JSONUtils.convertObjectToJson(ctx, header) + "\n" + jsondata, responseString);
        }
        this.afterLog(ctx, callInfo.getLogPK(), responseString, CallStatusEnum.success);
        String resDgtlEnvlp = resBean.getDgtlEnvlp();
        String resEncryptData = resBean.getEncryptData();
        if (!StringUtils.isEmpty((String)resEncryptData) && !StringUtils.isEmpty((String)resDgtlEnvlp)) {
            String dgtlEnvlpStr = OpenApiSecurityService.unSignByPublicKey(resDgtlEnvlp, bosPublickBase64Key);
            String decryptData = OpenApiSecurityService.decrypt(resEncryptData, EncryptionEnum.getEncryption(encryptMethod), dgtlEnvlpStr);
            CQResponseBean t = new CQResponseBean();
            Object json = JSON.parse((String)decryptData);
            if (json instanceof JSONObject && !StringUtils.isEmpty((String)((JSONObject)json).getString("errorCode"))) {
                t = (CQResponseBean)JSON.parseObject((String)decryptData, CQResponseBean.class);
            }
            if (resBean.getData() instanceof CQResponseBean) {
                t.setErrorCode(((CQResponseBean)resBean.getData()).getErrorCode());
                t.setMessage(((CQResponseBean)resBean.getData()).getMessage());
                t.setStatus(((CQResponseBean)resBean.getData()).isStatus());
                t.setData(((CQResponseBean)resBean.getData()).getData());
            } else if (resBean.getData() instanceof Map) {
                Map data = (Map)resBean.getData();
                t.setErrorCode((String)data.get("errorCode"));
                t.setMessage((String)data.get("message"));
                t.setStatus((Boolean)data.get("status"));
                t.setData(json);
            }
            t.setCallInfo(callInfo);
            result = t;
            resultStr = JSON.toJSONString((Object)t);
        } else {
            CQResponseBean t = new CQResponseBean();
            t.setCallInfo(callInfo);
            if (null != resBean.getData()) {
                Map data = (Map)resBean.getData();
                t.setErrorCode((String)data.get("errorCode"));
                t.setMessage((String)data.get("message"));
                t.setStatus((Boolean)data.get("status"));
                t.setData(data.get("data"));
            }
            result = t;
            resultStr = JSON.toJSONString((Object)t);
        }
        if (isTrans) {
            return result;
        }
        return resultStr;
    }
}

