/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.util;

import com.kingdee.shr.inte.cq.bean.EncryptInfo;
import com.kingdee.shr.inte.cq.crypto.EncryptorFactory;
import com.kingdee.shr.inte.cq.encrypt.impl.RSAEncrypterUtil;
import com.kingdee.shr.inte.cq.util.SignUtils;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class OpenApiSecurityService {
    private static int DEFAULT_RANDOM_KEY_LENGTH = 16;
    private static int DEFAULT_ENCRYPT_LENGTH = 128;
    private static Map<String, String> algorithmMap = new HashMap<String, String>();

    public static EncryptInfo encrypt(String content, String algorithm, String publicKeyBase64) throws Exception {
        String randomKey = RandomStringUtils.randomAlphabetic((int)DEFAULT_RANDOM_KEY_LENGTH);
        String result = OpenApiSecurityService.encryptOrDecrypt(true, content, algorithm, randomKey, DEFAULT_ENCRYPT_LENGTH);
        String dgtlEnvlp = "";
        if (StringUtils.isNotEmpty((CharSequence)publicKeyBase64)) {
            dgtlEnvlp = OpenApiSecurityService.signByPublicKey(randomKey, publicKeyBase64);
        }
        return EncryptInfo.valueOf(result, dgtlEnvlp);
    }

    public static String decrypt(String content, String algorithm, String randomKey) throws Exception {
        return OpenApiSecurityService.encryptOrDecrypt(false, content, algorithm, randomKey, DEFAULT_ENCRYPT_LENGTH);
    }

    public static String encryptOrDecrypt(boolean isEncrypt, String content, String algorithm, String randomKey, int encryptLength) throws Exception {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        if (!algorithmMap.containsKey(algorithm)) {
            throw new Exception("not support algorithm:" + algorithm);
        }
        if (StringUtils.isEmpty((CharSequence)randomKey)) {
            throw new Exception("not support randomKey, the randomKey is null");
        }
        if (encryptLength < DEFAULT_ENCRYPT_LENGTH) {
            throw new Exception("not support encryptLength, the length should not be less 128, encryptLength:" + encryptLength);
        }
        return isEncrypt ? EncryptorFactory.getEncryptor(algorithmMap.get(algorithm)).encrypt(content, randomKey, encryptLength) : EncryptorFactory.getEncryptor(algorithmMap.get(algorithm)).decrypt(content, randomKey, encryptLength);
    }

    public static String signByPublicKey(String content, String publicKeyBase64) throws Exception {
        String result = "";
        try {
            PublicKey publicKey = RSAEncrypterUtil.getPublicKey(publicKeyBase64);
            result = RSAEncrypterUtil.encrypt(content, publicKey);
        }
        catch (Exception e) {
            throw new Exception("signByPublicKey error:" + e.getMessage(), e);
        }
        return result;
    }

    public static String unSignByPublicKey(String content, String publicKeyBase64) throws Exception {
        String result = "";
        try {
            PublicKey publicKey = RSAEncrypterUtil.getPublicKey(publicKeyBase64);
            result = RSAEncrypterUtil.decrypt(content, publicKey);
        }
        catch (Exception e) {
            throw new Exception("unSignByPublicKey error:" + e.getMessage(), e);
        }
        return result;
    }

    private static StringBuilder getSignatureString(String datetimeString, String signatureNonce, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append(body);
        sb.append(datetimeString);
        sb.append(signatureNonce);
        return sb;
    }

    private static String signing(String appSecret, String content, String uuid, String timestamp) {
        String encyptString = "";
        try {
            StringBuilder sb = OpenApiSecurityService.getSignatureString(timestamp, uuid, content);
            encyptString = SignUtils.HMACSHA256StrByKey(sb.toString(), appSecret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encyptString;
    }

    static {
        algorithmMap.put("AES", "AES/GCM/NoPadding");
        algorithmMap.put("SM4", "SM4/GCM/NoPadding");
    }
}

