/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.util;

import com.kingdee.bos.Context;
import com.kingdee.util.Configuration;
import com.kingdee.util.LocaleUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class BOSConfigUtil {
    public static final String LANG = "lang";
    public static final String ALIAS = "alias";
    public static final String TEXT = "text";
    public static final String LOCALE = "locale";

    private BOSConfigUtil() {
    }

    public static Configuration getBosConfig() {
        return Configuration.getInstance();
    }

    public static String getOriginLocaleContextLanguage(Context ctx) {
        if (null == ctx) {
            return BOSConfigUtil.getOriginLocaleContextLanguage(LocaleUtils.getDefaultLocale());
        }
        return BOSConfigUtil.getOriginLocaleContextLanguage(ctx.getLocale());
    }

    public static String getOriginLocaleContextLanguage(Locale locale) {
        return LocaleUtils.getLocaleString((Locale)LocaleUtils.getFirstOriginLocale((Locale)locale));
    }

    public static String getCurrentContextLanguage(Context ctx) {
        if (null == ctx) {
            return BOSConfigUtil.getCurrentContextLanguage(LocaleUtils.getDefaultLocale());
        }
        return BOSConfigUtil.getCurrentContextLanguage(ctx.getLocale());
    }

    public static String getCurrentContextLanguage(Locale locale) {
        return LocaleUtils.getLocaleString((Locale)LocaleUtils.getFirstOriginLocale((Locale)locale));
    }

    public static List<Map<String, String>> getLanguageMapingList() {
        Map properties = BOSConfigUtil.getBosConfig().getConfigItem("supportlanguage").getProperties();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> each = null;
        String[] keys = null;
        for (Map.Entry key : properties.entrySet()) {
            each = new HashMap<String, String>();
            keys = ((String)key.getKey()).split("#");
            each.put(LANG, keys[0].toLowerCase());
            each.put(ALIAS, keys[1]);
            each.put(TEXT, (String)key.getValue());
            each.put(LOCALE, keys[1]);
            if ("CH".equals(keys[1]) && "L2".equalsIgnoreCase(keys[0])) {
                each.put(LOCALE, "zh_CN");
                each.put(ALIAS, "CN");
            }
            if ("en_US".equals(keys[1])) {
                each.put(ALIAS, "EN");
            }
            if ("zh_TW".equals(keys[1])) {
                each.put(ALIAS, "TW");
            }
            list.add(each);
        }
        Collections.sort(list, (Comparator)new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                if (null == o2 || null == o1) {
                    return 0;
                }
                int o1value = Integer.parseInt(o1.get(BOSConfigUtil.LANG).replace("l", ""));
                int o2value = Integer.parseInt(o2.get(BOSConfigUtil.LANG).replace("l", ""));
                return o1value - o2value;
            }
        });
        return list;
    }

    public static boolean isEnableMultiLan() {
        return BOSConfigUtil.getBosConfig().getConfigItem("supportlanguage").getProperties().size() > 1;
    }
}

