/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SHRServerResource {
    public static String getString(String resClassName, String resName, Context ctx) {
        return SHRServerResource.getString(resClassName, resName, ctx.getLocale());
    }

    public static String getString(String resClassName, String resName, Locale locale) {
        return EASResource.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    public static String getString(String resClassName, String resName, Context ctx, Object ... params) {
        return SHRServerResource.getString(resClassName, resName, ctx.getLocale(), params);
    }

    public static String getString(String resClassName, String resName, Locale locale, Object ... params) {
        String res = EASResource.getString((String)resClassName, (String)resName, (Locale)locale);
        if (StringUtils.isEmpty((String)res)) {
            return "";
        }
        return MessageFormat.format(res, params);
    }

    public static Map getFileResource(Context ctx, String pkg, String fileName) throws BOSException {
        String lan = LocaleUtils.getLocal(ctx);
        return SHRServerResource.getFileResource(ctx, pkg, fileName, lan, "wbpage");
    }

    public static Map getFileResource(Context ctx, String pkg, String fileName, String lan, String metaDataType) throws BOSException {
        return ResourceFacadeFactory.getLocalInstance((Context)ctx).getFileResource(pkg, fileName, lan, metaDataType);
    }

    public static Map getFileResource(Context ctx, String pkg, String fileName, String metaDataType) throws BOSException {
        String lan = LocaleUtils.getLocal(ctx);
        return SHRServerResource.getFileResource(ctx, pkg, fileName, lan, metaDataType);
    }

    public static Map<String, Map<String, String>> getFileResourceMulti(Context ctx, String pkg, String fileName, String metaDataType) throws BOSException {
        if (StringUtils.isEmpty((String)pkg) || StringUtils.isEmpty((String)fileName) || StringUtils.isEmpty((String)metaDataType)) {
            return Collections.EMPTY_MAP;
        }
        pkg = pkg.replace(".", "\\");
        List<Map<String, String>> lml = BOSConfigUtil.getLanguageMapingList();
        Map<String, String> lang = null;
        Map each = null;
        HashMap<String, Map<String, String>> m = new HashMap<String, Map<String, String>>();
        int total = lml.size();
        for (int i = 0; i < total; ++i) {
            lang = lml.get(i);
            each = SHRServerResource.getFileResource(ctx, pkg, fileName, lang.get("locale"), metaDataType);
            SHRServerResource.handlerData(each, m, lang.get("locale"));
        }
        return m;
    }

    private static void handlerData(Map ml, Map<String, Map<String, String>> m, String displayName) {
        if (null == ml || ml.size() <= 0) {
            return;
        }
        Map t = ml;
        Map<String, String> lan = null;
        for (Map.Entry entry : t.entrySet()) {
            lan = m.get(entry.getKey());
            if (null == lan) {
                lan = new HashMap<String, String>();
                m.put((String)entry.getKey(), lan);
            }
            if (!StringUtils.isEmpty((String)lan.get(displayName))) continue;
            lan.put(displayName, (String)entry.getValue());
        }
    }
}

