/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public final class TimeZoneTransfer {
    public static String timeZoneTransfer(String dateTime, String pattern, String currentTimeZone, String targetTimeZone) throws BOSException {
        Date date;
        if (StringUtils.isEmpty((String)dateTime)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(MessageFormat.format("{0}{1}", "GMT", currentTimeZone)));
        try {
            date = simpleDateFormat.parse(dateTime);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(MessageFormat.format("{0}{1}", "GMT", targetTimeZone)));
        return simpleDateFormat.format(date);
    }

    public static Date timeZoneTrans(Date sourceDate, TimeZone timeZone) {
        if (null == sourceDate || null == timeZone) {
            return sourceDate;
        }
        return new Date(sourceDate.getTime() + (long)timeZone.getRawOffset() - (long)TimeZone.getDefault().getRawOffset());
    }

    public static Date timeZoneTrans(String sourceDate, TimeZone timeZone) throws ParseException {
        return TimeZoneTransfer.timeZoneTrans(sourceDate, timeZone, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date timeZoneTrans(String sourceDate, TimeZone timeZone, String fmt) throws ParseException {
        if (StringUtils.isEmpty((String)sourceDate) || null == timeZone) {
            return null;
        }
        if (StringUtils.isEmpty((String)fmt)) {
            fmt = "yyyy-MM-dd HH:mm:ss";
        }
        Date d = DateTimeUtils.parseDate((String)sourceDate, (String)fmt);
        return TimeZoneTransfer.timeZoneTrans(d, timeZone);
    }

    public static String format(Context ctx, String dateType, Date date, boolean isAutoTimeZoneTrans, boolean isRemoveSeconds, boolean isRemoveDay) throws EASBizException, BOSException {
        SimpleDateFormat format = null;
        TimeZone timeZone = null;
        TimeZoneInfo timezoneInfo = null;
        Date value0 = null;
        Map formatAndTimeZone = UserNantionalUtil.getUserNationalFormat(ctx);
        format = DataType.TIME.getName().equalsIgnoreCase(dateType) ? (SimpleDateFormat)formatAndTimeZone.get("timeFormat") : (DataType.TIMESTAMP.getName().equalsIgnoreCase(dateType) ? (SimpleDateFormat)formatAndTimeZone.get("dateTimeFormat") : (SimpleDateFormat)formatAndTimeZone.get("dateFormat"));
        timezoneInfo = (TimeZoneInfo)formatAndTimeZone.get("timezoneInfo");
        timeZone = UserNantionalUtil.getTimeZoneIDForSunJDK(ctx, timezoneInfo);
        if (DataType.TIMESTAMP.getName().equalsIgnoreCase(dateType) || DataType.TIME.getName().equalsIgnoreCase(dateType)) {
            if (UserNantionalUtil.isShowTimeZoneForCtrl(ctx) && isAutoTimeZoneTrans) {
                value0 = TimeZoneTransfer.timeZoneTrans(date, timeZone);
                return MessageFormat.format("{0}{1} {2}", timezoneInfo.getTimeZoneStandard().getValue(), UserNantionalUtil.getTimeZoneDiffStringValue(timezoneInfo.getTimeDiff().getValue()), TimeZoneTransfer.format(ctx, dateType, format, value0, isRemoveSeconds, isRemoveDay));
            }
            return TimeZoneTransfer.format(ctx, dateType, format, date, isRemoveSeconds, isRemoveDay);
        }
        return TimeZoneTransfer.format(ctx, dateType, format, date, isRemoveSeconds, isRemoveDay);
    }

    private static String format(Context ctx, String dateType, SimpleDateFormat format, Date date, boolean isRemoveSeconds, boolean isRemoveDay) {
        String format0 = format.toPattern();
        String tempFormat = format0.toLowerCase();
        SimpleDateFormat sdf = null;
        if (DataType.TIME.getName().equalsIgnoreCase(dateType) || DataType.TIMESTAMP.getName().equalsIgnoreCase(dateType)) {
            if (isRemoveSeconds) {
                format0 = format0.substring(0, tempFormat.indexOf("ss") - 1);
            }
        } else if (isRemoveDay) {
            format0 = TimeZoneTransfer.getFormatWithoutDay(format0);
        }
        sdf = new SimpleDateFormat(format0, ctx.getOriginLocale());
        return sdf.format(date);
    }

    public static String getFormatWithoutDay(String format0) {
        String tempFormat = format0.toLowerCase();
        Object sdf = null;
        int ddIndex = tempFormat.indexOf("dd");
        int ddLength = 2;
        if (ddIndex == -1) {
            ddIndex = tempFormat.indexOf("d");
            ddLength = 1;
        }
        if (ddIndex != -1) {
            if (ddIndex == 0) {
                format0 = format0.substring(ddIndex + ddLength + 1);
            } else {
                String pre = format0.substring(0, ddIndex - 1);
                String after = format0.substring(ddIndex + ddLength);
                format0 = pre;
                if (!StringUtils.isEmpty((String)after)) {
                    format0 = MessageFormat.format("{0}{1}", pre, after);
                }
            }
        }
        return format0;
    }
}

