/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ueditor;

import com.kingdee.shr.ueditor.util.StreamReleaseUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UeditorConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(UeditorConfigManager.class);
    private final String rootPath;
    private static final String CONFIG_PATH = "jslib" + File.separator + "ueditor" + File.separator;
    private static final String CONFIG_FILE_NAME = "shrUeditorConfig.json";
    private String parentPath = null;
    private JSONObject jsonConfig = null;
    private static final String FILE_NAME = "{fileName}";

    public UeditorConfigManager(String rootPath) throws IOException {
        this.rootPath = rootPath.replace("\\", "/");
        this.initEnv();
    }

    public static UeditorConfigManager getInstance(String rootPath) {
        try {
            return new UeditorConfigManager(rootPath);
        }
        catch (Exception var4) {
            logger.error(var4.getMessage(), (Throwable)var4);
            return null;
        }
    }

    public boolean valid() {
        return this.jsonConfig != null;
    }

    public JSONObject getAllConfig() {
        return this.jsonConfig;
    }

    public Map<String, Object> getConfig(String appName, String domainVal, String noRename, String fileName) throws JSONException {
        String savePath = null;
        String imageRenamePath = null;
        fileName = this.filter(fileName).substring(0, fileName.lastIndexOf("."));
        if (Objects.isNull(appName) || Objects.isNull(domainVal)) {
            savePath = this.jsonConfig.getString("imagePathDefault").replace(FILE_NAME, fileName);
            imageRenamePath = this.jsonConfig.getString("imageRenamePathDefault").replace(FILE_NAME, fileName);
        } else {
            appName = this.filter(appName);
            domainVal = this.filter(domainVal);
            savePath = this.jsonConfig.getString("imagePathFormat").replace("{domainVal}", domainVal).replace(FILE_NAME, fileName).replace("{appName}", appName);
            imageRenamePath = this.jsonConfig.getString("imageRenamePath").replace("{domainVal}", domainVal).replace(FILE_NAME, fileName).replace("{appName}", appName);
        }
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("isBase64", "false");
        conf.put("maxSize", this.jsonConfig.getLong("imageMaxSize"));
        conf.put("allowFiles", this.getArray("imageAllowFiles"));
        conf.put("fieldName", this.jsonConfig.getString("imageFieldName"));
        conf.put("savePath", savePath);
        conf.put("imageRenamePath", imageRenamePath);
        conf.put("rootPath", this.rootPath);
        conf.put("noRename", noRename);
        return conf;
    }

    private void initEnv() throws IOException {
        StringBuilder rootPathStr = new StringBuilder().append(this.rootPath);
        this.parentPath = rootPathStr.append(CONFIG_PATH).toString();
        String configContent = this.readFile(this.getConfigPath());
        try {
            this.jsonConfig = new JSONObject(configContent);
        }
        catch (Exception var3) {
            this.jsonConfig = null;
        }
    }

    private String getConfigPath() {
        return this.parentPath + File.separator + CONFIG_FILE_NAME;
    }

    private String[] getArray(String key) throws JSONException {
        JSONArray jsonArray = this.jsonConfig.getJSONArray(key);
        String[] result = new String[jsonArray.length()];
        int len = jsonArray.length();
        for (int i = 0; i < len; ++i) {
            result[i] = jsonArray.getString(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String path) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = null;
        BufferedReader bfReader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            bfReader = new BufferedReader(reader);
            String tmpContent = null;
            while ((tmpContent = bfReader.readLine()) != null) {
                builder.append(tmpContent);
            }
        }
        catch (UnsupportedEncodingException var9) {
            try {
                logger.error(var9.getMessage(), (Throwable)var9);
            }
            catch (Throwable throwable) {
                StreamReleaseUtil.safeClose(reader);
                StreamReleaseUtil.safeClose(bfReader);
                throw throwable;
            }
            StreamReleaseUtil.safeClose(reader);
            StreamReleaseUtil.safeClose(bfReader);
        }
        StreamReleaseUtil.safeClose(reader);
        StreamReleaseUtil.safeClose(bfReader);
        return this.filter(builder.toString());
    }

    private String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }
}

