/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ueditor.upload;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.ueditor.PathFormat;
import com.kingdee.shr.ueditor.define.BaseState;
import com.kingdee.shr.ueditor.define.FileType;
import com.kingdee.shr.ueditor.define.State;
import com.kingdee.shr.ueditor.util.RandomUtil;
import com.kingdee.shr.ueditor.util.StreamReleaseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;

public class Uploader {
    private static Logger logger = Logger.getLogger(Uploader.class);
    private Map<String, Object> conf = null;
    private boolean isAjaxUpload;
    private Map<String, MultipartFile> fileMap = null;

    public Uploader(Map<String, Object> conf, boolean isAjaxUpload, Map<String, MultipartFile> fileMap) {
        this.isAjaxUpload = isAjaxUpload;
        this.conf = conf;
        this.fileMap = fileMap;
    }

    public final State doExec() {
        return Uploader.save(this.fileMap, this.conf, this.isAjaxUpload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static State save(Map<String, MultipartFile> fileMap, Map<String, Object> conf, boolean isAjaxUpload) {
        State var14;
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        InputStream is = null;
        try {
            String physicalPath;
            State storageState;
            String originFileName = null;
            for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
                MultipartFile mf = entity.getValue();
                originFileName = mf.getOriginalFilename();
                is = mf.getInputStream();
            }
            if (is == null) {
                BaseState var8 = new BaseState(false, 7);
                return var8;
            }
            String savePath = (String)conf.get("savePath");
            assert (originFileName != null);
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            long maxSize = (Long)conf.get("maxSize");
            if (!Uploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                BaseState baseState = new BaseState(false, 8);
                StreamReleaseUtil.safeClose(is);
                return baseState;
            }
            savePath = savePath.replace(savePath.substring(savePath.lastIndexOf(".")), suffix);
            if ((savePath = PathFormat.parse(savePath, originFileName)).startsWith("/")) {
                savePath = savePath.substring(1);
            }
            if ((storageState = Uploader.saveFileByInputStream(is, physicalPath = conf.get("rootPath") + savePath, maxSize)).isSuccess()) {
                storageState.putInfo("url", PathFormat.format(savePath));
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            var14 = storageState;
            StreamReleaseUtil.safeClose(is);
        }
        catch (IOException var18) {
            logger.error((Object)var18.getMessage(), (Throwable)var18);
            BaseState baseState = new BaseState(false, 4);
            return baseState;
        }
        finally {
            StreamReleaseUtil.safeClose(is);
        }
        return var14;
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static State saveFileByInputStream(InputStream is, String path, long maxSize) {
        State var11;
        BufferedOutputStream bos;
        FileOutputStream fileOutputStream;
        BufferedInputStream bis;
        File tmpFile;
        State state;
        block8: {
            int count;
            state = null;
            tmpFile = Uploader.getTmpFile();
            byte[] dataBuf = new byte[2048];
            bis = null;
            fileOutputStream = null;
            bos = null;
            bis = new BufferedInputStream(is, 8192);
            fileOutputStream = new FileOutputStream(tmpFile);
            bos = new BufferedOutputStream(fileOutputStream, 8192);
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            if (tmpFile.length() <= maxSize) break block8;
            tmpFile.delete();
            BaseState baseState = new BaseState(false, 1);
            StreamReleaseUtil.safeClose(is);
            StreamReleaseUtil.safeClose(bos);
            StreamReleaseUtil.safeClose(fileOutputStream);
            StreamReleaseUtil.safeClose(bis);
            return baseState;
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                boolean bl = file.delete();
            }
            if (!(state = Uploader.saveTmpFile(tmpFile, path)).isSuccess()) {
                tmpFile.delete();
            }
            var11 = state;
        }
        catch (IOException var15) {
            BaseState baseState;
            try {
                baseState = new BaseState(false, 4);
            }
            catch (Throwable throwable) {
                StreamReleaseUtil.safeClose(is);
                StreamReleaseUtil.safeClose(bos);
                StreamReleaseUtil.safeClose(fileOutputStream);
                StreamReleaseUtil.safeClose(bis);
                throw throwable;
            }
            StreamReleaseUtil.safeClose(is);
            StreamReleaseUtil.safeClose(bos);
            StreamReleaseUtil.safeClose(fileOutputStream);
            StreamReleaseUtil.safeClose(bis);
            return baseState;
        }
        StreamReleaseUtil.safeClose(is);
        StreamReleaseUtil.safeClose(bos);
        StreamReleaseUtil.safeClose(fileOutputStream);
        StreamReleaseUtil.safeClose(bis);
        return var11;
    }

    private static State saveTmpFile(File tmpFile, String path) {
        BaseState state = null;
        File targetFile = new File(path);
        try {
            if (targetFile.canWrite()) {
                return new BaseState(false, 2);
            }
            FileUtils.copyFile((File)tmpFile, (File)targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BaseState(false, 2);
        }
        state = new BaseState(true);
        state.putInfo("size", targetFile.length());
        state.putInfo("title", targetFile.getName());
        return state;
    }

    private static File getTmpFile() {
        File tmpDir = Uploader.getTempDirectory();
        Double nonce = RandomUtil.getRandomDouble();
        String tmpFileName = (nonce * 10000.0 + "").replace(".", "");
        String file = tmpDir.getAbsolutePath() + File.separator + tmpFileName;
        return new File(SHRCheck.checkFilePath(file));
    }

    public static File getTempDirectory() {
        return new File(SHRCheck.checkFilePath(Uploader.getTempDirectoryPath()));
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }
}

