/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.app.datatable;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.validaterule.app.datatable.AbstractDataStagTableControllerBean;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableFactory;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableHisCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableHisFactory;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableHisInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMRCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMRHisCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMRHisInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMRInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMatchFieldCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMatchFieldHisCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMatchFieldHisInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableMatchFieldInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableResultCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableResultHisCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableResultHisInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableResultInfo;
import com.kingdee.shr.validaterule.app.datatable.IDataStagTableHis;
import com.kingdee.shr.validaterule.app.datatable.MatchRule;
import com.kingdee.shr.validaterule.exception.DataStagTableException;
import com.kingdee.shr.validaterule.util.DateUtil;
import com.kingdee.util.LocaleUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class DataStagTableControllerBean
extends AbstractDataStagTableControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.app.datatable.DataStagTableControllerBean");
    protected List<String> updateFields = Lists.newArrayList();
    protected List<Object[]> updateFieldsParam = Lists.newArrayList();
    protected List<Object[]> updateHisFieldsParam = Lists.newArrayList();

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameNumber(ctx, model);
        DataStagTableInfo dataTableInfo = (DataStagTableInfo)model;
        boolean isChangeDate = this.handleDate(ctx, dataTableInfo);
        boolean isAddNew = dataTableInfo.getId() == null;
        IObjectPK pk = super._save(ctx, model);
        this.handleTableField(ctx, dataTableInfo);
        this.handleHistory(ctx, dataTableInfo, isChangeDate, isAddNew);
        this.handleMrData(ctx, "T_HR_SDataStagTableMR", this.updateFieldsParam);
        return pk;
    }

    protected void checkNameNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
    }

    protected void handleTableField(Context ctx, DataStagTableInfo dataTableInfo) {
        DataStagTableMatchFieldCollection matchField = dataTableInfo.getMatchField();
        int size = matchField.size();
        for (int i = 0; i < size; ++i) {
            DataStagTableMatchFieldInfo matchFieldInfo = matchField.get(i);
            this.addMatchFieldColumn(ctx, matchFieldInfo);
            MatchRule matchRule = matchFieldInfo.getType();
            int tN = matchFieldInfo.getT_n();
            if (MatchRule.ExactMatch == matchRule) {
                this.updateFields.add("t_" + tN);
                continue;
            }
            this.updateFields.add("tl_" + tN);
            this.updateFields.add("tr_" + tN);
        }
        DataStagTableResultCollection result = dataTableInfo.getResult();
        int size2 = result.size();
        for (int i = 0; i < size2; ++i) {
            DataStagTableResultInfo resultInfo = result.get(i);
            this.addResultFieldColumn(ctx, resultInfo);
            this.updateFields.add("r_" + resultInfo.getR_n());
        }
    }

    protected void addMatchFieldColumn(Context ctx, DataStagTableMatchFieldInfo matchFieldInfo) {
        int tN = matchFieldInfo.getT_n();
        MatchRule matchRule = matchFieldInfo.getType();
        try {
            if (MatchRule.ExactMatch == matchRule) {
                this.addColumn(ctx, "T_HR_SDataStagTableMR", "t_" + tN, "nvarchar(255)");
                this.addColumn(ctx, "T_HR_SDataStagTableMRHis", "t_" + tN, "nvarchar(255)");
            } else {
                this.addColumn(ctx, "T_HR_SDataStagTableMR", "tl_" + tN, "numeric(20,10)");
                this.addColumn(ctx, "T_HR_SDataStagTableMRHis", "tl_" + tN, "numeric(20,10)");
                this.addColumn(ctx, "T_HR_SDataStagTableMR", "tr_" + tN, "numeric(20,10)");
                this.addColumn(ctx, "T_HR_SDataStagTableMRHis", "tr_" + tN, "numeric(20,10)");
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void addResultFieldColumn(Context ctx, DataStagTableResultInfo resultInfo) {
        int rN = resultInfo.getR_n();
        try {
            this.addColumn(ctx, "T_HR_SDataStagTableMR", "r_" + rN, "nvarchar(255)");
            this.addColumn(ctx, "T_HR_SDataStagTableMRHis", "r_" + rN, "nvarchar(255)");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void addColumn(Context ctx, String tableName, String field, String type) throws BOSException {
        String sql = "If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + field + "' and KSQL_COL_TABNAME='" + tableName + "')alter table " + tableName + " add " + field + " " + type;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected boolean handleDate(Context ctx, DataStagTableInfo dataTableInfo) throws BOSException, EASBizException {
        Date leffectDate = dataTableInfo.getLeffectDate();
        if (null == leffectDate) {
            dataTableInfo.setLeffectDate(DateUtil.getMaxEndDate());
            return true;
        }
        Date effectDateNew = dataTableInfo.getEffectDate();
        String tableId = dataTableInfo.getId().toString();
        DataStagTableInfo infoOld = DataStagTableFactory.getLocalInstance(ctx).getDataStagTableInfo("select id,effectDate where id = '" + tableId + "'");
        Date effectDateCur = infoOld.getEffectDate();
        if (effectDateCur.after(effectDateNew)) {
            throw new DataStagTableException(DataStagTableException.EFFECTDAY);
        }
        return effectDateNew.after(effectDateCur);
    }

    protected void handleHistory(Context ctx, DataStagTableInfo dataTableInfo, boolean isChangeDate, boolean isAddNew) throws BOSException, EASBizException {
        IDataStagTableHis iTableHis = DataStagTableHisFactory.getLocalInstance(ctx);
        DataStagTableHisInfo tableHisInfo = null;
        if (!isAddNew) {
            String oql = "select id,effectDate,leffectDate,matchField.id,result.id where historyRelateID = '" + dataTableInfo.getId().toString() + "' order by effectDate desc";
            DataStagTableHisCollection tableHisCollection = iTableHis.getDataStagTableHisCollection(oql);
            tableHisInfo = tableHisCollection.get(0);
            if (isChangeDate) {
                tableHisInfo.setLeffectDate(DateUtil.getAddDate(dataTableInfo.getEffectDate(), -1));
                SelectorItemCollection sel = new SelectorItemCollection();
                sel.add("leffectDate");
                iTableHis.updatePartial(tableHisInfo, sel);
            } else {
                iTableHis.delete("where id = '" + tableHisInfo.getId().toString() + "'");
            }
        }
        BOSUuid tableHisInfoId = null;
        tableHisInfo = new DataStagTableHisInfo();
        BOSUuid tableId = null != dataTableInfo.getId() ? dataTableInfo.getId() : BOSUuid.create((BOSObjectType)dataTableInfo.getBOSType());
        dataTableInfo.setId(tableId);
        BeanUtils.copyProperties((Object)dataTableInfo, (Object)tableHisInfo);
        tableHisInfo.setHistoryRelateID(tableId.toString());
        tableHisInfo.setName(dataTableInfo.getName(LocaleUtils.locale_en_US), LocaleUtils.locale_en_US);
        tableHisInfo.setName(dataTableInfo.getName(LocaleUtils.locale_zh_CN), LocaleUtils.locale_zh_CN);
        tableHisInfo.setName(dataTableInfo.getName(LocaleUtils.locale_zh_TW), LocaleUtils.locale_zh_TW);
        tableHisInfo.setId(null == tableHisInfoId ? BOSUuid.create((BOSObjectType)tableHisInfo.getBOSType()) : tableHisInfoId);
        this.assembleMatchFieldHis(ctx, dataTableInfo.getMatchField(), tableHisInfo);
        this.assembleResultHis(ctx, dataTableInfo.getResult(), tableHisInfo);
        this.assembleMRHis(ctx, dataTableInfo.getData(), tableHisInfo);
        iTableHis.save((CoreBaseInfo)tableHisInfo);
        this.handleMrData(ctx, "T_HR_SDataStagTableMRHis", this.updateHisFieldsParam);
    }

    protected void handleMrData(Context ctx, String tableName, List<Object[]> params) {
        try {
            StringBuilder sql = new StringBuilder("update " + tableName + " set ");
            this.updateFields.forEach(field -> sql.append(", ").append((String)field).append(" = ?"));
            sql.append(" where fid = ?");
            if (this.updateFields.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql.toString().replaceFirst(",", ""), params);
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    protected void assembleMRHis(Context ctx, DataStagTableMRCollection data, DataStagTableHisInfo tableHisInfo) {
        DataStagTableMRHisCollection dataHis = tableHisInfo.getData();
        for (int i = 0; i < data.size(); ++i) {
            DataStagTableMRInfo tableMRInfo = data.get(i);
            DataStagTableMRHisInfo mrHisInfo = new DataStagTableMRHisInfo();
            Object[] updateParam = this.assembleMrUpdateParam(tableMRInfo);
            BeanUtils.copyProperties((Object)tableMRInfo, (Object)mrHisInfo);
            mrHisInfo.setDataTable(tableHisInfo);
            BOSUuid hisid = BOSUuid.create((BOSObjectType)mrHisInfo.getBOSType());
            mrHisInfo.setId(hisid);
            Object[] updateHisParam = new Object[updateParam.length];
            System.arraycopy(updateParam, 0, updateHisParam, 0, updateParam.length);
            updateHisParam[this.updateFields.size()] = hisid.toString();
            this.updateHisFieldsParam.add(updateHisParam);
            BOSUuid id = tableMRInfo.getId();
            if (null == id) {
                id = BOSUuid.create((BOSObjectType)tableMRInfo.getBOSType());
                tableMRInfo.setId(id);
            }
            updateParam[this.updateFields.size()] = id.toString();
            this.updateFieldsParam.add(updateParam);
            dataHis.add(mrHisInfo);
        }
    }

    protected Object[] assembleMrUpdateParam(DataStagTableMRInfo mrInfo) {
        int size = this.updateFields.size();
        Object[] updateParam = new Object[size + 1];
        for (int i = 0; i < size; ++i) {
            updateParam[i] = mrInfo.get(this.updateFields.get(i));
        }
        return updateParam;
    }

    protected void assembleMatchFieldHis(Context ctx, DataStagTableMatchFieldCollection matchField, DataStagTableHisInfo tableHisInfo) {
        DataStagTableMatchFieldHisCollection matchFieldHis = tableHisInfo.getMatchField();
        if (matchField != null && matchField.size() > 0) {
            int size = matchField.size();
            for (int i = 0; i < size; ++i) {
                DataStagTableMatchFieldInfo matchFieldInfo = matchField.get(i);
                DataStagTableMatchFieldHisInfo matchFieldHisInfo = new DataStagTableMatchFieldHisInfo();
                BeanUtils.copyProperties((Object)matchFieldInfo, (Object)matchFieldHisInfo);
                matchFieldHisInfo.setDataTable(tableHisInfo);
                matchFieldHisInfo.setId(null);
                matchFieldHis.add(matchFieldHisInfo);
            }
        }
    }

    protected void assembleResultHis(Context ctx, DataStagTableResultCollection result, DataStagTableHisInfo tableHisInfo) {
        DataStagTableResultHisCollection resultHis = tableHisInfo.getResult();
        if (result != null && result.size() > 0) {
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                DataStagTableResultInfo dataStagTableResultInfo = result.get(i);
                DataStagTableResultHisInfo resultHisInfo = new DataStagTableResultHisInfo();
                BeanUtils.copyProperties((Object)dataStagTableResultInfo, (Object)resultHisInfo);
                resultHisInfo.setDataTable(tableHisInfo);
                resultHisInfo.setId(null);
                resultHis.add(resultHisInfo);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkState(ctx, pk.toString(), StateEnum.DISABLE);
        super._delete(ctx, pk);
        DataStagTableHisFactory.getLocalInstance(ctx).delete("where historyRelateID = '" + pk.toString() + "'");
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.checkState(ctx, id, StateEnum.DISABLE);
        this.checkEntry(ctx, id);
        this.doState(ctx, id, StateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.checkState(ctx, id, StateEnum.ENABLE);
        this.doState(ctx, id, StateEnum.DISABLE);
    }

    private void doState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        DataStagTableInfo updateModel = new DataStagTableInfo();
        updateModel.setId(BOSUuid.read((String)id));
        updateModel.setState(state);
        updateModel.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        updateModel.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        this.updatePartial(ctx, updateModel, selector);
        DbUtil.execute((Context)ctx, (String)"update T_HR_SDataStagTableHis set fstate = ? where FHistoryRelateID = ?", (Object[])new Object[]{state.getValue(), id});
    }

    protected void checkState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        if (!this._exists(ctx, "where id='" + id + "' and state = " + state.getValue())) {
            throw new DataStagTableException(DataStagTableException.SELECTSTATEDATA, new Object[]{state.getAlias()});
        }
    }

    protected void checkEntry(Context ctx, String id) throws BOSException, EASBizException {
        DataStagTableInfo dataStagTableInfo = this.getDataStagTableInfo(ctx, "select id, matchField.id,result.id,data.id where id ='" + id + "'");
        if (dataStagTableInfo.getMatchField().size() == 0 || dataStagTableInfo.getResult().size() == 0) {
            throw new DataStagTableException(DataStagTableException.NOENTRY);
        }
        if (dataStagTableInfo.getData().size() == 0) {
            throw new DataStagTableException(DataStagTableException.NODATA);
        }
    }
}

