/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class RollFileOuputStream
extends OutputStream {
    private static final int MAX_FILESIZE = 0x200000;
    private static final int MAX_BACKUP = 10;
    private FileOutputStream fileOut;
    private String filename;
    private File originalFile;
    private int fileSize = 0;

    public RollFileOuputStream(String fileName) throws IOException {
        this.filename = fileName;
        this.originalFile = new File(fileName);
        if (!this.originalFile.getParentFile().exists()) {
            this.originalFile.getParentFile().mkdirs();
        }
        if (this.originalFile.exists()) {
            FileInputStream input = new FileInputStream(this.originalFile);
            this.fileSize = input.available();
            input.close();
            this.fileOut = new FileOutputStream(this.originalFile, true);
        } else {
            this.fileOut = new FileOutputStream(this.originalFile, false);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.fileOut == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        try {
            RollFileOuputStream rollFileOuputStream = this;
            synchronized (rollFileOuputStream) {
                this.ensureOpen();
                this.fileOut.write(b);
                ++this.fileSize;
                if (b == 10) {
                    this.fileOut.flush();
                    if (this.fileSize >= 0x200000) {
                        this.rollFile();
                    }
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
    }

    private void rollFile() throws IOException {
        File target;
        File file = new File(this.filename + '.' + 10);
        if (file.exists()) {
            file.delete();
        }
        for (int i = 9; i >= 1; --i) {
            file = new File(this.filename + "." + i);
            if (!file.exists()) continue;
            target = new File(this.filename + '.' + (i + 1));
            file.renameTo(target);
        }
        target = new File(this.filename + "." + 1);
        this.fileOut.close();
        file = new File(this.filename);
        file.renameTo(target);
        this.fileOut = new FileOutputStream(this.originalFile, false);
        this.fileSize = 0;
    }
}

