/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.config;

import com.kingdee.eas.client.startup.exception.ClientConfigException;
import com.kingdee.eas.client.startup.exception.ConfigFileReadException;
import com.kingdee.eas.client.startup.util.PropertiesUtils;
import com.kingdee.eas.client.startup.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class ClientConfigUtil {
    private static final String VM_ARG_VALUE_REF = "vmboot.ArgValue";
    private static Properties bootProps = new Properties();
    private static String[] args;
    private static final File vmPropsFile;
    private static String applicationClassname;
    private static boolean ondemandUpdate;
    private static int waittime;
    private static String localDirPath;
    private static File localDirFile;
    private static String updateUrl;
    private static String updateServer;

    private ClientConfigUtil() {
    }

    public static void init(String easHome, String updateServerAddr, String easServer, String ondemandupdate) {
        args = new String[]{easHome, updateServerAddr, easServer, ondemandupdate};
        ClientConfigUtil.loadCofig();
        ClientConfigUtil.checkAndInit();
    }

    private static void loadCofig() {
        Properties vmprops = new Properties();
        try {
            FileInputStream input = new FileInputStream(vmPropsFile);
            PropertiesUtils.load(vmprops, input);
            input.close();
        }
        catch (IOException e) {
            throw new ConfigFileReadException(vmPropsFile, (Throwable)e);
        }
        if (vmprops.size() == 0) {
            throw new ClientConfigException("\u914d\u7f6e\u6587\u4ef6" + vmPropsFile.getAbsolutePath() + "\u975e\u6cd5,\u5185\u5bb9\u4e3a\u7a7a");
        }
        String argValue = vmprops.getProperty(VM_ARG_VALUE_REF);
        if (StringUtil.isEmptyValue(argValue)) {
            throw new ClientConfigException("\u914d\u7f6e\u6587\u4ef6" + vmPropsFile.getAbsolutePath() + "\u4e2d\u7684\u914d\u7f6e" + VM_ARG_VALUE_REF + "\u503c\u4e3a\u7a7a");
        }
        String[] argRefs = argValue.split(";");
        if (argRefs.length > args.length) {
            throw new ClientConfigException("Command line args less than vmboot.argValue in vmoptions!");
        }
        for (int i = 0; i < argRefs.length; ++i) {
            vmprops.setProperty(argRefs[i], PropertiesUtils.unescape(args[i]));
        }
        PropertiesUtils.expandProperties(vmprops);
        Properties bootstrapperProps = PropertiesUtils.getPropertiesWithPrefix("vmboot.", vmprops);
        bootProps.putAll((Map<?, ?>)bootstrapperProps);
        Properties applicationsProperties = PropertiesUtils.getPropertiesWithoutPrefix("vmboot.", vmprops);
        System.getProperties().putAll((Map<?, ?>)applicationsProperties);
        ClientConfigUtil.loginfo("~~~~~~~~~~~~Application properties");
        Enumeration<?> en = applicationsProperties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            ClientConfigUtil.loginfo("\t" + key + "=" + applicationsProperties.getProperty(key));
        }
        ClientConfigUtil.loginfo("-----------------------------------------------");
        ClientConfigUtil.loginfo("~~~~~~~~~~~~Vmboot properties");
        Enumeration<?> fn = bootstrapperProps.propertyNames();
        while (fn.hasMoreElements()) {
            String key = (String)fn.nextElement();
            ClientConfigUtil.loginfo("\t" + key + "=" + bootstrapperProps.getProperty(key));
        }
        ClientConfigUtil.loginfo("-----------------------------------------------");
    }

    private static void loginfo(String string) {
        System.out.println(string);
    }

    private static void checkAndInit() {
        applicationClassname = bootProps.getProperty("vmboot.MainClass");
        ondemandUpdate = Boolean.parseBoolean(args[3].trim());
        updateUrl = "http://" + System.getProperty("UPDATE_SERVER_ADDR") + "/easupdater";
        updateUrl = ClientConfigUtil.makePathEndWithSlash(updateUrl);
        waittime = Integer.parseInt(bootProps.getProperty("vmboot.SocketTimeOut", "60"));
        localDirPath = bootProps.getProperty("vmboot.LocalDir");
        localDirPath = ClientConfigUtil.makePathEndWithSlash(localDirPath);
        System.setProperty("vmboot.LocalDir", localDirPath);
        localDirFile = new File(localDirPath);
        updateServer = System.getProperty("UPDATE_SERVER");
        updateServer = ClientConfigUtil.makePathEndWithSlash(updateServer);
        System.setProperty("UPDATE_SERVER", updateServer);
    }

    private static String makePathEndWithSlash(String path) {
        if (StringUtil.isEmptyValue(path)) {
            throw new IllegalArgumentException("path is '" + path + "'");
        }
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }

    public static String getApplicationClassname() {
        return applicationClassname;
    }

    public static boolean isOndemandUpdate() {
        return ondemandUpdate;
    }

    public static int getWaittime() {
        return waittime;
    }

    public static String getLocalDirPath() {
        return localDirPath;
    }

    public static File getLocalDirFile() {
        return localDirFile;
    }

    public static String getUpdateUrl() {
        return updateUrl;
    }

    public static String getUpdateServer() {
        return updateServer;
    }

    public static void changeUpdateServer(String newUpdateServer) {
        ClientConfigUtil.loginfo("\u65b0\u7684\u66f4\u65b0\u5730\u5740\u4e3a" + newUpdateServer);
        updateServer = newUpdateServer;
    }

    static {
        vmPropsFile = new File("./client.vmoptions");
    }
}

