/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.download.DownloadResult;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.handler.UpdateHandler;
import com.kingdee.eas.client.startup.update.model.UpdateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class BatchUpdater {
    private UpdateHandler handler;
    protected static final Logger logger = ClientStartLogger.getLogger();
    protected UpdateModel model;

    BatchUpdater(UpdateModel model, UpdateHandler handler) {
        this.model = model;
        this.handler = handler;
    }

    void update() {
        String logTitle = "[" + this.handler.getName() + "] ";
        if (this.model.getNeedUpdate().isEmpty()) {
            return;
        }
        if (!this.handler.isAvailable()) {
            return;
        }
        HashMap<HttpFileInfo, EASClientFile> file2Resurce = new HashMap<HttpFileInfo, EASClientFile>();
        ArrayList<HttpFileInfo> file2Download = new ArrayList<HttpFileInfo>();
        for (EASClientFile entryInfo : this.model.getNeedUpdate()) {
            HttpFileInfo file = this.convert2Download(entryInfo);
            if (null == file) continue;
            file2Download.add(file);
            file2Resurce.put(file, entryInfo);
        }
        logger.info((Object)(logTitle + "\u9002\u5408\u901a\u8fc7" + this.handler.getName() + "\u66f4\u65b0\u7684\u6587\u4ef6\u6709" + file2Download.size() + "\u4e2a:" + file2Download));
        if (file2Download.size() == 0) {
            return;
        }
        DownloadResult eas = this.handler.download(file2Download);
        Map<HttpFileInfo, String> failed = eas.getFailed();
        if (failed.size() > 0) {
            logger.info((Object)(logTitle + "\u4e0b\u8f7d\u5931\u8d25\u7684\u6587\u4ef6\u6709" + failed.size() + "\u4e2a\uff1a" + failed.keySet()));
            for (HttpFileInfo key : failed.keySet()) {
                String failReason = failed.get(key);
                this.model.updateFail((EASClientFile)file2Resurce.get(key), failReason);
            }
        }
        List<HttpFileInfo> success = eas.getSuccess();
        logger.info((Object)(logTitle + "\u4e0b\u8f7d\u6210\u529f\u7684\u6587\u4ef6\u6709" + success.size() + "\u4e2a\uff1a" + success));
        for (HttpFileInfo downloadSuccessFile : success) {
            EASClientFile entryInfo = (EASClientFile)file2Resurce.get(downloadSuccessFile);
            this.processDownloadSuccess(downloadSuccessFile, entryInfo);
        }
        this.model.store();
    }

    private HttpFileInfo convert2Download(EASClientFile entryInfo) {
        try {
            HttpFileInfo file = this.handler.convert2Download(entryInfo);
            return file;
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
            return null;
        }
    }

    private void processDownloadSuccess(HttpFileInfo downloadSuccessFile, EASClientFile entryInfo) {
        try {
            this.handler.processDownloadSuccess(downloadSuccessFile, entryInfo);
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
    }
}

