/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.download.DownloadResult;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.handler.UpdateHandler;
import com.kingdee.eas.client.startup.update.model.UpdateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class SingleUpdater {
    private UpdateHandler handler;
    protected static final Logger logger = ClientStartLogger.getLogger();
    protected UpdateModel model;

    SingleUpdater(UpdateModel model, UpdateHandler handler) {
        this.model = model;
        this.handler = handler;
    }

    void update(EASClientFile each) {
        if (this.model.getNeedUpdate().isEmpty()) {
            return;
        }
        if (!this.model.getNeedUpdate().contains(each)) {
            return;
        }
        if (!this.handler.isAvailable()) {
            return;
        }
        HashMap<HttpFileInfo, EASClientFile> file2Resurce = new HashMap<HttpFileInfo, EASClientFile>();
        ArrayList<HttpFileInfo> file2Download = new ArrayList<HttpFileInfo>();
        HttpFileInfo file = this.handler.convert2Download(each);
        if (null != file) {
            file2Download.add(file);
            file2Resurce.put(file, each);
        }
        if (file2Download.size() == 0) {
            logger.warn((Object)"\u6ca1\u6709\u6587\u4ef6\u9002\u7528\u672c\u66f4\u65b0\u65b9\u5f0f");
            return;
        }
        logger.info((Object)("\u9002\u7528\u901a\u8fc7" + this.handler.getName() + "\u66f4\u65b0\u7684\u6587\u4ef6:" + file2Download));
        DownloadResult eas = this.handler.download(file2Download);
        Map<HttpFileInfo, String> failed = eas.getFailed();
        if (failed.size() > 0) {
            logger.info((Object)("\u4e0b\u8f7d\u5931\u8d25\u7684\u6587\u4ef6\uff1a" + failed));
            for (HttpFileInfo key : failed.keySet()) {
                String failReason = failed.get(key);
                this.model.updateFail((EASClientFile)file2Resurce.get(key), failReason);
            }
        }
        List<HttpFileInfo> success = eas.getSuccess();
        logger.info((Object)("\u4e0b\u8f7d\u6210\u529f\u7684\u6587\u4ef6\uff1a" + success));
        for (HttpFileInfo downloadSuccessFile : success) {
            EASClientFile entryInfo = (EASClientFile)file2Resurce.get(downloadSuccessFile);
            this.handler.processDownloadSuccess(downloadSuccessFile, entryInfo);
        }
        this.model.store();
    }
}

