/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.EASClientFileList;
import com.kingdee.eas.client.startup.update.check.INode;
import com.kingdee.eas.client.startup.update.check.NodeFactory;
import com.kingdee.eas.client.startup.util.StringUtil;
import com.kingdee.eas.client.startup.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EASJnlpCacheEntryManager {
    private static final Logger logger = ClientStartLogger.getLogger();

    public static EASClientFileList load(File file) {
        BufferedInputStream bos = null;
        try {
            bos = new BufferedInputStream(new FileInputStream(file));
            INode root = NodeFactory.build(bos);
            EASClientFileList entry = EASJnlpCacheEntryManager.buildJnlpCacheEntry(root);
            EASJnlpCacheEntryManager.buildResources(root, entry);
            EASClientFileList eASClientFileList = entry;
            return eASClientFileList;
        }
        catch (Throwable t) {
            throw new EASClientException("\u8bfb\u53d6\u6587\u4ef6 " + file.getAbsolutePath() + " \u51fa\u9519", t);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private static EASClientFileList buildJnlpCacheEntry(INode root) {
        URL codebaseURL = URLUtil.convertString2URL("http://localhost");
        String codebase = root.getAttribute("codebase");
        String href = root.getAttribute("href");
        if (!StringUtil.isEmptyValue(codebase)) {
            codebaseURL = URLUtil.convertString2URL(codebase);
        }
        if (StringUtil.isEmptyValue(href)) {
            href = "file";
        }
        return new EASClientFileList(URLUtil.convertString2URL(codebaseURL, href));
    }

    private static void buildResources(INode root, EASClientFileList cache) {
        INode[] resources = EASJnlpCacheEntryManager.getChildNodes(root, "resources");
        int len = resources.length;
        for (int i = 0; i < len; ++i) {
            INode[] resource = resources[i].getChildNodes();
            for (int j = 0; j < resource.length; ++j) {
                cache.addResourceInfo(EASJnlpCacheEntryManager.buildResource(resource[j]));
            }
        }
    }

    private static EASClientFile buildResource(INode resource) {
        String href = resource.getAttribute("href");
        String md5Version = resource.getAttribute("md5Version");
        String md5VersionNew = resource.getAttribute("md5VersionNew");
        assert (href != null);
        return new EASClientFile(href, md5Version, md5VersionNew);
    }

    private static INode[] getChildNodes(INode node, String name) {
        ArrayList<INode> result = new ArrayList<INode>();
        for (INode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new INode[result.size()]);
    }
}

