/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.exception.NetworkException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.DownloadTraceInfo;
import com.kingdee.eas.client.startup.update.check.JnlpVersionInfo;
import com.kingdee.eas.client.startup.util.NetworkExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class JnlpVersionUtil {
    static final Logger logger = ClientStartLogger.getLogger();

    public static JnlpVersionInfo downloadJnlpVersion() {
        String url = ClientConfigUtil.getUpdateUrl() + "JnlpVersion";
        String logTitle = "[\u83b7\u53d6\u670d\u52a1\u7aefjnlp\u7248\u672c\u53f7 " + url + "] ";
        URL jnlpVersionURL = null;
        try {
            String line;
            jnlpVersionURL = new URL(url);
            logger.info((Object)(logTitle + "\u5f00\u59cb..."));
            URLConnection cn = jnlpVersionURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(((HttpURLConnection)cn).getInputStream()));
            String fulljnlpVersion = "";
            String ondemandJnlpVersion = "";
            while ((line = in.readLine()) != null) {
                logger.info((Object)(logTitle + "\u8bfb\u53d6\u5230\uff1a" + line));
                int index = line.indexOf("=");
                if (index <= 0) continue;
                String versionKey = line.substring(0, index);
                if ("fullJnlpVersion".equalsIgnoreCase(versionKey.trim())) {
                    fulljnlpVersion = line.substring(index + 1);
                }
                if (!"ondemandJnlpVersion".equalsIgnoreCase(versionKey.trim())) continue;
                ondemandJnlpVersion = line.substring(index + 1);
            }
            JnlpVersionInfo info = new JnlpVersionInfo();
            info.setFulljnlpVersion(fulljnlpVersion);
            info.setOndemandJnlpVersion(ondemandJnlpVersion);
            return info;
        }
        catch (IOException e) {
            NetworkException networkException = NetworkExceptionHandler.handle(jnlpVersionURL, e);
            throw EASClientException.convert("\u83b7\u53d6\u670d\u52a1\u5668jnlp\u7684\u7248\u672c\u53f7\u5931\u8d25", networkException);
        }
    }

    public static boolean isNewestJnlp(JnlpVersionInfo info, DownloadTraceInfo traceFile) {
        boolean newest;
        String localFulljnlpVersion = traceFile.getFulljnlpversion();
        String localOndemandJnlpVersion = traceFile.getOndemandjnlpversion();
        String serverFulljnlpVersion = info.getFulljnlpVersion();
        String serverOndemandJnlpVersion = info.getOndemandJnlpVersion();
        String logTitle = "[\u8bfb\u53d6" + traceFile.getTraceFileName() + ",\u6bd4\u8f83\u672c\u5730\u7f13\u5b58\u6587\u4ef6\u7684jnlp\u7248\u672c\u53f7\u548c\u670d\u52a1\u5668jnlp\u7248\u672c\u53f7] ";
        logger.info((Object)(logTitle + "local  fulljnlpVersion = " + localFulljnlpVersion));
        logger.info((Object)(logTitle + "server fulljnlpVersion = " + serverFulljnlpVersion));
        logger.info((Object)(logTitle + "local  ondemandJnlpVersion = " + localOndemandJnlpVersion));
        logger.info((Object)(logTitle + "server ondemandJnlpVersion = " + serverOndemandJnlpVersion));
        boolean full = localFulljnlpVersion.equals(serverFulljnlpVersion);
        boolean demand = localOndemandJnlpVersion.equals(serverOndemandJnlpVersion);
        boolean bl = newest = full && demand;
        if (newest) {
            logger.info((Object)(logTitle + "the local jnlp version is the newest"));
        } else {
            logger.info((Object)(logTitle + "there is a newer jnlp version at the server,we need to update the jnlp files."));
        }
        return newest;
    }
}

