/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.update.check.INode;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import nanoxml.XMLElement;

public class NodeNanoAdapter
implements INode {
    private XMLElement xml;
    private NodeNanoAdapter next;
    private NodeNanoAdapter[] children;

    public NodeNanoAdapter(XMLElement xml) {
        this.xml = xml;
    }

    public NodeNanoAdapter(String nodeName) {
        this.xml = new XMLElement();
        this.xml.setName(nodeName);
    }

    public String getAttribute(String name) {
        return (String)this.xml.getAttribute(name);
    }

    public INode[] getChildNodes() {
        if (this.children == null) {
            ArrayList<NodeNanoAdapter> list = new ArrayList<NodeNanoAdapter>();
            Enumeration e = this.xml.enumerateChildren();
            while (e.hasMoreElements()) {
                list.add(new NodeNanoAdapter((XMLElement)e.nextElement()));
            }
            this.children = list.toArray(new NodeNanoAdapter[list.size()]);
            for (int i = 0; i < this.children.length - 1; ++i) {
                this.children[i].next = this.children[i + 1];
            }
        }
        return Arrays.asList(this.children).toArray(new INode[0]);
    }

    public INode getFirstChild() {
        if (this.children == null) {
            this.getChildNodes();
        }
        if (this.children.length == 0) {
            return null;
        }
        return this.children[0];
    }

    public INode getNextSibling() {
        return this.next;
    }

    public String getNodeName() {
        if (this.xml.getName() == null) {
            return "";
        }
        return this.xml.getName();
    }

    public String getNodeValue() {
        return this.xml.getContent();
    }

    public void addChild(INode node) {
        assert (node != null && node instanceof NodeNanoAdapter && ((NodeNanoAdapter)node).xml != null);
        this.xml.addChild(((NodeNanoAdapter)node).xml);
    }

    public void setAttribute(String name, String value) {
        this.xml.setAttribute(name, value);
    }

    public void setName(String name) {
        this.xml.setName(name);
    }

    public void setNodeValue(String value) {
        this.xml.setContent(value);
    }

    public void write(Writer writer) throws IOException {
        this.xml.write(writer);
    }
}

