/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.update.check.CreateJNLPResource;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.EASClientFileList;
import com.kingdee.eas.client.startup.update.check.EASJnlpCacheEntryManager;
import com.kingdee.eas.client.startup.update.check.ResourceVerInfo;
import com.kingdee.eas.client.startup.update.check.ResourceVerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OnDemandUpdateStateUtil {
    public static void scanAndUpdateLastestUpdateState() {
        List resCacheList = ResourceVerUtil.readAll();
        OnDemandUpdateStateUtil.updateLatestUpdateState(resCacheList);
    }

    private static void updateLatestUpdateState(Collection resCacheList) {
        String jnlpFilename;
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File jnlpFile = new File(baseDir, jnlpFilename = "resource.lst");
        if (jnlpFile.exists()) {
            EASClientFileList entryInfo = EASJnlpCacheEntryManager.load(jnlpFile);
            OnDemandUpdateStateUtil.updateCacheState(entryInfo, resCacheList);
            CreateJNLPResource.store(jnlpFilename, entryInfo.getCacheEntries());
        }
    }

    private static void updateCacheState(EASClientFileList entryInfo, Collection resCacheList) {
        if (resCacheList != null) {
            for (ResourceVerInfo resVerInfo : resCacheList) {
                OnDemandUpdateStateUtil.updateEntryInfo(entryInfo, resVerInfo);
            }
        }
    }

    private static void updateEntryInfo(EASClientFileList info, ResourceVerInfo resVerInfo) {
        if (info.getCacheEntries() != null) {
            Iterator<EASClientFile> it = info.getCacheEntries().iterator();
            boolean flag = false;
            while (it.hasNext()) {
                EASClientFile entryInfo = it.next();
                String herf = entryInfo.getPath();
                if (entryInfo.getPath() == null || !resVerInfo.getHerf().endsWith(herf)) continue;
                flag = true;
                if (entryInfo.getMd5Version().equals(resVerInfo.getMd5()) || entryInfo.getMd5VersionNew() != null && entryInfo.getMd5VersionNew().equals(resVerInfo.getMd5New())) break;
                info.removeResourceInfo(entryInfo);
                info.addResourceInfo(OnDemandUpdateStateUtil.createEntryInfo(resVerInfo));
                break;
            }
            if (!flag) {
                EASClientFile entryInfoTemp = OnDemandUpdateStateUtil.createEntryInfo(resVerInfo);
                info.addResourceInfo(entryInfoTemp);
            }
        } else {
            EASClientFile entryInfoTemp = OnDemandUpdateStateUtil.createEntryInfo(resVerInfo);
            info.addResourceInfo(entryInfoTemp);
        }
    }

    private static EASClientFile createEntryInfo(ResourceVerInfo resVerInfo) {
        EASClientFile entryInfo = new EASClientFile(resVerInfo.getHerf(), resVerInfo.getMd5(), resVerInfo.getMd5New());
        return entryInfo;
    }
}

