/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download;

import com.kingdee.eas.client.startup.update.download.EasClientDownloaderHttpImpl;
import com.kingdee.eas.client.startup.update.download.IEasClientDownloader;
import java.util.HashMap;
import java.util.Map;

public final class EasClientDownloaderFactory {
    private static final Map downloaders = new HashMap();

    private EasClientDownloaderFactory() {
    }

    public static IEasClientDownloader getDownloader(String protocol) {
        IEasClientDownloader downloader = (IEasClientDownloader)downloaders.get(protocol);
        if (downloader != null) {
            return downloader;
        }
        assert (false) : "Unsuported protocol [" + protocol + "]";
        return null;
    }

    public static synchronized void registerDownloader(String protocol, IEasClientDownloader downloader) {
        downloaders.put(protocol, downloader);
    }

    public static synchronized void unregisterDownloader(String protocol) {
        downloaders.remove(protocol);
    }

    public static synchronized String[] getSupportedProtocols() {
        return downloaders.keySet().toArray(new String[0]);
    }

    static {
        EasClientDownloaderFactory.registerDownloader("http", EasClientDownloaderHttpImpl.getInstance());
        EasClientDownloaderFactory.registerDownloader("https", EasClientDownloaderHttpImpl.getInstance());
    }
}

