/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download.httpdownload;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.precess.DownloadPrecessHelper;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadManager;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpSiteInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadTask {
    private static final Logger logger = ClientStartLogger.getLogger();
    private int workerCount;
    private HttpSiteInfo siteInfo;
    private File localPath;
    private Map<HttpFileInfo, String> fileDownloadFailed = new HashMap<HttpFileInfo, String>();
    private List<HttpFileInfo> fileDownloadSucessed = new ArrayList<HttpFileInfo>();
    private long downloadBytes = 0L;

    public DownloadTask(HttpSiteInfo httpSite, File localRoot, List<HttpFileInfo> fileList) {
        this.workerCount = fileList.size();
        this.siteInfo = httpSite;
        this.localPath = localRoot;
        for (HttpFileInfo file : fileList) {
            this.fileDownloadFailed.put(file, "to download");
        }
    }

    public void start() throws InterruptedException {
        if (this.workerCount > 0) {
            DownloadManager.getInstance().runTask(this);
        }
    }

    public HttpSiteInfo getSiteInfo() {
        return this.siteInfo;
    }

    public File getLocalPath() {
        return this.localPath;
    }

    Map getFilesToDownload() {
        HashMap<HttpFileInfo, String> map = new HashMap<HttpFileInfo, String>(this.fileDownloadFailed.size());
        map.putAll(this.fileDownloadFailed);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void downloadFailed(HttpFileInfo info, String failInfo) {
        try {
            this.fileDownloadFailed.put(info, failInfo);
            --this.workerCount;
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        finally {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void downloadSuccess(HttpFileInfo info, long dBytes) {
        try {
            --this.workerCount;
            this.downloadBytes += dBytes;
            this.fileDownloadFailed.remove(info);
            this.fileDownloadSucessed.add(info);
            DownloadPrecessHelper.downloadSuccess(info.getSavePath());
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        finally {
            this.notifyAll();
        }
    }

    public void waitUntilTaskFinish() throws InterruptedException {
        while (this.workerCount > 0) {
            this.wait();
        }
    }

    public synchronized Map<HttpFileInfo, String> getDownloadFailedFiles() throws InterruptedException {
        this.waitUntilTaskFinish();
        return this.fileDownloadFailed;
    }

    public synchronized List<HttpFileInfo> getDownloadSucessedFiles() throws InterruptedException {
        this.waitUntilTaskFinish();
        return this.fileDownloadSucessed;
    }

    public synchronized long getDownloadBytes() throws InterruptedException {
        this.waitUntilTaskFinish();
        return this.downloadBytes;
    }

    public void beginDownload(HttpFileInfo fileInfo) {
        DownloadPrecessHelper.beginDownload(fileInfo.getSavePath());
    }
}

