/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download.httpdownload;

import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadManager;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadTask;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpSiteInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.NamedRunnable;
import com.kingdee.eas.client.startup.util.FileUtil;
import com.kingdee.eas.client.startup.util.StringUtil;
import com.kingdee.eas.client.startup.util.ThrowableUtil;
import com.twmacinta.util.MD5;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class DownloadWorker
implements NamedRunnable {
    private static final Logger logger = ClientStartLogger.getLogger();
    protected DownloadTask task;
    protected HttpFileInfo fileInfo;
    public static final int downloadTimeOut = Integer.parseInt(System.getProperty("downloadTimeout", "30000"));

    public DownloadWorker(DownloadTask dTask, HttpFileInfo file) {
        this.task = dTask;
        this.fileInfo = file;
    }

    public void run() {
        try {
            this.task.beginDownload(this.fileInfo);
            long downloadSize = this.downloadFile();
            this.task.downloadSuccess(this.fileInfo, downloadSize);
        }
        catch (EASClientException e) {
            String solution = "\u5904\u7406\u5efa\u8bae:" + e.getSolution();
            logger.warn((Object)solution, (Throwable)e);
            this.task.downloadFailed(this.fileInfo, e.getMessage() + "\r\n" + solution);
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
            String failInfo = ThrowableUtil.getStackTrace(t);
            this.task.downloadFailed(this.fileInfo, failInfo);
        }
    }

    private long downloadFile() {
        File downloadTemp;
        File localDirRoot = this.task.getLocalPath();
        HttpSiteInfo server = this.task.getSiteInfo();
        File destFile = new File(localDirRoot.getAbsolutePath() + "/" + this.fileInfo.getSavePath());
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        if (!(downloadTemp = new File(localDirRoot.getAbsolutePath() + "/" + this.fileInfo.getSavePath() + ".tmp")).getParentFile().exists()) {
            downloadTemp.getParentFile().mkdirs();
        }
        String fileToDownload = server.getRootContentPath() + this.fileInfo.getDownloadAddress();
        try {
            long startTime = System.currentTimeMillis();
            long downloadSize = this.retry(downloadTemp, fileToDownload);
            long fileDownloadElapseTime = System.currentTimeMillis() - startTime;
            fileDownloadElapseTime = fileDownloadElapseTime > 0L ? fileDownloadElapseTime : 1L;
            logger.info((Object)("[download] download success[[Cost Time:" + fileDownloadElapseTime + "ms]" + "[Download Size:" + downloadSize + "B]" + "[Download Speed:" + downloadSize * 1000L / (fileDownloadElapseTime * 1024L) + "KB/s]"));
            if (-1L == downloadSize) {
                downloadTemp.delete();
                throw new EASClientException("\u4e0b\u8f7d\u5931\u8d25");
            }
            String md5 = this.fileInfo.getMd5();
            String fileName = this.fileInfo.getSavePath();
            this.checkMD5(fileName, downloadTemp, md5);
            FileUtil.replace(downloadTemp, destFile);
            return downloadSize;
        }
        catch (Throwable e) {
            downloadTemp.delete();
            throw EASClientException.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long retry(File downloadTemp, String fileToDownload) throws IOException {
        long downloadSize = 0L;
        int retryTimes = DownloadManager.getInstance().getDownloadManagerConfig().getDownloadRetries();
        for (int i = 1; i < retryTimes; ++i) {
            RandomAccessFile tmpFile = new RandomAccessFile(downloadTemp, "rw");
            Properties requetProps = new Properties();
            long hasDownloaded = tmpFile.length();
            if (hasDownloaded > 0L) {
                logger.info((Object)("Continue download file[" + fileToDownload + "] from break point [" + hasDownloaded + "]......"));
                tmpFile.seek(hasDownloaded - 1L);
                requetProps.setProperty("Range", "bytes=" + (hasDownloaded - 1L) + "-");
            }
            try {
                InputStream is = this.getHttpInputStream(requetProps, fileToDownload);
                byte[] buf = new byte[1536];
                BufferedInputStream bufInput = new BufferedInputStream(is);
                int ret = 0;
                while ((ret = bufInput.read(buf, 0, buf.length)) != -1) {
                    tmpFile.write(buf, 0, ret);
                    hasDownloaded += (long)ret;
                    downloadSize += (long)ret;
                }
                is.close();
                this.closeWorker();
                long l = downloadSize;
                return l;
            }
            catch (SocketTimeoutException ste) {
                logger.error((Object)("Socket timeout, retry [" + i + "] ......"));
                continue;
            }
            catch (ConnectException ce) {
                if (ce.getMessage().indexOf("timeout") >= 0) {
                    logger.error((Object)("Socket timeout, retry [" + i + "] ......"));
                    continue;
                }
                throw ce;
            }
            finally {
                this.closeWorker();
                tmpFile.close();
            }
        }
        return -1L;
    }

    private void checkMD5(String fileName, File downloadTemp, String md5) throws IOException {
        String tmpVersion;
        if (!StringUtil.isEmptyValue(md5) && this.isNeedCheckMd5(fileName) && !md5.equals(tmpVersion = MD5.asHex(MD5.getHash(downloadTemp)))) {
            logger.error((Object)("compare md5 [local:" + tmpVersion + ",remote:" + md5 + "] failure, downloadSize[" + downloadTemp.length() + "]!"));
            EASClientException ex = new EASClientException("\u4e0b\u8f7d\u5230\u7684\u6587\u4ef6" + fileName + "\u7684MD5\u503c\u548c\u6700\u65b0\u6587\u4ef6\u5217\u8868\u4e2d\u7684\u4e0d\u7b26.remote:" + tmpVersion + ",local:" + md5);
            ex.setSolution("\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u8005\u6280\u672f\u652f\u6301\u4eba\u5458\u3002\u786e\u8ba4\u670d\u52a1\u7aef\u6587\u4ef6\u7684MD5\u503c\u662f\u5426\u6b63\u786e\uff0c\u5982\u679c\u9519\u8bef\uff0c\u901a\u8fc7\u7ba1\u7406\u63a7\u5236\u53f0\u5237\u65b0\u7ec4\u4ef6\u7248\u672c\u5e76\u91cd\u542f\u670d\u52a1\u3002");
            throw ex;
        }
    }

    private boolean isNeedCheckMd5(String localFile) {
        return !localFile.endsWith("datacenters.xml") && !localFile.endsWith("pkmap.lst") && !localFile.endsWith("resource.lst") && !localFile.endsWith("jnlp") && !localFile.endsWith("metasindex.jar") && !localFile.endsWith("updateodds.lst");
    }

    public String getName() {
        return this.fileInfo.getSavePath();
    }

    protected abstract void closeWorker();

    protected abstract InputStream getHttpInputStream(Properties var1, String var2) throws IOException;
}

