/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.exception;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.ServerUpdatedCheckUtil;
import com.kingdee.eas.client.startup.update.classloader.ClassLoaderUtil;
import org.apache.log4j.Logger;

public class ClassNotFoundExceptionHandlerHelper {
    public static final Logger logger = ClientStartLogger.getLogger();

    private static boolean isClassNotFoundException(Throwable t) {
        return t instanceof ClassNotFoundException;
    }

    private static String getClassNotFoundName(Throwable t) {
        if (!ClassNotFoundExceptionHandlerHelper.isClassNotFoundException(t)) {
            logger.error((Object)(t.getMessage() + "\u4e0d\u662fClassNotFoundException,\u65e0\u6cd5\u83b7\u53d6ClassNotFoundName"));
            return "";
        }
        String className = t.getMessage();
        logger.info((Object)("\u7c7b\u540d,ClassNotFoundName=" + className));
        return className;
    }

    static String handle(ClassLoader calssLoader, Throwable exc) {
        if (!ClassNotFoundExceptionHandlerHelper.isClassNotFoundException(exc)) {
            return "";
        }
        if (ServerUpdatedCheckUtil.isServerUpdated()) {
            return "\u670d\u52a1\u7aef\u6709\u66f4\u65b0\uff0c\u8bf7\u9000\u51fa\u5ba2\u6237\u7aef\uff0c\u91cd\u65b0\u767b\u9646";
        }
        String className = ClassNotFoundExceptionHandlerHelper.getClassNotFoundName(exc);
        String componentPath = ClassLoaderUtil.getComponentPath(calssLoader, className);
        StringBuffer sb = new StringBuffer("\u8865\u4e01\u9519\u8bef\u6216\u8005\u90e8\u7f72\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u8005\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
        sb.append("\r\n");
        sb.append("\u51fa\u9519\u539f\u56e0\uff1a");
        sb.append("\r\n");
        sb.append("\u5ba2\u6237\u7aef\u7ec4\u4ef6" + componentPath + "\u4e2d\u7684\u7c7b" + className + "\u627e\u4e0d\u5230\u3002");
        return sb.toString();
    }
}

