/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.handler.cdn;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.ICacheState;
import com.kingdee.eas.client.startup.update.download.DownloadResult;
import com.kingdee.eas.client.startup.update.download.MultiThreadHttpDownloadUtil;
import com.kingdee.eas.client.startup.update.download.URLUtils;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadWorker;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpSiteInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.HttpTimeoutHandler;
import com.kingdee.eas.client.startup.update.handler.AbstractUpdateHandler;
import com.kingdee.eas.client.startup.update.model.UpdateModel;
import com.kingdee.eas.client.startup.util.StringUtil;
import com.kingdee.eas.client.startup.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdnUpdateHandler
extends AbstractUpdateHandler {
    private static final String logTitle = "[CDN\u4e0b\u8f7d] ";
    private Set<String> fileTypesByCDN;
    private URL cndURL;

    public CdnUpdateHandler(UpdateModel model) {
        super(model);
    }

    @Override
    public boolean isAvailable() {
        boolean clientEnableCDN;
        ICacheState cacheState = this.model.getCacheState();
        URL urlInJNLPCodebase = cacheState.getServerCacheEntryInfo().getHref();
        String serverForceCDN = URLUtils.getParameter(urlInJNLPCodebase.getQuery(), "CDN_FORCE_ENABLE");
        if ((serverForceCDN == null || "false".equals(serverForceCDN)) && !(clientEnableCDN = Boolean.getBoolean("ENABLE_CDN"))) {
            return false;
        }
        String cdnURLPath = this.getCDNURLPath(urlInJNLPCodebase);
        try {
            this.cndURL = new URL(cdnURLPath);
        }
        catch (MalformedURLException e) {
            throw EASClientException.convert(e);
        }
        this.fileTypesByCDN = this.fetchCNDType(this.cndURL);
        return 0 != this.fileTypesByCDN.size();
    }

    private String getCDNURLPath(URL urlInJNLPCodebase) {
        String cdnURLPath = URLUtils.getParameter(urlInJNLPCodebase.getQuery(), "CDN_URL");
        cdnURLPath = StringUtil.isEmptyValue(cdnURLPath) ? "http://cdn.kingdee.com/easwebcache/" : cdnURLPath.trim();
        return cdnURLPath;
    }

    private Set<String> fetchCNDType(URL cdnURL) {
        try {
            URL fileTypeURL = new URL(cdnURL, "filetypes", new HttpTimeoutHandler(DownloadWorker.downloadTimeOut * 2));
            HttpURLConnection conn = (HttpURLConnection)fileTypeURL.openConnection();
            logger.info((Object)("[CDN\u4e0b\u8f7d] \u8bbf\u95ee" + fileTypeURL + "\u83b7\u53d6CDN\u4e0b\u8f7d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b"));
            conn.setRequestProperty("Connection", "Close");
            conn.setRequestMethod("GET");
            conn.connect();
            if (200 == conn.getResponseCode()) {
                InputStream input = conn.getInputStream();
                BufferedReader isr = new BufferedReader(new InputStreamReader(input));
                String cdnFiletypes = isr.readLine();
                logger.info((Object)("[CDN\u4e0b\u8f7d] CDN\u4e0b\u8f7d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b:" + cdnFiletypes));
                input.close();
                if (!StringUtil.isEmptyValue(cdnFiletypes)) {
                    String[] type = cdnFiletypes.split(";");
                    HashSet<String> types = new HashSet<String>();
                    types.addAll(Arrays.asList(type));
                    return types;
                }
            } else {
                logger.error((Object)("[CDN\u4e0b\u8f7d] \u8bbf\u95ee" + fileTypeURL + "\u8fd4\u56de\u54cd\u5e94\u7801" + conn.getResponseCode() + ",\u83b7\u53d6CDN\u4e0b\u8f7d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\u5931\u8d25"));
            }
            conn.disconnect();
        }
        catch (IOException ex) {
            if (ex instanceof UnknownHostException) {
                logger.error((Object)("[CDN\u4e0b\u8f7d] \u65e0\u6cd5\u89e3\u6790CND\u670d\u52a1\u57df\u540d [" + cdnURL + "]\u3002\u8bf7\u68c0\u67e5\u7f51\u7edc\u548c\u57df\u540d\u89e3\u6790\u662f\u5426\u53ef\u7528\uff0c\u4fee\u590d\u95ee\u9898\u540e\uff0c\u91cd\u8bd5\u3002 "), (Throwable)ex);
            }
            logger.error((Object)("[CDN\u4e0b\u8f7d] \u65e0\u6cd5\u8bbf\u95eeCND\u670d\u52a1 [" + cdnURL + "]\u3002 "), (Throwable)ex);
        }
        return new HashSet<String>();
    }

    @Override
    public HttpFileInfo convert2Download(EASClientFile entryInfo) {
        String fileName = entryInfo.getPath();
        if (this.existInCDN(fileName)) {
            HttpFileInfo file = new HttpFileInfo(entryInfo.getPath() + "/" + entryInfo.getMd5Version(), entryInfo.getPath(), entryInfo.getMd5Version(), fileName);
            return file;
        }
        logger.info((Object)("cdn\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684\u6587\u4ef6\u4e0b\u8f7d" + entryInfo.getPath()));
        return null;
    }

    private boolean existInCDN(String fileName) {
        String extensionName = Utils.fetchExtensionName(fileName);
        return this.fileTypesByCDN.contains(extensionName);
    }

    @Override
    public DownloadResult download(List<HttpFileInfo> files2Download) {
        URI serverURI = null;
        try {
            serverURI = new URI(this.cndURL.toString());
        }
        catch (URISyntaxException e) {
            throw EASClientException.convert(e);
        }
        HttpSiteInfo siteInfo = new HttpSiteInfo(serverURI.getScheme(), serverURI.getHost(), serverURI.getPort(), serverURI.getPath());
        File rootPath = ClientConfigUtil.getLocalDirFile();
        return MultiThreadHttpDownloadUtil.downloadFiles(siteInfo, rootPath, files2Download);
    }

    @Override
    public void processDownloadSuccess(HttpFileInfo downloadSuccessFile, EASClientFile entryInfo) {
        this.model.updateSuccess(entryInfo);
    }

    @Override
    public String getName() {
        return "CDN\u4e0b\u8f7d";
    }
}

